/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pkcs.bc;

import cn.win_trust_erpc.bouncycastle.asn1.DERNull;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.operator.MacCalculator;
import cn.win_trust_erpc.bouncycastle.operator.OperatorCreationException;
import cn.win_trust_erpc.bouncycastle.operator.bc.BcDigestProvider;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import cn.win_trust_erpc.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider digestProvider) {
        this.digestProvider = digestProvider;
    }

    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] password) throws OperatorCreationException {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pbeParams, password);
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

