/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.lms;

import cn.win_trust_erpc.bouncycastle.util.Encodable;
import java.io.ByteArrayOutputStream;

public class Composer {
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    private Composer() {
    }

    public static Composer compose() {
        return new Composer();
    }

    public Composer u64str(long n) {
        this.u32str((int)(n >>> 32));
        this.u32str((int)n);
        return this;
    }

    public Composer u32str(int n) {
        this.bos.write((byte)(n >>> 24));
        this.bos.write((byte)(n >>> 16));
        this.bos.write((byte)(n >>> 8));
        this.bos.write((byte)n);
        return this;
    }

    public Composer u16str(int n) {
        this.bos.write((byte)((n &= 0xFFFF) >>> 8));
        this.bos.write((byte)n);
        return this;
    }

    public Composer bytes(Encodable[] encodable) {
        try {
            Encodable[] encodableArray = encodable;
            int n = encodable.length;
            int n2 = 0;
            while (n2 < n) {
                Encodable e = encodableArray[n2];
                this.bos.write(e.getEncoded());
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer bytes(Encodable encodable) {
        try {
            this.bos.write(encodable.getEncoded());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer pad(int v, int len) {
        while (len >= 0) {
            try {
                this.bos.write(v);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            --len;
        }
        return this;
    }

    public Composer bytes(byte[][] arrays) {
        try {
            byte[][] byArray = arrays;
            int n = arrays.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] array = byArray[n2];
                this.bos.write(array);
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer bytes(byte[][] arrays, int start, int end) {
        try {
            int j = start;
            while (j != end) {
                this.bos.write(arrays[j]);
                ++j;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer bytes(byte[] array) {
        try {
            this.bos.write(array);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer bytes(byte[] array, int start, int len) {
        try {
            this.bos.write(array, start, len);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public byte[] build() {
        return this.bos.toByteArray();
    }

    public Composer padUntil(int v, int requiredLen) {
        while (this.bos.size() < requiredLen) {
            this.bos.write(v);
        }
        return this;
    }

    public Composer bool(boolean v) {
        this.bos.write(v ? 1 : 0);
        return this;
    }
}

