/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.lms;

import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.Composer;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.DigestUtil;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSS;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMS;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSContext;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSContextBasedSigner;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSSignature;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSigParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.SeedDerive;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HSSPrivateKeyParameters
extends LMSKeyParameters
implements LMSContextBasedSigner {
    private final int l;
    private final boolean isShard;
    private List<LMSPrivateKeyParameters> keys;
    private List<LMSSignature> sig;
    private final long indexLimit;
    private long index = 0L;
    private HSSPublicKeyParameters publicKey;

    public HSSPrivateKeyParameters(int l, List<LMSPrivateKeyParameters> keys, List<LMSSignature> sig, long index, long indexLimit) {
        super(true);
        this.l = l;
        this.keys = Collections.unmodifiableList(keys);
        this.sig = Collections.unmodifiableList(sig);
        this.index = index;
        this.indexLimit = indexLimit;
        this.isShard = false;
        this.resetKeyToIndex();
    }

    private HSSPrivateKeyParameters(int l, List<LMSPrivateKeyParameters> keys, List<LMSSignature> sig, long index, long indexLimit, boolean isShard) {
        super(true);
        this.l = l;
        this.keys = Collections.unmodifiableList(keys);
        this.sig = Collections.unmodifiableList(sig);
        this.index = index;
        this.indexLimit = indexLimit;
        this.isShard = isShard;
    }

    public static HSSPrivateKeyParameters getInstance(byte[] privEnc, byte[] pubEnc) throws IOException {
        HSSPrivateKeyParameters pKey = HSSPrivateKeyParameters.getInstance(privEnc);
        pKey.publicKey = HSSPublicKeyParameters.getInstance(pubEnc);
        return pKey;
    }

    public static HSSPrivateKeyParameters getInstance(Object src) throws IOException {
        if (src instanceof HSSPrivateKeyParameters) {
            return (HSSPrivateKeyParameters)src;
        }
        if (src instanceof DataInputStream) {
            if (((DataInputStream)src).readInt() != 0) {
                throw new IllegalStateException("unknown version for hss private key");
            }
            int d = ((DataInputStream)src).readInt();
            long index = ((DataInputStream)src).readLong();
            long maxIndex = ((DataInputStream)src).readLong();
            boolean limited = ((DataInputStream)src).readBoolean();
            ArrayList<LMSPrivateKeyParameters> keys = new ArrayList<LMSPrivateKeyParameters>();
            ArrayList<LMSSignature> signatures = new ArrayList<LMSSignature>();
            int t = 0;
            while (t < d) {
                keys.add(LMSPrivateKeyParameters.getInstance(src));
                ++t;
            }
            t = 0;
            while (t < d - 1) {
                signatures.add(LMSSignature.getInstance(src));
                ++t;
            }
            return new HSSPrivateKeyParameters(d, keys, signatures, index, maxIndex, limited);
        }
        if (src instanceof byte[]) {
            InputStream in = null;
            try {
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                HSSPrivateKeyParameters hSSPrivateKeyParameters = HSSPrivateKeyParameters.getInstance(in);
                return hSSPrivateKeyParameters;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (src instanceof InputStream) {
            return HSSPrivateKeyParameters.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public int getL() {
        return this.l;
    }

    public synchronized long getIndex() {
        return this.index;
    }

    public synchronized LMSParameters[] getLMSParameters() {
        int len = this.keys.size();
        LMSParameters[] parms = new LMSParameters[len];
        int i = 0;
        while (i < len) {
            LMSPrivateKeyParameters lmsPrivateKey = this.keys.get(i);
            parms[i] = new LMSParameters(lmsPrivateKey.getSigParameters(), lmsPrivateKey.getOtsParameters());
            ++i;
        }
        return parms;
    }

    synchronized void incIndex() {
        ++this.index;
    }

    private static HSSPrivateKeyParameters makeCopy(HSSPrivateKeyParameters privateKeyParameters) {
        try {
            return HSSPrivateKeyParameters.getInstance(privateKeyParameters.getEncoded());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHierarchy(LMSPrivateKeyParameters[] newKeys, LMSSignature[] newSig) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        synchronized (hSSPrivateKeyParameters) {
            this.keys = Collections.unmodifiableList(java.util.Arrays.asList(newKeys));
            this.sig = Collections.unmodifiableList(java.util.Arrays.asList(newSig));
        }
    }

    boolean isShard() {
        return this.isShard;
    }

    long getIndexLimit() {
        return this.indexLimit;
    }

    @Override
    public long getUsagesRemaining() {
        return this.indexLimit - this.index;
    }

    LMSPrivateKeyParameters getRootKey() {
        return this.keys.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HSSPrivateKeyParameters extractKeyShard(int usageCount) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        synchronized (hSSPrivateKeyParameters) {
            if (this.getUsagesRemaining() < (long)usageCount) {
                throw new IllegalArgumentException("usageCount exceeds usages remaining in current leaf");
            }
            long maxIndexForShard = this.index + (long)usageCount;
            long shardStartIndex = this.index;
            this.index += (long)usageCount;
            ArrayList<LMSPrivateKeyParameters> keys = new ArrayList<LMSPrivateKeyParameters>(this.getKeys());
            ArrayList<LMSSignature> sig = new ArrayList<LMSSignature>(this.getSig());
            HSSPrivateKeyParameters shard = HSSPrivateKeyParameters.makeCopy(new HSSPrivateKeyParameters(this.l, keys, sig, shardStartIndex, maxIndexForShard, true));
            this.resetKeyToIndex();
            return shard;
        }
    }

    synchronized List<LMSPrivateKeyParameters> getKeys() {
        return this.keys;
    }

    synchronized List<LMSSignature> getSig() {
        return this.sig;
    }

    void resetKeyToIndex() {
        List<LMSPrivateKeyParameters> originalKeys = this.getKeys();
        long[] qTreePath = new long[originalKeys.size()];
        long q = this.getIndex();
        int t = originalKeys.size() - 1;
        while (t >= 0) {
            LMSigParameters sigParameters = originalKeys.get(t).getSigParameters();
            int mask = (1 << sigParameters.getH()) - 1;
            qTreePath[t] = q & (long)mask;
            q >>>= sigParameters.getH();
            --t;
        }
        boolean changed = false;
        LMSPrivateKeyParameters[] keys = originalKeys.toArray(new LMSPrivateKeyParameters[originalKeys.size()]);
        LMSSignature[] sig = this.sig.toArray(new LMSSignature[this.sig.size()]);
        LMSPrivateKeyParameters originalRootKey = this.getRootKey();
        if ((long)(keys[0].getIndex() - 1) != qTreePath[0]) {
            keys[0] = LMS.generateKeys(originalRootKey.getSigParameters(), originalRootKey.getOtsParameters(), (int)qTreePath[0], originalRootKey.getI(), originalRootKey.getMasterSecret());
            changed = true;
        }
        int i = 1;
        while (i < qTreePath.length) {
            boolean seedEquals;
            LMSPrivateKeyParameters intermediateKey = keys[i - 1];
            byte[] childI = new byte[16];
            byte[] childSeed = new byte[32];
            SeedDerive derive = new SeedDerive(intermediateKey.getI(), intermediateKey.getMasterSecret(), DigestUtil.getDigest(intermediateKey.getOtsParameters().getDigestOID()));
            derive.setQ((int)qTreePath[i - 1]);
            derive.setJ(-2);
            derive.deriveSeed(childSeed, true);
            byte[] postImage = new byte[32];
            derive.deriveSeed(postImage, false);
            System.arraycopy(postImage, 0, childI, 0, childI.length);
            boolean lmsQMatch = i < qTreePath.length - 1 ? qTreePath[i] == (long)(keys[i].getIndex() - 1) : qTreePath[i] == (long)keys[i].getIndex();
            boolean bl = seedEquals = Arrays.areEqual(childI, keys[i].getI()) && Arrays.areEqual(childSeed, keys[i].getMasterSecret());
            if (!seedEquals) {
                keys[i] = LMS.generateKeys(originalKeys.get(i).getSigParameters(), originalKeys.get(i).getOtsParameters(), (int)qTreePath[i], childI, childSeed);
                sig[i - 1] = LMS.generateSign(keys[i - 1], keys[i].getPublicKey().toByteArray());
                changed = true;
            } else if (!lmsQMatch) {
                keys[i] = LMS.generateKeys(originalKeys.get(i).getSigParameters(), originalKeys.get(i).getOtsParameters(), (int)qTreePath[i], childI, childSeed);
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.updateHierarchy(keys, sig);
        }
    }

    public synchronized HSSPublicKeyParameters getPublicKey() {
        return new HSSPublicKeyParameters(this.l, this.getRootKey().getPublicKey());
    }

    void replaceConsumedKey(int d) {
        SeedDerive deriver = this.keys.get(d - 1).getCurrentOTSKey().getDerivationFunction();
        deriver.setJ(-2);
        byte[] childRootSeed = new byte[32];
        deriver.deriveSeed(childRootSeed, true);
        byte[] postImage = new byte[32];
        deriver.deriveSeed(postImage, false);
        byte[] childI = new byte[16];
        System.arraycopy(postImage, 0, childI, 0, childI.length);
        ArrayList<LMSPrivateKeyParameters> newKeys = new ArrayList<LMSPrivateKeyParameters>(this.keys);
        LMSPrivateKeyParameters oldPk = this.keys.get(d);
        newKeys.set(d, LMS.generateKeys(oldPk.getSigParameters(), oldPk.getOtsParameters(), 0, childI, childRootSeed));
        ArrayList<LMSSignature> newSig = new ArrayList<LMSSignature>(this.sig);
        newSig.set(d - 1, LMS.generateSign((LMSPrivateKeyParameters)newKeys.get(d - 1), ((LMSPrivateKeyParameters)newKeys.get(d)).getPublicKey().toByteArray()));
        this.keys = Collections.unmodifiableList(newKeys);
        this.sig = Collections.unmodifiableList(newSig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HSSPrivateKeyParameters that = (HSSPrivateKeyParameters)o;
        if (this.l != that.l) {
            return false;
        }
        if (this.isShard != that.isShard) {
            return false;
        }
        if (this.indexLimit != that.indexLimit) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (!this.keys.equals(that.keys)) {
            return false;
        }
        return this.sig.equals(that.sig);
    }

    @Override
    public synchronized byte[] getEncoded() throws IOException {
        Composer composer = Composer.compose().u32str(0).u32str(this.l).u64str(this.index).u64str(this.indexLimit).bool(this.isShard);
        for (LMSPrivateKeyParameters key : this.keys) {
            composer.bytes(key);
        }
        for (LMSSignature s : this.sig) {
            composer.bytes(s);
        }
        return composer.build();
    }

    public int hashCode() {
        int result = this.l;
        result = 31 * result + (this.isShard ? 1 : 0);
        result = 31 * result + this.keys.hashCode();
        result = 31 * result + this.sig.hashCode();
        result = 31 * result + (int)(this.indexLimit ^ this.indexLimit >>> 32);
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        return HSSPrivateKeyParameters.makeCopy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LMSContext generateLMSContext() {
        LMSSignedPubKey[] signed_pub_key;
        LMSPrivateKeyParameters nextKey;
        int L = this.getL();
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        synchronized (hSSPrivateKeyParameters) {
            HSS.rangeTestKeys(this);
            List<LMSPrivateKeyParameters> keys = this.getKeys();
            List<LMSSignature> sig = this.getSig();
            nextKey = this.getKeys().get(L - 1);
            int i = 0;
            signed_pub_key = new LMSSignedPubKey[L - 1];
            while (i < L - 1) {
                signed_pub_key[i] = new LMSSignedPubKey(sig.get(i), keys.get(i + 1).getPublicKey());
                ++i;
            }
            this.incIndex();
        }
        return nextKey.generateLMSContext().withSignedPublicKeys(signed_pub_key);
    }

    @Override
    public byte[] generateSignature(LMSContext context) {
        try {
            return HSS.generateSignature(this.getL(), context).getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode signature: " + e.getMessage(), e);
        }
    }
}

