/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.sphincs;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

public class BCSphincs256PublicKey
implements PublicKey,
SPHINCSKey {
    private static final long serialVersionUID = 1L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPublicKeyParameters params;

    public BCSphincs256PublicKey(ASN1ObjectIdentifier treeDigest, SPHINCSPublicKeyParameters params) {
        this.treeDigest = treeDigest;
        this.params = params;
    }

    public BCSphincs256PublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.treeDigest = SPHINCS256KeyParams.getInstance(keyInfo.getAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = (SPHINCSPublicKeyParameters)PublicKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCSphincs256PublicKey) {
            BCSphincs256PublicKey otherKey = (BCSphincs256PublicKey)o;
            return this.treeDigest.equals(otherKey.treeDigest) && Arrays.areEqual(this.params.getKeyData(), otherKey.params.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.params.getKeyData());
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo pki;
            if (this.params.getTreeDigest() != null) {
                pki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
                pki = new SubjectPublicKeyInfo(algorithmIdentifier, this.params.getKeyData());
            }
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getKeyData() {
        return this.params.getKeyData();
    }

    ASN1ObjectIdentifier getTreeDigest() {
        return this.treeDigest;
    }

    CipherParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

