/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.TlsContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsProtocol;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.io.TeeInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class ClientHello {
    private final ProtocolVersion version;
    private final byte[] random;
    private final byte[] sessionID;
    private final byte[] cookie;
    private final int[] cipherSuites;
    private final Hashtable extensions;
    private final int bindersSize;

    public ClientHello(ProtocolVersion version, byte[] random, byte[] sessionID, byte[] cookie, int[] cipherSuites, Hashtable extensions, int bindersSize) {
        this.version = version;
        this.random = random;
        this.sessionID = sessionID;
        this.cookie = cookie;
        this.cipherSuites = cipherSuites;
        this.extensions = extensions;
        this.bindersSize = bindersSize;
    }

    public int getBindersSize() {
        return this.bindersSize;
    }

    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    @Deprecated
    public ProtocolVersion getClientVersion() {
        return this.version;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public Hashtable getExtensions() {
        return this.extensions;
    }

    public byte[] getRandom() {
        return this.random;
    }

    public byte[] getSessionID() {
        return this.sessionID;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public void encode(TlsContext context, OutputStream output) throws IOException {
        if (this.bindersSize < 0) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeVersion(this.version, output);
        output.write(this.random);
        TlsUtils.writeOpaque8(this.sessionID, output);
        if (this.cookie != null) {
            TlsUtils.writeOpaque8(this.cookie, output);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(this.cipherSuites, output);
        TlsUtils.writeUint8ArrayWithUint8Length(new short[1], output);
        TlsProtocol.writeExtensions(output, this.extensions, this.bindersSize);
    }

    public static ClientHello parse(ByteArrayInputStream messageInput, OutputStream dtlsOutput) throws TlsFatalAlert {
        try {
            return ClientHello.implParse(messageInput, dtlsOutput);
        }
        catch (TlsFatalAlert e) {
            throw e;
        }
        catch (IOException e) {
            throw new TlsFatalAlert(50, (Throwable)e);
        }
    }

    private static ClientHello implParse(ByteArrayInputStream messageInput, OutputStream dtlsOutput) throws IOException {
        int cipher_suites_length;
        InputStream input = messageInput;
        if (dtlsOutput != null) {
            input = new TeeInputStream(input, dtlsOutput);
        }
        ProtocolVersion clientVersion = TlsUtils.readVersion(input);
        byte[] random = TlsUtils.readFully(32, input);
        byte[] sessionID = TlsUtils.readOpaque8(input, 0, 32);
        byte[] cookie = null;
        if (dtlsOutput != null) {
            int maxCookieLength = ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(clientVersion) ? 255 : 32;
            cookie = TlsUtils.readOpaque8(messageInput, 0, maxCookieLength);
        }
        if ((cipher_suites_length = TlsUtils.readUint16(input)) < 2 || (cipher_suites_length & 1) != 0 || messageInput.available() < cipher_suites_length) {
            throw new TlsFatalAlert(50);
        }
        int[] cipherSuites = TlsUtils.readUint16Array(cipher_suites_length / 2, input);
        short[] compressionMethods = TlsUtils.readUint8ArrayWithUint8Length(input, 1);
        if (!Arrays.contains(compressionMethods, (short)0)) {
            throw new TlsFatalAlert(40);
        }
        Hashtable extensions = null;
        if (messageInput.available() > 0) {
            byte[] extBytes = TlsUtils.readOpaque16(input);
            TlsProtocol.assertEmpty(messageInput);
            extensions = TlsProtocol.readExtensionsDataClientHello(extBytes);
        }
        return new ClientHello(clientVersion, random, sessionID, cookie, cipherSuites, extensions, -1);
    }
}

