/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.TlsContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsHandshakeHash;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHash;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class SSL3Utils {
    private static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
    private static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static final byte[] IPAD = SSL3Utils.genPad((byte)54, 48);
    private static final byte[] OPAD = SSL3Utils.genPad((byte)92, 48);

    SSL3Utils() {
    }

    static byte[] calculateVerifyData(TlsHandshakeHash handshakeHash, boolean isServer) {
        TlsHash prf = handshakeHash.forkPRFHash();
        byte[] sslSender = isServer ? SSL_SERVER : SSL_CLIENT;
        prf.update(sslSender, 0, sslSender.length);
        return prf.calculateHash();
    }

    static void completeCombinedHash(TlsContext context, TlsHash md5, TlsHash sha1) {
        TlsSecret masterSecret = context.getSecurityParametersHandshake().getMasterSecret();
        byte[] master_secret = context.getCrypto().adoptSecret(masterSecret).extract();
        SSL3Utils.completeHash(master_secret, md5, 48);
        SSL3Utils.completeHash(master_secret, sha1, 40);
    }

    private static void completeHash(byte[] master_secret, TlsHash hash, int padLength) {
        hash.update(master_secret, 0, master_secret.length);
        hash.update(IPAD, 0, padLength);
        byte[] tmp = hash.calculateHash();
        hash.update(master_secret, 0, master_secret.length);
        hash.update(OPAD, 0, padLength);
        hash.update(tmp, 0, tmp.length);
    }

    private static byte[] genPad(byte b, int count) {
        byte[] padding = new byte[count];
        Arrays.fill(padding, b);
        return padding;
    }

    static byte[] readEncryptedPMS(InputStream input) throws IOException {
        return Streams.readAll(input);
    }

    static void writeEncryptedPMS(byte[] encryptedPMS, OutputStream output) throws IOException {
        output.write(encryptedPMS);
    }
}

