/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.signers.Ed448Signer;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureScheme;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsStreamSigner;
import java.io.IOException;

public class BcTlsEd448Signer
extends BcTlsSigner {
    public BcTlsEd448Signer(BcTlsCrypto crypto, Ed448PrivateKeyParameters privateKey) {
        super(crypto, privateKey);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) {
        if (algorithm == null || SignatureScheme.from(algorithm) != 2056) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        Ed448Signer signer = new Ed448Signer(TlsUtils.EMPTY_BYTES);
        signer.init(true, this.privateKey);
        return new BcTlsStreamSigner(signer);
    }
}

