/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.ExtendedDigest;
import cn.win_trust_erpc.bouncycastle.crypto.macs.HMac;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHMAC;

final class BcTlsHMAC
implements TlsHMAC {
    private final HMac hmac;

    BcTlsHMAC(HMac hmac) {
        this.hmac = hmac;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.hmac.init(new KeyParameter(key, keyOff, keyLen));
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.hmac.update(input, inOff, length);
    }

    @Override
    public byte[] calculateMAC() {
        byte[] rv = new byte[this.hmac.getMacSize()];
        this.hmac.doFinal(rv, 0);
        return rv;
    }

    @Override
    public void calculateMAC(byte[] output, int outOff) {
        this.hmac.doFinal(output, outOff);
    }

    @Override
    public int getInternalBlockSize() {
        return ((ExtendedDigest)this.hmac.getUnderlyingDigest()).getByteLength();
    }

    @Override
    public int getMacLength() {
        return this.hmac.getMacSize();
    }

    @Override
    public void reset() {
        this.hmac.reset();
    }
}

