/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.Signer;
import cn.win_trust_erpc.bouncycastle.crypto.digests.NullDigest;
import cn.win_trust_erpc.bouncycastle.crypto.encodings.PKCS1Encoding;
import cn.win_trust_erpc.bouncycastle.crypto.engines.RSABlindedEngine;
import cn.win_trust_erpc.bouncycastle.crypto.params.RSAKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.signers.GenericSigner;
import cn.win_trust_erpc.bouncycastle.crypto.signers.RSADigestSigner;
import cn.win_trust_erpc.bouncycastle.tls.DigitallySigned;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsRSAVerifier
extends BcTlsVerifier {
    public BcTlsRSAVerifier(TlsCrypto crypto, RSAKeyParameters publicKey) {
        super(crypto, publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        Signer signer;
        NullDigest nullDigest = new NullDigest();
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null) {
            if (algorithm.getSignature() != 1) {
                throw new IllegalStateException("Invalid algorithm: " + algorithm);
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(false, this.publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(signedParams.getSignature());
    }
}

