/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.params.ECPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithID;
import cn.win_trust_erpc.bouncycastle.crypto.signers.SM2Signer;
import cn.win_trust_erpc.bouncycastle.tls.DigitallySigned;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamVerifier;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsStreamVerifier;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.IOException;

public class BcTlsSM2Verifier
extends BcTlsVerifier {
    protected final byte[] identifier;

    public BcTlsSM2Verifier(BcTlsCrypto crypto, ECPublicKeyParameters publicKey, byte[] identifier) {
        super(crypto, publicKey);
        this.identifier = Arrays.clone(identifier);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        ParametersWithID parametersWithID = new ParametersWithID(this.publicKey, this.identifier);
        SM2Signer verifier = new SM2Signer();
        verifier.init(false, parametersWithID);
        return new BcTlsStreamVerifier(verifier, signature.getSignature());
    }
}

