/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.crypto.Mac;
import cn.win_trust_erpc.bouncycastle.crypto.macs.HMac;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.Strings;

public class BcTlsSecret
extends AbstractTlsSecret {
    private static final byte[] SSL3_CONST = BcTlsSecret.generateSSL3Constants();
    protected final BcTlsCrypto crypto;

    public static BcTlsSecret convert(BcTlsCrypto crypto, TlsSecret secret) {
        if (secret instanceof BcTlsSecret) {
            return (BcTlsSecret)secret;
        }
        if (secret instanceof AbstractTlsSecret) {
            AbstractTlsSecret abstractTlsSecret = (AbstractTlsSecret)secret;
            return crypto.adoptLocalSecret(BcTlsSecret.copyData(abstractTlsSecret));
        }
        throw new IllegalArgumentException("unrecognized TlsSecret - cannot copy data: " + secret.getClass().getName());
    }

    private static byte[] generateSSL3Constants() {
        int n = 15;
        byte[] result = new byte[n * (n + 1) / 2];
        int pos = 0;
        int i = 0;
        while (i < n) {
            byte b = (byte)(65 + i);
            int j = 0;
            while (j <= i) {
                result[pos++] = b;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public BcTlsSecret(BcTlsCrypto crypto, byte[] data) {
        super(data);
        this.crypto = crypto;
    }

    @Override
    public synchronized TlsSecret deriveUsingPRF(int prfAlgorithm, String label, byte[] seed, int length) {
        this.checkAlive();
        try {
            switch (prfAlgorithm) {
                case 4: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 4, label, seed, length);
                }
                case 5: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 5, label, seed, length);
                }
                case 7: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 7, label, seed, length);
                }
            }
            return this.crypto.adoptLocalSecret(this.prf(prfAlgorithm, label, seed, length));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized TlsSecret hkdfExpand(int cryptoHashAlgorithm, byte[] info, int length) {
        int remaining;
        if (length < 1) {
            return this.crypto.adoptLocalSecret(TlsUtils.EMPTY_BYTES);
        }
        int hashLen = TlsCryptoUtils.getHashOutputSize(cryptoHashAlgorithm);
        if (length > 255 * hashLen) {
            throw new IllegalArgumentException("'length' must be <= 255 * (output size of 'hashAlgorithm')");
        }
        this.checkAlive();
        byte[] prk = this.data;
        HMac hmac = new HMac(this.crypto.createDigest(cryptoHashAlgorithm));
        hmac.init(new KeyParameter(prk));
        byte[] okm = new byte[length];
        byte[] t = new byte[hashLen];
        int counter = 0;
        int pos = 0;
        while (true) {
            hmac.update(info, 0, info.length);
            byte by = (byte)(counter + 1);
            counter = by;
            hmac.update(by);
            hmac.doFinal(t, 0);
            remaining = length - pos;
            if (remaining <= hashLen) break;
            System.arraycopy(t, 0, okm, pos, hashLen);
            pos += hashLen;
            hmac.update(t, 0, t.length);
        }
        System.arraycopy(t, 0, okm, pos, remaining);
        return this.crypto.adoptLocalSecret(okm);
    }

    @Override
    public synchronized TlsSecret hkdfExtract(int cryptoHashAlgorithm, TlsSecret ikm) {
        this.checkAlive();
        byte[] salt = this.data;
        this.data = null;
        HMac hmac = new HMac(this.crypto.createDigest(cryptoHashAlgorithm));
        hmac.init(new KeyParameter(salt));
        BcTlsSecret.convert(this.crypto, ikm).updateMac(hmac);
        byte[] prk = new byte[hmac.getMacSize()];
        hmac.doFinal(prk, 0);
        return this.crypto.adoptLocalSecret(prk);
    }

    @Override
    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(Digest digest, byte[] secret, int secretOff, int secretLen, byte[] seed, byte[] output) {
        HMac mac = new HMac(digest);
        mac.init(new KeyParameter(secret, secretOff, secretLen));
        byte[] a = seed;
        int macSize = mac.getMacSize();
        byte[] b1 = new byte[macSize];
        byte[] b2 = new byte[macSize];
        int pos = 0;
        while (pos < output.length) {
            mac.update(a, 0, a.length);
            mac.doFinal(b1, 0);
            a = b1;
            mac.update(a, 0, a.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(b2, 0);
            System.arraycopy(b2, 0, output, pos, Math.min(macSize, output.length - pos));
            pos += macSize;
        }
    }

    protected byte[] prf(int prfAlgorithm, String label, byte[] seed, int length) {
        if (prfAlgorithm == 0) {
            return this.prf_SSL(seed, length);
        }
        byte[] labelSeed = Arrays.concatenate(Strings.toByteArray(label), seed);
        if (1 == prfAlgorithm) {
            return this.prf_1_0(labelSeed, length);
        }
        return this.prf_1_2(prfAlgorithm, labelSeed, length);
    }

    protected byte[] prf_SSL(byte[] seed, int length) {
        Digest md5 = this.crypto.createDigest(1);
        Digest sha1 = this.crypto.createDigest(2);
        int md5Size = md5.getDigestSize();
        int sha1Size = sha1.getDigestSize();
        byte[] tmp = new byte[Math.max(md5Size, sha1Size)];
        byte[] result = new byte[length];
        int constLen = 1;
        int constPos = 0;
        int resultPos = 0;
        while (resultPos < length) {
            sha1.update(SSL3_CONST, constPos, constLen);
            constPos += constLen++;
            sha1.update(this.data, 0, this.data.length);
            sha1.update(seed, 0, seed.length);
            sha1.doFinal(tmp, 0);
            md5.update(this.data, 0, this.data.length);
            md5.update(tmp, 0, sha1Size);
            int remaining = length - resultPos;
            if (remaining < md5Size) {
                md5.doFinal(tmp, 0);
                System.arraycopy(tmp, 0, result, resultPos, remaining);
                resultPos += remaining;
                continue;
            }
            md5.doFinal(result, resultPos);
            resultPos += md5Size;
        }
        return result;
    }

    protected byte[] prf_1_0(byte[] labelSeed, int length) {
        int s_half = (this.data.length + 1) / 2;
        byte[] b1 = new byte[length];
        this.hmacHash(this.crypto.createDigest(1), this.data, 0, s_half, labelSeed, b1);
        byte[] b2 = new byte[length];
        this.hmacHash(this.crypto.createDigest(2), this.data, this.data.length - s_half, s_half, labelSeed, b2);
        int i = 0;
        while (i < length) {
            int n = i;
            b1[n] = (byte)(b1[n] ^ b2[i]);
            ++i;
        }
        return b1;
    }

    protected byte[] prf_1_2(int prfAlgorithm, byte[] labelSeed, int length) {
        Digest digest = this.crypto.createDigest(TlsCryptoUtils.getHashForPRF(prfAlgorithm));
        byte[] result = new byte[length];
        this.hmacHash(digest, this.data, 0, this.data.length, labelSeed, result);
        return result;
    }

    protected synchronized void updateMac(Mac mac) {
        this.checkAlive();
        mac.update(this.data, 0, this.data.length);
    }
}

