/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA512Digest;
import cn.win_trust_erpc.bouncycastle.crypto.prng.SP800SecureRandom;
import cn.win_trust_erpc.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsNonceGenerator;
import java.security.SecureRandom;

class JcaNonceGenerator
implements TlsNonceGenerator {
    private final SP800SecureRandom random;

    JcaNonceGenerator(SecureRandom entropySource, byte[] additionalData) {
        byte[] nonce = new byte[32];
        entropySource.nextBytes(nonce);
        this.random = new SP800SecureRandomBuilder(entropySource, false).setPersonalizationString(additionalData).buildHash(new SHA512Digest(), nonce, false);
    }

    @Override
    public byte[] generateNonce(int size) {
        byte[] nonce = new byte[size];
        this.random.nextBytes(nonce);
        return nonce;
    }
}

