/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsEncryptor;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

final class JcaTlsRSAEncryptor
implements TlsEncryptor {
    private final TlsCrypto crypto;
    private final PublicKey pubKeyRSA;

    JcaTlsRSAEncryptor(TlsCrypto crypto, PublicKey pubKeyRSA) {
        this.crypto = crypto;
        this.pubKeyRSA = pubKeyRSA;
    }

    @Override
    public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
        try {
            Cipher c = this.crypto.createRSAEncryptionCipher();
            try {
                c.init(3, (Key)this.pubKeyRSA, this.crypto.getSecureRandom());
                return c.wrap(new SecretKeySpec(input, inOff, length, "TLS"));
            }
            catch (Exception e) {
                try {
                    c.init(1, (Key)this.pubKeyRSA, this.crypto.getSecureRandom());
                    return c.doFinal(input, inOff, length);
                }
                catch (Exception ex) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

