/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.netsign.agent.communication.APIToServerNonePoolImpl;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.base.AbstractMessage;
import java.security.MessageDigest;

public class NetSignService
implements Cloneable {
    private String host;
    private int port;
    private int timeout = 60000;
    private int poolSize = 50;
    private byte[] pwd;
    private APIToServerNonePoolImpl api;

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private NetSignService() {
    }

    public static NetSignService getInstance(String host, int port, String pwd) throws NetSignAgentException {
        if (host == null || host.equals("") || port < 1) {
            throw new NetSignAgentException(-1025, "NetSignServer host must not null");
        }
        NetSignService nss = new NetSignService();
        nss.host = host;
        nss.port = port;
        if (pwd != null && !pwd.equals("")) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                nss.pwd = md.digest(pwd.getBytes("GBK"));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1023, "Hash api passwd error");
            }
        }
        nss.api = new APIToServerNonePoolImpl();
        return nss;
    }

    public static NetSignService getInstance(String host, int port, String pwd, int timeout) throws NetSignAgentException {
        if (host == null || host.equals("") || port < 1) {
            throw new NetSignAgentException(-1025, "NetSignServer host must not null");
        }
        NetSignService nss = new NetSignService();
        nss.host = host;
        nss.port = port;
        nss.timeout = timeout;
        if (pwd != null && !pwd.equals("")) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                nss.pwd = md.digest(pwd.getBytes("GBK"));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1023, "Hash api passwd error");
            }
        }
        nss.api = new APIToServerNonePoolImpl();
        return nss;
    }

    public static NetSignService getInstance(String host, int port, int timeout) throws NetSignAgentException {
        if (host == null || host.equals("") || port < 1) {
            throw new NetSignAgentException(-1025, "NetSignServer host must not null");
        }
        NetSignService nss = new NetSignService();
        nss.host = host;
        nss.port = port;
        nss.timeout = timeout;
        nss.api = new APIToServerNonePoolImpl();
        return nss;
    }

    public static NetSignService getInstance(String host, int port) throws NetSignAgentException {
        if (host == null || host.equals("") || port < 1) {
            throw new NetSignAgentException(-1025, "NetSignServer host must not null");
        }
        NetSignService nss = new NetSignService();
        nss.host = host;
        nss.port = port;
        nss.api = new APIToServerNonePoolImpl();
        return nss;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getPwd() {
        return this.pwd;
    }

    AbstractMessage sendAndRecv(AbstractMessage req) throws NetSignAgentException, ServerProcessException {
        return this.api.sendAndRecv(req, this.host, this.port, this.timeout);
    }

    public Object clone() {
        NetSignService nss = new NetSignService();
        nss.host = this.host;
        nss.port = this.port;
        nss.pwd = this.pwd;
        nss.api = new APIToServerNonePoolImpl();
        return nss;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NetSignService ").append(this.host).append(":").append(this.port);
        return buf.toString();
    }
}

