/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.BarCodeParameters;
import cn.com.infosec.netsign.base.CSRParameters;
import cn.com.infosec.netsign.base.NetSignInputStream;
import cn.com.infosec.netsign.base.PDFRequest;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NSMessage
extends AbstractMessage {
    private static final long serialVersionUID = -7287357755588305320L;
    private byte[] pdfpasswd = null;
    private ArrayList pdfSignatureRectangles;
    private ArrayList pdfImages;
    private HashMap pdfStamps;
    private BarCodeParameters bcPara = null;
    private double bcHeight = 0.0;
    private double bcElementWidth = 0.0;
    private boolean bcDoQuietZone = false;
    private double bcQuietZoneWidth = 0.0;
    private boolean bcDisplayHumanReadable = false;
    private boolean bcDisplayHumanReadableStartStop = false;
    private int bcReturnFormat = -1;
    private boolean bcAddCheckSUM = false;
    private float bcWideFactor = 1.0f;
    private int bcEncodingMode = -1;
    private int bcErrorCorrectingLevel = -1;
    private float bcAspectRatio = 0.0f;
    private float bcYHeight = 1.0f;
    private int bcBarSize = 0;
    private boolean needCanonial = false;
    private int communicateMode = 1;
    private boolean zipMode = false;
    private byte[] encKey = null;
    private byte[] keyHash = null;
    private byte[] plainText = null;
    private byte[] cryptoText = null;
    private byte[] tsaText = null;
    private boolean usedTSA = false;
    private X509Certificate cert = null;
    private PublicKey publickey = null;
    private boolean transCert = false;
    private String encCertDN = null;
    private String signCertDN = null;
    private String signCertType = null;
    private String digestAlg = null;
    private String symmetricalAlg = null;
    private byte[] hashValue;
    private String plainTextFile;
    private String cryptoTextFile;
    private NetSignInputStream[] in;
    private String xmlSigID;
    private String xmlReferenceURI;
    private byte[] APIPasswd;
    private String bankName;
    private String bankID;
    private String resourceName;
    private String notice;
    private CSRParameters csr;

    public void setCSRParameters(CSRParameters csr) {
        this.csr = csr;
    }

    public CSRParameters getCSRParameters() {
        return this.csr;
    }

    public void setNotice(String notice) {
        this.notice = notice;
    }

    public String getNotice() {
        return this.notice;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getBankID() {
        return this.bankID;
    }

    public void setBankID(String bankID) {
        this.bankID = bankID;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public byte[] getAPIPasswd() {
        return this.APIPasswd;
    }

    public void setAPIPasswd(byte[] aPIPasswd) {
        this.APIPasswd = aPIPasswd;
    }

    public void setXmlReferenceURI(String uri) {
        this.xmlReferenceURI = uri;
    }

    public String getXmlReferenceURI() {
        return this.xmlReferenceURI;
    }

    public void setXmlSigID(String id) {
        this.xmlSigID = id;
    }

    public String getXmlSigID() {
        return this.xmlSigID;
    }

    private String getCommDesc() {
        switch (this.communicateMode) {
            case 0: {
                return "CryptoText";
            }
            case 1: {
                return "PlainText";
            }
        }
        return null;
    }

    private String getBase64Desc(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return Base64.encode(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    String getDesc() {
        byte[] bs;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<processor>" + this.getProcessor() + "</processor>");
        if (this.getClientId() != null) {
            buffer.append("<client-id>" + this.getClientId() + "</client-id>");
        }
        buffer.append("<communicate-mode>" + this.getCommDesc() + "</communicate-mode>");
        if (this.isZipMode()) {
            buffer.append("<zip-mode>" + this.isZipMode() + "</zip-mode>");
        }
        if (this.getPlainText() != null) {
            buffer.append("<plain-text>" + this.getBase64Desc(this.getPlainText()) + "</plain-text>");
        }
        if (this.getCryptoText() != null) {
            buffer.append("<crypto-text>" + this.getBase64Desc(this.getCryptoText()) + "</crypto-text>");
        }
        if (this.getUsedTSA()) {
            buffer.append("<used-tsa usedTSA=\"" + this.getUsedTSA() + "\"/>");
        }
        if (this.getTSAText() != null) {
            buffer.append("<tsa-text>" + this.getBase64Desc(this.getTSAText()) + "</tsa-text>");
        }
        buffer.append("<certificate transCert=\"" + this.isTransCert() + "\">");
        if (this.getCert() != null) {
            try {
                buffer.append(this.getBase64Desc(this.getCert().getEncoded()));
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
            }
        }
        buffer.append("</certificate>");
        if (this.getPublicKey() != null) {
            try {
                buffer.append("<publickey>").append(this.getBase64Desc(this.getPublicKey().getEncoded())).append("</publickey>");
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
            }
        }
        if (this.getEncCertDN() != null) {
            buffer.append("<enc-cert-subject>" + this.getEncCertDN() + "</enc-cert-subject>");
        }
        if (this.getSignCertDN() != null) {
            buffer.append("<sign-cert-subject>" + this.getSignCertDN() + "</sign-cert-subject>");
        }
        if (this.getDigestAlg() != null) {
            buffer.append("<digest-alg>" + this.getDigestAlg() + "</digest-alg>");
        }
        if (this.getSymmetricalAlg() != null) {
            buffer.append("<symmetrical-alg>" + this.getSymmetricalAlg() + "</symmetrical-alg>");
        }
        if (this.pdfpasswd != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("sha1");
                bs = md.digest(this.pdfpasswd);
                buffer.append("<pdfpasswd>" + Base64.encode(bs) + "</pdfpasswd>");
            }
            catch (Exception md) {
                // empty catch block
            }
        }
        String str = null;
        str = this.getPDFSignatureRectangles2Trans();
        if (str != null) {
            buffer.append("<pdfsignrectangles>" + str + "</pdfsignrectangles>");
        }
        bs = null;
        bs = this.getPDFImages2Trans();
        if (bs != null) {
            buffer.append("<pdfimages>" + Base64.encode(bs) + "</pdfimages>");
        }
        if (this.bcHeight >= 0.0) {
            buffer.append("<bcHeight>" + this.bcHeight + "</bcHeight>");
        }
        if (this.bcElementWidth >= 0.0) {
            buffer.append("<bcElementWidth>" + this.bcElementWidth + "</bcElementWidth>");
        }
        if (this.bcDoQuietZone) {
            buffer.append("<bcDoneQuietZone>" + this.bcDoQuietZone + "</bcDoneQuietZone>");
        }
        if (this.bcQuietZoneWidth >= 0.0) {
            buffer.append("<bcQuietZoneWidth>" + this.bcQuietZoneWidth + "</bcQuietZoneWidth>");
        }
        if (this.bcDisplayHumanReadable) {
            buffer.append("<bcDisplayHumanReadable>" + this.bcDisplayHumanReadable + "</bcDisplayHumanReadable>");
        }
        if (this.bcDisplayHumanReadableStartStop) {
            buffer.append("<bcDisplayHumanReadableStartStop>" + this.bcDisplayHumanReadableStartStop + "</bcDisplayHumanReadableStartStop>");
        }
        if (this.bcReturnFormat >= 0) {
            buffer.append("<bcReturnFormat>" + this.bcReturnFormat + "</bcReturnFormat>");
        }
        if (this.bcAddCheckSUM) {
            buffer.append("<bcAddCheckSUM>" + this.bcAddCheckSUM + "</bcAddCheckSUM>");
        }
        if (this.bcWideFactor >= 0.0f) {
            buffer.append("<bcWideFactor>" + this.bcWideFactor + "</bcWideFactor>");
        }
        if (this.bcEncodingMode >= 0) {
            buffer.append("<bcEncodingMode>" + this.bcEncodingMode + "</bcEncodingMode>");
        }
        if (this.bcErrorCorrectingLevel >= 0) {
            buffer.append("<bcErrorCorrectingLevel>" + this.bcErrorCorrectingLevel + "</bcErrorCorrectingLevel>");
        }
        if (this.bcAspectRatio >= 0.0f) {
            buffer.append("<bcAspectRatio>" + this.bcAspectRatio + "</bcAspectRatio>");
        }
        if (this.bcYHeight >= 0.0f) {
            buffer.append("<bcYHeight>" + this.bcYHeight + "</bcYHeight>");
        }
        if (this.bcBarSize >= 0) {
            buffer.append("<bcBarSize>" + this.bcBarSize + "</bcBarSize>");
        }
        if (this.getBankID() != null) {
            buffer.append("<bankid>" + this.getBankID() + "</bankid>");
        }
        if (this.getBankName() != null) {
            buffer.append("<bankname>" + this.getBankName() + "</bankname>");
        }
        if (this.getAPIPasswd() != null) {
            buffer.append("<APIPasswd>" + Base64.encode(this.getAPIPasswd()) + "</APIPasswd>");
        }
        if (this.resourceName != null) {
            buffer.append("<ResourceName>").append(this.resourceName).append("</ResourceName>");
        }
        if (this.notice != null) {
            buffer.append("<Notice>").append(this.notice).append("</Notice>");
        }
        if (this.csr != null) {
            buffer.append("<csr>").append(Base64.encode(this.csr.getEncoded())).append("</csr>");
        }
        return buffer.toString();
    }

    public byte[] getPDFImages2Trans() {
        if (this.pdfImages != null && this.pdfImages.size() > 0) {
            byte[] tr = new byte[]{};
            int i = 0;
            int length = this.pdfImages.size();
            while (i < length) {
                PDFRequest prq = (PDFRequest)this.pdfImages.get(i);
                byte[] bs = prq.encodeImage();
                byte[] lengthB = Utils.generateBytes(bs.length);
                byte[] tmp = new byte[tr.length + 4 + bs.length];
                System.arraycopy(tr, 0, tmp, 0, tr.length);
                System.arraycopy(lengthB, 0, tmp, tr.length, 4);
                System.arraycopy(bs, 0, tmp, tr.length + 4, bs.length);
                tr = tmp;
                ++i;
            }
            return tr;
        }
        return null;
    }

    public BarCodeParameters getBarCodeParameters() {
        if (this.bcPara == null) {
            this.bcPara = new BarCodeParameters();
            this.bcPara.setBarHeight(this.getBcHeight());
            this.bcPara.setModuleWidth(this.getBcElementWidth());
            this.bcPara.setDoQuietZone(this.isBcDoQuietZone());
            this.bcPara.setDisplayHumanReadable(this.isBcDisplayHumanReadable());
            this.bcPara.setImageFormat(this.getBcReturnFormat());
        }
        return this.bcPara;
    }

    public void setBarCodeParameters(BarCodeParameters bcPara) {
        this.bcPara = bcPara;
        this.setBcHeight(bcPara.getBarHeight());
        this.setBcElementWidth(bcPara.getModuleWidth());
        this.setBcQuietZoneWidth(bcPara.getQuietZoneWidth());
        this.setBcDoQuietZone(bcPara.isDoQuietZone());
        this.setBcDisplayHumanReadable(bcPara.isDisplayHumanReadable());
        this.setBcReturnFormat(bcPara.getImageFormat());
    }

    public byte[] getPdfpasswd() {
        return this.pdfpasswd;
    }

    public void setPdfpasswd(byte[] pdfpasswd) {
        this.pdfpasswd = pdfpasswd;
    }

    public String getPDFSignatureRectangles2Trans() {
        if (this.pdfSignatureRectangles != null && this.pdfSignatureRectangles.size() > 0) {
            StringBuffer str = new StringBuffer();
            int i = 0;
            int size = this.pdfSignatureRectangles.size();
            while (i < size) {
                PDFRequest prq = (PDFRequest)this.pdfSignatureRectangles.get(i);
                str.append(prq.toString());
                if (i + 1 != size) {
                    str.append("<psr>");
                }
                ++i;
            }
            return str.toString();
        }
        return null;
    }

    public String getPDFStamp2Trans() {
        if (this.pdfStamps != null) {
            StringBuffer str = new StringBuffer();
            Iterator iterator = this.pdfStamps.entrySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                String image = (String)entry.getValue();
                str.append(String.valueOf(key) + ":" + image);
                if (i + 1 == this.pdfStamps.size()) continue;
                str.append("<pss>");
            }
            return str.toString();
        }
        return null;
    }

    public byte[] getApiPasswd() {
        return this.APIPasswd;
    }

    public void setApiPasswd(byte[] APIPasswd) {
        this.APIPasswd = APIPasswd;
    }

    public NetSignInputStream[] getNetSignInputStream() {
        return this.in;
    }

    public void setNetSignInputStream(NetSignInputStream[] in) {
        this.in = in;
    }

    public String getPlainTextFile() {
        return this.plainTextFile;
    }

    public void setPlainTextFile(String plainTextFile) {
        this.plainTextFile = plainTextFile;
    }

    public String getCryptoTextFile() {
        return this.cryptoTextFile;
    }

    public void setCryptoTextFile(String cryptoTextFile) {
        this.cryptoTextFile = cryptoTextFile;
    }

    public void setHashValue(byte[] hashValue) {
        this.hashValue = hashValue;
    }

    public byte[] getHashValue() {
        return this.hashValue;
    }

    public boolean isTransCert() {
        return this.transCert;
    }

    public void setTransCert(boolean returnCert) {
        this.transCert = returnCert;
    }

    public void setUsedTSA(boolean flag) {
        this.usedTSA = flag;
    }

    public boolean getUsedTSA() {
        return this.usedTSA;
    }

    public int getCommunicateMode() {
        return this.communicateMode;
    }

    public void setCommunicateMode(int communicateMode) {
        this.communicateMode = communicateMode;
    }

    public boolean isZipMode() {
        return this.zipMode;
    }

    public void setZipMode(boolean zipMode) {
        this.zipMode = zipMode;
    }

    public byte[] getEncKey() {
        return this.encKey;
    }

    public void setEncKey(byte[] encKey) {
        this.encKey = encKey;
    }

    public byte[] getKeyHash() {
        return this.keyHash;
    }

    public void setKeyHash(byte[] keyHash) {
        this.keyHash = keyHash;
    }

    public byte[] getPlainText() {
        return this.plainText;
    }

    public void setPlainText(byte[] plainText) {
        this.plainText = plainText;
    }

    public byte[] getCryptoText() {
        return this.cryptoText;
    }

    public void setCryptoText(byte[] cryptoText) {
        this.cryptoText = cryptoText;
    }

    public byte[] getTSAText() {
        return this.tsaText;
    }

    public void setTSAText(byte[] tsaText) {
        this.tsaText = tsaText;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    public PublicKey getPublicKey() {
        return this.publickey;
    }

    public void setPublicKey(PublicKey publickey) {
        this.publickey = publickey;
    }

    public String getEncCertDN() {
        return this.encCertDN;
    }

    public void setEncCertDN(String certDN) {
        this.encCertDN = certDN;
    }

    public String getSignCertDN() {
        return this.signCertDN;
    }

    public void setSignCertDN(String certDN) {
        this.signCertDN = certDN;
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public void setDigestAlg(String digestAlg) {
        this.digestAlg = digestAlg;
    }

    public String getSymmetricalAlg() {
        return this.symmetricalAlg;
    }

    public void setSymmetricalAlg(String symmetricalAlg) {
        this.symmetricalAlg = symmetricalAlg;
    }

    public double getBcHeight() {
        return this.bcHeight;
    }

    public void setBcHeight(double bcHeight) {
        this.bcHeight = bcHeight;
    }

    public double getBcElementWidth() {
        return this.bcElementWidth;
    }

    public void setBcElementWidth(double bcElementWidth) {
        this.bcElementWidth = bcElementWidth;
    }

    public boolean isBcDoQuietZone() {
        return this.bcDoQuietZone;
    }

    public void setBcDoQuietZone(boolean bcDoQuietZone) {
        this.bcDoQuietZone = bcDoQuietZone;
    }

    public double getBcQuietZoneWidth() {
        return this.bcQuietZoneWidth;
    }

    public void setBcQuietZoneWidth(double bcQuietZoneWidth) {
        this.bcQuietZoneWidth = bcQuietZoneWidth;
    }

    public boolean isBcDisplayHumanReadable() {
        return this.bcDisplayHumanReadable;
    }

    public void setBcDisplayHumanReadable(boolean bcDisplayHumanReadable) {
        this.bcDisplayHumanReadable = bcDisplayHumanReadable;
    }

    public boolean isBcDisplayHumanReadableStartStop() {
        return this.bcDisplayHumanReadableStartStop;
    }

    public void setBcDisplayHumanReadableStartStop(boolean bcDisplayHumanReadableStartStop) {
        this.bcDisplayHumanReadableStartStop = bcDisplayHumanReadableStartStop;
    }

    public int getBcReturnFormat() {
        return this.bcReturnFormat;
    }

    public void setBcReturnFormat(int bcReturnFormat) {
        this.bcReturnFormat = bcReturnFormat;
    }

    public boolean isBcAddCheckSUM() {
        return this.bcAddCheckSUM;
    }

    public void setBcAddCheckSUM(boolean bcAddCheckSUM) {
        this.bcAddCheckSUM = bcAddCheckSUM;
    }

    public float getBcWideFactor() {
        return this.bcWideFactor;
    }

    public void setBcWideFactor(float bcWideFactor) {
        this.bcWideFactor = bcWideFactor;
    }

    public int getBcEncodingMode() {
        return this.bcEncodingMode;
    }

    public void setBcEncodingMode(int bcEncodingMode) {
        this.bcEncodingMode = bcEncodingMode;
    }

    public int getBcErrorCorrectingLevel() {
        return this.bcErrorCorrectingLevel;
    }

    public void setBcErrorCorrectingLevel(int bcErrorCorrectingLevel) {
        this.bcErrorCorrectingLevel = bcErrorCorrectingLevel;
    }

    public float getBcAspectRatio() {
        return this.bcAspectRatio;
    }

    public void setBcAspectRatio(float bcAspectRatio) {
        this.bcAspectRatio = bcAspectRatio;
    }

    public float getBcYHeight() {
        return this.bcYHeight;
    }

    public void setBcYHeight(float bcYHeight) {
        this.bcYHeight = bcYHeight;
    }

    public int getBcBarSize() {
        return this.bcBarSize;
    }

    public void setBcBarSize(int bcBarSize) {
        this.bcBarSize = bcBarSize;
    }

    public String getString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<" + this.getType() + ">");
        buffer.append(this.getDesc());
        buffer.append("</" + this.getType() + ">");
        return buffer.toString();
    }

    public boolean isNeedCanonial() {
        return this.needCanonial;
    }

    public void setNeedCanonial(boolean needCanonial) {
        this.needCanonial = needCanonial;
    }

    public void setPDFSignatureRectangles(ArrayList rectangles) {
        this.pdfSignatureRectangles = rectangles;
    }

    public void setPdfImages(ArrayList pdfImages) {
        this.pdfImages = pdfImages;
    }

    public ArrayList getPDFSignatureRectangles() {
        return this.pdfSignatureRectangles;
    }

    public ArrayList getPdfImages() {
        return this.pdfImages;
    }

    public void setSignCertType(String signCertType) {
        this.signCertType = signCertType;
    }

    public String getSignCertType() {
        return this.signCertType;
    }

    public void setPdfStamps(HashMap pdfStamps) {
        this.pdfStamps = pdfStamps;
    }

    public HashMap getPdfStamps() {
        return this.pdfStamps;
    }
}

