/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;

public class NetSignX509CRL {
    private BigInteger[] ids = new BigInteger[0];
    private long nextUpdate;
    private long fileModify;
    private String file;
    private long lastLoadTime;
    private long lastCheckTime;

    public long getLastCheckTime() {
        return this.lastCheckTime;
    }

    public void setLastCheckTime(long lastCheckTime) {
        this.lastCheckTime = lastCheckTime;
    }

    public long getLastLoadTime() {
        return this.lastLoadTime;
    }

    public void setLastLoadTime(long lastLoadTime) {
        this.lastLoadTime = lastLoadTime;
    }

    public void setFileName(String file) {
        this.file = file;
    }

    public String getFileName() {
        return this.file;
    }

    public void setFileModify(long time) {
        this.fileModify = time;
    }

    public boolean isNewFile(File file) {
        return this.fileModify != file.lastModified();
    }

    public boolean isNewFile(String file) {
        File f = new File(file);
        return this.fileModify != f.lastModified();
    }

    public void addCRL(X509CRL crl) {
        try {
            Object[] os = crl.getRevokedCertificates().toArray();
            BigInteger[] certSN = new BigInteger[os.length];
            int i = 0;
            int length = os.length;
            while (i < length) {
                certSN[i] = ((X509CRLEntry)os[i]).getSerialNumber();
                ++i;
            }
            BigInteger[] idTmp = new BigInteger[this.ids.length + os.length];
            System.arraycopy(this.ids, 0, idTmp, 0, this.ids.length);
            System.arraycopy(certSN, 0, idTmp, this.ids.length, certSN.length);
            this.ids = idTmp;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addCRL(File f, CertificateFactory crlFact) throws Exception {
        X509CRL crl = NetSignX509CRL.genCRL(f, crlFact);
        if (crl != null) {
            this.addCRL(crl);
        }
    }

    public boolean checkValidity() {
        return this.nextUpdate >= System.currentTimeMillis();
    }

    public void sort() {
        Arrays.sort(this.ids);
    }

    private static X509CRL genCRL(File f, CertificateFactory crlFact) throws Exception {
        X509CRL x509CRL;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            X509CRL x509crl = null;
            try {
                x509crl = (X509CRL)crlFact.generateCRL(fis);
            }
            catch (Exception e1) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.sleep(10L);
                fis = new FileInputStream(f);
                x509crl = (X509CRL)crlFact.generateCRL(fis);
            }
            x509CRL = x509crl;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return x509CRL;
    }

    public static NetSignX509CRL getInstance(File f, CertificateFactory crlFact) throws Exception {
        X509CRL x509crl;
        block3: {
            x509crl = NetSignX509CRL.genCRL(f, crlFact);
            if (x509crl != null) break block3;
            return null;
        }
        NetSignX509CRL crl = NetSignX509CRL.getInstance(x509crl);
        crl.setFileModify(f.lastModified());
        crl.setFileName(f.getAbsolutePath());
        crl.setLastLoadTime(System.currentTimeMillis());
        return crl;
    }

    public static NetSignX509CRL getInstance(X509CRL crl) {
        NetSignX509CRL nscrl = new NetSignX509CRL();
        try {
            if (crl != null) {
                Set<? extends X509CRLEntry> crls = crl.getRevokedCertificates();
                if (crls != null) {
                    nscrl.ids = new BigInteger[crls.size()];
                    Object[] os = crls.toArray();
                    crls = null;
                    int i = 0;
                    int size = os.length;
                    while (i < size) {
                        nscrl.ids[i] = ((X509CRLEntry)os[i]).getSerialNumber();
                        os[i] = null;
                        ++i;
                    }
                    os = null;
                    Arrays.sort(nscrl.ids);
                } else {
                    nscrl.ids = new BigInteger[0];
                }
                nscrl.nextUpdate = crl.getNextUpdate().getTime();
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
        return nscrl;
    }

    public boolean isRevoked(X509Certificate cert) {
        return Arrays.binarySearch(this.ids, cert.getSerialNumber()) > -1;
    }

    public int size() {
        return this.ids == null ? 0 : this.ids.length;
    }

    void write(OutputStream out) {
        if (this.ids != null) {
            int i = 0;
            int length = this.ids.length;
            while (i < length) {
                try {
                    out.write(("\t\t" + this.ids[i].toString() + "\n").getBytes());
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                }
                ++i;
            }
        }
    }
}

