/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import java.math.BigInteger;

public class XMLVerifyResult {
    private int returnCode = 1;
    private String issuerSubject;
    private BigInteger sn;
    private String subject;
    private long notBefore;
    private long notAfter;
    private String sigId;
    private String b64cert;
    private String[] reference;

    public String getSigId() {
        return this.sigId;
    }

    public void setSigId(String sigId) {
        this.sigId = sigId;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public String getIssuerSubject() {
        return this.issuerSubject;
    }

    public void setIssuerSubject(String issuerSubject) {
        this.issuerSubject = issuerSubject;
    }

    public BigInteger getSn() {
        return this.sn;
    }

    public void setSn(BigInteger sn) {
        this.sn = sn;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(long notBefore) {
        this.notBefore = notBefore;
    }

    public long getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(long notAfter) {
        this.notAfter = notAfter;
    }

    public String[] getReference() {
        return this.reference;
    }

    public void setReference(String[] reference) {
        this.reference = reference;
    }

    public String getB64cert() {
        return this.b64cert;
    }

    public void setB64cert(String b64cert) {
        this.b64cert = b64cert;
    }

    public String toString() {
        String s = ";";
        StringBuffer buf = new StringBuffer();
        buf.append(this.returnCode);
        buf.append(s);
        if (this.issuerSubject != null) {
            buf.append(this.issuerSubject);
        } else {
            buf.append(" ");
        }
        buf.append(s);
        if (this.sn != null) {
            buf.append(this.sn.toString(16));
        } else {
            buf.append("0");
        }
        buf.append(s);
        if (this.subject != null) {
            buf.append(this.subject);
        } else {
            buf.append(" ");
        }
        buf.append(s);
        if (this.sigId != null) {
            buf.append(this.sigId);
        } else {
            buf.append(" ");
        }
        buf.append(s);
        buf.append(this.notBefore).append(s).append(this.notAfter).append(s);
        if (this.b64cert != null) {
            buf.append(this.b64cert);
        } else {
            buf.append(" ");
        }
        buf.append(s);
        int i = 0;
        while (i < this.reference.length) {
            buf.append(this.reference[i]);
            if (i < this.reference.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }

    public static XMLVerifyResult parse(String str) {
        XMLVerifyResult pvr = new XMLVerifyResult();
        String[] pieces = str.split(";");
        if (!pieces[0].equals(" ")) {
            pvr.setReturnCode(Integer.parseInt(pieces[0]));
        }
        if (!pieces[1].equals(" ")) {
            pvr.setIssuerSubject(pieces[1]);
        }
        try {
            BigInteger bi = new BigInteger(pieces[2], 16);
            pvr.setSn(bi);
        }
        catch (Exception bi) {
            // empty catch block
        }
        if (!pieces[3].equals(" ")) {
            pvr.setSubject(pieces[3]);
        }
        if (!pieces[4].equals(" ")) {
            pvr.setSigId(pieces[4]);
        }
        pvr.setNotBefore(Long.parseLong(pieces[5]));
        pvr.setNotAfter(Long.parseLong(pieces[6]));
        if (!pieces[7].equals(" ")) {
            pvr.setB64cert(pieces[7]);
        }
        if (pieces.length < 9) {
            pvr.setReference(new String[]{""});
        } else if (!pieces[8].equals(" ")) {
            String[] refs = pieces[8].trim().split(",");
            pvr.setReference(refs);
        }
        return pvr;
    }
}

