/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.pool;

import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.pool.Poolable;
import java.util.ArrayList;

public class Pool {
    private Class pooledClass;
    private int maxSize;
    private int usingSize = 0;
    private Object lock = new Object();
    private ArrayList pooledObjects = new ArrayList();
    private Object initPara;

    public Pool(String className, int maxSize, Object initPara) throws ClassNotFoundException {
        this.pooledClass = Class.forName(className);
        this.maxSize = maxSize;
        this.initPara = initPara;
    }

    public int usingSize() {
        return this.usingSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Poolable getObject() throws Exception {
        Poolable obj = null;
        Object object = this.lock;
        synchronized (object) {
            while (this.maxSize > 0 && this.usingSize >= this.maxSize) {
                this.lock.wait();
            }
            if (this.pooledObjects.size() > 0) {
                obj = (Poolable)this.pooledObjects.remove(this.pooledObjects.size() - 1);
            } else {
                obj = (Poolable)this.pooledClass.newInstance();
                obj.init(this.initPara);
            }
            ++this.usingSize;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeObject(Poolable obj) {
        Object object = this.lock;
        synchronized (object) {
            this.pooledObjects.add(obj);
            --this.usingSize;
            try {
                this.lock.notifyAll();
            }
            catch (IllegalMonitorStateException e) {
                ConsoleLogger.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropObject(Poolable obj) {
        Object object = this.lock;
        synchronized (object) {
            try {
                obj.destory();
            }
            catch (Exception e) {
                ConsoleLogger.logException(e);
            }
            --this.usingSize;
            try {
                this.lock.notifyAll();
            }
            catch (IllegalMonitorStateException e) {
                ConsoleLogger.logException(e);
            }
        }
    }
}

