/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.netsign.der.util.CRLParameters;
import cn.com.infosec.netsign.der.util.DERSegment;
import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.der.util.RevokedCertificate;
import java.math.BigInteger;
import java.util.ArrayList;

public class CRLParser {
    public static CRLParameters parse(byte[] crlEntry) {
        CRLParameters crl = new CRLParameters();
        DERSegment ds = new DERSegment(crlEntry);
        ds = ds.getInnerDERSegment();
        DERSegment tbs = ds.nextDERSegment();
        DERSegment sigAlg = ds.nextDERSegment();
        DERSegment sig = ds.nextDERSegment();
        crl.setSignature(sig.getInnerData());
        ds = tbs.getInnerDERSegment();
        ds.nextDERSegment();
        ds.nextDERSegment();
        ds.nextDERSegment();
        DERSegment thisUpdateDS = ds.nextDERSegment();
        try {
            crl.setThisUpdate(DERUtil.ASN12Date(thisUpdateDS.getInnerData()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        block11: while (ds.hasMoreDERSegment()) {
            DERSegment tmp = ds.nextDERSegment();
            switch (tmp.getType()) {
                case 23: {
                    try {
                        crl.setNextUpdate(DERUtil.ASN12Date(tmp.getInnerData()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block11;
                }
                case 24: {
                    try {
                        crl.setNextUpdate(DERUtil.ASN12Date(tmp.getInnerData()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue block11;
                }
                case 48: {
                    crl.setRevokedCertificates(CRLParser.parseRevokedCertificates(tmp));
                }
            }
        }
        return crl;
    }

    private static ArrayList parseRevokedCertificates(DERSegment ds) {
        ds = ds.getInnerDERSegment();
        ArrayList<RevokedCertificate> list = new ArrayList<RevokedCertificate>();
        while (ds.hasMoreDERSegment()) {
            DERSegment rc = ds.nextDERSegment();
            RevokedCertificate rCert = new RevokedCertificate();
            rc = rc.getInnerDERSegment();
            rc = rc.nextDERSegment();
            rCert.setRevokedSerialNumber(new BigInteger(rc.getInnerData()));
            list.add(rCert);
        }
        return list;
    }
}

