/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.der.util.CRLGenerater;
import cn.com.infosec.netsign.der.util.CRLParameters;
import cn.com.infosec.netsign.der.util.CRLParser;
import cn.com.infosec.netsign.der.util.ConsoleLogger;
import cn.com.infosec.netsign.der.util.DERSegment;
import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.der.util.PKCS7SignedData;
import cn.com.infosec.netsign.der.util.PKCS7SignedDataGenerater;
import cn.com.infosec.netsign.der.util.PKCS7SignedDataParser;
import cn.com.infosec.netsign.der.util.RevokedCertificate;
import cn.com.infosec.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;

public class Test {
    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        ConsoleLogger.isDebug = true;
        ConsoleLogger.isSave = true;
        Test.parseP7();
    }

    public static void testParseCrl() throws Exception {
        File f = new File("D:/TEMP/icbc/20120523/");
        File[] files = f.listFiles();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        TimeZone tz = TimeZone.getDefault();
        tz.setRawOffset(8);
        int i = 0;
        int length = files.length;
        while (i < length) {
            if (files[i].getName().indexOf(".crl") > 0) {
                System.out.println("File:" + files[i].getName());
                FileInputStream in = new FileInputStream(files[i]);
                byte[] bs = new byte[in.available()];
                in.read(bs);
                CRLParameters crl = CRLParser.parse(bs);
                System.out.println("This update:" + dateFormat.format(crl.getThisUpdate()));
                System.out.println("Next update:" + dateFormat.format(crl.getNextUpdate()));
                ArrayList list = crl.getRevokedCertificates();
                if (list != null) {
                    System.out.println(String.valueOf(list.size()) + " certs revoked");
                    int j = 0;
                    int size = list.size();
                    while (j < size) {
                        RevokedCertificate revokedCertificate = (RevokedCertificate)list.get(j);
                        ++j;
                    }
                } else {
                    System.out.println("0 cert revoked");
                }
            }
            ++i;
        }
    }

    public static void testP10() throws Exception {
        String p10 = "MIHRMH4CAQAwJTERMA8GA1UEAwwIc20ydGVzdDExEDAOBgNVBAoMB2luZm9zZWMwUjAMBgcqhkjOPQIBAgEHA0IABEchRtuTK1vQbs4kDWeG5aHy1DrxHu3IDQ7ZK3cIxqdz1nt9MzPXYov5D9WBO3nvCFYY6nqbFxwQIDNOu8ucaaMwDAYIKoEcgUUBg3UFAANBAOWvInKXf4MrOI7bK5+XQxGE9SQ0qFdHe70zlnSxA5Ezp4cAoAgefJkSLTrwTnDg7EQFT3oSvgqjnLaK7oTrHmc=";
        DERSegment seg = new DERSegment(Base64.decode((String)p10));
        seg = seg.getInnerDERSegment();
        ConsoleLogger.logBinary("1", seg.getEncoded());
        seg = seg.getInnerDERSegment();
        ConsoleLogger.logBinary("2", seg.getEncoded());
        seg = seg.getDERSegment(2);
        ConsoleLogger.logBinary("3", seg.getEncoded());
        byte[] pubk = seg.getEncoded();
    }

    public static void makeCRL() throws Exception {
        CRLParameters crlPara = new CRLParameters();
        Date now = new Date();
        RevokedCertificate rc = new RevokedCertificate();
        rc.setRevokedSerialNumber(new BigInteger("4b920137", 16));
        rc.setRevokedTime(now);
        ArrayList<RevokedCertificate> list = new ArrayList<RevokedCertificate>();
        list.add(rc);
        crlPara.setIssuer("C=cn,O=syn080924,CN=root080924");
        crlPara.setThisUpdate(now);
        now = new Date();
        now.setTime(System.currentTimeMillis() + 43200000L);
        crlPara.setNextUpdate(now);
        crlPara.setSignatureAlgOid("1.2.840.113549.1.1.1");
        crlPara.setRevokedCertificates(list);
        CRLGenerater cg = new CRLGenerater(crlPara);
        cg.generateTBSCRL();
        cg.setSignature(new byte[128]);
        byte[] crl = cg.generateCRL();
        CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
        X509CRL c = (X509CRL)cf.generateCRL(new ByteArrayInputStream(crl));
        System.out.println(c.getIssuerX500Principal().toString());
        FileOutputStream out = new FileOutputStream("D:\\WORK\\myjava\\infosec\\certs\\cert\\crl\\crl15.crl");
        out.write(crl);
        out.flush();
        out.close();
    }

    public static void testCert() throws Exception {
        FileInputStream in = new FileInputStream("D:\\TEMP\\5year.cer");
        byte[] bs = new byte[in.available()];
        in.read(bs);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bs));
        DERSegment derSeg = new DERSegment(cert.getTBSCertificate()).getInnerDERSegment().getDERSegment(1);
        byte[] sn = derSeg.getInnerData();
        String result = "";
        int i = 0;
        int length = sn.length;
        while (i < length) {
            int a = sn[i] & 0xFF;
            String hex = a < 16 ? "0" + Integer.toHexString(a) : Integer.toHexString(a);
            result = String.valueOf(result) + hex;
            ++i;
        }
        System.out.println(result);
    }

    public static void parseP7() throws Exception {
        FileInputStream in = new FileInputStream("D:\\TEMP\\ecc\\20120608\\1decode.p7b");
        byte[] bs = new byte[in.available()];
        in.read(bs);
        PKCS7SignedData p7sd = PKCS7SignedDataParser.parse(bs, null);
        ConsoleLogger.logBinary("content", p7sd.getContent());
        ConsoleLogger.logBinary("sig", p7sd.getSignature());
        ConsoleLogger.logString(p7sd.getDigestAlgOid());
        ConsoleLogger.logString(p7sd.getDigestEncryptionAlgOid());
        ConsoleLogger.logBinary("sn", p7sd.getSignCertSN().toByteArray());
        ConsoleLogger.logBinary("issuer", p7sd.getSignCertIssuerSubjectDer());
    }

    public static void testOID() {
        String oid = "1.2.840.113549.2.2";
        byte[] oidbs = DERUtil.oid2ASN1(oid);
        ConsoleLogger.logBinary("oid", oidbs);
        ConsoleLogger.logString(DERUtil.ASN12OID(oidbs));
    }

    public static void makeP7() throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12", "INFOSEC");
        FileInputStream in = new FileInputStream("D:\\WORK\\myjava\\infosec\\certs\\store\\signstore\\5year.pfx");
        ks.load(in, "11111111".toCharArray());
        RSAPrivateKey prik = null;
        X509Certificate cert = null;
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            ConsoleLogger.logString(alias);
            prik = (RSAPrivateKey)ks.getKey(alias, "".toCharArray());
            cert = (X509Certificate)ks.getCertificate(alias);
            break;
        }
        byte[] plainText = "1".getBytes();
        Signature sig = Signature.getInstance("SHA1withRSA", "INFOSEC");
        sig.initSign(prik);
        sig.update(plainText);
        byte[] signed = sig.sign();
        PKCS7SignedData p7sdp = new PKCS7SignedData();
        p7sdp.setContent(plainText);
        p7sdp.setDigestAlgOid("1.3.14.3.2.26");
        p7sdp.setDigestEncryptionAlgOid("1.2.840.113549.1.1.1");
        p7sdp.setContent(plainText);
        p7sdp.setSignCertIssuerSubjectDer(cert.getIssuerX500Principal().getEncoded());
        p7sdp.setSignCertSN(cert.getSerialNumber());
        p7sdp.setSignature(signed);
        PKCS7SignedDataGenerater p7sdg = new PKCS7SignedDataGenerater(p7sdp);
        byte[] p7 = p7sdg.generatePKCS7SignedData();
        ConsoleLogger.logBinary("P7", p7);
        ConsoleLogger.saveBinary("d:/TEMP/testgenp7.p7b", p7);
    }
}

