/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.engines;

import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.DataLengthException;
import cn.com.infosec.crypto.params.KeyParameter;

public class CamelliaEngine
implements BlockCipher {
    private boolean initialised;
    private boolean _keyIs128;
    private static final int BLOCK_SIZE = 16;
    private static final long MASK8 = 255L;
    private static final long MASK32 = 0xFFFFFFFFL;
    private static final long SIGMA1 = -6872943284670656373L;
    private static final long SIGMA2 = -5297666545706961998L;
    private static final long SIGMA3 = -4112007255848680770L;
    private static final long SIGMA4 = 6124705990439038748L;
    private static final long SIGMA5 = 1217423232700263709L;
    private static final long SIGMA6 = -5740250305213840899L;
    private long _kw1;
    private long _kw2;
    private long _kw3;
    private long _kw4;
    private long _k1;
    private long _k2;
    private long _k3;
    private long _k4;
    private long _k5;
    private long _k6;
    private long _k7;
    private long _k8;
    private long _k9;
    private long _k10;
    private long _k11;
    private long _k12;
    private long _k13;
    private long _k14;
    private long _k15;
    private long _k16;
    private long _k17;
    private long _k18;
    private long _k19;
    private long _k20;
    private long _k21;
    private long _k22;
    private long _k23;
    private long _k24;
    private long _ke1;
    private long _ke2;
    private long _ke3;
    private long _ke4;
    private long _ke5;
    private long _ke6;
    private final byte[] SBOX1;
    private final byte[] SBOX2;
    private final byte[] SBOX3;
    private final byte[] SBOX4;

    public CamelliaEngine() {
        byte[] byArray = new byte[256];
        byArray[0] = 112;
        byArray[1] = -126;
        byArray[2] = 44;
        byArray[3] = -20;
        byArray[4] = -77;
        byArray[5] = 39;
        byArray[6] = -64;
        byArray[7] = -27;
        byArray[8] = -28;
        byArray[9] = -123;
        byArray[10] = 87;
        byArray[11] = 53;
        byArray[12] = -22;
        byArray[13] = 12;
        byArray[14] = -82;
        byArray[15] = 65;
        byArray[16] = 35;
        byArray[17] = -17;
        byArray[18] = 107;
        byArray[19] = -109;
        byArray[20] = 69;
        byArray[21] = 25;
        byArray[22] = -91;
        byArray[23] = 33;
        byArray[24] = -19;
        byArray[25] = 14;
        byArray[26] = 79;
        byArray[27] = 78;
        byArray[28] = 29;
        byArray[29] = 101;
        byArray[30] = -110;
        byArray[31] = -67;
        byArray[32] = -122;
        byArray[33] = -72;
        byArray[34] = -81;
        byArray[35] = -113;
        byArray[36] = 124;
        byArray[37] = -21;
        byArray[38] = 31;
        byArray[39] = -50;
        byArray[40] = 62;
        byArray[41] = 48;
        byArray[42] = -36;
        byArray[43] = 95;
        byArray[44] = 94;
        byArray[45] = -59;
        byArray[46] = 11;
        byArray[47] = 26;
        byArray[48] = -90;
        byArray[49] = -31;
        byArray[50] = 57;
        byArray[51] = -54;
        byArray[52] = -43;
        byArray[53] = 71;
        byArray[54] = 93;
        byArray[55] = 61;
        byArray[56] = -39;
        byArray[57] = 1;
        byArray[58] = 90;
        byArray[59] = -42;
        byArray[60] = 81;
        byArray[61] = 86;
        byArray[62] = 108;
        byArray[63] = 77;
        byArray[64] = -117;
        byArray[65] = 13;
        byArray[66] = -102;
        byArray[67] = 102;
        byArray[68] = -5;
        byArray[69] = -52;
        byArray[70] = -80;
        byArray[71] = 45;
        byArray[72] = 116;
        byArray[73] = 18;
        byArray[74] = 43;
        byArray[75] = 32;
        byArray[76] = -16;
        byArray[77] = -79;
        byArray[78] = -124;
        byArray[79] = -103;
        byArray[80] = -33;
        byArray[81] = 76;
        byArray[82] = -53;
        byArray[83] = -62;
        byArray[84] = 52;
        byArray[85] = 126;
        byArray[86] = 118;
        byArray[87] = 5;
        byArray[88] = 109;
        byArray[89] = -73;
        byArray[90] = -87;
        byArray[91] = 49;
        byArray[92] = -47;
        byArray[93] = 23;
        byArray[94] = 4;
        byArray[95] = -41;
        byArray[96] = 20;
        byArray[97] = 88;
        byArray[98] = 58;
        byArray[99] = 97;
        byArray[100] = -34;
        byArray[101] = 27;
        byArray[102] = 17;
        byArray[103] = 28;
        byArray[104] = 50;
        byArray[105] = 15;
        byArray[106] = -100;
        byArray[107] = 22;
        byArray[108] = 83;
        byArray[109] = 24;
        byArray[110] = -14;
        byArray[111] = 34;
        byArray[112] = -2;
        byArray[113] = 68;
        byArray[114] = -49;
        byArray[115] = -78;
        byArray[116] = -61;
        byArray[117] = -75;
        byArray[118] = 122;
        byArray[119] = -111;
        byArray[120] = 36;
        byArray[121] = 8;
        byArray[122] = -24;
        byArray[123] = -88;
        byArray[124] = 96;
        byArray[125] = -4;
        byArray[126] = 105;
        byArray[127] = 80;
        byArray[128] = -86;
        byArray[129] = -48;
        byArray[130] = -96;
        byArray[131] = 125;
        byArray[132] = -95;
        byArray[133] = -119;
        byArray[134] = 98;
        byArray[135] = -105;
        byArray[136] = 84;
        byArray[137] = 91;
        byArray[138] = 30;
        byArray[139] = -107;
        byArray[140] = -32;
        byArray[141] = -1;
        byArray[142] = 100;
        byArray[143] = -46;
        byArray[144] = 16;
        byArray[145] = -60;
        byArray[147] = 72;
        byArray[148] = -93;
        byArray[149] = -9;
        byArray[150] = 117;
        byArray[151] = -37;
        byArray[152] = -118;
        byArray[153] = 3;
        byArray[154] = -26;
        byArray[155] = -38;
        byArray[156] = 9;
        byArray[157] = 63;
        byArray[158] = -35;
        byArray[159] = -108;
        byArray[160] = -121;
        byArray[161] = 92;
        byArray[162] = -125;
        byArray[163] = 2;
        byArray[164] = -51;
        byArray[165] = 74;
        byArray[166] = -112;
        byArray[167] = 51;
        byArray[168] = 115;
        byArray[169] = 103;
        byArray[170] = -10;
        byArray[171] = -13;
        byArray[172] = -99;
        byArray[173] = 127;
        byArray[174] = -65;
        byArray[175] = -30;
        byArray[176] = 82;
        byArray[177] = -101;
        byArray[178] = -40;
        byArray[179] = 38;
        byArray[180] = -56;
        byArray[181] = 55;
        byArray[182] = -58;
        byArray[183] = 59;
        byArray[184] = -127;
        byArray[185] = -106;
        byArray[186] = 111;
        byArray[187] = 75;
        byArray[188] = 19;
        byArray[189] = -66;
        byArray[190] = 99;
        byArray[191] = 46;
        byArray[192] = -23;
        byArray[193] = 121;
        byArray[194] = -89;
        byArray[195] = -116;
        byArray[196] = -97;
        byArray[197] = 110;
        byArray[198] = -68;
        byArray[199] = -114;
        byArray[200] = 41;
        byArray[201] = -11;
        byArray[202] = -7;
        byArray[203] = -74;
        byArray[204] = 47;
        byArray[205] = -3;
        byArray[206] = -76;
        byArray[207] = 89;
        byArray[208] = 120;
        byArray[209] = -104;
        byArray[210] = 6;
        byArray[211] = 106;
        byArray[212] = -25;
        byArray[213] = 70;
        byArray[214] = 113;
        byArray[215] = -70;
        byArray[216] = -44;
        byArray[217] = 37;
        byArray[218] = -85;
        byArray[219] = 66;
        byArray[220] = -120;
        byArray[221] = -94;
        byArray[222] = -115;
        byArray[223] = -6;
        byArray[224] = 114;
        byArray[225] = 7;
        byArray[226] = -71;
        byArray[227] = 85;
        byArray[228] = -8;
        byArray[229] = -18;
        byArray[230] = -84;
        byArray[231] = 10;
        byArray[232] = 54;
        byArray[233] = 73;
        byArray[234] = 42;
        byArray[235] = 104;
        byArray[236] = 60;
        byArray[237] = 56;
        byArray[238] = -15;
        byArray[239] = -92;
        byArray[240] = 64;
        byArray[241] = 40;
        byArray[242] = -45;
        byArray[243] = 123;
        byArray[244] = -69;
        byArray[245] = -55;
        byArray[246] = 67;
        byArray[247] = -63;
        byArray[248] = 21;
        byArray[249] = -29;
        byArray[250] = -83;
        byArray[251] = -12;
        byArray[252] = 119;
        byArray[253] = -57;
        byArray[254] = -128;
        byArray[255] = -98;
        this.SBOX1 = byArray;
        this.SBOX2 = new byte[256];
        this.SBOX3 = new byte[256];
        this.SBOX4 = new byte[256];
        int x = 0;
        while (x != 256) {
            this.SBOX2[x] = this.lRot8(this.SBOX1[x], 1);
            this.SBOX3[x] = this.lRot8(this.SBOX1[x], 7);
            this.SBOX4[x] = this.SBOX1[this.lRot8((byte)x, 1) & 0xFF];
            ++x;
        }
    }

    private void setKey(boolean forEncryption, byte[] key) {
        long krB;
        long krA;
        long klB;
        long klA;
        switch (key.length) {
            case 16: {
                this._keyIs128 = true;
                klA = this.bytesToWord(key, 0);
                klB = this.bytesToWord(key, 8);
                krA = 0L;
                krB = 0L;
                break;
            }
            case 24: {
                klA = this.bytesToWord(key, 0);
                klB = this.bytesToWord(key, 8);
                krA = this.bytesToWord(key, 16);
                krB = this.bytesToWord(key, 16) ^ 0xFFFFFFFFFFFFFFFFL;
                this._keyIs128 = false;
                break;
            }
            case 32: {
                klA = this.bytesToWord(key, 0);
                klB = this.bytesToWord(key, 8);
                krA = this.bytesToWord(key, 16);
                krB = this.bytesToWord(key, 24);
                this._keyIs128 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("only a key sizes of 128/192/256 are acceptable.");
            }
        }
        long d1 = klA ^ krA;
        long d2 = klB ^ krB;
        d2 ^= this.f(d1, -6872943284670656373L);
        d1 ^= this.f(d2, -5297666545706961998L);
        d2 ^= klB;
        d2 ^= this.f(d1 ^= klA, -4112007255848680770L);
        long kaA = d1 ^= this.f(d2, 6124705990439038748L);
        long kaB = d2;
        if (this._keyIs128) {
            if (forEncryption) {
                this._kw1 = klA;
                this._kw2 = klB;
                this._kw3 = this.lRot128high(kaA, kaB, 111);
                this._kw4 = this.lRot128low(kaA, kaB, 111);
                this._k1 = kaA;
                this._k2 = kaB;
                this._k3 = this.lRot128high(klA, klB, 15);
                this._k4 = this.lRot128low(klA, klB, 15);
                this._k5 = this.lRot128high(kaA, kaB, 15);
                this._k6 = this.lRot128low(kaA, kaB, 15);
                this._k7 = this.lRot128high(klA, klB, 45);
                this._k8 = this.lRot128low(klA, klB, 45);
                this._k9 = this.lRot128high(kaA, kaB, 45);
                this._k10 = this.lRot128low(klA, klB, 60);
                this._k11 = this.lRot128high(kaA, kaB, 60);
                this._k12 = this.lRot128low(kaA, kaB, 60);
                this._k13 = this.lRot128high(klA, klB, 94);
                this._k14 = this.lRot128low(klA, klB, 94);
                this._k15 = this.lRot128high(kaA, kaB, 94);
                this._k16 = this.lRot128low(kaA, kaB, 94);
                this._k17 = this.lRot128high(klA, klB, 111);
                this._k18 = this.lRot128low(klA, klB, 111);
                this._ke1 = this.lRot128high(kaA, kaB, 30);
                this._ke2 = this.lRot128low(kaA, kaB, 30);
                this._ke3 = this.lRot128high(klA, klB, 77);
                this._ke4 = this.lRot128low(klA, klB, 77);
            } else {
                this._kw3 = klA;
                this._kw4 = klB;
                this._kw1 = this.lRot128high(kaA, kaB, 111);
                this._kw2 = this.lRot128low(kaA, kaB, 111);
                this._k18 = kaA;
                this._k17 = kaB;
                this._k16 = this.lRot128high(klA, klB, 15);
                this._k15 = this.lRot128low(klA, klB, 15);
                this._k14 = this.lRot128high(kaA, kaB, 15);
                this._k13 = this.lRot128low(kaA, kaB, 15);
                this._k12 = this.lRot128high(klA, klB, 45);
                this._k11 = this.lRot128low(klA, klB, 45);
                this._k10 = this.lRot128high(kaA, kaB, 45);
                this._k9 = this.lRot128low(klA, klB, 60);
                this._k8 = this.lRot128high(kaA, kaB, 60);
                this._k7 = this.lRot128low(kaA, kaB, 60);
                this._k6 = this.lRot128high(klA, klB, 94);
                this._k5 = this.lRot128low(klA, klB, 94);
                this._k4 = this.lRot128high(kaA, kaB, 94);
                this._k3 = this.lRot128low(kaA, kaB, 94);
                this._k2 = this.lRot128high(klA, klB, 111);
                this._k1 = this.lRot128low(klA, klB, 111);
                this._ke4 = this.lRot128high(kaA, kaB, 30);
                this._ke3 = this.lRot128low(kaA, kaB, 30);
                this._ke2 = this.lRot128high(klA, klB, 77);
                this._ke1 = this.lRot128low(klA, klB, 77);
            }
        } else {
            d1 = kaA ^ krA;
            d2 = kaB ^ krB;
            d2 ^= this.f(d1, 1217423232700263709L);
            long kbA = d1 ^= this.f(d2, -5740250305213840899L);
            long kbB = d2;
            if (forEncryption) {
                this._kw1 = klA;
                this._kw2 = klB;
                this._k1 = kbA;
                this._k2 = kbB;
                this._k3 = this.lRot128high(krA, krB, 15);
                this._k4 = this.lRot128low(krA, krB, 15);
                this._k5 = this.lRot128high(kaA, kaB, 15);
                this._k6 = this.lRot128low(kaA, kaB, 15);
                this._ke1 = this.lRot128high(krA, krB, 30);
                this._ke2 = this.lRot128low(krA, krB, 30);
                this._k7 = this.lRot128high(kbA, kbB, 30);
                this._k8 = this.lRot128low(kbA, kbB, 30);
                this._k9 = this.lRot128high(klA, klB, 45);
                this._k10 = this.lRot128low(klA, klB, 45);
                this._k11 = this.lRot128high(kaA, kaB, 45);
                this._k12 = this.lRot128low(kaA, kaB, 45);
                this._ke3 = this.lRot128high(klA, klB, 60);
                this._ke4 = this.lRot128low(klA, klB, 60);
                this._k13 = this.lRot128high(krA, krB, 60);
                this._k14 = this.lRot128low(krA, krB, 60);
                this._k15 = this.lRot128high(kbA, kbB, 60);
                this._k16 = this.lRot128low(kbA, kbB, 60);
                this._k17 = this.lRot128high(klA, klB, 77);
                this._k18 = this.lRot128low(klA, klB, 77);
                this._ke5 = this.lRot128high(kaA, kaB, 77);
                this._ke6 = this.lRot128low(kaA, kaB, 77);
                this._k19 = this.lRot128high(krA, krB, 94);
                this._k20 = this.lRot128low(krA, krB, 94);
                this._k21 = this.lRot128high(kaA, kaB, 94);
                this._k22 = this.lRot128low(kaA, kaB, 94);
                this._k23 = this.lRot128high(klA, klB, 111);
                this._k24 = this.lRot128low(klA, klB, 111);
                this._kw3 = this.lRot128high(kbA, kbB, 111);
                this._kw4 = this.lRot128low(kbA, kbB, 111);
            } else {
                this._kw3 = klA;
                this._kw4 = klB;
                this._kw1 = this.lRot128high(kbA, kbB, 111);
                this._kw2 = this.lRot128low(kbA, kbB, 111);
                this._k24 = kbA;
                this._k23 = kbB;
                this._k22 = this.lRot128high(krA, krB, 15);
                this._k21 = this.lRot128low(krA, krB, 15);
                this._k20 = this.lRot128high(kaA, kaB, 15);
                this._k19 = this.lRot128low(kaA, kaB, 15);
                this._k18 = this.lRot128high(kbA, kbB, 30);
                this._k17 = this.lRot128low(kbA, kbB, 30);
                this._k16 = this.lRot128high(klA, klB, 45);
                this._k15 = this.lRot128low(klA, klB, 45);
                this._k14 = this.lRot128high(kaA, kaB, 45);
                this._k13 = this.lRot128low(kaA, kaB, 45);
                this._k12 = this.lRot128high(krA, krB, 60);
                this._k11 = this.lRot128low(krA, krB, 60);
                this._k10 = this.lRot128high(kbA, kbB, 60);
                this._k9 = this.lRot128low(kbA, kbB, 60);
                this._k8 = this.lRot128high(klA, klB, 77);
                this._k7 = this.lRot128low(klA, klB, 77);
                this._k6 = this.lRot128high(krA, krB, 94);
                this._k5 = this.lRot128low(krA, krB, 94);
                this._k4 = this.lRot128high(kaA, kaB, 94);
                this._k3 = this.lRot128low(kaA, kaB, 94);
                this._k2 = this.lRot128high(klA, klB, 111);
                this._k1 = this.lRot128low(klA, klB, 111);
                this._ke6 = this.lRot128high(krA, krB, 30);
                this._ke5 = this.lRot128low(krA, krB, 30);
                this._ke4 = this.lRot128high(klA, klB, 60);
                this._ke3 = this.lRot128low(klA, klB, 60);
                this._ke2 = this.lRot128high(kaA, kaB, 77);
                this._ke1 = this.lRot128low(kaA, kaB, 77);
            }
        }
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("only simple KeyParameter expected.");
        }
        this.setKey(forEncryption, ((KeyParameter)params).getKey());
        this.initialised = true;
    }

    public String getAlgorithmName() {
        return "Camellia";
    }

    public int getBlockSize() {
        return 16;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Camellia engine not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this._keyIs128) {
            return this.processBlock128(in, inOff, out, outOff);
        }
        return this.processBlock192or256(in, inOff, out, outOff);
    }

    public void reset() {
    }

    private byte lRot8(byte value, int rotation) {
        return (byte)(value << rotation | (value & 0xFF) >>> 8 - rotation);
    }

    private int lRot32(int value, int rotation) {
        return value << rotation | value >>> -rotation;
    }

    private long lRot128high(long a, long b, int rotation) {
        a = rotation < 64 ? a << rotation | b >>> -rotation : (rotation == 64 ? b : b << rotation - 64 | a >>> -(rotation - 64));
        return a;
    }

    private long lRot128low(long a, long b, int rotation) {
        b = rotation < 64 ? b << rotation | a >>> -rotation : (rotation == 64 ? a : a << rotation - 64 | b >>> -(rotation - 64));
        return b;
    }

    private long fl(long in, long ke) {
        int x1 = (int)(in >> 32);
        int x2 = (int)in;
        int k1 = (int)(ke >> 32);
        int k2 = (int)ke;
        x2 ^= this.lRot32(x1 & k1, 1);
        return (long)(x1 ^= x2 | k2) << 32 | (long)x2 & 0xFFFFFFFFL;
    }

    private long flInv(long in, long ke) {
        int y1 = (int)(in >> 32);
        int y2 = (int)in;
        int k1 = (int)(ke >> 32);
        int k2 = (int)ke;
        y1 ^= y2 | k2;
        return (long)y1 << 32 | (long)(y2 ^= this.lRot32(y1 & k1, 1)) & 0xFFFFFFFFL;
    }

    private long f(long in, long ke) {
        long x = in ^ ke;
        int a = (int)(x >> 32);
        int b = (int)x;
        byte t1 = this.SBOX1[a >> 24 & 0xFF];
        byte t2 = this.SBOX2[a >> 16 & 0xFF];
        byte t3 = this.SBOX3[a >> 8 & 0xFF];
        byte t4 = this.SBOX4[a & 0xFF];
        byte t5 = this.SBOX2[b >> 24 & 0xFF];
        byte t6 = this.SBOX3[b >> 16 & 0xFF];
        byte t7 = this.SBOX4[b >> 8 & 0xFF];
        byte t8 = this.SBOX1[b & 0xFF];
        int y1 = t1 ^ t3 ^ t4 ^ t6 ^ t7 ^ t8;
        int y2 = t1 ^ t2 ^ t4 ^ t5 ^ t7 ^ t8;
        int y3 = t1 ^ t2 ^ t3 ^ t5 ^ t6 ^ t8;
        int y4 = t2 ^ t3 ^ t4 ^ t5 ^ t6 ^ t7;
        int y5 = t1 ^ t2 ^ t6 ^ t7 ^ t8;
        int y6 = t2 ^ t3 ^ t5 ^ t7 ^ t8;
        int y7 = t3 ^ t4 ^ t5 ^ t6 ^ t8;
        int y8 = t1 ^ t4 ^ t5 ^ t6 ^ t7;
        return (long)y1 << 56 | ((long)y2 & 0xFFL) << 48 | ((long)y3 & 0xFFL) << 40 | ((long)y4 & 0xFFL) << 32 | ((long)y5 & 0xFFL) << 24 | ((long)y6 & 0xFFL) << 16 | ((long)y7 & 0xFFL) << 8 | (long)y8 & 0xFFL;
    }

    private long bytesToWord(byte[] src, int srcOff) {
        long word = 0L;
        int i = 0;
        while (i < 8) {
            word = (word << 8) + (long)(src[i + srcOff] & 0xFF);
            ++i;
        }
        return word;
    }

    private void wordToBytes(long word, byte[] dst, int dstOff) {
        int i = 0;
        while (i < 8) {
            dst[7 - i + dstOff] = (byte)word;
            word >>>= 8;
            ++i;
        }
    }

    private int processBlock128(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        long d1 = this.bytesToWord(in, inOff);
        long d2 = this.bytesToWord(in, inOff + 8);
        d2 ^= this._kw2;
        d2 ^= this.f(d1 ^= this._kw1, this._k1);
        d1 ^= this.f(d2, this._k2);
        d2 ^= this.f(d1, this._k3);
        d1 ^= this.f(d2, this._k4);
        d2 ^= this.f(d1, this._k5);
        d1 ^= this.f(d2, this._k6);
        d1 = this.fl(d1, this._ke1);
        d2 = this.flInv(d2, this._ke2);
        d2 ^= this.f(d1, this._k7);
        d1 ^= this.f(d2, this._k8);
        d2 ^= this.f(d1, this._k9);
        d1 ^= this.f(d2, this._k10);
        d2 ^= this.f(d1, this._k11);
        d1 ^= this.f(d2, this._k12);
        d1 = this.fl(d1, this._ke3);
        d2 = this.flInv(d2, this._ke4);
        d2 ^= this.f(d1, this._k13);
        d1 ^= this.f(d2, this._k14);
        d2 ^= this.f(d1, this._k15);
        d1 ^= this.f(d2, this._k16);
        d2 ^= this.f(d1, this._k17);
        d1 ^= this.f(d2, this._k18);
        this.wordToBytes(d2 ^= this._kw3, out, outOff);
        this.wordToBytes(d1 ^= this._kw4, out, outOff + 8);
        return 16;
    }

    private int processBlock192or256(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        long d1 = this.bytesToWord(in, inOff);
        long d2 = this.bytesToWord(in, inOff + 8);
        d2 ^= this._kw2;
        d2 ^= this.f(d1 ^= this._kw1, this._k1);
        d1 ^= this.f(d2, this._k2);
        d2 ^= this.f(d1, this._k3);
        d1 ^= this.f(d2, this._k4);
        d2 ^= this.f(d1, this._k5);
        d1 ^= this.f(d2, this._k6);
        d1 = this.fl(d1, this._ke1);
        d2 = this.flInv(d2, this._ke2);
        d2 ^= this.f(d1, this._k7);
        d1 ^= this.f(d2, this._k8);
        d2 ^= this.f(d1, this._k9);
        d1 ^= this.f(d2, this._k10);
        d2 ^= this.f(d1, this._k11);
        d1 ^= this.f(d2, this._k12);
        d1 = this.fl(d1, this._ke3);
        d2 = this.flInv(d2, this._ke4);
        d2 ^= this.f(d1, this._k13);
        d1 ^= this.f(d2, this._k14);
        d2 ^= this.f(d1, this._k15);
        d1 ^= this.f(d2, this._k16);
        d2 ^= this.f(d1, this._k17);
        d1 ^= this.f(d2, this._k18);
        d1 = this.fl(d1, this._ke5);
        d2 = this.flInv(d2, this._ke6);
        d2 ^= this.f(d1, this._k19);
        d1 ^= this.f(d2, this._k20);
        d2 ^= this.f(d1, this._k21);
        d1 ^= this.f(d2, this._k22);
        d2 ^= this.f(d1, this._k23);
        d1 ^= this.f(d2, this._k24);
        this.wordToBytes(d2 ^= this._kw3, out, outOff);
        this.wordToBytes(d1 ^= this._kw4, out, outOff + 8);
        return 16;
    }
}

