/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;

public class JCESM2PublicKey
implements PublicKey {
    private int bits = 256;
    private byte[] x;
    private byte[] y;
    private byte[] encoded;
    private byte[] head;

    public JCESM2PublicKey() {
        byte[] byArray = new byte[27];
        byArray[0] = 48;
        byArray[1] = 89;
        byArray[2] = 48;
        byArray[3] = 19;
        byArray[4] = 6;
        byArray[5] = 7;
        byArray[6] = 42;
        byArray[7] = -122;
        byArray[8] = 72;
        byArray[9] = -50;
        byArray[10] = 61;
        byArray[11] = 2;
        byArray[12] = 1;
        byArray[13] = 6;
        byArray[14] = 8;
        byArray[15] = 42;
        byArray[16] = -127;
        byArray[17] = 28;
        byArray[18] = -49;
        byArray[19] = 85;
        byArray[20] = 1;
        byArray[21] = -126;
        byArray[22] = 45;
        byArray[23] = 3;
        byArray[24] = 66;
        byArray[26] = 4;
        this.head = byArray;
        this.x = new byte[32];
        this.y = new byte[32];
    }

    public JCESM2PublicKey(byte[] pubk) {
        byte[] byArray = new byte[27];
        byArray[0] = 48;
        byArray[1] = 89;
        byArray[2] = 48;
        byArray[3] = 19;
        byArray[4] = 6;
        byArray[5] = 7;
        byArray[6] = 42;
        byArray[7] = -122;
        byArray[8] = 72;
        byArray[9] = -50;
        byArray[10] = 61;
        byArray[11] = 2;
        byArray[12] = 1;
        byArray[13] = 6;
        byArray[14] = 8;
        byArray[15] = 42;
        byArray[16] = -127;
        byArray[17] = 28;
        byArray[18] = -49;
        byArray[19] = 85;
        byArray[20] = 1;
        byArray[21] = -126;
        byArray[22] = 45;
        byArray[23] = 3;
        byArray[24] = 66;
        byArray[26] = 4;
        this.head = byArray;
        this.x = new byte[32];
        this.y = new byte[32];
        System.arraycopy(pubk, pubk.length - 64, this.x, 0, 32);
        System.arraycopy(pubk, pubk.length - 32, this.y, 0, 32);
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public byte[] getX() {
        return this.x;
    }

    public void setX(byte[] x) {
        this.encoded = null;
        System.arraycopy(x, 0, this.x, 0, 32);
    }

    public byte[] getY() {
        return this.y;
    }

    public void setY(byte[] y) {
        this.encoded = null;
        System.arraycopy(y, 0, this.y, 0, 32);
    }

    public byte[] getEncoded() {
        if (this.encoded != null) {
            return this.encoded;
        }
        this.encoded = new byte[this.head.length + 64];
        System.arraycopy(this.head, 0, this.encoded, 0, this.head.length);
        System.arraycopy(this.x, 0, this.encoded, this.head.length, 32);
        System.arraycopy(this.y, 0, this.encoded, this.head.length + 32, 32);
        return this.encoded;
    }

    public String getAlgorithm() {
        return "EC";
    }

    public String getFormat() {
        return "X.509";
    }

    public int hashCode() {
        return new BigInteger(this.getEncoded()).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof JCESM2PublicKey) {
            JCESM2PublicKey pubk = (JCESM2PublicKey)o;
            return Arrays.equals(this.getEncoded(), pubk.getEncoded());
        }
        return false;
    }
}

