/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.fastparser;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.jce.provider.fastparser.Item;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;

public class DerUtil {
    public static boolean debug = false;
    public static final byte[] OID_PKCS7 = new byte[]{42, -122, 72, -122, -9, 13, 1, 7};
    public static final byte[] OID_Data = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 1};
    public static final byte[] OID_SignedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 2};
    public static final byte[] OID_EnvelopedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 3};
    public static final byte[] OID_SignedAndEnvelopedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 4};
    public static final byte[] OID_DigestedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 5};
    public static final byte[] OID_EncryptedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 6};

    public static int toInt(byte[] input, int start, int length) {
        int value = 0;
        int i = 0;
        while (i < length) {
            value *= 256;
            value += input[i + start] & 0xFF;
            ++i;
        }
        return value;
    }

    public static void computeOffset(byte[] input, Item item, int offset, int pos) {
        int size = 0;
        int length = 0;
        int noffset = 0;
        if (pos + offset > input.length - 2) {
            return;
        }
        byte first = input[pos + 1 + offset];
        byte preFirst = input[pos + offset];
        if (((preFirst & 0xFF) == 0 || (preFirst & 0xFF) == 5) && (first & 0xFF) == 0) {
            item.offset = 2 + pos;
            item.length = 0;
            item.tagsize = 2;
            return;
        }
        if ((preFirst & 0xFF) == 0 && (first & 0xFF) != 0) {
            noffset = 1;
        }
        if (((first = input[pos + 1 + offset + noffset]) & 0x80) == 128 || (first & 0xFF) == 0) {
            size = first & 0xF;
            length = size == 0 && (first & 0xFF) != 0 ? input.length - pos - 1 - noffset : DerUtil.toInt(input, 2 + pos + offset + noffset, size);
        } else {
            size = 0;
            length = first & 0xFF;
        }
        item.offset = 2 + size + pos + noffset;
        if (length < 0 || length > input.length - item.offset) {
            if (debug) {
                System.out.println("length error! length=" + length);
            }
            length = input.length - item.offset - noffset;
        }
        item.length = length;
        item.tagsize = 2 + size;
        if (debug) {
            System.out.println("@computeOffset offset=" + item.offset + " ,length=" + item.length + ",tagsize=" + item.tagsize);
        }
    }

    public static boolean isEqual(byte[] src, int srcstart, byte[] dst, int dststart, int length) {
        if (src.length < srcstart + length || dst.length < dststart + length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (src[i + srcstart] != dst[dststart + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumberEqual(byte[] num1, byte[] num2) {
        if (num1.length == num2.length) {
            return DerUtil.isByteArrayEquals(num1, num2);
        }
        if (num1.length > num2.length) {
            return DerUtil.isNumberEquals(num1, num2);
        }
        return DerUtil.isNumberEquals(num2, num1);
    }

    private static boolean isNumberEquals(byte[] longer, byte[] shorter) {
        int i = 1;
        while (i <= shorter.length) {
            if (longer[longer.length - i] != shorter[shorter.length - i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < longer.length - shorter.length) {
            if (longer[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isByteArrayEquals(byte[] bs1, byte[] bs2) {
        int i = 0;
        while (i < bs1.length) {
            if (bs1[i] != bs2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void parseSequence(byte[] input, int offset, int length, List list) {
        int position = 0;
        Item tmpitem = new Item();
        if (debug) {
            System.out.println("=========parseSequence============");
            DerUtil.printBytes(input, offset, length, 16);
            System.out.println("==================================");
        }
        while (position < input.length - offset && position < length) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position += tmpitem.tagsize + tmpitem.length;
            tmpitem.offset += offset;
            list.add(new Item(tmpitem));
            if (!debug) continue;
            System.out.println("Parsed sequence " + list.size());
            DerUtil.printItemAndTag(input, tmpitem);
        }
    }

    public static void parseSequence(byte[] input, Item it, List list) {
        int position = 0;
        Item tmpitem = new Item();
        if (debug) {
            System.out.println("=========parseSequence============");
            DerUtil.printBytes(input, it.offset, it.length, 16);
            System.out.println("==================================");
        }
        while (position < input.length - it.offset && position < it.length) {
            DerUtil.computeOffset(input, tmpitem, it.offset, position);
            position += tmpitem.tagsize + tmpitem.length;
            tmpitem.offset += it.offset;
            list.add(new Item(tmpitem));
            if (!debug) continue;
            System.out.println("Parsed sequence " + list.size());
            DerUtil.printItem(input, tmpitem);
        }
    }

    public static int getContentType(byte[] input, int offset) {
        int code = 0;
        int oidLength = input[offset - 1] & 0xFF;
        if (offset + oidLength > input.length - 1) {
            return code;
        }
        code = input[oidLength + offset - 1] & 0xF;
        if (debug) {
            System.out.println("oidLength=" + oidLength);
            DerUtil.printBytes(input, offset, oidLength, 16);
            System.out.println("code=" + code);
        }
        return code;
    }

    public static String toDERObjectIdentifier(byte[] bytes, int offset, int length) {
        Item tmpitem = new Item();
        DerUtil.computeOffset(bytes, tmpitem, offset, 0);
        StringBuffer objId = new StringBuffer();
        long value = 0L;
        BigInteger bigValue = null;
        boolean first = true;
        int i = 0;
        while (i != tmpitem.length && i + offset + tmpitem.offset < bytes.length) {
            int tmpbyte = bytes[i + offset + tmpitem.offset] & 0xFF;
            if (value < 0x80000000000000L) {
                value = value * 128L + (long)(tmpbyte & 0x7F);
                if ((tmpbyte & 0x80) == 0) {
                    if (first) {
                        switch ((int)value / 40) {
                            case 0: {
                                objId.append('0');
                                break;
                            }
                            case 1: {
                                objId.append('1');
                                value -= 40L;
                                break;
                            }
                            default: {
                                objId.append('2');
                                value -= 80L;
                            }
                        }
                        first = false;
                    }
                    objId.append('.');
                    objId.append(value);
                    value = 0L;
                }
            } else {
                if (bigValue == null) {
                    bigValue = BigInteger.valueOf(value);
                }
                bigValue = bigValue.shiftLeft(7);
                bigValue = bigValue.or(BigInteger.valueOf(tmpbyte & 0x7F));
                if ((tmpbyte & 0x80) == 0) {
                    objId.append('.');
                    objId.append(bigValue);
                    bigValue = null;
                    value = 0L;
                }
            }
            ++i;
        }
        return objId.toString();
    }

    public static void printBytes(byte[] input, int start, int length, int radix) {
        System.out.print("@printBytes\n[");
        int i = 0;
        while (start + i < input.length && i < length) {
            int b;
            if ((i + 1) % 17 == 0) {
                System.out.println();
            }
            System.out.print(String.valueOf((b = input[start + i] & 0xFF) < radix ? "0" : "") + Integer.toString(b, radix).toUpperCase() + " ");
            ++i;
        }
        System.out.println(']');
    }

    public static void printBytes(byte[] input) {
        DerUtil.printBytes(input, 0, input.length, 16);
    }

    public static void printItem(byte[] input, Item it) {
        if (it == null) {
            return;
        }
        System.out.println("printItem with offset=" + Integer.toHexString(it.offset) + ",length=" + Integer.toHexString(it.length));
        DerUtil.printBytes(input, it.offset, it.length, 16);
    }

    public static void printItemAndTag(byte[] input, Item it) {
        System.out.println("printItemAndTag with offset=" + Integer.toHexString(it.offset) + ",length=" + Integer.toHexString(it.length) + ",tagsize=" + it.tagsize);
        DerUtil.printBytes(input, it.offset, it.length, 16);
    }

    public static DERObject getDerObject(byte[] input) throws IOException {
        ByteArrayInputStream bai = new ByteArrayInputStream(input);
        ASN1InputStream ains = new ASN1InputStream(bai);
        return ains.readObject();
    }

    public static byte[] copyByteArray(byte[] source, Item item) {
        if (item == null || item.length == 0) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length];
        System.arraycopy(source, item.offset, bs, 0, item.length);
        return bs;
    }

    public static byte[] getItemData(byte[] source, Item item) {
        if (item == null) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length];
        System.arraycopy(source, item.offset, bs, 0, item.length);
        return bs;
    }

    public static byte[] getItemDataAndTag(byte[] source, Item item) {
        if (item == null) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length + item.tagsize];
        System.arraycopy(source, item.offset - item.tagsize, bs, 0, item.length + item.tagsize);
        return bs;
    }
}

