/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.conn.ssl;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.conn.util.DomainType;
import com.icbc.api.internal.apache.http.conn.util.InetAddressUtils;
import com.icbc.api.internal.apache.http.conn.util.PublicSuffixMatcher;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public final class DefaultHostnameVerifier
implements HostnameVerifier {
    static final int eI = 2;
    static final int eJ = 7;
    private final Log cy = LogFactory.getLog(this.getClass());
    private final PublicSuffixMatcher eK;

    public DefaultHostnameVerifier(PublicSuffixMatcher publicSuffixMatcher) {
        this.eK = publicSuffixMatcher;
    }

    public DefaultHostnameVerifier() {
        this(null);
    }

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            this.a(string, x509Certificate);
            return true;
        }
        catch (SSLException sSLException) {
            if (this.cy.isDebugEnabled()) {
                this.cy.debug((Object)sSLException.getMessage(), (Throwable)sSLException);
            }
            return false;
        }
    }

    public void a(String string, X509Certificate x509Certificate) throws SSLException {
        TYPE tYPE = TYPE.DNS;
        if (InetAddressUtils.isIPv4Address(string)) {
            tYPE = TYPE.IPv4;
        } else {
            String string2 = string;
            if (string2.startsWith("[") && string2.endsWith("]")) {
                string2 = string.substring(1, string.length() - 1);
            }
            if (InetAddressUtils.isIPv6Address(string2)) {
                tYPE = TYPE.IPv6;
            }
        }
        int n2 = tYPE == TYPE.IPv4 || tYPE == TYPE.IPv6 ? 7 : 2;
        List<String> list = DefaultHostnameVerifier.a(x509Certificate, n2);
        if (list != null && !list.isEmpty()) {
            switch (tYPE) {
                case IPv4: {
                    DefaultHostnameVerifier.a(string, list);
                    break;
                }
                case IPv6: {
                    DefaultHostnameVerifier.b(string, list);
                    break;
                }
                default: {
                    DefaultHostnameVerifier.a(string, list, this.eK);
                    break;
                }
            }
        } else {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            String string3 = DefaultHostnameVerifier.X(x500Principal.getName("RFC2253"));
            if (string3 == null) {
                throw new SSLException("Certificate subject for <" + string + "> doesn't contain a common name and does not have alternative names");
            }
            DefaultHostnameVerifier.a(string, string3, this.eK);
        }
    }

    static void a(String string, List<String> list) throws SSLException {
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (!string.equals(string2)) continue;
            return;
        }
        throw new SSLException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list);
    }

    static void b(String string, List<String> list) throws SSLException {
        String string2 = DefaultHostnameVerifier.Y(string);
        for (int i = 0; i < list.size(); ++i) {
            String string3 = list.get(i);
            String string4 = DefaultHostnameVerifier.Y(string3);
            if (!string2.equals(string4)) continue;
            return;
        }
        throw new SSLException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list);
    }

    static void a(String string, List<String> list, PublicSuffixMatcher publicSuffixMatcher) throws SSLException {
        String string2 = string.toLowerCase(Locale.ROOT);
        for (int i = 0; i < list.size(); ++i) {
            String string3 = list.get(i);
            String string4 = string3.toLowerCase(Locale.ROOT);
            if (!DefaultHostnameVerifier.c(string2, string4, publicSuffixMatcher)) continue;
            return;
        }
        throw new SSLException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list);
    }

    static void a(String string, String string2, PublicSuffixMatcher publicSuffixMatcher) throws SSLException {
        if (!DefaultHostnameVerifier.c(string, string2, publicSuffixMatcher)) {
            throw new SSLException("Certificate for <" + string + "> doesn't match common name of the certificate subject: " + string2);
        }
    }

    static boolean j(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return string.endsWith(string2) && (string.length() == string2.length() || string.charAt(string.length() - string2.length() - 1) == '.');
    }

    private static boolean a(String string, String string2, PublicSuffixMatcher publicSuffixMatcher, boolean bl) {
        if (publicSuffixMatcher != null && string.contains(".") && !DefaultHostnameVerifier.j(string, publicSuffixMatcher.getDomainRoot(string2, DomainType.ICANN))) {
            return false;
        }
        int n2 = string2.indexOf(42);
        if (n2 != -1) {
            String string3;
            String string4 = string2.substring(0, n2);
            String string5 = string2.substring(n2 + 1);
            if (!string4.isEmpty() && !string.startsWith(string4)) {
                return false;
            }
            if (!string5.isEmpty() && !string.endsWith(string5)) {
                return false;
            }
            return !bl || !(string3 = string.substring(string4.length(), string.length() - string5.length())).contains(".");
        }
        return string.equalsIgnoreCase(string2);
    }

    static boolean b(String string, String string2, PublicSuffixMatcher publicSuffixMatcher) {
        return DefaultHostnameVerifier.a(string, string2, publicSuffixMatcher, false);
    }

    static boolean k(String string, String string2) {
        return DefaultHostnameVerifier.a(string, string2, null, false);
    }

    static boolean c(String string, String string2, PublicSuffixMatcher publicSuffixMatcher) {
        return DefaultHostnameVerifier.a(string, string2, publicSuffixMatcher, true);
    }

    static boolean l(String string, String string2) {
        return DefaultHostnameVerifier.a(string, string2, null, true);
    }

    static String X(String string) throws SSLException {
        if (string == null) {
            return null;
        }
        try {
            LdapName ldapName = new LdapName(string);
            List<Rdn> list = ldapName.getRdns();
            for (int i = list.size() - 1; i >= 0; --i) {
                Rdn rdn = list.get(i);
                Attributes attributes = rdn.toAttributes();
                Attribute attribute = attributes.get("cn");
                if (attribute == null) continue;
                try {
                    Object object = attribute.get();
                    if (object == null) continue;
                    return object.toString();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (InvalidNameException invalidNameException) {
            throw new SSLException(string + " is not a valid X500 distinguished name");
        }
    }

    static List<String> a(X509Certificate x509Certificate, int n2) {
        Collection<List<?>> collection = null;
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        ArrayList<String> arrayList = null;
        if (collection != null) {
            for (List<?> list : collection) {
                List<?> list2 = list;
                int n3 = (Integer)list2.get(0);
                if (n3 != n2) continue;
                String string = (String)list2.get(1);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    static String Y(String string) {
        if (string == null) {
            return string;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    static enum TYPE {
        IPv4,
        IPv6,
        DNS;

    }
}

