/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.auth;

import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import com.icbc.api.internal.apache.http.auth.i;
import com.icbc.api.internal.apache.http.auth.l;
import com.icbc.api.internal.apache.http.auth.m;
import com.icbc.api.internal.apache.http.auth.n;
import com.icbc.api.internal.apache.http.auth.o;
import com.icbc.api.internal.apache.http.conn.routing.b;
import com.icbc.api.internal.apache.http.g;
import com.icbc.api.internal.apache.http.g.r;
import com.icbc.api.internal.apache.http.impl.auth.a;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import com.icbc.api.internal.apache.http.v;
import com.icbc.api.internal.util.codec.Base64;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

@NotThreadSafe
public abstract class GGSSchemeBase
extends a {
    private final Log cy = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Base64 hd = new Base64(0);
    private final boolean he;
    private final boolean hf;
    private State hg;
    private byte[] hh;
    private String hi;

    GGSSchemeBase(boolean bl, boolean bl2) {
        this.he = bl;
        this.hf = bl2;
        this.hg = State.UNINITIATED;
    }

    GGSSchemeBase(boolean bl) {
        this(bl, true);
    }

    GGSSchemeBase() {
        this(true, true);
    }

    protected GSSManager cU() {
        return GSSManager.getInstance();
    }

    protected byte[] a(byte[] byArray, Oid oid, String string) throws GSSException {
        return this.a(byArray, oid, string, null);
    }

    protected byte[] a(byte[] byArray, Oid oid, String string, l l2) throws GSSException {
        byte[] byArray2 = byArray;
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        GSSManager gSSManager = this.cU();
        GSSName gSSName = gSSManager.createName(this.hi + "@" + string, GSSName.NT_HOSTBASED_SERVICE);
        GSSCredential gSSCredential = l2 instanceof n ? ((n)l2).O() : null;
        GSSContext gSSContext = gSSManager.createContext(gSSName.canonicalize(oid), oid, gSSCredential, 0);
        gSSContext.requestMutualAuth(true);
        gSSContext.requestCredDeleg(true);
        return gSSContext.initSecContext(byArray2, 0, byArray2.length);
    }

    @Deprecated
    protected byte[] a(byte[] byArray, String string) throws GSSException {
        return null;
    }

    protected byte[] a(byte[] byArray, String string, l l2) throws GSSException {
        return this.a(byArray, string);
    }

    public boolean isComplete() {
        return this.hg == State.TOKEN_GENERATED || this.hg == State.FAILED;
    }

    @Deprecated
    public g a(l l2, v v2) throws i {
        return this.a(l2, v2, null);
    }

    public g a(l l2, v v2, com.icbc.api.internal.apache.http.j.g g2) throws i {
        Args.notNull(v2, "HTTP request");
        switch (this.hg) {
            case UNINITIATED: {
                throw new i(this.getSchemeName() + " authentication has not been initiated");
            }
            case FAILED: {
                throw new i(this.getSchemeName() + " authentication has failed");
            }
            case CHALLENGE_RECEIVED: {
                Object object;
                Object object2;
                try {
                    object2 = (b)g2.getAttribute("http.route");
                    if (object2 == null) {
                        throw new i("Connection route is not available");
                    }
                    if (this.isProxy()) {
                        object = object2.ca();
                        if (object == null) {
                            object = object2.bV();
                        }
                    } else {
                        object = object2.bV();
                    }
                    String string = object.getHostName();
                    if (this.hf) {
                        try {
                            string = this.aj(string);
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                    }
                    String string2 = this.he ? string : string + ":" + object.getPort();
                    this.hi = object.getSchemeName().toUpperCase(Locale.ROOT);
                    if (this.cy.isDebugEnabled()) {
                        this.cy.debug((Object)("init " + string2));
                    }
                    this.hh = this.a(this.hh, string2, l2);
                    this.hg = State.TOKEN_GENERATED;
                }
                catch (GSSException gSSException) {
                    this.hg = State.FAILED;
                    if (gSSException.getMajor() == 9 || gSSException.getMajor() == 8) {
                        throw new m(gSSException.getMessage(), (Throwable)gSSException);
                    }
                    if (gSSException.getMajor() == 13) {
                        throw new m(gSSException.getMessage(), (Throwable)gSSException);
                    }
                    if (gSSException.getMajor() == 10 || gSSException.getMajor() == 19 || gSSException.getMajor() == 20) {
                        throw new i(gSSException.getMessage(), (Throwable)gSSException);
                    }
                    throw new i(gSSException.getMessage());
                }
            }
            case TOKEN_GENERATED: {
                Object object2 = new String(this.hd.encode(this.hh));
                if (this.cy.isDebugEnabled()) {
                    this.cy.debug((Object)("Sending response '" + (String)object2 + "' back to the auth server"));
                }
                Object object = new CharArrayBuffer(32);
                if (this.isProxy()) {
                    ((CharArrayBuffer)object).append("Proxy-Authorization");
                } else {
                    ((CharArrayBuffer)object).append("Authorization");
                }
                ((CharArrayBuffer)object).append(": Negotiate ");
                ((CharArrayBuffer)object).append((String)object2);
                return new r((CharArrayBuffer)object);
            }
        }
        throw new IllegalStateException("Illegal state: " + (Object)((Object)this.hg));
    }

    protected void a(CharArrayBuffer charArrayBuffer, int n2, int n3) throws o {
        String string = charArrayBuffer.substringTrimmed(n2, n3);
        if (this.cy.isDebugEnabled()) {
            this.cy.debug((Object)("Received challenge '" + string + "' from the auth server"));
        }
        if (this.hg == State.UNINITIATED) {
            this.hh = Base64.decodeBase64(string.getBytes());
            this.hg = State.CHALLENGE_RECEIVED;
        } else {
            this.cy.debug((Object)"Authentication already attempted");
            this.hg = State.FAILED;
        }
    }

    private String aj(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        String string2 = inetAddress.getCanonicalHostName();
        if (inetAddress.getHostAddress().contentEquals(string2)) {
            return string;
        }
        return string2;
    }

    static enum State {
        UNINITIATED,
        CHALLENGE_RECEIVED,
        TOKEN_GENERATED,
        FAILED;

    }
}

