/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.util;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.c;
import com.icbc.api.internal.apache.http.nio.g;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentOutputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class SharedOutputBuffer
extends ExpandableBuffer
implements ContentOutputBuffer {
    private final ReentrantLock lock;
    private final Condition condition;
    private volatile g ioctrl;
    private volatile boolean shutdown = false;
    private volatile boolean endOfStream = false;

    @Deprecated
    public SharedOutputBuffer(int n2, g g2, ByteBufferAllocator byteBufferAllocator) {
        super(n2, byteBufferAllocator);
        Args.notNull(g2, "I/O content control");
        this.ioctrl = g2;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedOutputBuffer(int n2, ByteBufferAllocator byteBufferAllocator) {
        super(n2, byteBufferAllocator);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    public SharedOutputBuffer(int n2) {
        this(n2, HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public void reset() {
        if (this.shutdown) {
            return;
        }
        this.lock.lock();
        try {
            this.clear();
            this.endOfStream = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasData() {
        this.lock.lock();
        try {
            boolean bl = super.hasData();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int available() {
        this.lock.lock();
        try {
            int n2 = super.available();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int capacity() {
        this.lock.lock();
        try {
            int n2 = super.capacity();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int length() {
        this.lock.lock();
        try {
            int n2 = super.length();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Deprecated
    public int produceContent(c c2) throws IOException {
        return this.produceContent(c2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int produceContent(c c2, g g2) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            if (g2 != null) {
                this.ioctrl = g2;
            }
            this.setOutputMode();
            int n2 = 0;
            if (super.hasData()) {
                n2 = c2.write(this.buffer);
                if (c2.isCompleted()) {
                    this.endOfStream = true;
                }
            }
            if (!super.hasData()) {
                if (this.endOfStream && !c2.isCompleted()) {
                    c2.complete();
                }
                if (!this.endOfStream && this.ioctrl != null) {
                    this.ioctrl.ht();
                }
            }
            this.condition.signalAll();
            int n3 = n2;
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            return;
        }
        int n4 = n2;
        this.lock.lock();
        try {
            Asserts.check(!this.shutdown && !this.endOfStream, "Buffer already closed for writing");
            this.setInputMode();
            int n5 = n3;
            while (n5 > 0) {
                if (!this.buffer.hasRemaining()) {
                    this.flushContent();
                    this.setInputMode();
                }
                int n6 = Math.min(n5, this.buffer.remaining());
                this.buffer.put(byArray, n4, n6);
                n5 -= n6;
                n4 += n6;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) throws IOException {
        this.lock.lock();
        try {
            Asserts.check(!this.shutdown && !this.endOfStream, "Buffer already closed for writing");
            this.setInputMode();
            if (!this.buffer.hasRemaining()) {
                this.flushContent();
                this.setInputMode();
            }
            this.buffer.put((byte)n2);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    private void flushContent() throws IOException {
        this.lock.lock();
        try {
            try {
                while (super.hasData()) {
                    if (this.shutdown) {
                        throw new InterruptedIOException("Output operation aborted");
                    }
                    if (this.ioctrl != null) {
                        this.ioctrl.hr();
                    }
                    this.condition.await();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Interrupted while flushing the content buffer");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void writeCompleted() throws IOException {
        this.lock.lock();
        try {
            if (this.endOfStream) {
                return;
            }
            this.endOfStream = true;
            if (this.ioctrl != null) {
                this.ioctrl.hr();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

