/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util;

import com.icbc.api.internal.util.Charsets;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringUtils {
    private static byte[] getBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return string.getBytes(charset);
    }

    public static byte[] getBytesIso8859_1(String string) {
        return StringUtils.getBytes(string, Charsets.ISO_8859_1);
    }

    public static byte[] getBytesUnchecked(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw StringUtils.newIllegalStateException(string2, unsupportedEncodingException);
        }
    }

    public static byte[] getBytesUsAscii(String string) {
        return StringUtils.getBytes(string, Charsets.US_ASCII);
    }

    public static byte[] getBytesUtf16(String string) {
        return StringUtils.getBytes(string, Charsets.UTF_16);
    }

    public static byte[] getBytesUtf16Be(String string) {
        return StringUtils.getBytes(string, Charsets.UTF_16BE);
    }

    public static byte[] getBytesUtf16Le(String string) {
        return StringUtils.getBytes(string, Charsets.UTF_16LE);
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytes(string, Charsets.UTF_8);
    }

    private static IllegalStateException newIllegalStateException(String string, UnsupportedEncodingException unsupportedEncodingException) {
        return new IllegalStateException(string + ": " + unsupportedEncodingException);
    }

    private static String newString(byte[] byArray, Charset charset) {
        return byArray == null ? null : new String(byArray, charset);
    }

    public static String newString(byte[] byArray, String string) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw StringUtils.newIllegalStateException(string, unsupportedEncodingException);
        }
    }

    public static String newStringIso8859_1(byte[] byArray) {
        return new String(byArray, Charsets.ISO_8859_1);
    }

    public static String newStringUsAscii(byte[] byArray) {
        return new String(byArray, Charsets.US_ASCII);
    }

    public static String newStringUtf16(byte[] byArray) {
        return new String(byArray, Charsets.UTF_16);
    }

    public static String newStringUtf16Be(byte[] byArray) {
        return new String(byArray, Charsets.UTF_16BE);
    }

    public static String newStringUtf16Le(byte[] byArray) {
        return new String(byArray, Charsets.UTF_16LE);
    }

    public static String newStringUtf8(byte[] byArray) {
        return StringUtils.newString(byArray, Charsets.UTF_8);
    }

    private StringUtils() {
    }

    public static boolean isEmpty(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(Object object) {
        if (object == null) {
            return false;
        }
        char[] cArray = object.toString().toCharArray();
        int n2 = cArray.length;
        if (n2 < 1) {
            return false;
        }
        int n3 = 0;
        if (n2 > 1 && cArray[0] == '-') {
            n3 = 1;
        }
        while (n3 < n2) {
            if (!Character.isDigit(cArray[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean areNotEmpty(String ... stringArray) {
        boolean bl = true;
        if (stringArray == null || stringArray.length == 0) {
            bl = false;
        } else {
            for (String string : stringArray) {
                bl &= !StringUtils.isEmpty(string);
            }
        }
        return bl;
    }

    public static String unicodeToChinese(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtils.isEmpty(string)) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                stringBuilder.append(string.charAt(i2));
            }
        }
        return stringBuilder.toString();
    }

    public static String stripNonValidXMLCharacters(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!(c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 >= ' ' && c2 <= '\ud7ff' || c2 >= '\ue000' && c2 <= '\ufffd') && (c2 < '\u10000' || c2 > '\u10ffff')) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

