/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser;

import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.JSONScanner;
import com.icbc.api.internal.util.fastjson.parser.JSONToken;
import com.icbc.api.internal.util.fastjson.parser.SymbolTable;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONLexerBase
implements JSONLexer,
Closeable {
    protected int token;
    protected int pos;
    protected int features;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    protected Calendar calendar = null;
    protected TimeZone timeZone = JSON.defaultTimeZone;
    protected Locale locale = JSON.defaultLocale;
    public int matchStat = 0;
    private static final ThreadLocal<char[]> SBUF_LOCAL;
    protected String stringDefaultValue = null;
    protected int nanos = 0;
    protected static final char[] typeFieldName;
    protected static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    protected static final int INT_MULTMIN_RADIX_TEN = -214748364;
    protected static final int[] digits;

    protected void lexError(String string, Object ... objectArray) {
        this.token = 1;
    }

    public JSONLexerBase(int n2) {
        this.features = n2;
        if ((n2 & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
        this.sbuf = SBUF_LOCAL.get();
        if (this.sbuf == null) {
            this.sbuf = new char[512];
        }
    }

    public final int matchStat() {
        return this.matchStat;
    }

    public void setToken(int n2) {
        this.token = n2;
    }

    @Override
    public final void nextToken() {
        block28: {
            this.sp = 0;
            block19: while (true) {
                this.pos = this.bp;
                if (this.ch == '/') {
                    this.skipComment();
                    continue;
                }
                if (this.ch == '\"') {
                    this.scanString();
                    return;
                }
                if (this.ch == ',') {
                    this.next();
                    this.token = 16;
                    return;
                }
                if (this.ch >= '0' && this.ch <= '9') {
                    this.scanNumber();
                    return;
                }
                if (this.ch == '-') {
                    this.scanNumber();
                    return;
                }
                switch (this.ch) {
                    case '\'': {
                        if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                            throw new JSONException("Feature.AllowSingleQuotes is false");
                        }
                        this.scanStringSingleQuote();
                        return;
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this.next();
                        continue block19;
                    }
                    case 't': {
                        this.scanTrue();
                        return;
                    }
                    case 'f': {
                        this.scanFalse();
                        return;
                    }
                    case 'n': {
                        this.scanNullOrNew();
                        return;
                    }
                    case 'N': 
                    case 'S': 
                    case 'T': 
                    case 'u': {
                        this.scanIdent();
                        return;
                    }
                    case '(': {
                        this.next();
                        this.token = 10;
                        return;
                    }
                    case ')': {
                        this.next();
                        this.token = 11;
                        return;
                    }
                    case '[': {
                        this.next();
                        this.token = 14;
                        return;
                    }
                    case ']': {
                        this.next();
                        this.token = 15;
                        return;
                    }
                    case '{': {
                        this.next();
                        this.token = 12;
                        return;
                    }
                    case '}': {
                        this.next();
                        this.token = 13;
                        return;
                    }
                    case ':': {
                        this.next();
                        this.token = 17;
                        return;
                    }
                    case ';': {
                        this.next();
                        this.token = 24;
                        return;
                    }
                    case '.': {
                        this.next();
                        this.token = 25;
                        return;
                    }
                    case '+': {
                        this.next();
                        this.scanNumber();
                        return;
                    }
                    case 'x': {
                        this.scanHex();
                        return;
                    }
                }
                if (this.isEOF()) {
                    if (this.token == 20) {
                        throw new JSONException("EOF error");
                    }
                    this.token = 20;
                    this.eofPos = this.pos = this.bp;
                    break block28;
                }
                if (this.ch > '\u001f' && this.ch != '\u007f') break;
                this.next();
            }
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.next();
        }
    }

    @Override
    public final void nextToken(int n2) {
        this.sp = 0;
        while (true) {
            switch (n2) {
                case 12: {
                    if (this.ch == '{') {
                        this.token = 12;
                        this.next();
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.next();
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        this.token = 16;
                        this.next();
                        return;
                    }
                    if (this.ch == '}') {
                        this.token = 13;
                        this.next();
                        return;
                    }
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                    if (this.ch == '\u001a') {
                        this.token = 20;
                        return;
                    }
                    if (this.ch != 'n') break;
                    this.scanNullOrNew(false);
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 4: {
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (JSONLexerBase.isWhitespace(this.ch)) {
            this.next();
        }
        if (this.ch == '_' || this.ch == '$' || Character.isLetter(this.ch)) {
            this.scanIdent();
        } else {
            this.nextToken();
        }
    }

    @Override
    public final void nextTokenWithColon() {
        this.nextTokenWithChar(':');
    }

    public final void nextTokenWithChar(char c2) {
        this.sp = 0;
        while (true) {
            if (this.ch == c2) {
                this.next();
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        throw new JSONException("not match " + c2 + " - " + this.ch + ", info : " + this.info());
    }

    @Override
    public final int token() {
        return this.token;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    public final String stringDefaultValue() {
        return this.stringDefaultValue;
    }

    @Override
    public final Number integerValue() throws NumberFormatException {
        int n2;
        long l2;
        long l3 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        int n3 = this.np;
        int n4 = this.np + this.sp;
        int n5 = 32;
        switch (this.charAt(n4 - 1)) {
            case 'L': {
                --n4;
                n5 = 76;
                break;
            }
            case 'S': {
                --n4;
                n5 = 83;
                break;
            }
            case 'B': {
                --n4;
                n5 = 66;
                break;
            }
        }
        if (this.charAt(this.np) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n3;
        } else {
            l2 = -9223372036854775807L;
        }
        long l4 = -922337203685477580L;
        if (n3 < n4) {
            n2 = this.charAt(n3++) - 48;
            l3 = -n2;
        }
        while (n3 < n4) {
            n2 = this.charAt(n3++) - 48;
            if (l3 < l4) {
                return new BigInteger(this.numberString());
            }
            if ((l3 *= 10L) < l2 + (long)n2) {
                return new BigInteger(this.numberString());
            }
            l3 -= (long)n2;
        }
        if (bl) {
            if (n3 > this.np + 1) {
                if (l3 >= Integer.MIN_VALUE && n5 != 76) {
                    if (n5 == 83) {
                        return (short)l3;
                    }
                    if (n5 == 66) {
                        return (byte)l3;
                    }
                    return (int)l3;
                }
                return l3;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((l3 = -l3) <= Integer.MAX_VALUE && n5 != 76) {
            if (n5 == 83) {
                return (short)l3;
            }
            if (n5 == 66) {
                return (byte)l3;
            }
            return (int)l3;
        }
        return l3;
    }

    @Override
    public final void nextTokenWithColon(int n2) {
        this.nextTokenWithChar(':');
    }

    @Override
    public float floatValue() {
        char c2;
        String string = this.numberString();
        float f2 = Float.parseFloat(string);
        if ((f2 == 0.0f || f2 == Float.POSITIVE_INFINITY) && (c2 = string.charAt(0)) > '0' && c2 <= '9') {
            throw new JSONException("float overflow : " + string);
        }
        return f2;
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public void config(Feature feature, boolean bl) {
        this.features = Feature.config(this.features, feature, bl);
        if ((this.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.mask);
    }

    @Override
    public final boolean isEnabled(int n2) {
        return (this.features & n2) != 0;
    }

    public final boolean isEnabled(int n2, int n3) {
        return (this.features & n3) != 0 || (n2 & n3) != 0;
    }

    @Override
    public abstract String numberString();

    public abstract boolean isEOF();

    @Override
    public final char getCurrent() {
        return this.ch;
    }

    public abstract char charAt(int var1);

    @Override
    public abstract char next();

    protected void skipComment() {
        this.next();
        if (this.ch == '/') {
            do {
                this.next();
                if (this.ch != '\n') continue;
                this.next();
                return;
            } while (this.ch != '\u001a');
            return;
        }
        if (this.ch == '*') {
            this.next();
            while (this.ch != '\u001a') {
                if (this.ch == '*') {
                    this.next();
                    if (this.ch != '/') continue;
                    this.next();
                    return;
                }
                this.next();
            }
        } else {
            throw new JSONException("invalid comment");
        }
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable) {
        this.skipWhitespace();
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    protected abstract void arrayCopy(int var1, char[] var2, int var3, int var4);

    @Override
    public final String scanSymbol(SymbolTable symbolTable, char c2) {
        String string;
        char c3;
        int n2 = 0;
        this.np = this.bp;
        this.sp = 0;
        boolean bl = false;
        block22: while ((c3 = this.next()) != c2) {
            if (c3 == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (c3 == '\\') {
                int n3;
                if (!bl) {
                    bl = true;
                    if (this.sp >= this.sbuf.length) {
                        n3 = this.sbuf.length * 2;
                        if (this.sp > n3) {
                            n3 = this.sp;
                        }
                        char[] cArray = new char[n3];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    this.arrayCopy(this.np + 1, this.sbuf, 0, this.sp);
                }
                c3 = this.next();
                switch (c3) {
                    case '0': {
                        n2 = 31 * n2 + c3;
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        n2 = 31 * n2 + c3;
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        n2 = 31 * n2 + c3;
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        n2 = 31 * n2 + c3;
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        n2 = 31 * n2 + c3;
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        n2 = 31 * n2 + c3;
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        n2 = 31 * n2 + c3;
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        n2 = 31 * n2 + c3;
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        n2 = 31 * n2 + 8;
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        n2 = 31 * n2 + 9;
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        n2 = 31 * n2 + 10;
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        n2 = 31 * n2 + 11;
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        n2 = 31 * n2 + 12;
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        n2 = 31 * n2 + 13;
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        n2 = 31 * n2 + 34;
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        n2 = 31 * n2 + 39;
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        n2 = 31 * n2 + 47;
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        n2 = 31 * n2 + 92;
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        n3 = this.ch = this.next();
                        char c4 = this.ch = this.next();
                        int n4 = digits[n3] * 16 + digits[c4];
                        char c5 = (char)n4;
                        n2 = 31 * n2 + c5;
                        this.putChar(c5);
                        continue block22;
                    }
                    case 'u': {
                        char c6 = c3 = this.next();
                        char c7 = c3 = this.next();
                        char c8 = c3 = this.next();
                        char c9 = c3 = this.next();
                        int n5 = Integer.parseInt(new String(new char[]{c6, c7, c8, c9}), 16);
                        n2 = 31 * n2 + n5;
                        this.putChar((char)n5);
                        continue block22;
                    }
                }
                this.ch = c3;
                throw new JSONException("unclosed.str.lit");
            }
            n2 = 31 * n2 + c3;
            if (!bl) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c3);
                continue;
            }
            this.sbuf[this.sp++] = c3;
        }
        this.token = 4;
        if (!bl) {
            int n6 = this.np == -1 ? 0 : this.np + 1;
            string = this.addSymbol(n6, this.sp, n2, symbolTable);
        } else {
            string = symbolTable.addSymbol(this.sbuf, 0, this.sp, n2);
        }
        this.sp = 0;
        this.next();
        return string;
    }

    @Override
    public final void resetStringPosition() {
        this.sp = 0;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char c2;
        boolean bl;
        if (this.token == 1 && this.pos == 0 && this.bp == 1) {
            this.bp = 0;
        }
        boolean[] blArray = IOUtils.firstIdentifierFlags;
        int n2 = this.ch;
        boolean bl2 = bl = this.ch >= blArray.length || blArray[n2];
        if (!bl) {
            throw new JSONException("illegal identifier : " + this.ch + this.info());
        }
        boolean[] blArray2 = IOUtils.identifierFlags;
        int n3 = n2;
        this.np = this.bp;
        this.sp = 1;
        while ((c2 = this.next()) >= blArray2.length || blArray2[c2]) {
            n3 = 31 * n3 + c2;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        int n4 = 3392903;
        if (this.sp == 4 && n3 == 3392903 && this.charAt(this.np) == 'n' && this.charAt(this.np + 1) == 'u' && this.charAt(this.np + 2) == 'l' && this.charAt(this.np + 3) == 'l') {
            return null;
        }
        if (symbolTable == null) {
            return this.subString(this.np, this.sp);
        }
        return this.addSymbol(this.np, this.sp, n3, symbolTable);
    }

    protected abstract void copyTo(int var1, int var2, char[] var3);

    @Override
    public final void scanString() {
        char c2;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((c2 = this.next()) != '\"') {
            if (c2 == '\u001a') {
                if (!this.isEOF()) {
                    this.putChar('\u001a');
                    continue;
                }
                throw new JSONException("unclosed string : " + c2);
            }
            if (c2 == '\\') {
                char c3;
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        c3 = this.sbuf.length * 2;
                        if (this.sp > c3) {
                            c3 = this.sp;
                        }
                        char[] cArray = new char[c3];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    this.copyTo(this.np + 1, this.sp, this.sbuf);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        boolean bl;
                        c3 = this.next();
                        char c4 = this.next();
                        boolean bl2 = c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 <= 'F';
                        boolean bl3 = bl = c4 >= '0' && c4 <= '9' || c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 <= 'F';
                        if (!bl2 || !bl) {
                            throw new JSONException("invalid escape character \\x" + c3 + c4);
                        }
                        char c5 = (char)(digits[c3] * 16 + digits[c4]);
                        this.putChar(c5);
                        continue block22;
                    }
                    case 'u': {
                        char c6 = this.next();
                        char c7 = this.next();
                        char c8 = this.next();
                        char c9 = this.next();
                        int n2 = Integer.parseInt(new String(new char[]{c6, c7, c8, c9}), 16);
                        this.putChar((char)n2);
                        continue block22;
                    }
                }
                this.ch = c2;
                throw new JSONException("unclosed string : " + c2);
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c2);
                continue;
            }
            this.sbuf[this.sp++] = c2;
        }
        this.token = 4;
        this.ch = this.next();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public final int intValue() {
        char c2;
        int n2;
        int n3;
        if (this.np == -1) {
            this.np = 0;
        }
        int n4 = 0;
        boolean bl = false;
        int n5 = this.np;
        int n6 = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            bl = true;
            n3 = Integer.MIN_VALUE;
            ++n5;
        } else {
            n3 = -2147483647;
        }
        long l2 = -214748364L;
        if (n5 < n6) {
            n2 = this.charAt(n5++) - 48;
            n4 = -n2;
        }
        while (n5 < n6 && (c2 = this.charAt(n5++)) != 'L' && c2 != 'S' && c2 != 'B') {
            n2 = c2 - 48;
            if ((long)n4 < l2) {
                throw new NumberFormatException(this.numberString());
            }
            if ((n4 *= 10) < n3 + n2) {
                throw new NumberFormatException(this.numberString());
            }
            n4 -= n2;
        }
        if (bl) {
            if (n5 > this.np + 1) {
                return n4;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -n4;
    }

    @Override
    public abstract byte[] bytesValue();

    @Override
    public void close() {
        if (this.sbuf.length <= 8192) {
            SBUF_LOCAL.set(this.sbuf);
        }
        this.sbuf = null;
    }

    @Override
    public final boolean isRef() {
        if (this.sp != 4) {
            return false;
        }
        return this.charAt(this.np + 1) == '$' && this.charAt(this.np + 2) == 'r' && this.charAt(this.np + 3) == 'e' && this.charAt(this.np + 4) == 'f';
    }

    @Override
    public String scanTypeName(SymbolTable symbolTable) {
        return null;
    }

    public final int scanType(String string) {
        this.matchStat = 0;
        if (!this.charArrayCompare(typeFieldName)) {
            return -2;
        }
        int n2 = this.bp + typeFieldName.length;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (string.charAt(i2) == this.charAt(n2 + i2)) continue;
            return -1;
        }
        if (this.charAt(n2 += n3) != '\"') {
            return -1;
        }
        this.ch = this.charAt(++n2);
        if (this.ch == ',') {
            this.ch = this.charAt(++n2);
            this.bp = n2;
            this.token = 16;
            return 3;
        }
        if (this.ch == '}') {
            this.ch = this.charAt(++n2);
            if (this.ch == ',') {
                this.token = 16;
                this.ch = this.charAt(++n2);
            } else if (this.ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++n2);
            } else if (this.ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++n2);
            } else if (this.ch == '\u001a') {
                this.token = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.bp = n2;
        return this.matchStat;
    }

    public final boolean matchField(char[] cArray) {
        while (!this.charArrayCompare(cArray)) {
            if (JSONLexerBase.isWhitespace(this.ch)) {
                this.next();
                continue;
            }
            return false;
        }
        this.bp += cArray.length;
        this.ch = this.charAt(this.bp);
        if (this.ch == '{') {
            this.next();
            this.token = 12;
        } else if (this.ch == '[') {
            this.next();
            this.token = 14;
        } else if (this.ch == 'S' && this.charAt(this.bp + 1) == 'e' && this.charAt(this.bp + 2) == 't' && this.charAt(this.bp + 3) == '[') {
            this.bp += 3;
            this.ch = this.charAt(this.bp);
            this.token = 21;
        } else {
            this.nextToken();
        }
        return true;
    }

    public int matchField(long l2) {
        throw new UnsupportedOperationException();
    }

    public boolean seekArrayToItem(int n2) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long l2, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long[] lArray) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToFieldDeepScan(long l2) {
        throw new UnsupportedOperationException();
    }

    public void skipObject() {
        throw new UnsupportedOperationException();
    }

    public void skipObject(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void skipArray() {
        throw new UnsupportedOperationException();
    }

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] cArray) {
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int n2 = cArray.length;
        if ((c2 = this.charAt(this.bp + n2++)) != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        int n3 = this.bp + cArray.length + 1;
        int n4 = this.indexOf('\"', n3);
        if (n4 == -1) {
            throw new JSONException("unclosed str");
        }
        int n5 = this.bp + cArray.length + 1;
        String string = this.subString(n5, n4 - n5);
        if (string.indexOf(92) != -1) {
            while (true) {
                int n6 = 0;
                for (int i2 = n4 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n6, --i2) {
                }
                if (n6 % 2 == 0) {
                    n6 = n4 - (this.bp + cArray.length + 1);
                    char[] cArray2 = this.sub_chars(this.bp + cArray.length + 1, n6);
                    string = JSONLexerBase.readString(cArray2, n6);
                    break;
                }
                n4 = this.indexOf('\"', n4 + 1);
            }
        }
        n2 += n4 - (this.bp + cArray.length + 1) + 1;
        c2 = this.charAt(this.bp + n2++);
        String string2 = string;
        if (c2 == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return string2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return string2;
    }

    @Override
    public String scanString(char c2) {
        String string;
        char c3;
        int n2;
        block13: {
            this.matchStat = 0;
            n2 = 0;
            if ((c3 = this.charAt(this.bp + n2++)) == 'n') {
                if (this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                    n2 += 3;
                } else {
                    this.matchStat = -1;
                    return null;
                }
                c3 = this.charAt(this.bp + n2++);
                if (c3 == c2) {
                    this.bp += n2;
                    this.ch = this.charAt(this.bp);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            while (true) {
                if (c3 == '\"') {
                    int n3 = this.bp + n2;
                    int n4 = this.indexOf('\"', n3);
                    if (n4 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    string = this.subString(this.bp + n2, n4 - n3);
                    if (string.indexOf(92) != -1) {
                        int n5;
                        while (true) {
                            n5 = 0;
                            for (int i2 = n4 - 1; i2 >= 0 && this.charAt(i2) == '\\'; --i2) {
                                ++n5;
                            }
                            if (n5 % 2 == 0) break;
                            n4 = this.indexOf('\"', n4 + 1);
                        }
                        n5 = n4 - n3;
                        char[] cArray = this.sub_chars(this.bp + 1, n5);
                        string = JSONLexerBase.readString(cArray, n5);
                    }
                    n2 += n4 - n3 + 1;
                    break block13;
                }
                if (!JSONLexerBase.isWhitespace(c3)) break;
                c3 = this.charAt(this.bp + n2++);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        c3 = this.charAt(this.bp + n2++);
        String string2 = string;
        while (true) {
            if (c3 == c2) {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return string2;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.bp + n2++);
        }
        if (c3 == ']') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = -1;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldSymbol(char[] cArray) {
        long l2;
        char c2;
        int n2;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n2 = cArray.length;
                if ((c2 = this.charAt(this.bp + n2++)) != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                l2 = -3750763034362895579L;
                do {
                    if ((c2 = this.charAt(this.bp + n2++)) == '\"') {
                        if ((c2 = this.charAt(this.bp + n2++)) != ',') break block12;
                        break block13;
                    }
                    l2 ^= (long)c2;
                    l2 *= 1099511628211L;
                } while (c2 != '\\');
                this.matchStat = -1;
                return 0L;
            }
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return l2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanEnumSymbol(char[] cArray) {
        long l2;
        int n2;
        int n3;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n3 = cArray.length;
                if ((n2 = this.charAt(this.bp + n3++)) != 34) {
                    this.matchStat = -1;
                    return 0L;
                }
                l2 = -3750763034362895579L;
                do {
                    if ((n2 = this.charAt(this.bp + n3++)) == 34) {
                        if ((n2 = this.charAt(this.bp + n3++)) != 44) break block12;
                        break block13;
                    }
                    l2 ^= (long)(n2 >= 65 && n2 <= 90 ? n2 + 32 : n2);
                    l2 *= 1099511628211L;
                } while (n2 != 92);
                this.matchStat = -1;
                return 0L;
            }
            this.bp += n3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return l2;
        }
        if (n2 != 125) {
            this.matchStat = -1;
            return 0L;
        }
        if ((n2 = (int)this.charAt(this.bp + n3++)) == 44) {
            this.token = 16;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 93) {
            this.token = 15;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 125) {
            this.token = 13;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else {
            if (n2 != 26) {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n3 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return l2;
    }

    @Override
    public Enum<?> scanEnum(Class<?> clazz, SymbolTable symbolTable, char c2) {
        String string = this.scanSymbolWithSeperator(symbolTable, c2);
        if (string == null) {
            return null;
        }
        return Enum.valueOf(clazz, string);
    }

    @Override
    public String scanSymbolWithSeperator(SymbolTable symbolTable, char c2) {
        int n2;
        char c3;
        int n3;
        block8: {
            this.matchStat = 0;
            n3 = 0;
            if ((c3 = this.charAt(this.bp + n3++)) == 'n') {
                if (this.charAt(this.bp + n3) == 'u' && this.charAt(this.bp + n3 + 1) == 'l' && this.charAt(this.bp + n3 + 2) == 'l') {
                    n3 += 3;
                } else {
                    this.matchStat = -1;
                    return null;
                }
                c3 = this.charAt(this.bp + n3++);
                if (c3 == c2) {
                    this.bp += n3;
                    this.ch = this.charAt(this.bp);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            if (c3 != '\"') {
                this.matchStat = -1;
                return null;
            }
            n2 = 0;
            do {
                if ((c3 = this.charAt(this.bp + n3++)) == '\"') break block8;
                n2 = 31 * n2 + c3;
            } while (c3 != '\\');
            this.matchStat = -1;
            return null;
        }
        int n4 = this.bp + 0 + 1;
        int n5 = this.bp + n3 - n4 - 1;
        String string = this.addSymbol(n4, n5, n2, symbolTable);
        c3 = this.charAt(this.bp + n3++);
        while (true) {
            if (c3 == c2) {
                this.bp += n3;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return string;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.bp + n3++);
        }
        this.matchStat = -1;
        return string;
    }

    public Collection<String> newCollectionByType(Class<?> clazz) {
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<String>();
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<String>();
        }
        if (clazz.isAssignableFrom(LinkedList.class)) {
            return new LinkedList<String>();
        }
        try {
            return (Collection)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JSONException(exception.getMessage(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Collection<String> scanFieldStringArray(char[] cArray, Class<?> clazz) {
        char c2;
        int n2;
        Collection<String> collection;
        block19: {
            this.matchStat = 0;
            if (!this.charArrayCompare(cArray)) {
                this.matchStat = -2;
                return null;
            }
            collection = this.newCollectionByType(clazz);
            n2 = cArray.length;
            if ((c2 = this.charAt(this.bp + n2++)) != '[') {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.bp + n2++);
            while (true) {
                block23: {
                    String string;
                    int n3;
                    block21: {
                        block22: {
                            block20: {
                                if (c2 != '\"') break block20;
                                int n4 = this.bp + n2;
                                n3 = this.indexOf('\"', n4);
                                if (n3 == -1) {
                                    throw new JSONException("unclosed str");
                                }
                                int n5 = this.bp + n2;
                                string = this.subString(n5, n3 - n5);
                                if (string.indexOf(92) == -1) break block21;
                                break block22;
                            }
                            if (c2 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                                n2 += 3;
                                c2 = this.charAt(this.bp + n2++);
                                collection.add(null);
                                break block23;
                            } else {
                                if (c2 != ']') throw new JSONException("illega str");
                                if (collection.size() != 0) throw new JSONException("illega str");
                                c2 = this.charAt(this.bp + n2++);
                                break block19;
                            }
                        }
                        while (true) {
                            int n6 = 0;
                            for (int i2 = n3 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n6, --i2) {
                            }
                            if (n6 % 2 == 0) {
                                n6 = n3 - (this.bp + n2);
                                char[] cArray2 = this.sub_chars(this.bp + n2, n6);
                                string = JSONLexerBase.readString(cArray2, n6);
                                break;
                            }
                            n3 = this.indexOf('\"', n3 + 1);
                        }
                    }
                    n2 += n3 - (this.bp + n2) + 1;
                    c2 = this.charAt(this.bp + n2++);
                    collection.add(string);
                }
                if (c2 != ',') break;
                c2 = this.charAt(this.bp + n2++);
            }
            if (c2 != ']') {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.bp + n2++);
        }
        if (c2 == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return collection;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n2 - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return collection;
    }

    @Override
    public void scanStringArray(Collection<String> collection, char c2) {
        char c3;
        int n2;
        block14: {
            this.matchStat = 0;
            n2 = 0;
            if ((c3 = this.charAt(this.bp + n2++)) == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l' && this.charAt(this.bp + n2 + 3) == c2) {
                this.bp += 5;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                return;
            }
            if (c3 != '[') {
                this.matchStat = -1;
                return;
            }
            c3 = this.charAt(this.bp + n2++);
            while (true) {
                if (c3 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                    n2 += 3;
                    c3 = this.charAt(this.bp + n2++);
                    collection.add(null);
                } else {
                    if (c3 == ']' && collection.size() == 0) {
                        c3 = this.charAt(this.bp + n2++);
                        break block14;
                    }
                    if (c3 != '\"') {
                        this.matchStat = -1;
                        return;
                    }
                    int n3 = this.bp + n2;
                    int n4 = this.indexOf('\"', n3);
                    if (n4 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    String string = this.subString(this.bp + n2, n4 - n3);
                    if (string.indexOf(92) != -1) {
                        int n5;
                        while (true) {
                            n5 = 0;
                            for (int i2 = n4 - 1; i2 >= 0 && this.charAt(i2) == '\\'; --i2) {
                                ++n5;
                            }
                            if (n5 % 2 == 0) break;
                            n4 = this.indexOf('\"', n4 + 1);
                        }
                        n5 = n4 - n3;
                        char[] cArray = this.sub_chars(this.bp + n2, n5);
                        string = JSONLexerBase.readString(cArray, n5);
                    }
                    n2 += n4 - (this.bp + n2) + 1;
                    c3 = this.charAt(this.bp + n2++);
                    collection.add(string);
                }
                if (c3 != ',') break;
                c3 = this.charAt(this.bp + n2++);
            }
            if (c3 == ']') {
                c3 = this.charAt(this.bp + n2++);
            } else {
                this.matchStat = -1;
                return;
            }
        }
        if (c3 == c2) {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return;
        }
        this.matchStat = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(char[] cArray) {
        int n2;
        int n3;
        char c2;
        boolean bl;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0;
        }
        int n4 = cArray.length;
        boolean bl2 = bl = (c2 = this.charAt(this.bp + n4++)) == '-';
        if (bl) {
            c2 = this.charAt(this.bp + n4++);
        }
        if (c2 >= '0' && c2 <= '9') {
            n3 = c2 - 48;
            while ((c2 = this.charAt(this.bp + n4++)) >= '0' && c2 <= '9') {
                n3 = n3 * 10 + (c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (!(n3 >= 0 && n4 <= 14 + cArray.length || n3 == Integer.MIN_VALUE && n4 == 17 && bl)) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (c2 == ',') {
            int n5;
            this.bp += n4;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                n5 = -n3;
                return n5;
            }
            n5 = n3;
            return n5;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0;
        }
        if ((c2 = this.charAt(this.bp + n4++)) == ',') {
            this.token = 16;
            this.bp += n4;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n4;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n4;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0;
            }
            this.token = 20;
            this.bp += n4 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            n2 = n3;
            return n2;
        }
        n2 = -n3;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int[] scanFieldIntArray(char[] cArray) {
        int n2;
        int[] nArray;
        char c2;
        int n3;
        block20: {
            block19: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return null;
                }
                n3 = cArray.length;
                if ((c2 = this.charAt(this.bp + n3++)) != '[') {
                    this.matchStat = -2;
                    return null;
                }
                c2 = this.charAt(this.bp + n3++);
                nArray = new int[16];
                n2 = 0;
                if (c2 == ']') {
                    c2 = this.charAt(this.bp + n3++);
                } else {
                    while (true) {
                        boolean bl = false;
                        if (c2 == '-') {
                            c2 = this.charAt(this.bp + n3++);
                            bl = true;
                        }
                        if (c2 < '0' || c2 > '9') break block19;
                        int n4 = c2 - 48;
                        while ((c2 = this.charAt(this.bp + n3++)) >= '0' && c2 <= '9') {
                            n4 = n4 * 10 + (c2 - 48);
                        }
                        if (n2 >= nArray.length) {
                            int[] nArray2 = new int[nArray.length * 3 / 2];
                            System.arraycopy(nArray, 0, nArray2, 0, n2);
                            nArray = nArray2;
                        }
                        int n5 = nArray[n2++] = bl ? -n4 : n4;
                        if (c2 == ',') {
                            c2 = this.charAt(this.bp + n3++);
                            continue;
                        }
                        if (c2 == ']') break;
                    }
                    c2 = this.charAt(this.bp + n3++);
                }
                break block20;
            }
            this.matchStat = -1;
            return null;
        }
        if (n2 != nArray.length) {
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            nArray = nArray3;
        }
        if (c2 == ',') {
            this.bp += n3 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return nArray;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n3++)) == ',') {
            this.token = 16;
            this.bp += n3 - 1;
            this.next();
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n3 - 1;
            this.next();
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n3 - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n3 - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean scanBoolean(char c2) {
        boolean bl;
        char c3;
        int n2;
        block12: {
            this.matchStat = 0;
            n2 = 0;
            c3 = this.charAt(this.bp + n2++);
            bl = false;
            if (c3 == 't') {
                if (this.charAt(this.bp + n2) == 'r' && this.charAt(this.bp + n2 + 1) == 'u' && this.charAt(this.bp + n2 + 2) == 'e') {
                    n2 += 3;
                    c3 = this.charAt(this.bp + n2++);
                    bl = true;
                    break block12;
                } else {
                    this.matchStat = -1;
                    return false;
                }
            }
            if (c3 == 'f') {
                if (this.charAt(this.bp + n2) == 'a' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 's' && this.charAt(this.bp + n2 + 3) == 'e') {
                    n2 += 4;
                    c3 = this.charAt(this.bp + n2++);
                    bl = false;
                    break block12;
                } else {
                    this.matchStat = -1;
                    return false;
                }
            }
            if (c3 == '1') {
                c3 = this.charAt(this.bp + n2++);
                bl = true;
            } else if (c3 == '0') {
                c3 = this.charAt(this.bp + n2++);
                bl = false;
            }
        }
        while (true) {
            if (c3 == c2) {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return bl;
            }
            if (!JSONLexerBase.isWhitespace(c3)) {
                this.matchStat = -1;
                return bl;
            }
            c3 = this.charAt(this.bp + n2++);
        }
    }

    @Override
    public int scanInt(char c2) {
        int n2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n3 = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.bp + n3++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.bp + n3++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.bp + n3++);
        }
        if (c3 >= '0' && c3 <= '9') {
            n2 = c3 - 48;
            while ((c3 = this.charAt(this.bp + n3++)) >= '0' && c3 <= '9') {
                n2 = n2 * 10 + (c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (n2 < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (c3 == 'n' && this.charAt(this.bp + n3) == 'u' && this.charAt(this.bp + n3 + 1) == 'l' && this.charAt(this.bp + n3 + 2) == 'l') {
                this.matchStat = 5;
                int n4 = 0;
                n3 += 3;
                c3 = this.charAt(this.bp + n3++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.bp + n3++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp += n3;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return n4;
                    }
                    if (c3 == ']') {
                        this.bp += n3;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return n4;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.bp + n3++);
                }
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (c3 == c2) {
                this.bp += n3;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bl ? -n2 : n2;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.bp + n3++);
        }
        this.matchStat = -1;
        return bl ? -n2 : n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(char[] cArray) {
        boolean bl;
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return false;
        }
        int n2 = cArray.length;
        if ((c2 = this.charAt(this.bp + n2++)) == 't') {
            if (this.charAt(this.bp + n2++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n2++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n2++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = true;
        } else {
            if (c2 != 'f') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n2++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n2++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n2++) != 's') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.bp + n2++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = false;
        }
        c2 = this.charAt(this.bp + n2++);
        if (c2 == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return bl;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return false;
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return false;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] cArray) {
        long l2;
        long l3;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        int n2 = cArray.length;
        char c2 = this.charAt(this.bp + n2++);
        boolean bl = false;
        if (c2 == '-') {
            c2 = this.charAt(this.bp + n2++);
            bl = true;
        }
        if (c2 >= '0' && c2 <= '9') {
            boolean bl2;
            l3 = c2 - 48;
            while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                l3 = l3 * 10L + (long)(c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            boolean bl3 = bl2 = n2 - cArray.length < 21 && (l3 >= 0L || l3 == Long.MIN_VALUE && bl);
            if (!bl2) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (c2 == ',') {
            long l4;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                l4 = -l3;
                return l4;
            }
            l4 = l3;
            return l4;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            l2 = l3;
            return l2;
        }
        l2 = -l3;
        return l2;
    }

    @Override
    public long scanLong(char c2) {
        long l2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n2 = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.bp + n2++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.bp + n2++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.bp + n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            boolean bl5;
            l2 = c3 - 48;
            while ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                l2 = l2 * 10L + (long)(c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            boolean bl6 = bl5 = l2 >= 0L || l2 == Long.MIN_VALUE && bl;
            if (!bl5) {
                String string = this.subString(this.bp, n2 - 1);
                throw new NumberFormatException(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                this.matchStat = 5;
                long l3 = 0L;
                n2 += 3;
                c3 = this.charAt(this.bp + n2++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.bp + n2++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp += n2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return l3;
                    }
                    if (c3 == ']') {
                        this.bp += n2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return l3;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.bp + n2++);
                }
                this.matchStat = -1;
                return 0L;
            }
            this.matchStat = -1;
            return 0L;
        }
        if (bl2) {
            if (c3 != '\"') {
                this.matchStat = -1;
                return 0L;
            }
            c3 = this.charAt(this.bp + n2++);
        }
        while (true) {
            if (c3 == c2) {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bl ? -l2 : l2;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.bp + n2++);
        }
        this.matchStat = -1;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final float scanFieldFloat(char[] cArray) {
        float f2;
        char c2;
        int n2;
        block35: {
            float f3;
            block34: {
                boolean bl;
                block33: {
                    int n3;
                    int n4;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    n2 = cArray.length;
                    boolean bl5 = bl = (c2 = this.charAt(this.bp + n2++)) == '\"';
                    if (bl) {
                        c2 = this.charAt(this.bp + n2++);
                    }
                    boolean bl6 = bl4 = c2 == '-';
                    if (bl4) {
                        c2 = this.charAt(this.bp + n2++);
                    }
                    if (c2 < '0' || c2 > '9') break block33;
                    long l2 = c2 - 48;
                    while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                        l2 = l2 * 10L + (long)(c2 - 48);
                    }
                    long l3 = 1L;
                    boolean bl7 = bl3 = c2 == '.';
                    if (bl3) {
                        if ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                            l2 = l2 * 10L + (long)(c2 - 48);
                            l3 = 10L;
                            while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                                l2 = l2 * 10L + (long)(c2 - 48);
                                l3 *= 10L;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    boolean bl8 = bl2 = c2 == 'e' || c2 == 'E';
                    if (bl2) {
                        if ((c2 = this.charAt(this.bp + n2++)) == '+' || c2 == '-') {
                            c2 = this.charAt(this.bp + n2++);
                        }
                        while (c2 >= '0' && c2 <= '9') {
                            c2 = this.charAt(this.bp + n2++);
                        }
                    }
                    if (bl) {
                        if (c2 != '\"') {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                        c2 = this.charAt(this.bp + n2++);
                        n4 = this.bp + cArray.length + 1;
                        n3 = this.bp + n2 - n4 - 2;
                    } else {
                        n4 = this.bp + cArray.length;
                        n3 = this.bp + n2 - n4 - 1;
                    }
                    if (!bl2 && n3 < 17) {
                        f3 = (float)((double)l2 / (double)l3);
                        if (bl4) {
                            f3 = -f3;
                        }
                        break block34;
                    } else {
                        String string = this.subString(n4, n3);
                        f3 = Float.parseFloat(string);
                    }
                    break block34;
                }
                if (c2 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                    this.matchStat = 5;
                    f2 = 0.0f;
                    n2 += 3;
                    c2 = this.charAt(this.bp + n2++);
                    if (bl && c2 == '\"') {
                        c2 = this.charAt(this.bp + n2++);
                    }
                    break block35;
                } else {
                    this.matchStat = -1;
                    return 0.0f;
                }
            }
            if (c2 == ',') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return f3;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return 0.0f;
            }
            if ((c2 = this.charAt(this.bp + n2++)) == ',') {
                this.token = 16;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c2 == ']') {
                this.token = 15;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c2 == '}') {
                this.token = 13;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return 0.0f;
                }
                this.bp += n2 - 1;
                this.token = 20;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return f3;
        }
        while (true) {
            if (c2 == ',') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return f2;
            }
            if (c2 == '}') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return f2;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return 0.0f;
            }
            c2 = this.charAt(this.bp + n2++);
        }
    }

    @Override
    public final float scanFloat(char c2) {
        float f2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n2 = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.bp + n2++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.bp + n2++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.bp + n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            int n3;
            int n4;
            boolean bl5;
            boolean bl6;
            long l2 = c3 - 48;
            while ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                l2 = l2 * 10L + (long)(c3 - 48);
            }
            long l3 = 1L;
            boolean bl7 = bl6 = c3 == '.';
            if (bl6) {
                if ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                    l2 = l2 * 10L + (long)(c3 - 48);
                    l3 = 10L;
                    while ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                        l2 = l2 * 10L + (long)(c3 - 48);
                        l3 *= 10L;
                    }
                } else {
                    this.matchStat = -1;
                    return 0.0f;
                }
            }
            boolean bl8 = bl5 = c3 == 'e' || c3 == 'E';
            if (bl5) {
                if ((c3 = this.charAt(this.bp + n2++)) == '+' || c3 == '-') {
                    c3 = this.charAt(this.bp + n2++);
                }
                while (c3 >= '0' && c3 <= '9') {
                    c3 = this.charAt(this.bp + n2++);
                }
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0.0f;
                }
                c3 = this.charAt(this.bp + n2++);
                n4 = this.bp + 1;
                n3 = this.bp + n2 - n4 - 2;
            } else {
                n4 = this.bp;
                n3 = this.bp + n2 - n4 - 1;
            }
            if (!bl5 && n3 < 17) {
                f2 = (float)((double)l2 / (double)l3);
                if (bl) {
                    f2 = -f2;
                }
            } else {
                String string = this.subString(n4, n3);
                f2 = Float.parseFloat(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                this.matchStat = 5;
                float f3 = 0.0f;
                n2 += 3;
                c3 = this.charAt(this.bp + n2++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.bp + n2++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp += n2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return f3;
                    }
                    if (c3 == ']') {
                        this.bp += n2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return f3;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.bp + n2++);
                }
                this.matchStat = -1;
                return 0.0f;
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (c3 == c2) {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return f2;
        }
        this.matchStat = -1;
        return f2;
    }

    @Override
    public double scanDouble(char c2) {
        double d2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n2 = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.bp + n2++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.bp + n2++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.bp + n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            int n3;
            int n4;
            boolean bl5;
            boolean bl6;
            long l2 = c3 - 48;
            while ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                l2 = l2 * 10L + (long)(c3 - 48);
            }
            long l3 = 1L;
            boolean bl7 = bl6 = c3 == '.';
            if (bl6) {
                if ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                    l2 = l2 * 10L + (long)(c3 - 48);
                    l3 = 10L;
                    while ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                        l2 = l2 * 10L + (long)(c3 - 48);
                        l3 *= 10L;
                    }
                } else {
                    this.matchStat = -1;
                    return 0.0;
                }
            }
            boolean bl8 = bl5 = c3 == 'e' || c3 == 'E';
            if (bl5) {
                if ((c3 = this.charAt(this.bp + n2++)) == '+' || c3 == '-') {
                    c3 = this.charAt(this.bp + n2++);
                }
                while (c3 >= '0' && c3 <= '9') {
                    c3 = this.charAt(this.bp + n2++);
                }
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0.0;
                }
                c3 = this.charAt(this.bp + n2++);
                n4 = this.bp + 1;
                n3 = this.bp + n2 - n4 - 2;
            } else {
                n4 = this.bp;
                n3 = this.bp + n2 - n4 - 1;
            }
            if (!bl5 && n3 < 17) {
                d2 = (double)l2 / (double)l3;
                if (bl) {
                    d2 = -d2;
                }
            } else {
                String string = this.subString(n4, n3);
                d2 = Double.parseDouble(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                this.matchStat = 5;
                double d3 = 0.0;
                n2 += 3;
                c3 = this.charAt(this.bp + n2++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.bp + n2++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.bp += n2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return d3;
                    }
                    if (c3 == ']') {
                        this.bp += n2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return d3;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.bp + n2++);
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (c3 == c2) {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return d2;
        }
        this.matchStat = -1;
        return d2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BigDecimal scanDecimal(char c2) {
        BigDecimal bigDecimal;
        char c3;
        int n2;
        block31: {
            BigDecimal bigDecimal2;
            block29: {
                block30: {
                    boolean bl;
                    block28: {
                        int n3;
                        int n4;
                        boolean bl2;
                        boolean bl3;
                        boolean bl4;
                        this.matchStat = 0;
                        n2 = 0;
                        boolean bl5 = bl = (c3 = this.charAt(this.bp + n2++)) == '\"';
                        if (bl) {
                            c3 = this.charAt(this.bp + n2++);
                        }
                        boolean bl6 = bl4 = c3 == '-';
                        if (bl4) {
                            c3 = this.charAt(this.bp + n2++);
                        }
                        if (c3 < '0' || c3 > '9') break block28;
                        while ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                        }
                        boolean bl7 = bl3 = c3 == '.';
                        if (bl3) {
                            if ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                                while ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        boolean bl8 = bl2 = c3 == 'e' || c3 == 'E';
                        if (bl2) {
                            if ((c3 = this.charAt(this.bp + n2++)) == '+' || c3 == '-') {
                                c3 = this.charAt(this.bp + n2++);
                            }
                            while (c3 >= '0' && c3 <= '9') {
                                c3 = this.charAt(this.bp + n2++);
                            }
                        }
                        if (bl) {
                            if (c3 != '\"') {
                                this.matchStat = -1;
                                return null;
                            }
                            c3 = this.charAt(this.bp + n2++);
                            n4 = this.bp + 1;
                            n3 = this.bp + n2 - n4 - 2;
                        } else {
                            n4 = this.bp;
                            n3 = this.bp + n2 - n4 - 1;
                        }
                        char[] cArray = this.sub_chars(n4, n3);
                        bigDecimal2 = new BigDecimal(cArray);
                        if (c3 != ',') break block29;
                        break block30;
                    }
                    if (c3 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                        this.matchStat = 5;
                        bigDecimal = null;
                        n2 += 3;
                        c3 = this.charAt(this.bp + n2++);
                        if (bl && c3 == '\"') {
                            c3 = this.charAt(this.bp + n2++);
                        }
                        break block31;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bigDecimal2;
            }
            if (c3 != ']') {
                this.matchStat = -1;
                return null;
            }
            if ((c3 = this.charAt(this.bp + n2++)) == ',') {
                this.token = 16;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c3 == ']') {
                this.token = 15;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c3 == '}') {
                this.token = 13;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else {
                if (c3 != '\u001a') {
                    this.matchStat = -1;
                    return null;
                }
                this.token = 20;
                this.bp += n2 - 1;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return bigDecimal2;
        }
        while (true) {
            if (c3 == ',') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return bigDecimal;
            }
            if (c3 == '}') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return bigDecimal;
            }
            if (!JSONLexerBase.isWhitespace(c3)) {
                this.matchStat = -1;
                return null;
            }
            c3 = this.charAt(this.bp + n2++);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final float[] scanFieldFloatArray(char[] cArray) {
        void var4_8;
        char c2;
        int n2;
        block27: {
            void var4_5;
            int n3;
            block28: {
                block26: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return null;
                    }
                    n2 = cArray.length;
                    if ((c2 = this.charAt(this.bp + n2++)) != '[') {
                        this.matchStat = -2;
                        return null;
                    }
                    c2 = this.charAt(this.bp + n2++);
                    float[] fArray = new float[16];
                    n3 = 0;
                    while (true) {
                        Object object;
                        float f2;
                        boolean bl;
                        boolean bl2;
                        boolean bl3;
                        int n4 = this.bp + n2 - 1;
                        boolean bl4 = bl3 = c2 == '-';
                        if (bl3) {
                            c2 = this.charAt(this.bp + n2++);
                        }
                        if (c2 < '0' || c2 > '9') break block26;
                        int n5 = c2 - 48;
                        while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                            n5 = n5 * 10 + (c2 - 48);
                        }
                        int n6 = 1;
                        boolean bl5 = bl2 = c2 == '.';
                        if (bl2) {
                            c2 = this.charAt(this.bp + n2++);
                            n6 = 10;
                            if (c2 >= '0' && c2 <= '9') {
                                n5 = n5 * 10 + (c2 - 48);
                                while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                                    n5 = n5 * 10 + (c2 - 48);
                                    n6 *= 10;
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        boolean bl6 = bl = c2 == 'e' || c2 == 'E';
                        if (bl) {
                            if ((c2 = this.charAt(this.bp + n2++)) == '+' || c2 == '-') {
                                c2 = this.charAt(this.bp + n2++);
                            }
                            while (c2 >= '0' && c2 <= '9') {
                                c2 = this.charAt(this.bp + n2++);
                            }
                        }
                        int n7 = this.bp + n2 - n4 - 1;
                        if (!bl && n7 < 10) {
                            f2 = (float)n5 / (float)n6;
                            if (bl3) {
                                f2 = -f2;
                            }
                        } else {
                            object = this.subString(n4, n7);
                            f2 = Float.parseFloat((String)object);
                        }
                        if (n3 >= ((void)var4_5).length) {
                            object = new float[((void)var4_5).length * 3 / 2];
                            System.arraycopy(var4_5, 0, object, 0, n3);
                            Object object2 = object;
                        }
                        var4_5[n3++] = f2;
                        if (c2 == ',') {
                            c2 = this.charAt(this.bp + n2++);
                            continue;
                        }
                        if (c2 == ']') break;
                    }
                    c2 = this.charAt(this.bp + n2++);
                    if (n3 == ((void)var4_5).length) break block27;
                    break block28;
                }
                this.matchStat = -1;
                return null;
            }
            float[] fArray = new float[n3];
            System.arraycopy(var4_5, 0, fArray, 0, n3);
            float[] fArray2 = fArray;
        }
        if (c2 == ',') {
            this.bp += n2 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return var4_8;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2 - 1;
            this.next();
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2 - 1;
            this.next();
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2 - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n2 - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return var4_8;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final float[][] scanFieldFloatArray2(char[] cArray) {
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return null;
        }
        int n2 = cArray.length;
        if ((c2 = this.charAt(this.bp + n2++)) != '[') {
            this.matchStat = -2;
            return null;
        }
        c2 = this.charAt(this.bp + n2++);
        float[][] fArrayArray = new float[16][];
        int n3 = 0;
        while (c2 == '[') {
            void var6_6;
            int n4;
            block31: {
                void var6_8;
                block32: {
                    block30: {
                        c2 = this.charAt(this.bp + n2++);
                        float[] fArray = new float[16];
                        n4 = 0;
                        while (true) {
                            Object object;
                            float f2;
                            boolean bl;
                            boolean bl2;
                            int n5 = this.bp + n2 - 1;
                            boolean bl3 = bl2 = c2 == '-';
                            if (bl2) {
                                c2 = this.charAt(this.bp + n2++);
                            }
                            if (c2 < '0' || c2 > '9') break block30;
                            int n6 = c2 - 48;
                            while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                                n6 = n6 * 10 + (c2 - 48);
                            }
                            int n7 = 1;
                            if (c2 == '.') {
                                if ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                                    n6 = n6 * 10 + (c2 - 48);
                                    n7 = 10;
                                    while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                                        n6 = n6 * 10 + (c2 - 48);
                                        n7 *= 10;
                                    }
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            boolean bl4 = bl = c2 == 'e' || c2 == 'E';
                            if (bl) {
                                if ((c2 = this.charAt(this.bp + n2++)) == '+' || c2 == '-') {
                                    c2 = this.charAt(this.bp + n2++);
                                }
                                while (c2 >= '0' && c2 <= '9') {
                                    c2 = this.charAt(this.bp + n2++);
                                }
                            }
                            int n8 = this.bp + n2 - n5 - 1;
                            if (!bl && n8 < 10) {
                                f2 = (float)n6 / (float)n7;
                                if (bl2) {
                                    f2 = -f2;
                                }
                            } else {
                                object = this.subString(n5, n8);
                                f2 = Float.parseFloat((String)object);
                            }
                            if (n4 >= ((void)var6_8).length) {
                                object = new float[((void)var6_8).length * 3 / 2];
                                System.arraycopy(var6_8, 0, object, 0, n4);
                                Object object2 = object;
                            }
                            var6_8[n4++] = f2;
                            if (c2 == ',') {
                                c2 = this.charAt(this.bp + n2++);
                                continue;
                            }
                            if (c2 == ']') break;
                        }
                        c2 = this.charAt(this.bp + n2++);
                        if (n4 == ((void)var6_8).length) break block31;
                        break block32;
                    }
                    this.matchStat = -1;
                    return null;
                }
                float[] fArray = new float[n4];
                System.arraycopy(var6_8, 0, fArray, 0, n4);
                float[] fArray2 = fArray;
            }
            if (n3 >= fArrayArray.length) {
                float[][] fArrayArray2 = new float[fArrayArray.length * 3 / 2][];
                System.arraycopy(var6_6, 0, fArrayArray2, 0, n4);
                fArrayArray = fArrayArray2;
            }
            fArrayArray[n3++] = var6_6;
            if (c2 == ',') {
                c2 = this.charAt(this.bp + n2++);
                continue;
            }
            if (c2 != ']') continue;
            c2 = this.charAt(this.bp + n2++);
            break;
        }
        if (n3 != fArrayArray.length) {
            float[][] fArrayArray3 = new float[n3][];
            System.arraycopy(fArrayArray, 0, fArrayArray3, 0, n3);
            fArrayArray = fArrayArray3;
        }
        if (c2 == ',') {
            this.bp += n2 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return fArrayArray;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2 - 1;
            this.next();
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2 - 1;
            this.next();
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2 - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n2 - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return fArrayArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double scanFieldDouble(char[] cArray) {
        double d2;
        char c2;
        int n2;
        block35: {
            double d3;
            block34: {
                boolean bl;
                block33: {
                    int n3;
                    int n4;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    n2 = cArray.length;
                    boolean bl5 = bl = (c2 = this.charAt(this.bp + n2++)) == '\"';
                    if (bl) {
                        c2 = this.charAt(this.bp + n2++);
                    }
                    boolean bl6 = bl4 = c2 == '-';
                    if (bl4) {
                        c2 = this.charAt(this.bp + n2++);
                    }
                    if (c2 < '0' || c2 > '9') break block33;
                    long l2 = c2 - 48;
                    while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                        l2 = l2 * 10L + (long)(c2 - 48);
                    }
                    long l3 = 1L;
                    boolean bl7 = bl3 = c2 == '.';
                    if (bl3) {
                        if ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                            l2 = l2 * 10L + (long)(c2 - 48);
                            l3 = 10L;
                            while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                                l2 = l2 * 10L + (long)(c2 - 48);
                                l3 *= 10L;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    boolean bl8 = bl2 = c2 == 'e' || c2 == 'E';
                    if (bl2) {
                        if ((c2 = this.charAt(this.bp + n2++)) == '+' || c2 == '-') {
                            c2 = this.charAt(this.bp + n2++);
                        }
                        while (c2 >= '0' && c2 <= '9') {
                            c2 = this.charAt(this.bp + n2++);
                        }
                    }
                    if (bl) {
                        if (c2 != '\"') {
                            this.matchStat = -1;
                            return 0.0;
                        }
                        c2 = this.charAt(this.bp + n2++);
                        n4 = this.bp + cArray.length + 1;
                        n3 = this.bp + n2 - n4 - 2;
                    } else {
                        n4 = this.bp + cArray.length;
                        n3 = this.bp + n2 - n4 - 1;
                    }
                    if (!bl2 && n3 < 17) {
                        d3 = (double)l2 / (double)l3;
                        if (bl4) {
                            d3 = -d3;
                        }
                        break block34;
                    } else {
                        String string = this.subString(n4, n3);
                        d3 = Double.parseDouble(string);
                    }
                    break block34;
                }
                if (c2 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                    this.matchStat = 5;
                    d2 = 0.0;
                    n2 += 3;
                    c2 = this.charAt(this.bp + n2++);
                    if (bl && c2 == '\"') {
                        c2 = this.charAt(this.bp + n2++);
                    }
                    break block35;
                } else {
                    this.matchStat = -1;
                    return 0.0;
                }
            }
            if (c2 == ',') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return d3;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return 0.0;
            }
            if ((c2 = this.charAt(this.bp + n2++)) == ',') {
                this.token = 16;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c2 == ']') {
                this.token = 15;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c2 == '}') {
                this.token = 13;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return 0.0;
                }
                this.token = 20;
                this.bp += n2 - 1;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return d3;
        }
        while (true) {
            if (c2 == ',') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return d2;
            }
            if (c2 == '}') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return d2;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return 0.0;
            }
            c2 = this.charAt(this.bp + n2++);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public BigDecimal scanFieldDecimal(char[] cArray) {
        BigDecimal bigDecimal;
        char c2;
        int n2;
        block32: {
            BigDecimal bigDecimal2;
            block30: {
                block31: {
                    boolean bl;
                    block29: {
                        int n3;
                        int n4;
                        boolean bl2;
                        boolean bl3;
                        boolean bl4;
                        this.matchStat = 0;
                        if (!this.charArrayCompare(cArray)) {
                            this.matchStat = -2;
                            return null;
                        }
                        n2 = cArray.length;
                        boolean bl5 = bl = (c2 = this.charAt(this.bp + n2++)) == '\"';
                        if (bl) {
                            c2 = this.charAt(this.bp + n2++);
                        }
                        boolean bl6 = bl4 = c2 == '-';
                        if (bl4) {
                            c2 = this.charAt(this.bp + n2++);
                        }
                        if (c2 < '0' || c2 > '9') break block29;
                        while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                        }
                        boolean bl7 = bl3 = c2 == '.';
                        if (bl3) {
                            if ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                                while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        boolean bl8 = bl2 = c2 == 'e' || c2 == 'E';
                        if (bl2) {
                            if ((c2 = this.charAt(this.bp + n2++)) == '+' || c2 == '-') {
                                c2 = this.charAt(this.bp + n2++);
                            }
                            while (c2 >= '0' && c2 <= '9') {
                                c2 = this.charAt(this.bp + n2++);
                            }
                        }
                        if (bl) {
                            if (c2 != '\"') {
                                this.matchStat = -1;
                                return null;
                            }
                            c2 = this.charAt(this.bp + n2++);
                            n4 = this.bp + cArray.length + 1;
                            n3 = this.bp + n2 - n4 - 2;
                        } else {
                            n4 = this.bp + cArray.length;
                            n3 = this.bp + n2 - n4 - 1;
                        }
                        char[] cArray2 = this.sub_chars(n4, n3);
                        bigDecimal2 = new BigDecimal(cArray2);
                        if (c2 != ',') break block30;
                        break block31;
                    }
                    if (c2 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                        this.matchStat = 5;
                        bigDecimal = null;
                        n2 += 3;
                        c2 = this.charAt(this.bp + n2++);
                        if (bl && c2 == '\"') {
                            c2 = this.charAt(this.bp + n2++);
                        }
                        break block32;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bigDecimal2;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return null;
            }
            if ((c2 = this.charAt(this.bp + n2++)) == ',') {
                this.token = 16;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c2 == ']') {
                this.token = 15;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c2 == '}') {
                this.token = 13;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return null;
                }
                this.token = 20;
                this.bp += n2 - 1;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return bigDecimal2;
        }
        while (true) {
            if (c2 == ',') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return bigDecimal;
            }
            if (c2 == '}') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return bigDecimal;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.bp + n2++);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public BigInteger scanFieldBigInteger(char[] cArray) {
        BigInteger bigInteger;
        char c2;
        int n2;
        block28: {
            BigInteger bigInteger2;
            int n3;
            int n4;
            boolean bl;
            long l2;
            boolean bl2;
            boolean bl3;
            block27: {
                block26: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return null;
                    }
                    n2 = cArray.length;
                    boolean bl4 = bl3 = (c2 = this.charAt(this.bp + n2++)) == '\"';
                    if (bl3) {
                        c2 = this.charAt(this.bp + n2++);
                    }
                    boolean bl5 = bl2 = c2 == '-';
                    if (bl2) {
                        c2 = this.charAt(this.bp + n2++);
                    }
                    if (c2 < '0' || c2 > '9') break block26;
                    l2 = c2 - 48;
                    bl = false;
                    break block27;
                }
                if (c2 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                    this.matchStat = 5;
                    bigInteger = null;
                    n2 += 3;
                    c2 = this.charAt(this.bp + n2++);
                    if (bl3 && c2 == '\"') {
                        c2 = this.charAt(this.bp + n2++);
                    }
                    break block28;
                } else {
                    this.matchStat = -1;
                    return null;
                }
            }
            while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                long l3 = l2 * 10L + (long)(c2 - 48);
                if (l3 < l2) {
                    bl = true;
                    break;
                }
                l2 = l3;
            }
            if (bl3) {
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                c2 = this.charAt(this.bp + n2++);
                n4 = this.bp + cArray.length + 1;
                n3 = this.bp + n2 - n4 - 2;
            } else {
                n4 = this.bp + cArray.length;
                n3 = this.bp + n2 - n4 - 1;
            }
            if (!bl && (n3 < 20 || bl2 && n3 < 21)) {
                bigInteger2 = BigInteger.valueOf(bl2 ? -l2 : l2);
            } else {
                String string = this.subString(n4, n3);
                bigInteger2 = new BigInteger(string);
            }
            if (c2 == ',') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return bigInteger2;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return null;
            }
            if ((c2 = this.charAt(this.bp + n2++)) == ',') {
                this.token = 16;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c2 == ']') {
                this.token = 15;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else if (c2 == '}') {
                this.token = 13;
                this.bp += n2;
                this.ch = this.charAt(this.bp);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return null;
                }
                this.token = 20;
                this.bp += n2 - 1;
                this.ch = (char)26;
            }
            this.matchStat = 4;
            return bigInteger2;
        }
        while (true) {
            if (c2 == ',') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 16;
                return bigInteger;
            }
            if (c2 == '}') {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 5;
                this.token = 13;
                return bigInteger;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.bp + n2++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanFieldDate(char[] cArray) {
        Date date;
        char c2;
        int n2;
        block25: {
            Object object;
            String string;
            int n3;
            block27: {
                block28: {
                    block26: {
                        this.matchStat = 0;
                        if (!this.charArrayCompare(cArray)) {
                            this.matchStat = -2;
                            return null;
                        }
                        n2 = cArray.length;
                        if ((c2 = this.charAt(this.bp + n2++)) != '\"') break block26;
                        int n4 = this.bp + cArray.length + 1;
                        n3 = this.indexOf('\"', n4);
                        if (n3 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        int n5 = this.bp + cArray.length + 1;
                        string = this.subString(n5, n3 - n5);
                        if (string.indexOf(92) == -1) break block27;
                        break block28;
                    }
                    if (c2 == '-' || c2 >= '0' && c2 <= '9') {
                        long l2 = 0L;
                        boolean bl = false;
                        if (c2 == '-') {
                            c2 = this.charAt(this.bp + n2++);
                            bl = true;
                        }
                        if (c2 >= '0' && c2 <= '9') {
                            l2 = c2 - 48;
                            while ((c2 = this.charAt(this.bp + n2++)) >= '0' && c2 <= '9') {
                                l2 = l2 * 10L + (long)(c2 - 48);
                            }
                        }
                        if (l2 < 0L) {
                            this.matchStat = -1;
                            return null;
                        }
                        if (bl) {
                            l2 = -l2;
                        }
                        date = new Date(l2);
                        break block25;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                while (true) {
                    int n6 = 0;
                    for (int i2 = n3 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n6, --i2) {
                    }
                    if (n6 % 2 == 0) {
                        n6 = n3 - (this.bp + cArray.length + 1);
                        object = this.sub_chars(this.bp + cArray.length + 1, n6);
                        string = JSONLexerBase.readString((char[])object, n6);
                        break;
                    }
                    n3 = this.indexOf('\"', n3 + 1);
                }
            }
            n2 += n3 - (this.bp + cArray.length + 1) + 1;
            c2 = this.charAt(this.bp + n2++);
            try (JSONScanner jSONScanner = new JSONScanner(string);){
                if (!jSONScanner.scanISO8601DateIfMatch(false)) {
                    this.matchStat = -1;
                    object = null;
                    return object;
                }
                object = jSONScanner.getCalendar();
                date = ((Calendar)object).getTime();
            }
        }
        if (c2 == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return date;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanDate(char c2) {
        Date date;
        char c3;
        int n2;
        block26: {
            Object object;
            String string;
            int n3;
            block28: {
                block29: {
                    block27: {
                        this.matchStat = 0;
                        n2 = 0;
                        if ((c3 = this.charAt(this.bp + n2++)) != '\"') break block27;
                        int n4 = this.bp + 1;
                        n3 = this.indexOf('\"', n4);
                        if (n3 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        int n5 = this.bp + 1;
                        string = this.subString(n5, n3 - n5);
                        if (string.indexOf(92) == -1) break block28;
                        break block29;
                    }
                    if (c3 == '-' || c3 >= '0' && c3 <= '9') {
                        long l2 = 0L;
                        boolean bl = false;
                        if (c3 == '-') {
                            c3 = this.charAt(this.bp + n2++);
                            bl = true;
                        }
                        if (c3 >= '0' && c3 <= '9') {
                            l2 = c3 - 48;
                            while ((c3 = this.charAt(this.bp + n2++)) >= '0' && c3 <= '9') {
                                l2 = l2 * 10L + (long)(c3 - 48);
                            }
                        }
                        if (l2 < 0L) {
                            this.matchStat = -1;
                            return null;
                        }
                        if (bl) {
                            l2 = -l2;
                        }
                        date = new Date(l2);
                        break block26;
                    } else if (c3 == 'n' && this.charAt(this.bp + n2) == 'u' && this.charAt(this.bp + n2 + 1) == 'l' && this.charAt(this.bp + n2 + 2) == 'l') {
                        this.matchStat = 5;
                        date = null;
                        n2 += 3;
                        c3 = this.charAt(this.bp + n2++);
                        break block26;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                while (true) {
                    int n6 = 0;
                    for (int i2 = n3 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n6, --i2) {
                    }
                    if (n6 % 2 == 0) {
                        n6 = n3 - (this.bp + 1);
                        object = this.sub_chars(this.bp + 1, n6);
                        string = JSONLexerBase.readString((char[])object, n6);
                        break;
                    }
                    n3 = this.indexOf('\"', n3 + 1);
                }
            }
            n2 += n3 - (this.bp + 1) + 1;
            c3 = this.charAt(this.bp + n2++);
            try (JSONScanner jSONScanner = new JSONScanner(string);){
                if (!jSONScanner.scanISO8601DateIfMatch(false)) {
                    this.matchStat = -1;
                    object = null;
                    return object;
                }
                object = jSONScanner.getCalendar();
                date = ((Calendar)object).getTime();
            }
        }
        if (c3 == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return date;
        }
        if (c3 != ']') {
            this.matchStat = -1;
            return null;
        }
        if ((c3 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c3 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c3 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c3 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return date;
    }

    /*
     * Enabled aggressive block sorting
     */
    public UUID scanFieldUUID(char[] cArray) {
        UUID uUID;
        char c2;
        int n2;
        block63: {
            char c3;
            int n3;
            int n4;
            long l2;
            long l3;
            int n5;
            int n6;
            block67: {
                char c4;
                int n7;
                int n8;
                long l4;
                long l5;
                block66: {
                    block64: {
                        int n9;
                        block65: {
                            this.matchStat = 0;
                            if (!this.charArrayCompare(cArray)) {
                                this.matchStat = -2;
                                return null;
                            }
                            n2 = cArray.length;
                            if ((c2 = this.charAt(this.bp + n2++)) != '\"') break block64;
                            int n10 = this.bp + cArray.length + 1;
                            n6 = this.indexOf('\"', n10);
                            if (n6 == -1) {
                                throw new JSONException("unclosed str");
                            }
                            n5 = this.bp + cArray.length + 1;
                            n9 = n6 - n5;
                            if (n9 != 36) break block65;
                            l5 = 0L;
                            l4 = 0L;
                            break block66;
                        }
                        if (n9 != 32) {
                            this.matchStat = -1;
                            return null;
                        }
                        l3 = 0L;
                        l2 = 0L;
                        break block67;
                    }
                    if (c2 == 'n' && this.charAt(this.bp + n2++) == 'u' && this.charAt(this.bp + n2++) == 'l' && this.charAt(this.bp + n2++) == 'l') {
                        uUID = null;
                        c2 = this.charAt(this.bp + n2++);
                        break block63;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                for (n7 = 0; n7 < 8; l5 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 9; n7 < 13; l5 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 14; n7 < 18; l5 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 19; n7 < 23; l4 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n7 = 24; n7 < 36; l4 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                uUID = new UUID(l5, l4);
                n2 += n6 - (this.bp + cArray.length + 1) + 1;
                c2 = this.charAt(this.bp + n2++);
                break block63;
            }
            for (n3 = 0; n3 < 16; l3 |= (long)n4, ++n3) {
                c3 = this.charAt(n5 + n3);
                if (c3 >= '0' && c3 <= '9') {
                    n4 = c3 - 48;
                } else if (c3 >= 'a' && c3 <= 'f') {
                    n4 = 10 + (c3 - 97);
                } else if (c3 >= 'A' && c3 <= 'F') {
                    n4 = 10 + (c3 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l3 <<= 4;
            }
            for (n3 = 16; n3 < 32; l2 |= (long)n4, ++n3) {
                c3 = this.charAt(n5 + n3);
                if (c3 >= '0' && c3 <= '9') {
                    n4 = c3 - 48;
                } else if (c3 >= 'a' && c3 <= 'f') {
                    n4 = 10 + (c3 - 97);
                } else if (c3 >= 'A' && c3 <= 'F') {
                    n4 = 10 + (c3 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l2 <<= 4;
            }
            uUID = new UUID(l3, l2);
            n2 += n6 - (this.bp + cArray.length + 1) + 1;
            c2 = this.charAt(this.bp + n2++);
        }
        if (c2 == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return uUID;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return uUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    public UUID scanUUID(char c2) {
        UUID uUID;
        char c3;
        int n2;
        block62: {
            char c4;
            int n3;
            int n4;
            long l2;
            long l3;
            int n5;
            int n6;
            block66: {
                char c5;
                int n7;
                int n8;
                long l4;
                long l5;
                block65: {
                    block63: {
                        int n9;
                        block64: {
                            this.matchStat = 0;
                            n2 = 0;
                            if ((c3 = this.charAt(this.bp + n2++)) != '\"') break block63;
                            int n10 = this.bp + 1;
                            n6 = this.indexOf('\"', n10);
                            if (n6 == -1) {
                                throw new JSONException("unclosed str");
                            }
                            n5 = this.bp + 1;
                            n9 = n6 - n5;
                            if (n9 != 36) break block64;
                            l5 = 0L;
                            l4 = 0L;
                            break block65;
                        }
                        if (n9 != 32) {
                            this.matchStat = -1;
                            return null;
                        }
                        l3 = 0L;
                        l2 = 0L;
                        break block66;
                    }
                    if (c3 == 'n' && this.charAt(this.bp + n2++) == 'u' && this.charAt(this.bp + n2++) == 'l' && this.charAt(this.bp + n2++) == 'l') {
                        uUID = null;
                        c3 = this.charAt(this.bp + n2++);
                        break block62;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                for (n7 = 0; n7 < 8; l5 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 9; n7 < 13; l5 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 14; n7 < 18; l5 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 19; n7 < 23; l4 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n7 = 24; n7 < 36; l4 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                uUID = new UUID(l5, l4);
                n2 += n6 - (this.bp + 1) + 1;
                c3 = this.charAt(this.bp + n2++);
                break block62;
            }
            for (n3 = 0; n3 < 16; l3 |= (long)n4, ++n3) {
                c4 = this.charAt(n5 + n3);
                if (c4 >= '0' && c4 <= '9') {
                    n4 = c4 - 48;
                } else if (c4 >= 'a' && c4 <= 'f') {
                    n4 = 10 + (c4 - 97);
                } else if (c4 >= 'A' && c4 <= 'F') {
                    n4 = 10 + (c4 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l3 <<= 4;
            }
            for (n3 = 16; n3 < 32; l2 |= (long)n4, ++n3) {
                c4 = this.charAt(n5 + n3);
                if (c4 >= '0' && c4 <= '9') {
                    n4 = c4 - 48;
                } else if (c4 >= 'a' && c4 <= 'f') {
                    n4 = 10 + (c4 - 97);
                } else if (c4 >= 'A' && c4 <= 'F') {
                    n4 = 10 + (c4 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l2 <<= 4;
            }
            uUID = new UUID(l3, l2);
            n2 += n6 - (this.bp + 1) + 1;
            c3 = this.charAt(this.bp + n2++);
        }
        if (c3 == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return uUID;
        }
        if (c3 != ']') {
            this.matchStat = -1;
            return null;
        }
        if ((c3 = this.charAt(this.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c3 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c3 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c3 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return uUID;
    }

    public final void scanTrue() {
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'u') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b' && this.ch != ':' && this.ch != '/') {
            throw new JSONException("scan true error");
        }
        this.token = 6;
    }

    public final void scanNullOrNew() {
        this.scanNullOrNew(true);
    }

    public final void scanNullOrNew(boolean bl) {
        if (this.ch != 'n') {
            throw new JSONException("error parse null or new");
        }
        this.next();
        if (this.ch == 'u') {
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (!(this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == ':' && bl || this.ch == '\f' || this.ch == '\b')) {
                throw new JSONException("scan null error");
            }
            this.token = 8;
            return;
        }
        if (this.ch != 'e') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.ch != 'w') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan new error");
        }
        this.token = 9;
    }

    public final void scanFalse() {
        if (this.ch != 'f') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'a') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'l') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 's') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b' && this.ch != ':' && this.ch != '/') {
            throw new JSONException("scan false error");
        }
        this.token = 7;
    }

    public final void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.next();
        } while (Character.isLetterOrDigit(this.ch));
        String string = this.stringVal();
        this.token = "null".equalsIgnoreCase(string) ? 8 : ("new".equals(string) ? 9 : ("true".equals(string) ? 6 : ("false".equals(string) ? 7 : ("undefined".equals(string) ? 23 : ("Set".equals(string) ? 21 : ("TreeSet".equals(string) ? 22 : 18))))));
    }

    @Override
    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    protected abstract char[] sub_chars(int var1, int var2);

    public static String readString(char[] cArray, int n2) {
        char[] cArray2 = new char[n2];
        int n3 = 0;
        block22: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 != '\\') {
                cArray2[n3++] = c2;
                continue;
            }
            c2 = cArray[++i2];
            switch (c2) {
                case '0': {
                    cArray2[n3++] = '\u0000';
                    continue block22;
                }
                case '1': {
                    cArray2[n3++] = '\u0001';
                    continue block22;
                }
                case '2': {
                    cArray2[n3++] = 2;
                    continue block22;
                }
                case '3': {
                    cArray2[n3++] = 3;
                    continue block22;
                }
                case '4': {
                    cArray2[n3++] = 4;
                    continue block22;
                }
                case '5': {
                    cArray2[n3++] = 5;
                    continue block22;
                }
                case '6': {
                    cArray2[n3++] = 6;
                    continue block22;
                }
                case '7': {
                    cArray2[n3++] = 7;
                    continue block22;
                }
                case 'b': {
                    cArray2[n3++] = 8;
                    continue block22;
                }
                case 't': {
                    cArray2[n3++] = 9;
                    continue block22;
                }
                case 'n': {
                    cArray2[n3++] = 10;
                    continue block22;
                }
                case 'v': {
                    cArray2[n3++] = 11;
                    continue block22;
                }
                case 'F': 
                case 'f': {
                    cArray2[n3++] = 12;
                    continue block22;
                }
                case 'r': {
                    cArray2[n3++] = 13;
                    continue block22;
                }
                case '\"': {
                    cArray2[n3++] = 34;
                    continue block22;
                }
                case '\'': {
                    cArray2[n3++] = 39;
                    continue block22;
                }
                case '/': {
                    cArray2[n3++] = 47;
                    continue block22;
                }
                case '\\': {
                    cArray2[n3++] = 92;
                    continue block22;
                }
                case 'x': {
                    cArray2[n3++] = (char)(digits[cArray[++i2]] * 16 + digits[cArray[++i2]]);
                    continue block22;
                }
                case 'u': {
                    cArray2[n3++] = (char)Integer.parseInt(new String(new char[]{cArray[++i2], cArray[++i2], cArray[++i2], cArray[++i2]}), 16);
                    continue block22;
                }
                default: {
                    throw new JSONException("unclosed.str.lit");
                }
            }
        }
        return new String(cArray2, 0, n3);
    }

    protected abstract boolean charArrayCompare(char[] var1);

    @Override
    public boolean isBlankInput() {
        int n2 = 0;
        while (true) {
            char c2;
            if ((c2 = this.charAt(n2)) == '\u001a') break;
            if (!JSONLexerBase.isWhitespace(c2)) {
                return false;
            }
            ++n2;
        }
        this.token = 20;
        return true;
    }

    @Override
    public final void skipWhitespace() {
        while (this.ch <= '/') {
            if (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b') {
                this.next();
                continue;
            }
            if (this.ch != '/') break;
            this.skipComment();
        }
    }

    private void scanStringSingleQuote() {
        char c2;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((c2 = this.next()) != '\'') {
            if (c2 == '\u001a') {
                if (!this.isEOF()) {
                    this.putChar('\u001a');
                    continue;
                }
                throw new JSONException("unclosed single-quote string");
            }
            if (c2 == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] cArray = new char[this.sp * 2];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    this.copyTo(this.np + 1, this.sp, this.sbuf);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        boolean bl;
                        char c3 = this.next();
                        char c4 = this.next();
                        boolean bl2 = c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 <= 'F';
                        boolean bl3 = bl = c4 >= '0' && c4 <= '9' || c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 <= 'F';
                        if (!bl2 || !bl) {
                            throw new JSONException("invalid escape character \\x" + c3 + c4);
                        }
                        this.putChar((char)(digits[c3] * 16 + digits[c4]));
                        continue block22;
                    }
                    case 'u': {
                        this.putChar((char)Integer.parseInt(new String(new char[]{this.next(), this.next(), this.next(), this.next()}), 16));
                        continue block22;
                    }
                }
                this.ch = c2;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c2);
                continue;
            }
            this.sbuf[this.sp++] = c2;
        }
        this.token = 4;
        this.next();
    }

    protected final void putChar(char c2) {
        if (this.sp == this.sbuf.length) {
            char[] cArray = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
            this.sbuf = cArray;
        }
        this.sbuf[this.sp++] = c2;
    }

    public final void scanHex() {
        if (this.ch != 'x') {
            throw new JSONException("illegal state. " + this.ch);
        }
        this.next();
        if (this.ch != '\'') {
            throw new JSONException("illegal state. " + this.ch);
        }
        this.np = this.bp;
        this.next();
        if (this.ch == '\'') {
            this.next();
            this.token = 26;
            return;
        }
        int n2 = 0;
        while (true) {
            char c2;
            if ((c2 = this.next()) >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F') {
                ++this.sp;
            } else {
                if (c2 == '\'') {
                    ++this.sp;
                    break;
                }
                throw new JSONException("illegal state. " + c2);
            }
            ++n2;
        }
        this.next();
        this.token = 26;
    }

    @Override
    public final void scanNumber() {
        this.np = this.bp;
        if (this.ch == '-') {
            ++this.sp;
            this.next();
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.next();
        }
        boolean bl = false;
        if (this.ch == '.') {
            ++this.sp;
            this.next();
            bl = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.next();
            }
        }
        if (this.ch == 'L') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'S') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'B') {
            ++this.sp;
            this.next();
        } else if (this.ch == 'F') {
            ++this.sp;
            this.next();
            bl = true;
        } else if (this.ch == 'D') {
            ++this.sp;
            this.next();
            bl = true;
        } else if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.next();
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.next();
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.next();
            }
            if (this.ch == 'D' || this.ch == 'F') {
                ++this.sp;
                this.next();
            }
            bl = true;
        }
        this.token = bl ? 3 : 2;
    }

    @Override
    public final long longValue() throws NumberFormatException {
        char c2;
        int n2;
        long l2;
        long l3 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        int n3 = this.np;
        int n4 = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n3;
        } else {
            l2 = -9223372036854775807L;
        }
        long l4 = -922337203685477580L;
        if (n3 < n4) {
            n2 = this.charAt(n3++) - 48;
            l3 = -n2;
        }
        while (n3 < n4 && (c2 = this.charAt(n3++)) != 'L' && c2 != 'S' && c2 != 'B') {
            n2 = c2 - 48;
            if (l3 < l4) {
                throw new NumberFormatException(this.numberString());
            }
            if ((l3 *= 10L) < l2 + (long)n2) {
                throw new NumberFormatException(this.numberString());
            }
            l3 -= (long)n2;
        }
        if (bl) {
            if (n3 > this.np + 1) {
                return l3;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -l3;
    }

    @Override
    public final Number decimalValue(boolean bl) {
        char c2 = this.charAt(this.np + this.sp - 1);
        try {
            if (c2 == 'F') {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            if (c2 == 'D') {
                return Double.parseDouble(this.numberString());
            }
            if (bl) {
                return this.decimalValue();
            }
            return this.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSONException(numberFormatException.getMessage() + ", " + this.info());
        }
    }

    @Override
    public abstract BigDecimal decimalValue();

    public static boolean isWhitespace(char c2) {
        return c2 <= ' ' && (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\f' || c2 == '\b');
    }

    public String[] scanFieldStringArray(char[] cArray, int n2, SymbolTable symbolTable) {
        throw new UnsupportedOperationException();
    }

    public boolean matchField2(char[] cArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFeatures() {
        return this.features;
    }

    static {
        int n2;
        SBUF_LOCAL = new ThreadLocal();
        typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
        digits = new int[103];
        for (n2 = 48; n2 <= 57; ++n2) {
            JSONLexerBase.digits[n2] = n2 - 48;
        }
        for (n2 = 97; n2 <= 102; ++n2) {
            JSONLexerBase.digits[n2] = n2 - 97 + 10;
        }
        for (n2 = 65; n2 <= 70; ++n2) {
            JSONLexerBase.digits[n2] = n2 - 65 + 10;
        }
    }
}

