/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser.deserializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.serializer.BeanContext;
import com.icbc.api.internal.util.fastjson.util.FieldInfo;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class FieldDeserializer {
    public final FieldInfo fieldInfo;
    protected final Class<?> clazz;
    protected BeanContext beanContext;

    public FieldDeserializer(Class<?> clazz, FieldInfo fieldInfo) {
        this.clazz = clazz;
        this.fieldInfo = fieldInfo;
    }

    public abstract void parseField(DefaultJSONParser var1, Object var2, Type var3, Map<String, Object> var4);

    public int getFastMatchToken() {
        return 0;
    }

    public void setValue(Object object, boolean bl) {
        this.setValue(object, (Object)bl);
    }

    public void setValue(Object object, int n2) {
        this.setValue(object, (Object)n2);
    }

    public void setValue(Object object, long l2) {
        this.setValue(object, (Object)l2);
    }

    public void setValue(Object object, String string) {
        this.setValue(object, (Object)string);
    }

    public void setValue(Object object, Object object2) {
        if (object2 == null && this.fieldInfo.fieldClass.isPrimitive()) {
            return;
        }
        if (this.fieldInfo.fieldClass == String.class && this.fieldInfo.format != null && this.fieldInfo.format.equals("trim")) {
            object2 = ((String)object2).trim();
        }
        try {
            Method method = this.fieldInfo.method;
            if (method != null) {
                if (this.fieldInfo.getOnly) {
                    if (this.fieldInfo.fieldClass == AtomicInteger.class) {
                        AtomicInteger atomicInteger = (AtomicInteger)method.invoke(object, new Object[0]);
                        if (atomicInteger != null) {
                            atomicInteger.set(((AtomicInteger)object2).get());
                        }
                    } else if (this.fieldInfo.fieldClass == AtomicLong.class) {
                        AtomicLong atomicLong = (AtomicLong)method.invoke(object, new Object[0]);
                        if (atomicLong != null) {
                            atomicLong.set(((AtomicLong)object2).get());
                        }
                    } else if (this.fieldInfo.fieldClass == AtomicBoolean.class) {
                        AtomicBoolean atomicBoolean = (AtomicBoolean)method.invoke(object, new Object[0]);
                        if (atomicBoolean != null) {
                            atomicBoolean.set(((AtomicBoolean)object2).get());
                        }
                    } else if (Map.class.isAssignableFrom(method.getReturnType())) {
                        Map map = (Map)method.invoke(object, new Object[0]);
                        if (map != null) {
                            if (map == Collections.emptyMap() || map.getClass().getName().startsWith("java.util.Collections$Unmodifiable")) {
                                return;
                            }
                            if (map.getClass().getName().equals("kotlin.collections.EmptyMap")) {
                                if (this.fieldInfo.field != null && !Modifier.isFinal(this.fieldInfo.field.getModifiers())) {
                                    this.fieldInfo.field.set(object, object2);
                                }
                                return;
                            }
                            map.putAll((Map)object2);
                        }
                    } else {
                        Collection collection = (Collection)method.invoke(object, new Object[0]);
                        if (collection != null && object2 != null) {
                            String string = collection.getClass().getName();
                            if (collection == Collections.emptySet() || collection == Collections.emptyList() || string.startsWith("java.util.Collections$Unmodifiable")) {
                                return;
                            }
                            if (!collection.isEmpty()) {
                                collection.clear();
                            }
                            if (string.equals("kotlin.collections.EmptyList") || string.equals("kotlin.collections.EmptySet")) {
                                if (this.fieldInfo.field != null && !Modifier.isFinal(this.fieldInfo.field.getModifiers())) {
                                    this.fieldInfo.field.set(object, (Collection)object2);
                                }
                                return;
                            }
                            collection.addAll((Collection)object2);
                        }
                    }
                } else {
                    method.invoke(object, object2);
                }
            } else {
                Field field = this.fieldInfo.field;
                if (this.fieldInfo.getOnly) {
                    if (this.fieldInfo.fieldClass == AtomicInteger.class) {
                        AtomicInteger atomicInteger = (AtomicInteger)field.get(object);
                        if (atomicInteger != null) {
                            atomicInteger.set(((AtomicInteger)object2).get());
                        }
                    } else if (this.fieldInfo.fieldClass == AtomicLong.class) {
                        AtomicLong atomicLong = (AtomicLong)field.get(object);
                        if (atomicLong != null) {
                            atomicLong.set(((AtomicLong)object2).get());
                        }
                    } else if (this.fieldInfo.fieldClass == AtomicBoolean.class) {
                        AtomicBoolean atomicBoolean = (AtomicBoolean)field.get(object);
                        if (atomicBoolean != null) {
                            atomicBoolean.set(((AtomicBoolean)object2).get());
                        }
                    } else if (Map.class.isAssignableFrom(this.fieldInfo.fieldClass)) {
                        Map map = (Map)field.get(object);
                        if (map != null) {
                            if (map == Collections.emptyMap() || map.getClass().getName().startsWith("java.util.Collections$Unmodifiable")) {
                                return;
                            }
                            map.putAll((Map)object2);
                        }
                    } else {
                        Collection collection = (Collection)field.get(object);
                        if (collection != null && object2 != null) {
                            if (collection == Collections.emptySet() || collection == Collections.emptyList() || collection.getClass().getName().startsWith("java.util.Collections$Unmodifiable")) {
                                return;
                            }
                            collection.clear();
                            collection.addAll((Collection)object2);
                        }
                    }
                } else if (field != null) {
                    field.set(object, object2);
                }
            }
        }
        catch (Exception exception) {
            throw new JSONException("set property error, " + this.clazz.getName() + "#" + this.fieldInfo.name, exception);
        }
    }

    public void setWrappedValue(String string, Object object) {
        throw new JSONException("TODO");
    }
}

