/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser.deserializer;

import com.icbc.api.internal.util.fastjson.annotation.JSONField;
import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.JSONLexerBase;
import com.icbc.api.internal.util.fastjson.parser.JSONToken;
import com.icbc.api.internal.util.fastjson.parser.ParseContext;
import com.icbc.api.internal.util.fastjson.parser.ParserConfig;
import com.icbc.api.internal.util.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.EnumDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.FieldDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.MapDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.util.FieldInfo;
import com.icbc.api.internal.util.fastjson.util.JavaBeanInfo;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JavaBeanDeserializer
implements ObjectDeserializer {
    private final FieldDeserializer[] fieldDeserializers;
    protected final FieldDeserializer[] sortedFieldDeserializers;
    protected final Class<?> clazz;
    public final JavaBeanInfo beanInfo;
    private ConcurrentMap<String, Object> extraFieldDeserializers;
    private final Map<String, FieldDeserializer> alterNameFieldDeserializers;
    private Map<String, FieldDeserializer> fieldDeserializerMap;
    private transient long[] smartMatchHashArray;
    private transient short[] smartMatchHashArrayMapping;
    private transient long[] hashArray;
    private transient short[] hashArrayMapping;

    public JavaBeanDeserializer(ParserConfig parserConfig, Class<?> clazz) {
        this(parserConfig, clazz, clazz);
    }

    public JavaBeanDeserializer(ParserConfig parserConfig, Class<?> clazz, Type type) {
        this(parserConfig, JavaBeanInfo.build(clazz, type, parserConfig.propertyNamingStrategy, parserConfig.fieldBased, parserConfig.compatibleWithJavaBean, parserConfig.isJacksonCompatible()));
    }

    public JavaBeanDeserializer(ParserConfig parserConfig, JavaBeanInfo javaBeanInfo) {
        FieldDeserializer fieldDeserializer;
        this.clazz = javaBeanInfo.clazz;
        this.beanInfo = javaBeanInfo;
        HashMap<String, FieldDeserializer> hashMap = null;
        this.sortedFieldDeserializers = new FieldDeserializer[javaBeanInfo.sortedFields.length];
        int n2 = javaBeanInfo.sortedFields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FieldInfo fieldInfo = javaBeanInfo.sortedFields[i2];
            this.sortedFieldDeserializers[i2] = fieldDeserializer = parserConfig.createFieldDeserializer(parserConfig, javaBeanInfo, fieldInfo);
            if (n2 > 128) {
                if (this.fieldDeserializerMap == null) {
                    this.fieldDeserializerMap = new HashMap<String, FieldDeserializer>();
                }
                this.fieldDeserializerMap.put(fieldInfo.name, fieldDeserializer);
            }
            for (String string : fieldInfo.alternateNames) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, FieldDeserializer>();
                }
                hashMap.put(string, fieldDeserializer);
            }
        }
        this.alterNameFieldDeserializers = hashMap;
        this.fieldDeserializers = new FieldDeserializer[javaBeanInfo.fields.length];
        for (FieldInfo fieldInfo : javaBeanInfo.fields) {
            this.fieldDeserializers[i2] = fieldDeserializer = this.getFieldDeserializer(fieldInfo.name);
        }
    }

    public FieldDeserializer getFieldDeserializer(String string) {
        return this.getFieldDeserializer(string, null);
    }

    public FieldDeserializer getFieldDeserializer(String string, int[] nArray) {
        FieldDeserializer fieldDeserializer;
        if (string == null) {
            return null;
        }
        if (this.fieldDeserializerMap != null && (fieldDeserializer = this.fieldDeserializerMap.get(string)) != null) {
            return fieldDeserializer;
        }
        int n2 = 0;
        int n3 = this.sortedFieldDeserializers.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            String string2 = this.sortedFieldDeserializers[n4].fieldInfo.name;
            int n5 = string2.compareTo(string);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            if (JavaBeanDeserializer.isSetFlag(n4, nArray)) {
                return null;
            }
            return this.sortedFieldDeserializers[n4];
        }
        if (this.alterNameFieldDeserializers != null) {
            return this.alterNameFieldDeserializers.get(string);
        }
        return null;
    }

    public FieldDeserializer getFieldDeserializer(long l2) {
        int n2;
        int n3;
        if (this.hashArray == null) {
            long[] lArray = new long[this.sortedFieldDeserializers.length];
            for (n3 = 0; n3 < this.sortedFieldDeserializers.length; ++n3) {
                lArray[n3] = TypeUtils.fnv1a_64(this.sortedFieldDeserializers[n3].fieldInfo.name);
            }
            Arrays.sort(lArray);
            this.hashArray = lArray;
        }
        if ((n2 = Arrays.binarySearch(this.hashArray, l2)) < 0) {
            return null;
        }
        if (this.hashArrayMapping == null) {
            short[] sArray = new short[this.hashArray.length];
            Arrays.fill(sArray, (short)-1);
            for (int i2 = 0; i2 < this.sortedFieldDeserializers.length; ++i2) {
                int n4 = Arrays.binarySearch(this.hashArray, TypeUtils.fnv1a_64(this.sortedFieldDeserializers[i2].fieldInfo.name));
                if (n4 < 0) continue;
                sArray[n4] = (short)i2;
            }
            this.hashArrayMapping = sArray;
        }
        if ((n3 = this.hashArrayMapping[n2]) != -1) {
            return this.sortedFieldDeserializers[n3];
        }
        return null;
    }

    static boolean isSetFlag(int n2, int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n3 = n2 / 32;
        int n4 = n2 % 32;
        return n3 < nArray.length && (nArray[n3] & 1 << n4) != 0;
    }

    public Object createInstance(DefaultJSONParser defaultJSONParser, Type type) {
        Object object;
        if (type instanceof Class && this.clazz.isInterface()) {
            Class clazz = (Class)type;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            JSONObject jSONObject = new JSONObject();
            Object object2 = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)jSONObject);
            return object2;
        }
        if (this.beanInfo.defaultConstructor == null && this.beanInfo.factoryMethod == null) {
            return null;
        }
        if (this.beanInfo.factoryMethod != null && this.beanInfo.defaultConstructorParameterSize > 0) {
            return null;
        }
        try {
            FieldInfo[] fieldInfoArray = this.beanInfo.defaultConstructor;
            if (this.beanInfo.defaultConstructorParameterSize == 0) {
                object = fieldInfoArray != null ? fieldInfoArray.newInstance(new Object[0]) : this.beanInfo.factoryMethod.invoke(null, new Object[0]);
            } else {
                ParseContext parseContext = defaultJSONParser.getContext();
                if (parseContext == null || parseContext.object == null) {
                    throw new JSONException("can't create non-static inner class instance.");
                }
                if (!(type instanceof Class)) {
                    throw new JSONException("can't create non-static inner class instance.");
                }
                String string = ((Class)type).getName();
                int n2 = string.lastIndexOf(36);
                String string2 = string.substring(0, n2);
                Object object3 = parseContext.object;
                String string3 = object3.getClass().getName();
                Object object4 = null;
                if (!string3.equals(string2)) {
                    ParseContext parseContext2 = parseContext.parent;
                    if (parseContext2 != null && parseContext2.object != null && ("java.util.ArrayList".equals(string3) || "java.util.List".equals(string3) || "java.util.Collection".equals(string3) || "java.util.Map".equals(string3) || "java.util.HashMap".equals(string3))) {
                        string3 = parseContext2.object.getClass().getName();
                        if (string3.equals(string2)) {
                            object4 = parseContext2.object;
                        }
                    } else {
                        object4 = object3;
                    }
                } else {
                    object4 = object3;
                }
                if (object4 == null || object4 instanceof Collection && ((Collection)object4).isEmpty()) {
                    throw new JSONException("can't create non-static inner class instance.");
                }
                object = fieldInfoArray.newInstance(object4);
            }
        }
        catch (JSONException jSONException) {
            throw jSONException;
        }
        catch (Exception exception) {
            throw new JSONException("create instance error, class " + this.clazz.getName(), exception);
        }
        if (defaultJSONParser != null && defaultJSONParser.lexer.isEnabled(Feature.InitStringFieldAsEmpty)) {
            for (FieldInfo fieldInfo : this.beanInfo.fields) {
                if (fieldInfo.fieldClass != String.class) continue;
                try {
                    fieldInfo.set(object, "");
                }
                catch (Exception exception) {
                    throw new JSONException("create instance error, class " + this.clazz.getName(), exception);
                }
            }
        }
        return object;
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        return this.deserialze(defaultJSONParser, type, object, 0);
    }

    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object, int n2) {
        return this.deserialze(defaultJSONParser, type, object, null, n2, null);
    }

    public <T> T deserialzeArrayMapping(DefaultJSONParser defaultJSONParser, Type type, Object object, Object object2) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() != 14) {
            throw new JSONException("error");
        }
        String string = null;
        string = jSONLexer.scanTypeName(defaultJSONParser.symbolTable);
        if (string != null) {
            ObjectDeserializer objectDeserializer = JavaBeanDeserializer.getSeeAlso(defaultJSONParser.getConfig(), this.beanInfo, string);
            Class<?> clazz = null;
            if (objectDeserializer == null) {
                Class<?> clazz2 = TypeUtils.getClass(type);
                clazz = defaultJSONParser.getConfig().checkAutoType(string, clazz2, jSONLexer.getFeatures());
                objectDeserializer = defaultJSONParser.getConfig().getDeserializer(clazz);
            }
            if (objectDeserializer instanceof JavaBeanDeserializer) {
                return objectDeserializer.deserialzeArrayMapping(defaultJSONParser, type, object, object2);
            }
        }
        object2 = this.createInstance(defaultJSONParser, type);
        int n2 = this.sortedFieldDeserializers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = i2 == n2 - 1 ? (char)']' : ',';
            FieldDeserializer fieldDeserializer = this.sortedFieldDeserializers[i2];
            Class<?> clazz = fieldDeserializer.fieldInfo.fieldClass;
            if (clazz == Integer.TYPE) {
                int n3 = jSONLexer.scanInt(c2);
                fieldDeserializer.setValue(object2, n3);
                continue;
            }
            if (clazz == String.class) {
                String string2 = jSONLexer.scanString(c2);
                fieldDeserializer.setValue(object2, string2);
                continue;
            }
            if (clazz == Long.TYPE) {
                long l2 = jSONLexer.scanLong(c2);
                fieldDeserializer.setValue(object2, l2);
                continue;
            }
            if (clazz.isEnum()) {
                Enum<?> enum_;
                char c3 = jSONLexer.getCurrent();
                if (c3 == '\"' || c3 == 'n') {
                    enum_ = jSONLexer.scanEnum(clazz, defaultJSONParser.getSymbolTable(), c2);
                } else if (c3 >= '0' && c3 <= '9') {
                    int n4 = jSONLexer.scanInt(c2);
                    EnumDeserializer enumDeserializer = (EnumDeserializer)((DefaultFieldDeserializer)fieldDeserializer).getFieldValueDeserilizer(defaultJSONParser.getConfig());
                    enum_ = enumDeserializer.valueOf(n4);
                } else {
                    enum_ = this.scanEnum(jSONLexer, c2);
                }
                fieldDeserializer.setValue(object2, enum_);
                continue;
            }
            if (clazz == Boolean.TYPE) {
                boolean bl = jSONLexer.scanBoolean(c2);
                fieldDeserializer.setValue(object2, bl);
                continue;
            }
            if (clazz == Float.TYPE) {
                float f2 = jSONLexer.scanFloat(c2);
                fieldDeserializer.setValue(object2, Float.valueOf(f2));
                continue;
            }
            if (clazz == Double.TYPE) {
                double d2 = jSONLexer.scanDouble(c2);
                fieldDeserializer.setValue(object2, d2);
                continue;
            }
            if (clazz == Date.class && jSONLexer.getCurrent() == '1') {
                long l3 = jSONLexer.scanLong(c2);
                fieldDeserializer.setValue(object2, new Date(l3));
                continue;
            }
            if (clazz == BigDecimal.class) {
                BigDecimal bigDecimal = jSONLexer.scanDecimal(c2);
                fieldDeserializer.setValue(object2, bigDecimal);
                continue;
            }
            jSONLexer.nextToken(14);
            Object t2 = defaultJSONParser.parseObject(fieldDeserializer.fieldInfo.fieldType, (Object)fieldDeserializer.fieldInfo.name);
            fieldDeserializer.setValue(object2, t2);
            if (jSONLexer.token() == 15) break;
            this.check(jSONLexer, c2 == ']' ? 15 : 16);
        }
        jSONLexer.nextToken(16);
        return (T)object2;
    }

    protected void check(JSONLexer jSONLexer, int n2) {
        if (jSONLexer.token() != n2) {
            throw new JSONException("syntax error");
        }
    }

    protected Enum<?> scanEnum(JSONLexer jSONLexer, char c2) {
        throw new JSONException("illegal enum. " + jSONLexer.info());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T deserialze(DefaultJSONParser var1_1, Type var2_2, Object var3_3, Object var4_4, int var5_5, int[] var6_6) {
        if (var2_2 == JSON.class) return (T)var1_1.parse();
        if (var2_2 == JSONObject.class) {
            return (T)var1_1.parse();
        }
        var7_7 = (JSONLexerBase)var1_1.lexer;
        var8_8 = var1_1.getConfig();
        var9_9 = var7_7.token();
        if (var9_9 == 8) {
            var7_7.nextToken(16);
            return null;
        }
        var10_10 = var1_1.getContext();
        if (var4_4 != null && var10_10 != null) {
            var10_10 = var10_10.parent;
        }
        var11_11 = null;
        try {
            block165: {
                block177: {
                    block176: {
                        block175: {
                            block166: {
                                var12_12 = null;
                                if (var9_9 == 13) {
                                    var7_7.nextToken(16);
                                    if (var4_4 == null) {
                                        var4_4 = this.createInstance(var1_1, var2_2);
                                    }
                                    var13_13 = var4_4;
                                    return (T)var13_13;
                                }
                                if (var9_9 == 14) {
                                    var13_14 = Feature.SupportArrayToBean.mask;
                                    v0 = var14_22 = (this.beanInfo.parserFeatures & var13_14) != 0 || var7_7.isEnabled(Feature.SupportArrayToBean) != false || (var5_5 & var13_14) != 0 ? 1 : 0;
                                    if (var14_22 != 0) {
                                        var15_30 = this.deserialzeArrayMapping(var1_1, var2_2, var3_3, var4_4);
                                        return var15_30;
                                    }
                                }
                                if (var9_9 != 12 && var9_9 != 16) {
                                    block130: {
                                        if (var7_7.isBlankInput()) {
                                            var13_15 = null;
                                            return var13_15;
                                        }
                                        if (var9_9 == 4) {
                                            var13_16 = var7_7.stringVal();
                                            if (var13_16.length() == 0) {
                                                var7_7.nextToken();
                                                var14_23 = null;
                                                return var14_23;
                                            }
                                            if (this.beanInfo.jsonType != null) {
                                                for (Class<?> var17_45 : this.beanInfo.jsonType.seeAlso()) {
                                                    if (!Enum.class.isAssignableFrom(var17_45)) continue;
                                                    try {
                                                        var19_60 = var18_53 = Enum.valueOf(var17_45, var13_16);
                                                        return (T)var19_60;
                                                    }
                                                    catch (IllegalArgumentException var18_52) {
                                                    }
                                                }
                                            }
                                        }
                                        if (var9_9 == 14 && var7_7.getCurrent() == ']') {
                                            var7_7.next();
                                            var7_7.nextToken();
                                            var13_17 = null;
                                            return var13_17;
                                        }
                                        if (this.beanInfo.factoryMethod != null && this.beanInfo.fields.length == 1) {
                                            block129: {
                                                try {
                                                    var13_18 = this.beanInfo.fields[0];
                                                    if (var13_18.fieldClass != Integer.class) break block129;
                                                    if (var9_9 == 2) {
                                                        var14_25 = var7_7.intValue();
                                                        var7_7.nextToken();
                                                        var15_32 = this.createFactoryInstance(var8_8, var14_25);
                                                        return (T)var15_32;
                                                    }
                                                    break block130;
                                                }
                                                catch (Exception var13_19) {
                                                    throw new JSONException(var13_19.getMessage(), var13_19);
                                                }
                                            }
                                            if (var13_18.fieldClass == String.class && var9_9 == 4) {
                                                var14_26 = var7_7.stringVal();
                                                var7_7.nextToken();
                                                var15_33 = this.createFactoryInstance(var8_8, var14_26);
                                                return (T)var15_33;
                                            }
                                        }
                                    }
                                    var13_20 = new StringBuilder().append("syntax error, expect {, actual ").append(var7_7.tokenName()).append(", pos ").append(var7_7.pos());
                                    if (var3_3 instanceof String) {
                                        var13_20.append(", fieldName ").append(var3_3);
                                    }
                                    var13_20.append(", fastjson-version ").append("1.2.70");
                                    throw new JSONException(var13_20.toString());
                                }
                                if (var1_1.resolveStatus == 2) {
                                    var1_1.resolveStatus = 0;
                                }
                                var13_21 = this.beanInfo.typeKey;
                                var14_22 = 0;
                                var15_34 = 0;
                                while (true) {
                                    block132: {
                                        block164: {
                                            block162: {
                                                block163: {
                                                    block134: {
                                                        block160: {
                                                            block161: {
                                                                block158: {
                                                                    block159: {
                                                                        block156: {
                                                                            block157: {
                                                                                block154: {
                                                                                    block155: {
                                                                                        block152: {
                                                                                            block153: {
                                                                                                block150: {
                                                                                                    block151: {
                                                                                                        block148: {
                                                                                                            block149: {
                                                                                                                block146: {
                                                                                                                    block147: {
                                                                                                                        block144: {
                                                                                                                            block145: {
                                                                                                                                block142: {
                                                                                                                                    block143: {
                                                                                                                                        block140: {
                                                                                                                                            block141: {
                                                                                                                                                block138: {
                                                                                                                                                    block139: {
                                                                                                                                                        block136: {
                                                                                                                                                            block137: {
                                                                                                                                                                block135: {
                                                                                                                                                                    var16_39 = null;
                                                                                                                                                                    var17_46 = null;
                                                                                                                                                                    var18_54 = null;
                                                                                                                                                                    var19_61 = null;
                                                                                                                                                                    var20_62 = null;
                                                                                                                                                                    var21_63 = false;
                                                                                                                                                                    if (var14_22 < this.sortedFieldDeserializers.length && var15_34 < 16) {
                                                                                                                                                                        var17_46 = this.sortedFieldDeserializers[var14_22];
                                                                                                                                                                        var18_54 = var17_46.fieldInfo;
                                                                                                                                                                        var19_61 = var18_54.fieldClass;
                                                                                                                                                                        var20_62 = var18_54.getAnnotation();
                                                                                                                                                                        if (var20_62 != null && var17_46 instanceof DefaultFieldDeserializer) {
                                                                                                                                                                            var21_63 = ((DefaultFieldDeserializer)var17_46).customDeserilizer;
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    var22_67 = false;
                                                                                                                                                                    var23_70 = false;
                                                                                                                                                                    var24_71 = null;
                                                                                                                                                                    if (var17_46 == null) break block134;
                                                                                                                                                                    var25_72 = var18_54.name_chars;
                                                                                                                                                                    if (!var21_63 || !var7_7.matchField((char[])var25_72)) break block135;
                                                                                                                                                                    var22_67 = true;
                                                                                                                                                                    break block134;
                                                                                                                                                                }
                                                                                                                                                                if (var19_61 != Integer.TYPE && var19_61 != Integer.class) break block136;
                                                                                                                                                                var26_75 = var7_7.scanFieldInt((char[])var25_72);
                                                                                                                                                                var24_71 = var26_75 == 0 && var7_7.matchStat == 5 ? null : Integer.valueOf(var26_75);
                                                                                                                                                                if (var7_7.matchStat <= 0) break block137;
                                                                                                                                                                var22_67 = true;
                                                                                                                                                                var23_70 = true;
                                                                                                                                                                break block134;
                                                                                                                                                            }
                                                                                                                                                            if (var7_7.matchStat != -2) break block134;
                                                                                                                                                            ++var15_34;
                                                                                                                                                            break block132;
                                                                                                                                                        }
                                                                                                                                                        if (var19_61 != Long.TYPE && var19_61 != Long.class) break block138;
                                                                                                                                                        var26_76 = var7_7.scanFieldLong((char[])var25_72);
                                                                                                                                                        var24_71 = var26_76 == 0L && var7_7.matchStat == 5 ? null : Long.valueOf(var26_76);
                                                                                                                                                        if (var7_7.matchStat <= 0) break block139;
                                                                                                                                                        var22_67 = true;
                                                                                                                                                        var23_70 = true;
                                                                                                                                                        break block134;
                                                                                                                                                    }
                                                                                                                                                    if (var7_7.matchStat != -2) break block134;
                                                                                                                                                    ++var15_34;
                                                                                                                                                    break block132;
                                                                                                                                                }
                                                                                                                                                if (var19_61 != String.class) break block140;
                                                                                                                                                var24_71 = var7_7.scanFieldString((char[])var25_72);
                                                                                                                                                if (var7_7.matchStat <= 0) break block141;
                                                                                                                                                var22_67 = true;
                                                                                                                                                var23_70 = true;
                                                                                                                                                break block134;
                                                                                                                                            }
                                                                                                                                            if (var7_7.matchStat != -2) break block134;
                                                                                                                                            ++var15_34;
                                                                                                                                            break block132;
                                                                                                                                        }
                                                                                                                                        if (var19_61 != Date.class || var18_54.format != null) break block142;
                                                                                                                                        var24_71 = var7_7.scanFieldDate((char[])var25_72);
                                                                                                                                        if (var7_7.matchStat <= 0) break block143;
                                                                                                                                        var22_67 = true;
                                                                                                                                        var23_70 = true;
                                                                                                                                        break block134;
                                                                                                                                    }
                                                                                                                                    if (var7_7.matchStat != -2) break block134;
                                                                                                                                    ++var15_34;
                                                                                                                                    break block132;
                                                                                                                                }
                                                                                                                                if (var19_61 != BigDecimal.class) break block144;
                                                                                                                                var24_71 = var7_7.scanFieldDecimal((char[])var25_72);
                                                                                                                                if (var7_7.matchStat <= 0) break block145;
                                                                                                                                var22_67 = true;
                                                                                                                                var23_70 = true;
                                                                                                                                break block134;
                                                                                                                            }
                                                                                                                            if (var7_7.matchStat != -2) break block134;
                                                                                                                            ++var15_34;
                                                                                                                            break block132;
                                                                                                                        }
                                                                                                                        if (var19_61 != BigInteger.class) break block146;
                                                                                                                        var24_71 = var7_7.scanFieldBigInteger((char[])var25_72);
                                                                                                                        if (var7_7.matchStat <= 0) break block147;
                                                                                                                        var22_67 = true;
                                                                                                                        var23_70 = true;
                                                                                                                        break block134;
                                                                                                                    }
                                                                                                                    if (var7_7.matchStat != -2) break block134;
                                                                                                                    ++var15_34;
                                                                                                                    break block132;
                                                                                                                }
                                                                                                                if (var19_61 != Boolean.TYPE && var19_61 != Boolean.class) break block148;
                                                                                                                var26_77 = var7_7.scanFieldBoolean((char[])var25_72);
                                                                                                                var24_71 = var7_7.matchStat == 5 ? null : Boolean.valueOf(var26_77);
                                                                                                                if (var7_7.matchStat <= 0) break block149;
                                                                                                                var22_67 = true;
                                                                                                                var23_70 = true;
                                                                                                                break block134;
                                                                                                            }
                                                                                                            if (var7_7.matchStat != -2) break block134;
                                                                                                            ++var15_34;
                                                                                                            break block132;
                                                                                                        }
                                                                                                        if (var19_61 != Float.TYPE && var19_61 != Float.class) break block150;
                                                                                                        var26_78 = var7_7.scanFieldFloat((char[])var25_72);
                                                                                                        var24_71 = var26_78 == 0.0f && var7_7.matchStat == 5 ? null : Float.valueOf(var26_78);
                                                                                                        if (var7_7.matchStat <= 0) break block151;
                                                                                                        var22_67 = true;
                                                                                                        var23_70 = true;
                                                                                                        break block134;
                                                                                                    }
                                                                                                    if (var7_7.matchStat != -2) break block134;
                                                                                                    ++var15_34;
                                                                                                    break block132;
                                                                                                }
                                                                                                if (var19_61 != Double.TYPE && var19_61 != Double.class) break block152;
                                                                                                var26_79 = var7_7.scanFieldDouble((char[])var25_72);
                                                                                                var24_71 = var26_79 == 0.0 && var7_7.matchStat == 5 ? null : Double.valueOf(var26_79);
                                                                                                if (var7_7.matchStat <= 0) break block153;
                                                                                                var22_67 = true;
                                                                                                var23_70 = true;
                                                                                                break block134;
                                                                                            }
                                                                                            if (var7_7.matchStat != -2) break block134;
                                                                                            ++var15_34;
                                                                                            break block132;
                                                                                        }
                                                                                        if (!var19_61.isEnum() || !(var1_1.getConfig().getDeserializer((Type)var19_61) instanceof EnumDeserializer) || var20_62 != null && var20_62.deserializeUsing() != Void.class) break block154;
                                                                                        if (!(var17_46 instanceof DefaultFieldDeserializer)) break block134;
                                                                                        var26_80 = ((DefaultFieldDeserializer)var17_46).fieldValueDeserilizer;
                                                                                        var24_71 = this.scanEnum(var7_7, (char[])var25_72, var26_80);
                                                                                        if (var7_7.matchStat <= 0) break block155;
                                                                                        var22_67 = true;
                                                                                        var23_70 = true;
                                                                                        break block134;
                                                                                    }
                                                                                    if (var7_7.matchStat != -2) break block134;
                                                                                    ++var15_34;
                                                                                    break block132;
                                                                                }
                                                                                if (var19_61 != int[].class) break block156;
                                                                                var24_71 = var7_7.scanFieldIntArray((char[])var25_72);
                                                                                if (var7_7.matchStat <= 0) break block157;
                                                                                var22_67 = true;
                                                                                var23_70 = true;
                                                                                break block134;
                                                                            }
                                                                            if (var7_7.matchStat != -2) break block134;
                                                                            ++var15_34;
                                                                            break block132;
                                                                        }
                                                                        if (var19_61 != float[].class) break block158;
                                                                        var24_71 = var7_7.scanFieldFloatArray((char[])var25_72);
                                                                        if (var7_7.matchStat <= 0) break block159;
                                                                        var22_67 = true;
                                                                        var23_70 = true;
                                                                        break block134;
                                                                    }
                                                                    if (var7_7.matchStat != -2) break block134;
                                                                    ++var15_34;
                                                                    break block132;
                                                                }
                                                                if (var19_61 != float[][].class) break block160;
                                                                var24_71 = var7_7.scanFieldFloatArray2((char[])var25_72);
                                                                if (var7_7.matchStat <= 0) break block161;
                                                                var22_67 = true;
                                                                var23_70 = true;
                                                                break block134;
                                                            }
                                                            if (var7_7.matchStat != -2) break block134;
                                                            ++var15_34;
                                                            break block132;
                                                        }
                                                        if (!var7_7.matchField((char[])var25_72)) break block132;
                                                        var22_67 = true;
                                                    }
                                                    if (var22_67) break block162;
                                                    var16_39 = var7_7.scanSymbol(var1_1.symbolTable);
                                                    if (var16_39 != null) break block163;
                                                    var9_9 = var7_7.token();
                                                    if (var9_9 == 13) {
                                                        var7_7.nextToken(16);
                                                        break;
                                                    }
                                                    if (var9_9 == 16 && var7_7.isEnabled(Feature.AllowArbitraryCommas)) break block132;
                                                }
                                                if ("$ref" == var16_39 && var10_10 != null) {
                                                    var7_7.nextTokenWithColon(4);
                                                    var9_9 = var7_7.token();
                                                    if (var9_9 != 4) throw new JSONException("illegal ref, " + JSONToken.name(var9_9));
                                                    var25_72 = var7_7.stringVal();
                                                    if ("@".equals(var25_72)) {
                                                        var4_4 = var10_10.object;
                                                    } else if ("..".equals(var25_72)) {
                                                        var26_81 = var10_10.parent;
                                                        if (var26_81.object != null) {
                                                            var4_4 = var26_81.object;
                                                        } else {
                                                            var1_1.addResolveTask(new DefaultJSONParser.ResolveTask(var26_81, (String)var25_72));
                                                            var1_1.resolveStatus = 1;
                                                        }
                                                    } else if ("$".equals(var25_72)) {
                                                        var26_82 = var10_10;
                                                        while (var26_82.parent != null) {
                                                            var26_82 = var26_82.parent;
                                                        }
                                                        if (var26_82.object != null) {
                                                            var4_4 = var26_82.object;
                                                        } else {
                                                            var1_1.addResolveTask(new DefaultJSONParser.ResolveTask(var26_82, (String)var25_72));
                                                            var1_1.resolveStatus = 1;
                                                        }
                                                    } else {
                                                        if (var25_72.indexOf(92) > 0) {
                                                            var26_83 = new StringBuilder();
                                                            for (var27_87 = 0; var27_87 < var25_72.length(); ++var27_87) {
                                                                var28_89 = var25_72.charAt(var27_87);
                                                                if (var28_89 == '\\') {
                                                                    var28_89 = var25_72.charAt(++var27_87);
                                                                }
                                                                var26_83.append(var28_89);
                                                            }
                                                            var25_72 = var26_83.toString();
                                                        }
                                                        if ((var26_84 = var1_1.resolveReference((String)var25_72)) != null) {
                                                            var4_4 = var26_84;
                                                        } else {
                                                            var1_1.addResolveTask(new DefaultJSONParser.ResolveTask(var10_10, (String)var25_72));
                                                            var1_1.resolveStatus = 1;
                                                        }
                                                    }
                                                    var7_7.nextToken(13);
                                                    if (var7_7.token() != 13) {
                                                        throw new JSONException("illegal ref");
                                                    }
                                                    var7_7.nextToken(16);
                                                    var1_1.setContext(var10_10, var4_4, var3_3);
                                                    var25_72 = var4_4;
                                                    return (T)var25_72;
                                                }
                                                if (var13_21 != null && var13_21.equals(var16_39) || JSON.DEFAULT_TYPE_KEY == var16_39) {
                                                    var7_7.nextTokenWithColon(4);
                                                    if (var7_7.token() != 4) throw new JSONException("syntax error");
                                                    var25_72 = var7_7.stringVal();
                                                    var7_7.nextToken(16);
                                                    if (var25_72.equals(this.beanInfo.typeName) || var1_1.isEnabled(Feature.IgnoreAutoType)) {
                                                        if (var7_7.token() == 13) {
                                                            var7_7.nextToken();
                                                            break;
                                                        }
                                                        break block132;
                                                    } else {
                                                        var26_85 /* !! */  = JavaBeanDeserializer.getSeeAlso(var8_8, this.beanInfo, (String)var25_72);
                                                        var27_88 = null;
                                                        if (var26_85 /* !! */  == null) {
                                                            var28_90 /* !! */  = TypeUtils.getClass(var2_2);
                                                            var27_88 = var8_8.checkAutoType((String)var25_72, var28_90 /* !! */ , var7_7.getFeatures());
                                                            var26_85 /* !! */  = var1_1.getConfig().getDeserializer(var27_88);
                                                        }
                                                        var28_90 /* !! */  = var26_85 /* !! */ .deserialze(var1_1, var27_88, var3_3);
                                                        if (var26_85 /* !! */  instanceof JavaBeanDeserializer) {
                                                            var29_91 = var26_85 /* !! */ ;
                                                            if (var13_21 != null && (var30_92 = var29_91.getFieldDeserializer(var13_21)) != null) {
                                                                var30_92.setValue(var28_90 /* !! */ , (String)var25_72);
                                                            }
                                                        }
                                                        var29_91 = var28_90 /* !! */ ;
                                                        return (T)var29_91;
                                                    }
                                                }
                                            }
                                            if (var4_4 == null && var12_12 == null) {
                                                var4_4 = this.createInstance(var1_1, var2_2);
                                                if (var4_4 == null) {
                                                    var12_12 = new HashMap<String, Integer>(this.fieldDeserializers.length);
                                                }
                                                var11_11 = var1_1.setContext(var10_10, var4_4, var3_3);
                                                if (var6_6 == null) {
                                                    var6_6 = new int[this.fieldDeserializers.length / 32 + 1];
                                                }
                                            }
                                            if (!var22_67) break block164;
                                            if (!var23_70) {
                                                var17_46.parseField(var1_1, var4_4, var2_2, var12_12);
                                            } else {
                                                if (var4_4 == null) {
                                                    var12_12.put(var18_54.name, (Integer)var24_71);
                                                } else if (var24_71 == null) {
                                                    if (var19_61 != Integer.TYPE && var19_61 != Long.TYPE && var19_61 != Float.TYPE && var19_61 != Double.TYPE && var19_61 != Boolean.TYPE) {
                                                        var17_46.setValue(var4_4, var24_71);
                                                    }
                                                } else {
                                                    var17_46.setValue(var4_4, var24_71);
                                                }
                                                if (var6_6 != null) {
                                                    var25_73 = var14_22 / 32;
                                                    var26_86 = var14_22 % 32;
                                                    v1 = var25_73;
                                                    var6_6[v1] = var6_6[v1] | 1 << var26_86;
                                                }
                                                if (var7_7.matchStat == 4) {
                                                    break;
                                                }
                                            }
                                            ** GOTO lbl381
                                        }
                                        var25_74 = this.parseField(var1_1, (String)var16_39, var4_4, var2_2, (Map<String, Object>)(var12_12 == null ? new HashMap<K, V>(this.fieldDeserializers.length) : var12_12), var6_6);
                                        if (!var25_74) {
                                            if (var7_7.token() == 13) {
                                                var7_7.nextToken();
                                                break;
                                            }
                                        } else {
                                            if (var7_7.token() == 17) {
                                                throw new JSONException("syntax error, unexpect token ':'");
                                            }
lbl381:
                                            // 4 sources

                                            if (var7_7.token() != 16) {
                                                if (var7_7.token() == 13) {
                                                    var7_7.nextToken(16);
                                                    break;
                                                }
                                                if (var7_7.token() == 18) throw new JSONException("syntax error, unexpect token " + JSONToken.name(var7_7.token()));
                                                if (var7_7.token() == 1) {
                                                    throw new JSONException("syntax error, unexpect token " + JSONToken.name(var7_7.token()));
                                                }
                                            }
                                        }
                                    }
                                    ++var14_22;
                                }
                                if (var4_4 != null) break block165;
                                if (var12_12 == null) {
                                    var4_4 = this.createInstance(var1_1, var2_2);
                                    if (var11_11 == null) {
                                        var11_11 = var1_1.setContext(var10_10, var4_4, var3_3);
                                    }
                                    var14_27 = var4_4;
                                    return (T)var14_27;
                                }
                                var14_28 = this.beanInfo.creatorConstructorParameters;
                                if (var14_28 == null) break block166;
                                var15_35 = new Object[var14_28.length];
                                for (var16_40 = 0; var16_40 < var14_28.length; ++var16_40) {
                                    block169: {
                                        block167: {
                                            block174: {
                                                block173: {
                                                    block172: {
                                                        block171: {
                                                            block170: {
                                                                block168: {
                                                                    var17_46 = var14_28[var16_40];
                                                                    var18_54 = var12_12.remove(var17_46);
                                                                    if (var18_54 != null) break block167;
                                                                    var19_61 = this.beanInfo.creatorConstructorParameterTypes[var16_40];
                                                                    var20_62 = this.beanInfo.fields[var16_40];
                                                                    if (var19_61 != Byte.TYPE) break block168;
                                                                    var18_54 = (byte)0;
                                                                    break block169;
                                                                }
                                                                if (var19_61 != Short.TYPE) break block170;
                                                                var18_54 = (short)0;
                                                                break block169;
                                                            }
                                                            if (var19_61 != Integer.TYPE) break block171;
                                                            var18_54 = 0;
                                                            break block169;
                                                        }
                                                        if (var19_61 != Long.TYPE) break block172;
                                                        var18_54 = 0L;
                                                        break block169;
                                                    }
                                                    if (var19_61 != Float.TYPE) break block173;
                                                    var18_54 = Float.valueOf(0.0f);
                                                    break block169;
                                                }
                                                if (var19_61 != Double.TYPE) break block174;
                                                var18_54 = 0.0;
                                                break block169;
                                            }
                                            if (var19_61 == Boolean.TYPE) {
                                                var18_54 = Boolean.FALSE;
                                                break block169;
                                            } else if (var19_61 == String.class && (var20_62.parserFeatures & Feature.InitStringFieldAsEmpty.mask) != 0) {
                                                var18_54 = "";
                                            }
                                            break block169;
                                        }
                                        if (this.beanInfo.creatorConstructorParameterTypes != null && var16_40 < this.beanInfo.creatorConstructorParameterTypes.length && (var19_61 = this.beanInfo.creatorConstructorParameterTypes[var16_40]) instanceof Class && !(var20_62 = (Class)var19_61).isInstance(var18_54) && var18_54 instanceof List && (var21_65 = (List)var18_54).size() == 1 && var20_62.isInstance(var22_69 = var21_65.get(0))) {
                                            var18_54 = var21_65.get(0);
                                        }
                                    }
                                    var15_35[var16_40] = var18_54;
                                }
                                break block175;
                            }
                            var16_39 = this.beanInfo.fields;
                            var17_47 = var16_39.length;
                            var15_35 = new Object[var17_47];
                            for (var18_55 = 0; var18_55 < var17_47; ++var18_55) {
                                var19_61 = var16_39[var18_55];
                                var20_62 = var12_12.get(var19_61.name);
                                if (var20_62 == null) {
                                    var21_66 = var19_61.fieldType;
                                    if (var21_66 == Byte.TYPE) {
                                        var20_62 = (byte)0;
                                    } else if (var21_66 == Short.TYPE) {
                                        var20_62 = (short)0;
                                    } else if (var21_66 == Integer.TYPE) {
                                        var20_62 = 0;
                                    } else if (var21_66 == Long.TYPE) {
                                        var20_62 = 0L;
                                    } else if (var21_66 == Float.TYPE) {
                                        var20_62 = Float.valueOf(0.0f);
                                    } else if (var21_66 == Double.TYPE) {
                                        var20_62 = 0.0;
                                    } else if (var21_66 == Boolean.TYPE) {
                                        var20_62 = Boolean.FALSE;
                                    } else if (var21_66 == String.class && (var19_61.parserFeatures & Feature.InitStringFieldAsEmpty.mask) != 0) {
                                        var20_62 = "";
                                    }
                                }
                                var15_35[var18_55] = var20_62;
                            }
                        }
                        if (this.beanInfo.creatorConstructor == null) break block176;
                        var16_41 = false;
                        if (this.beanInfo.kotlin) {
                            for (var17_48 = 0; var17_48 < var15_35.length; ++var17_48) {
                                if (var15_35[var17_48] != null || this.beanInfo.fields == null || var17_48 >= this.beanInfo.fields.length) continue;
                                var18_57 = this.beanInfo.fields[var17_48];
                                if (var18_57.fieldClass != String.class) break;
                                var16_41 = true;
                                break;
                            }
                        }
                        try {
                            if (var16_41 && this.beanInfo.kotlinDefaultConstructor != null) {
                                var4_4 = this.beanInfo.kotlinDefaultConstructor.newInstance(new Object[0]);
                                for (var17_49 = 0; var17_49 < var15_35.length; ++var17_49) {
                                    var18_58 = var15_35[var17_49];
                                    if (var18_58 == null || this.beanInfo.fields == null || var17_49 >= this.beanInfo.fields.length) continue;
                                    var19_61 = this.beanInfo.fields[var17_49];
                                    var19_61.set(var4_4, var18_58);
                                }
                            } else {
                                var4_4 = this.beanInfo.creatorConstructor.newInstance(var15_35);
                            }
                        }
                        catch (Exception var17_50) {
                            throw new JSONException("create instance error, " + var14_28 + ", " + this.beanInfo.creatorConstructor.toGenericString(), var17_50);
                        }
                        if (var14_28 != null) {
                            for (Map.Entry<K, V> var18_59 : var12_12.entrySet()) {
                                var19_61 = this.getFieldDeserializer((String)var18_59.getKey());
                                if (var19_61 == null) continue;
                                var19_61.setValue(var4_4, var18_59.getValue());
                            }
                        }
                        break block177;
                    }
                    if (this.beanInfo.factoryMethod != null) {
                        try {
                            var4_4 = this.beanInfo.factoryMethod.invoke(null, var15_35);
                        }
                        catch (Exception var16_42) {
                            throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), var16_42);
                        }
                    }
                }
                if (var11_11 != null) {
                    var11_11.object = var4_4;
                }
            }
            if ((var14_29 = this.beanInfo.buildMethod) == null) {
                var15_36 = var4_4;
                return (T)var15_36;
            }
            try {
                var15_37 = var14_29.invoke(var4_4, new Object[0]);
            }
            catch (Exception var16_43) {
                throw new JSONException("build object error", var16_43);
            }
            var16_44 = var15_37;
            return (T)var16_44;
        }
        finally {
            if (var11_11 != null) {
                var11_11.object = var4_4;
            }
            var1_1.setContext(var10_10);
        }
    }

    protected Enum scanEnum(JSONLexerBase jSONLexerBase, char[] cArray, ObjectDeserializer objectDeserializer) {
        EnumDeserializer enumDeserializer = null;
        if (objectDeserializer instanceof EnumDeserializer) {
            enumDeserializer = (EnumDeserializer)objectDeserializer;
        }
        if (enumDeserializer == null) {
            jSONLexerBase.matchStat = -1;
            return null;
        }
        long l2 = jSONLexerBase.scanEnumSymbol(cArray);
        if (jSONLexerBase.matchStat > 0) {
            Enum enum_ = enumDeserializer.getEnumByHashCode(l2);
            if (enum_ == null) {
                if (l2 == -3750763034362895579L) {
                    return null;
                }
                if (jSONLexerBase.isEnabled(Feature.ErrorOnEnumNotMatch)) {
                    throw new JSONException("not match enum value, " + enumDeserializer.enumClass);
                }
            }
            return enum_;
        }
        return null;
    }

    public boolean parseField(DefaultJSONParser defaultJSONParser, String string, Object object, Type type, Map<String, Object> map) {
        return this.parseField(defaultJSONParser, string, object, type, map, null);
    }

    public boolean parseField(DefaultJSONParser defaultJSONParser, String string, Object object, Type type, Map<String, Object> map, int[] nArray) {
        int n2;
        Object object2;
        Object object3;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n3 = Feature.DisableFieldSmartMatch.mask;
        int n4 = Feature.InitStringFieldAsEmpty.mask;
        FieldDeserializer fieldDeserializer = jSONLexer.isEnabled(n3) || (this.beanInfo.parserFeatures & n3) != 0 ? this.getFieldDeserializer(string) : (jSONLexer.isEnabled(n4) || (this.beanInfo.parserFeatures & n4) != 0 ? this.smartMatch(string) : this.smartMatch(string, nArray));
        int n5 = Feature.SupportNonPublicField.mask;
        if (fieldDeserializer == null && (jSONLexer.isEnabled(n5) || (this.beanInfo.parserFeatures & n5) != 0)) {
            AnnotatedElement annotatedElement;
            Object object4;
            if (this.extraFieldDeserializers == null) {
                object4 = new ConcurrentHashMap(1, 0.75f, 1);
                for (annotatedElement = this.clazz; annotatedElement != null && annotatedElement != Object.class; annotatedElement = ((Class)annotatedElement).getSuperclass()) {
                    object3 = ((Class)annotatedElement).getDeclaredFields();
                    for (Object object5 : object3) {
                        String string2;
                        int n6;
                        object2 = ((Field)object5).getName();
                        if (this.getFieldDeserializer((String)object2) != null || ((n6 = ((Field)object5).getModifiers()) & 0x10) != 0 || (n6 & 8) != 0) continue;
                        JSONField jSONField = TypeUtils.getAnnotation((Field)object5, JSONField.class);
                        if (jSONField != null && !"".equals(string2 = jSONField.name())) {
                            object2 = string2;
                        }
                        ((ConcurrentHashMap)object4).put(object2, (Object)object5);
                    }
                }
                this.extraFieldDeserializers = object4;
            }
            if ((object4 = this.extraFieldDeserializers.get(string)) != null) {
                if (object4 instanceof FieldDeserializer) {
                    fieldDeserializer = (FieldDeserializer)object4;
                } else {
                    annotatedElement = (Field)object4;
                    ((Field)annotatedElement).setAccessible(true);
                    object3 = new FieldInfo(string, ((Field)annotatedElement).getDeclaringClass(), ((Field)annotatedElement).getType(), ((Field)annotatedElement).getGenericType(), (Field)annotatedElement, 0, 0, 0);
                    fieldDeserializer = new DefaultFieldDeserializer(defaultJSONParser.getConfig(), this.clazz, (FieldInfo)object3);
                    this.extraFieldDeserializers.put(string, fieldDeserializer);
                }
            }
        }
        if (fieldDeserializer == null) {
            int n7;
            if (!jSONLexer.isEnabled(Feature.IgnoreNotMatch)) {
                throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + string);
            }
            int n8 = -1;
            for (n7 = 0; n7 < this.sortedFieldDeserializers.length; ++n7) {
                Object object6;
                object3 = this.sortedFieldDeserializers[n7];
                Field[] fieldArray = ((FieldDeserializer)object3).fieldInfo;
                if (!fieldArray.unwrapped || !(object3 instanceof DefaultFieldDeserializer)) continue;
                if (fieldArray.field != null) {
                    Object object7;
                    Object object5;
                    object6 = (DefaultFieldDeserializer)object3;
                    ObjectDeserializer objectDeserializer = ((DefaultFieldDeserializer)object6).getFieldValueDeserilizer(defaultJSONParser.getConfig());
                    if (objectDeserializer instanceof JavaBeanDeserializer) {
                        object5 = (JavaBeanDeserializer)objectDeserializer;
                        object2 = ((JavaBeanDeserializer)object5).getFieldDeserializer(string);
                        if (object2 == null) continue;
                        try {
                            object7 = fieldArray.field.get(object);
                            if (object7 == null) {
                                object7 = ((JavaBeanDeserializer)objectDeserializer).createInstance(defaultJSONParser, fieldArray.fieldType);
                                ((FieldDeserializer)object3).setValue(object, object7);
                            }
                            jSONLexer.nextTokenWithColon(((DefaultFieldDeserializer)object6).getFastMatchToken());
                            ((FieldDeserializer)object2).parseField(defaultJSONParser, object7, type, map);
                            n8 = n7;
                            continue;
                        }
                        catch (Exception exception) {
                            throw new JSONException("parse unwrapped field error.", exception);
                        }
                    }
                    if (!(objectDeserializer instanceof MapDeserializer)) continue;
                    object5 = (MapDeserializer)objectDeserializer;
                    try {
                        object2 = (Map)fieldArray.field.get(object);
                        if (object2 == null) {
                            object2 = ((MapDeserializer)object5).createMap(fieldArray.fieldType);
                            ((FieldDeserializer)object3).setValue(object, object2);
                        }
                        jSONLexer.nextTokenWithColon();
                        object7 = defaultJSONParser.parse(string);
                        object2.put((Object)string, (Object)object7);
                    }
                    catch (Exception exception) {
                        throw new JSONException("parse unwrapped field error.", exception);
                    }
                    n8 = n7;
                    continue;
                }
                if (fieldArray.method.getParameterTypes().length != 2) continue;
                jSONLexer.nextTokenWithColon();
                object6 = defaultJSONParser.parse(string);
                try {
                    fieldArray.method.invoke(object, string, object6);
                }
                catch (Exception exception) {
                    throw new JSONException("parse unwrapped field error.", exception);
                }
                n8 = n7;
            }
            if (n8 != -1) {
                if (nArray != null) {
                    n7 = n8 / 32;
                    int n9 = n8 % 32;
                    int n10 = n7;
                    nArray[n10] = nArray[n10] | 1 << n9;
                }
                return true;
            }
            defaultJSONParser.parseExtra(object, string);
            return false;
        }
        int n11 = -1;
        for (n2 = 0; n2 < this.sortedFieldDeserializers.length; ++n2) {
            if (this.sortedFieldDeserializers[n2] != fieldDeserializer) continue;
            n11 = n2;
            break;
        }
        if (n11 != -1 && nArray != null && string.startsWith("_") && JavaBeanDeserializer.isSetFlag(n11, nArray)) {
            defaultJSONParser.parseExtra(object, string);
            return false;
        }
        jSONLexer.nextTokenWithColon(fieldDeserializer.getFastMatchToken());
        fieldDeserializer.parseField(defaultJSONParser, object, type, map);
        if (nArray != null) {
            n2 = n11 / 32;
            int n12 = n11 % 32;
            int n13 = n2;
            nArray[n13] = nArray[n13] | 1 << n12;
        }
        return true;
    }

    public FieldDeserializer smartMatch(String string) {
        return this.smartMatch(string, null);
    }

    public FieldDeserializer smartMatch(String string, int[] nArray) {
        if (string == null) {
            return null;
        }
        FieldDeserializer fieldDeserializer = this.getFieldDeserializer(string, nArray);
        if (fieldDeserializer == null) {
            int n2;
            long l2 = TypeUtils.fnv1a_64_lower(string);
            if (this.smartMatchHashArray == null) {
                long[] lArray = new long[this.sortedFieldDeserializers.length];
                for (n2 = 0; n2 < this.sortedFieldDeserializers.length; ++n2) {
                    lArray[n2] = TypeUtils.fnv1a_64_lower(this.sortedFieldDeserializers[n2].fieldInfo.name);
                }
                Arrays.sort(lArray);
                this.smartMatchHashArray = lArray;
            }
            int n3 = Arrays.binarySearch(this.smartMatchHashArray, l2);
            n2 = 0;
            if (n3 < 0) {
                boolean bl = string.startsWith("is");
                n2 = bl ? 1 : 0;
                if (bl) {
                    l2 = TypeUtils.fnv1a_64_lower(string.substring(2));
                    n3 = Arrays.binarySearch(this.smartMatchHashArray, l2);
                }
            }
            if (n3 >= 0) {
                short s2;
                if (this.smartMatchHashArrayMapping == null) {
                    short[] sArray = new short[this.smartMatchHashArray.length];
                    Arrays.fill(sArray, (short)-1);
                    for (int i2 = 0; i2 < this.sortedFieldDeserializers.length; ++i2) {
                        int n4 = Arrays.binarySearch(this.smartMatchHashArray, TypeUtils.fnv1a_64_lower(this.sortedFieldDeserializers[i2].fieldInfo.name));
                        if (n4 < 0) continue;
                        sArray[n4] = (short)i2;
                    }
                    this.smartMatchHashArrayMapping = sArray;
                }
                if ((s2 = this.smartMatchHashArrayMapping[n3]) != -1 && !JavaBeanDeserializer.isSetFlag(s2, nArray)) {
                    fieldDeserializer = this.sortedFieldDeserializers[s2];
                }
            }
            if (fieldDeserializer != null) {
                FieldInfo fieldInfo = fieldDeserializer.fieldInfo;
                if ((fieldInfo.parserFeatures & Feature.DisableFieldSmartMatch.mask) != 0) {
                    return null;
                }
                Class<?> clazz = fieldInfo.fieldClass;
                if (n2 != 0 && clazz != Boolean.TYPE && clazz != Boolean.class) {
                    fieldDeserializer = null;
                }
            }
        }
        return fieldDeserializer;
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    private Object createFactoryInstance(ParserConfig parserConfig, Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.beanInfo.factoryMethod.invoke(null, object);
    }

    /*
     * WARNING - void declaration
     */
    public Object createInstance(Map<String, Object> map, ParserConfig parserConfig) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz;
        Object object;
        Object object2 = null;
        if (this.beanInfo.creatorConstructor == null && this.beanInfo.factoryMethod == null) {
            object2 = this.createInstance(null, this.clazz);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Class<?> clazz2;
                String string = entry.getKey();
                Comparable<Date> comparable = entry.getValue();
                FieldDeserializer fieldDeserializer = this.smartMatch(string);
                if (fieldDeserializer == null) continue;
                FieldInfo fieldInfo = fieldDeserializer.fieldInfo;
                Field field = fieldDeserializer.fieldInfo.field;
                Type type = fieldInfo.fieldType;
                if (fieldInfo.declaringClass != null && fieldInfo.getAnnotation() != null && fieldInfo.getAnnotation().deserializeUsing() != Void.class && fieldInfo.fieldClass.isInstance(comparable)) {
                    clazz2 = new DefaultJSONParser(JSON.toJSONString(comparable));
                    fieldDeserializer.parseField((DefaultJSONParser)((Object)clazz2), object2, type, null);
                    continue;
                }
                if (field != null && fieldInfo.method == null) {
                    String string2;
                    clazz2 = field.getType();
                    if (clazz2 == Boolean.TYPE) {
                        if (comparable == Boolean.FALSE) {
                            field.setBoolean(object2, false);
                            continue;
                        }
                        if (comparable == Boolean.TRUE) {
                            field.setBoolean(object2, true);
                            continue;
                        }
                    } else if (clazz2 == Integer.TYPE) {
                        if (comparable instanceof Number) {
                            field.setInt(object2, ((Number)((Object)comparable)).intValue());
                            continue;
                        }
                    } else if (clazz2 == Long.TYPE) {
                        if (comparable instanceof Number) {
                            field.setLong(object2, ((Number)((Object)comparable)).longValue());
                            continue;
                        }
                    } else if (clazz2 == Float.TYPE) {
                        if (comparable instanceof Number) {
                            field.setFloat(object2, ((Number)((Object)comparable)).floatValue());
                            continue;
                        }
                        if (comparable instanceof String) {
                            string2 = (String)((Object)comparable);
                            float f2 = string2.length() <= 10 ? TypeUtils.parseFloat(string2) : Float.parseFloat(string2);
                            field.setFloat(object2, f2);
                            continue;
                        }
                    } else if (clazz2 == Double.TYPE) {
                        if (comparable instanceof Number) {
                            field.setDouble(object2, ((Number)((Object)comparable)).doubleValue());
                            continue;
                        }
                        if (comparable instanceof String) {
                            string2 = (String)((Object)comparable);
                            double d2 = string2.length() <= 10 ? TypeUtils.parseDouble(string2) : Double.parseDouble(string2);
                            field.setDouble(object2, d2);
                            continue;
                        }
                    } else if (comparable != null && type == comparable.getClass()) {
                        field.set(object2, comparable);
                        continue;
                    }
                }
                comparable = (clazz2 = fieldInfo.format) != null && type == Date.class ? TypeUtils.castToDate(comparable, (String)((Object)clazz2)) : (clazz2 != null && type instanceof Class && ((Class)type).getName().equals("java.time.LocalDateTime") ? TypeUtils.castToLocalDateTime(comparable, (String)((Object)clazz2)) : (type instanceof ParameterizedType ? TypeUtils.cast((Object)comparable, (ParameterizedType)type, parserConfig) : TypeUtils.cast((Object)comparable, type, parserConfig)));
                fieldDeserializer.setValue(object2, comparable);
            }
            if (this.beanInfo.buildMethod != null) {
                Object object3;
                try {
                    object3 = this.beanInfo.buildMethod.invoke(object2, new Object[0]);
                }
                catch (Exception exception) {
                    throw new JSONException("build object error", exception);
                }
                return object3;
            }
            return object2;
        }
        FieldInfo[] fieldInfoArray = this.beanInfo.fields;
        int n2 = fieldInfoArray.length;
        Object[] objectArray = new Object[n2];
        HashMap<String, Integer> hashMap = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            FieldInfo object4 = fieldInfoArray[i2];
            object = map.get(object4.name);
            if (object == null) {
                clazz = object4.fieldClass;
                if (clazz == Integer.TYPE) {
                    object = 0;
                } else if (clazz == Long.TYPE) {
                    object = 0L;
                } else if (clazz == Short.TYPE) {
                    object = (short)0;
                } else if (clazz == Byte.TYPE) {
                    object = (byte)0;
                } else if (clazz == Float.TYPE) {
                    object = Float.valueOf(0.0f);
                } else if (clazz == Double.TYPE) {
                    object = 0.0;
                } else if (clazz == Character.TYPE) {
                    object = Character.valueOf('0');
                } else if (clazz == Boolean.TYPE) {
                    object = false;
                }
                if (hashMap == null) {
                    hashMap = new HashMap<String, Integer>();
                }
                hashMap.put(object4.name, i2);
            }
            objectArray[i2] = object;
        }
        if (hashMap != null) {
            for (Map.Entry<String, Object> i4 : map.entrySet()) {
                Integer n3;
                object = i4.getKey();
                clazz = i4.getValue();
                FieldDeserializer fieldDeserializer = this.smartMatch((String)object);
                if (fieldDeserializer == null || (n3 = (Integer)hashMap.get(fieldDeserializer.fieldInfo.name)) == null) continue;
                objectArray[n3.intValue()] = clazz;
            }
        }
        if (this.beanInfo.creatorConstructor != null) {
            boolean bl = false;
            if (this.beanInfo.kotlin) {
                boolean exception = false;
                while (exception < objectArray.length) {
                    if (objectArray[exception] == null && this.beanInfo.fields != null && exception < this.beanInfo.fields.length) {
                        object = this.beanInfo.fields[exception];
                        if (((FieldInfo)object).fieldClass != String.class) break;
                        bl = true;
                        break;
                    }
                    ++exception;
                }
            }
            if (bl && this.beanInfo.kotlinDefaultConstructor != null) {
                try {
                    void var9_25;
                    object2 = this.beanInfo.kotlinDefaultConstructor.newInstance(new Object[0]);
                    boolean bl2 = false;
                    while (var9_25 < objectArray.length) {
                        object = objectArray[var9_25];
                        if (object != null && this.beanInfo.fields != null && var9_25 < this.beanInfo.fields.length) {
                            clazz = this.beanInfo.fields[var9_25];
                            ((FieldInfo)((Object)clazz)).set(object2, object);
                        }
                        ++var9_25;
                    }
                }
                catch (Exception exception) {
                    throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), exception);
                }
            } else {
                try {
                    object2 = this.beanInfo.creatorConstructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), exception);
                }
            }
        } else if (this.beanInfo.factoryMethod != null) {
            try {
                object2 = this.beanInfo.factoryMethod.invoke(null, objectArray);
            }
            catch (Exception exception) {
                throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), exception);
            }
        }
        return object2;
    }

    public Type getFieldType(int n2) {
        return this.sortedFieldDeserializers[n2].fieldInfo.fieldType;
    }

    protected Object parseRest(DefaultJSONParser defaultJSONParser, Type type, Object object, Object object2, int n2) {
        return this.parseRest(defaultJSONParser, type, object, object2, n2, new int[0]);
    }

    protected Object parseRest(DefaultJSONParser defaultJSONParser, Type type, Object object, Object object2, int n2, int[] nArray) {
        Object t2 = this.deserialze(defaultJSONParser, type, object, object2, n2, nArray);
        return t2;
    }

    protected static JavaBeanDeserializer getSeeAlso(ParserConfig parserConfig, JavaBeanInfo javaBeanInfo, String string) {
        if (javaBeanInfo.jsonType == null) {
            return null;
        }
        for (Class<?> clazz : javaBeanInfo.jsonType.seeAlso()) {
            ObjectDeserializer objectDeserializer = parserConfig.getDeserializer(clazz);
            if (!(objectDeserializer instanceof JavaBeanDeserializer)) continue;
            JavaBeanDeserializer javaBeanDeserializer = (JavaBeanDeserializer)objectDeserializer;
            JavaBeanInfo javaBeanInfo2 = javaBeanDeserializer.beanInfo;
            if (javaBeanInfo2.typeName.equals(string)) {
                return javaBeanDeserializer;
            }
            JavaBeanDeserializer javaBeanDeserializer2 = JavaBeanDeserializer.getSeeAlso(parserConfig, javaBeanInfo2, string);
            if (javaBeanDeserializer2 == null) continue;
            return javaBeanDeserializer2;
        }
        return null;
    }

    protected static void parseArray(Collection collection, ObjectDeserializer objectDeserializer, DefaultJSONParser defaultJSONParser, Type type, Object object) {
        char c2;
        JSONLexerBase jSONLexerBase = (JSONLexerBase)defaultJSONParser.lexer;
        int n2 = jSONLexerBase.token();
        if (n2 == 8) {
            jSONLexerBase.nextToken(16);
            n2 = jSONLexerBase.token();
            return;
        }
        if (n2 != 14) {
            defaultJSONParser.throwException(n2);
        }
        if ((c2 = jSONLexerBase.getCurrent()) == '[') {
            jSONLexerBase.next();
            jSONLexerBase.setToken(14);
        } else {
            jSONLexerBase.nextToken(14);
        }
        if (jSONLexerBase.token() == 15) {
            jSONLexerBase.nextToken();
            return;
        }
        int n3 = 0;
        while (true) {
            Object t2 = objectDeserializer.deserialze(defaultJSONParser, type, n3);
            collection.add(t2);
            ++n3;
            if (jSONLexerBase.token() != 16) break;
            c2 = jSONLexerBase.getCurrent();
            if (c2 == '[') {
                jSONLexerBase.next();
                jSONLexerBase.setToken(14);
                continue;
            }
            jSONLexerBase.nextToken(14);
        }
        n2 = jSONLexerBase.token();
        if (n2 != 15) {
            defaultJSONParser.throwException(n2);
        }
        if ((c2 = jSONLexerBase.getCurrent()) == ',') {
            jSONLexerBase.next();
            jSONLexerBase.setToken(16);
        } else {
            jSONLexerBase.nextToken(16);
        }
    }
}

