/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.parser.deserializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.JSONScanner;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Time;

public class TimeDeserializer
implements ObjectDeserializer {
    public static final TimeDeserializer instance = new TimeDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 16) {
            jSONLexer.nextToken(4);
            if (jSONLexer.token() != 4) {
                throw new JSONException("syntax error");
            }
            jSONLexer.nextTokenWithColon(2);
            if (jSONLexer.token() != 2) {
                throw new JSONException("syntax error");
            }
            long l2 = jSONLexer.longValue();
            jSONLexer.nextToken(13);
            if (jSONLexer.token() != 13) {
                throw new JSONException("syntax error");
            }
            jSONLexer.nextToken(16);
            return (T)new Time(l2);
        }
        Object object2 = defaultJSONParser.parse();
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Time) {
            return (T)object2;
        }
        if (object2 instanceof BigDecimal) {
            return (T)new Time(TypeUtils.longValue((BigDecimal)object2));
        }
        if (object2 instanceof Number) {
            return (T)new Time(((Number)object2).longValue());
        }
        if (object2 instanceof String) {
            long l3;
            String string = (String)object2;
            if (string.length() == 0) {
                return null;
            }
            JSONScanner jSONScanner = new JSONScanner(string);
            if (jSONScanner.scanISO8601DateIfMatch()) {
                l3 = jSONScanner.getCalendar().getTimeInMillis();
            } else {
                boolean bl = true;
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c2 = string.charAt(i2);
                    if (c2 >= '0' && c2 <= '9') continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    jSONScanner.close();
                    return (T)Time.valueOf(string);
                }
                l3 = Long.parseLong(string);
            }
            jSONScanner.close();
            return (T)new Time(l3);
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

