/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;

public class BigIntegerCodec
implements ObjectDeserializer,
ObjectSerializer {
    private static final BigInteger LOW = BigInteger.valueOf(-9007199254740991L);
    private static final BigInteger HIGH = BigInteger.valueOf(0x1FFFFFFFFFFFFFL);
    public static final BigIntegerCodec instance = new BigIntegerCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        BigInteger bigInteger = (BigInteger)object;
        String string = bigInteger.toString();
        if (string.length() >= 16 && SerializerFeature.isEnabled(n2, serializeWriter.features, SerializerFeature.BrowserCompatible) && (bigInteger.compareTo(LOW) < 0 || bigInteger.compareTo(HIGH) > 0)) {
            serializeWriter.writeString(string);
            return;
        }
        serializeWriter.write(string);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        return BigIntegerCodec.deserialze(defaultJSONParser);
    }

    public static <T> T deserialze(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 2) {
            String string = jSONLexer.numberString();
            jSONLexer.nextToken(16);
            return (T)new BigInteger(string);
        }
        Object object = defaultJSONParser.parse();
        return (T)(object == null ? null : TypeUtils.castToBigInteger(object));
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

