/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.JavaBeanSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerialContext;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        boolean bl = jSONSerializer.out.isEnabled(SerializerFeature.WriteClassName) || SerializerFeature.isEnabled(n2, SerializerFeature.WriteClassName);
        SerializeWriter serializeWriter = jSONSerializer.out;
        Type type2 = null;
        if (bl) {
            type2 = TypeUtils.getCollectionItemType(type);
        }
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        List list = (List)object;
        if (list.size() == 0) {
            serializeWriter.append("[]");
            return;
        }
        SerialContext serialContext = jSONSerializer.context;
        jSONSerializer.setContext(serialContext, object, object2, 0);
        ObjectSerializer objectSerializer = null;
        try {
            if (serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                serializeWriter.append('[');
                jSONSerializer.incrementIndent();
                int n3 = 0;
                for (Object e2 : list) {
                    if (n3 != 0) {
                        serializeWriter.append(',');
                    }
                    jSONSerializer.println();
                    if (e2 != null) {
                        if (jSONSerializer.containsReference(e2)) {
                            jSONSerializer.writeReference(e2);
                        } else {
                            SerialContext serialContext2;
                            objectSerializer = jSONSerializer.getObjectWriter(e2.getClass());
                            jSONSerializer.context = serialContext2 = new SerialContext(serialContext, object, object2, 0, 0);
                            objectSerializer.write(jSONSerializer, e2, n3, type2, n2);
                        }
                    } else {
                        jSONSerializer.out.writeNull();
                    }
                    ++n3;
                }
                jSONSerializer.decrementIdent();
                jSONSerializer.println();
                serializeWriter.append(']');
                return;
            }
            serializeWriter.append('[');
            int n4 = list.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                Object e3 = list.get(i2);
                if (i2 != 0) {
                    serializeWriter.append(',');
                }
                if (e3 == null) {
                    serializeWriter.append("null");
                    continue;
                }
                Class<?> clazz = e3.getClass();
                if (clazz == Integer.class) {
                    serializeWriter.writeInt((Integer)e3);
                    continue;
                }
                if (clazz == Long.class) {
                    long l2 = (Long)e3;
                    if (bl) {
                        serializeWriter.writeLong(l2);
                        serializeWriter.write(76);
                        continue;
                    }
                    serializeWriter.writeLong(l2);
                    continue;
                }
                if ((SerializerFeature.DisableCircularReferenceDetect.mask & n2) != 0) {
                    objectSerializer = jSONSerializer.getObjectWriter(e3.getClass());
                    objectSerializer.write(jSONSerializer, e3, i2, type2, n2);
                    continue;
                }
                if (!serializeWriter.disableCircularReferenceDetect) {
                    SerialContext serialContext3;
                    jSONSerializer.context = serialContext3 = new SerialContext(serialContext, object, object2, 0, 0);
                }
                if (jSONSerializer.containsReference(e3)) {
                    jSONSerializer.writeReference(e3);
                    continue;
                }
                objectSerializer = jSONSerializer.getObjectWriter(e3.getClass());
                if ((SerializerFeature.WriteClassName.mask & n2) != 0 && objectSerializer instanceof JavaBeanSerializer) {
                    JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)objectSerializer;
                    javaBeanSerializer.writeNoneASM(jSONSerializer, e3, i2, type2, n2);
                    continue;
                }
                objectSerializer.write(jSONSerializer, e3, i2, type2, n2);
            }
            serializeWriter.append(']');
        }
        finally {
            jSONSerializer.context = serialContext;
        }
    }
}

