/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerialContext;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONArray;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;

public class ObjectArrayCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final ObjectArrayCodec instance = new ObjectArrayCodec();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        Object[] objectArray = (Object[])object;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        int n3 = objectArray.length;
        int n4 = n3 - 1;
        if (n4 == -1) {
            serializeWriter.append("[]");
            return;
        }
        SerialContext serialContext = jSONSerializer.context;
        jSONSerializer.setContext(serialContext, object, object2, 0);
        try {
            Class<?> clazz = null;
            ObjectSerializer objectSerializer = null;
            serializeWriter.append('[');
            if (serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                jSONSerializer.incrementIndent();
                jSONSerializer.println();
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (i2 != 0) {
                        serializeWriter.write(44);
                        jSONSerializer.println();
                    }
                    jSONSerializer.write(objectArray[i2]);
                }
                jSONSerializer.decrementIdent();
                jSONSerializer.println();
                serializeWriter.write(93);
                return;
            }
            for (int i3 = 0; i3 < n4; ++i3) {
                Object object3 = objectArray[i3];
                if (object3 == null) {
                    serializeWriter.append("null,");
                    continue;
                }
                if (jSONSerializer.containsReference(object3)) {
                    jSONSerializer.writeReference(object3);
                } else {
                    Class<?> clazz2 = object3.getClass();
                    if (clazz2 == clazz) {
                        objectSerializer.write(jSONSerializer, object3, i3, null, 0);
                    } else {
                        clazz = clazz2;
                        objectSerializer = jSONSerializer.getObjectWriter(clazz2);
                        objectSerializer.write(jSONSerializer, object3, i3, null, 0);
                    }
                }
                serializeWriter.append(',');
            }
            Object object4 = objectArray[n4];
            if (object4 == null) {
                serializeWriter.append("null]");
            } else {
                if (jSONSerializer.containsReference(object4)) {
                    jSONSerializer.writeReference(object4);
                } else {
                    jSONSerializer.writeWithFieldName(object4, n4);
                }
                serializeWriter.append(']');
            }
        }
        finally {
            jSONSerializer.context = serialContext;
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Class<Object> clazz;
        Class<?> clazz2;
        Object object2;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n2 = jSONLexer.token();
        if (n2 == 8) {
            jSONLexer.nextToken(16);
            return null;
        }
        if (n2 == 4 || n2 == 26) {
            byte[] byArray = jSONLexer.bytesValue();
            jSONLexer.nextToken(16);
            if (byArray.length == 0 && type != byte[].class) {
                return null;
            }
            return (T)byArray;
        }
        if (type instanceof GenericArrayType) {
            object2 = (GenericArrayType)type;
            clazz2 = object2.getGenericComponentType();
            if (clazz2 instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)((Object)clazz2);
                Type type2 = defaultJSONParser.getContext().type;
                if (type2 instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)type2;
                    Type type3 = parameterizedType.getRawType();
                    Type type4 = null;
                    if (type3 instanceof Class) {
                        TypeVariable<Class<T>>[] typeVariableArray = ((Class)type3).getTypeParameters();
                        for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
                            if (!typeVariableArray[i2].getName().equals(typeVariable.getName())) continue;
                            type4 = parameterizedType.getActualTypeArguments()[i2];
                        }
                    }
                    clazz = type4 instanceof Class ? (Class<Object>)type4 : Object.class;
                } else {
                    clazz = TypeUtils.getClass(typeVariable.getBounds()[0]);
                }
            } else {
                clazz = TypeUtils.getClass(clazz2);
            }
        } else {
            object2 = (Class)type;
            clazz = ((Class)object2).getComponentType();
            clazz2 = clazz;
        }
        object2 = new JSONArray();
        defaultJSONParser.parseArray(clazz2, (Collection)object2, object);
        return this.toObjectArray(defaultJSONParser, clazz, (JSONArray)object2);
    }

    private <T> T toObjectArray(DefaultJSONParser defaultJSONParser, Class<?> clazz, JSONArray jSONArray) {
        if (jSONArray == null) {
            return null;
        }
        int n2 = jSONArray.size();
        Object object = Array.newInstance(clazz, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            Object object3 = jSONArray.get(i2);
            if (object3 == jSONArray) {
                Array.set(object, i2, object);
                continue;
            }
            if (clazz.isArray()) {
                object2 = clazz.isInstance(object3) ? object3 : this.toObjectArray(defaultJSONParser, clazz, (JSONArray)object3);
                Array.set(object, i2, object2);
                continue;
            }
            object2 = null;
            if (object3 instanceof JSONArray) {
                boolean bl = false;
                JSONArray jSONArray2 = (JSONArray)object3;
                int n3 = jSONArray2.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Object object4 = jSONArray2.get(i3);
                    if (object4 != jSONArray) continue;
                    jSONArray2.set(i2, object);
                    bl = true;
                }
                if (bl) {
                    object2 = jSONArray2.toArray();
                }
            }
            if (object2 == null) {
                object2 = TypeUtils.cast(object3, clazz, defaultJSONParser.getConfig());
            }
            Array.set(object, i2, object2);
        }
        jSONArray.setRelatedArray(object);
        jSONArray.setComponentType(clazz);
        return (T)object;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

