/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import com.icbc.api.internal.util.fastjson.annotation.JSONField;
import com.icbc.api.internal.util.fastjson.annotation.JSONType;
import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.JSONLexerBase;
import com.icbc.api.internal.util.fastjson.parser.JSONScanner;
import com.icbc.api.internal.util.fastjson.parser.ParserConfig;
import com.icbc.api.internal.util.fastjson.parser.deserializer.EnumDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.CalendarCodec;
import com.icbc.api.internal.util.fastjson.serializer.SerializeBeanInfo;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.FieldInfo;
import com.icbc.api.internal.util.fastjson.util.GenericArrayTypeImpl;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.fastjson.util.ParameterizedTypeImpl;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONArray;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import com.icbc.api.internal.util.internal.util.fastjson.JSONPObject;
import com.icbc.api.internal.util.internal.util.fastjson.PropertyNamingStrategy;
import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeUtils {
    private static final Pattern NUMBER_WITH_TRAILING_ZEROS_PATTERN = Pattern.compile("\\.0*$");
    public static boolean compatibleWithJavaBean = false;
    public static boolean compatibleWithFieldName = false;
    private static boolean setAccessibleEnable = true;
    private static boolean oracleTimestampMethodInited = false;
    private static Method oracleTimestampMethod;
    private static boolean oracleDateMethodInited;
    private static Method oracleDateMethod;
    private static boolean optionalClassInited;
    private static Class<?> optionalClass;
    private static boolean transientClassInited;
    private static Class<? extends Annotation> transientClass;
    private static Class<? extends Annotation> class_OneToMany;
    private static boolean class_OneToMany_error;
    private static Class<? extends Annotation> class_ManyToMany;
    private static boolean class_ManyToMany_error;
    private static Method method_HibernateIsInitialized;
    private static boolean method_HibernateIsInitialized_error;
    private static volatile Class kotlin_metadata;
    private static volatile boolean kotlin_metadata_error;
    private static volatile boolean kotlin_class_klass_error;
    private static volatile Constructor kotlin_kclass_constructor;
    private static volatile Method kotlin_kclass_getConstructors;
    private static volatile Method kotlin_kfunction_getParameters;
    private static volatile Method kotlin_kparameter_getName;
    private static volatile boolean kotlin_error;
    private static volatile Map<Class, String[]> kotlinIgnores;
    private static volatile boolean kotlinIgnores_error;
    private static ConcurrentMap<String, Class<?>> mappings;
    private static Class<?> pathClass;
    private static boolean pathClass_error;
    private static Class<? extends Annotation> class_JacksonCreator;
    private static boolean class_JacksonCreator_error;
    private static volatile Class class_Clob;
    private static volatile boolean class_Clob_error;
    private static volatile Class class_XmlAccessType;
    private static volatile Class class_XmlAccessorType;
    private static volatile boolean classXmlAccessorType_error;
    private static volatile Method method_XmlAccessorType_value;
    private static volatile Field field_XmlAccessType_FIELD;
    private static volatile Object field_XmlAccessType_FIELD_VALUE;

    public static boolean isXmlField(Class clazz) {
        if (class_XmlAccessorType == null && !classXmlAccessorType_error) {
            try {
                class_XmlAccessorType = Class.forName("javax.xml.bind.annotation.XmlAccessorType");
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        if (class_XmlAccessorType == null) {
            return false;
        }
        Object a2 = TypeUtils.getAnnotation(clazz, class_XmlAccessorType);
        if (a2 == null) {
            return false;
        }
        if (method_XmlAccessorType_value == null && !classXmlAccessorType_error) {
            try {
                method_XmlAccessorType_value = class_XmlAccessorType.getMethod("value", new Class[0]);
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        if (method_XmlAccessorType_value == null) {
            return false;
        }
        Object object = null;
        if (!classXmlAccessorType_error) {
            try {
                object = method_XmlAccessorType_value.invoke(a2, new Object[0]);
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        if (object == null) {
            return false;
        }
        if (class_XmlAccessType == null && !classXmlAccessorType_error) {
            try {
                class_XmlAccessType = Class.forName("javax.xml.bind.annotation.XmlAccessType");
                field_XmlAccessType_FIELD = class_XmlAccessType.getField("FIELD");
                field_XmlAccessType_FIELD_VALUE = field_XmlAccessType_FIELD.get(null);
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        return object == field_XmlAccessType_FIELD_VALUE;
    }

    public static Annotation getXmlAccessorType(Class clazz) {
        if (class_XmlAccessorType == null && !classXmlAccessorType_error) {
            try {
                class_XmlAccessorType = Class.forName("javax.xml.bind.annotation.XmlAccessorType");
            }
            catch (Throwable throwable) {
                classXmlAccessorType_error = true;
            }
        }
        if (class_XmlAccessorType == null) {
            return null;
        }
        return TypeUtils.getAnnotation(clazz, class_XmlAccessorType);
    }

    public static boolean isClob(Class clazz) {
        if (class_Clob == null && !class_Clob_error) {
            try {
                class_Clob = Class.forName("java.sql.Clob");
            }
            catch (Throwable throwable) {
                class_Clob_error = true;
            }
        }
        if (class_Clob == null) {
            return false;
        }
        return class_Clob.isAssignableFrom(clazz);
    }

    public static String castToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static Byte castToByte(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.byteValue((BigDecimal)object);
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            return Byte.parseByte(string);
        }
        throw new JSONException("can not cast to byte, value : " + object);
    }

    public static Character castToChar(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            if (string.length() != 1) {
                throw new JSONException("can not cast to char, value : " + object);
            }
            return Character.valueOf(string.charAt(0));
        }
        throw new JSONException("can not cast to char, value : " + object);
    }

    public static Short castToShort(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.shortValue((BigDecimal)object);
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            return Short.parseShort(string);
        }
        throw new JSONException("can not cast to short, value : " + object);
    }

    public static BigDecimal castToBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        String string = object.toString();
        if (string.length() == 0) {
            return null;
        }
        if (object instanceof Map && ((Map)object).size() == 0) {
            return null;
        }
        return new BigDecimal(string);
    }

    public static BigInteger castToBigInteger(Object object) {
        Object object2;
        int n2;
        if (object == null) {
            return null;
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof Float || object instanceof Double) {
            return BigInteger.valueOf(((Number)object).longValue());
        }
        if (object instanceof BigDecimal && (n2 = ((BigDecimal)(object2 = (BigDecimal)object)).scale()) > -1000 && n2 < 1000) {
            return ((BigDecimal)object).toBigInteger();
        }
        object2 = object.toString();
        if (((String)object2).length() == 0 || "null".equals(object2) || "NULL".equals(object2)) {
            return null;
        }
        return new BigInteger((String)object2);
    }

    public static Float castToFloat(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (object instanceof String) {
            String string = object.toString();
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            if (string.indexOf(44) != -1) {
                string = string.replaceAll(",", "");
            }
            return Float.valueOf(Float.parseFloat(string));
        }
        throw new JSONException("can not cast to float, value : " + object);
    }

    public static Double castToDouble(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            String string = object.toString();
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            if (string.indexOf(44) != -1) {
                string = string.replaceAll(",", "");
            }
            return Double.parseDouble(string);
        }
        throw new JSONException("can not cast to double, value : " + object);
    }

    public static Date castToDate(Object object) {
        return TypeUtils.castToDate(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date castToDate(Object object, String string) {
        Object object2;
        Class<?> clazz;
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        long l2 = -1L;
        if (object instanceof BigDecimal) {
            l2 = TypeUtils.longValue((BigDecimal)object);
            return new Date(l2);
        }
        if (object instanceof Number) {
            l2 = ((Number)object).longValue();
            if ("unixtime".equals(string)) {
                l2 *= 1000L;
            }
            return new Date(l2);
        }
        if (object instanceof String) {
            clazz = (String)object;
            object2 = new JSONScanner((String)((Object)clazz));
            try {
                if (((JSONScanner)object2).scanISO8601DateIfMatch(false)) {
                    Calendar calendar = ((JSONLexerBase)object2).getCalendar();
                    Date date = calendar.getTime();
                    return date;
                }
            }
            finally {
                ((JSONLexerBase)object2).close();
            }
            if (((String)((Object)clazz)).startsWith("/Date(") && ((String)((Object)clazz)).endsWith(")/")) {
                clazz = ((String)((Object)clazz)).substring(6, ((String)((Object)clazz)).length() - 2);
            }
            if (((String)((Object)clazz)).indexOf(45) > 0 || ((String)((Object)clazz)).indexOf(43) > 0) {
                if (string == null) {
                    string = ((String)((Object)clazz)).length() == JSON.DEFFAULT_DATE_FORMAT.length() || ((String)((Object)clazz)).length() == 22 && JSON.DEFFAULT_DATE_FORMAT.equals("yyyyMMddHHmmssSSSZ") ? JSON.DEFFAULT_DATE_FORMAT : (((String)((Object)clazz)).length() == 10 ? "yyyy-MM-dd" : (((String)((Object)clazz)).length() == "yyyy-MM-dd HH:mm:ss".length() ? "yyyy-MM-dd HH:mm:ss" : (((String)((Object)clazz)).length() == 29 && ((String)((Object)clazz)).charAt(26) == ':' && ((String)((Object)clazz)).charAt(28) == '0' ? "yyyy-MM-dd'T'HH:mm:ss.SSSXXX" : (((String)((Object)clazz)).length() == 23 && ((String)((Object)clazz)).charAt(19) == ',' ? "yyyy-MM-dd HH:mm:ss,SSS" : "yyyy-MM-dd HH:mm:ss.SSS"))));
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, JSON.defaultLocale);
                simpleDateFormat.setTimeZone(JSON.defaultTimeZone);
                try {
                    return simpleDateFormat.parse((String)((Object)clazz));
                }
                catch (ParseException parseException) {
                    throw new JSONException("can not cast to Date, value : " + (String)((Object)clazz));
                }
            }
            if (((String)((Object)clazz)).length() == 0) {
                return null;
            }
            l2 = Long.parseLong((String)((Object)clazz));
        }
        if (l2 == -1L) {
            clazz = object.getClass();
            if ("oracle.sql.TIMESTAMP".equals(clazz.getName())) {
                if (oracleTimestampMethod == null && !oracleTimestampMethodInited) {
                    try {
                        oracleTimestampMethod = clazz.getMethod("toJdbc", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    finally {
                        oracleTimestampMethodInited = true;
                    }
                }
                try {
                    object2 = oracleTimestampMethod.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    throw new JSONException("can not cast oracle.sql.TIMESTAMP to Date", exception);
                }
                return (Date)object2;
            }
            if ("oracle.sql.DATE".equals(clazz.getName())) {
                if (oracleDateMethod == null && !oracleDateMethodInited) {
                    try {
                        oracleDateMethod = clazz.getMethod("toJdbc", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    finally {
                        oracleDateMethodInited = true;
                    }
                }
                try {
                    object2 = oracleDateMethod.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    throw new JSONException("can not cast oracle.sql.DATE to Date", exception);
                }
                return (Date)object2;
            }
            throw new JSONException("can not cast to Date, value : " + object);
        }
        return new Date(l2);
    }

    public static java.sql.Date castToSqlDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof java.sql.Date) {
            return (java.sql.Date)object;
        }
        if (object instanceof Date) {
            return new java.sql.Date(((Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return new java.sql.Date(((Calendar)object).getTimeInMillis());
        }
        long l2 = 0L;
        if (object instanceof BigDecimal) {
            l2 = TypeUtils.longValue((BigDecimal)object);
        } else if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            if (TypeUtils.isNumber(string)) {
                l2 = Long.parseLong(string);
            } else {
                JSONScanner jSONScanner = new JSONScanner(string);
                if (jSONScanner.scanISO8601DateIfMatch(false)) {
                    l2 = jSONScanner.getCalendar().getTime().getTime();
                } else {
                    throw new JSONException("can not cast to Timestamp, value : " + string);
                }
            }
        }
        if (l2 <= 0L) {
            throw new JSONException("can not cast to Date, value : " + object);
        }
        return new java.sql.Date(l2);
    }

    public static long longExtractValue(Number number) {
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).longValueExact();
        }
        return number.longValue();
    }

    public static Time castToSqlTime(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof Date) {
            return new Time(((Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return new Time(((Calendar)object).getTimeInMillis());
        }
        long l2 = 0L;
        if (object instanceof BigDecimal) {
            l2 = TypeUtils.longValue((BigDecimal)object);
        } else if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equalsIgnoreCase(string)) {
                return null;
            }
            if (TypeUtils.isNumber(string)) {
                l2 = Long.parseLong(string);
            } else {
                JSONScanner jSONScanner = new JSONScanner(string);
                if (jSONScanner.scanISO8601DateIfMatch(false)) {
                    l2 = jSONScanner.getCalendar().getTime().getTime();
                } else {
                    throw new JSONException("can not cast to Timestamp, value : " + string);
                }
            }
        }
        if (l2 <= 0L) {
            throw new JSONException("can not cast to Date, value : " + object);
        }
        return new Time(l2);
    }

    public static Timestamp castToTimestamp(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return new Timestamp(((Calendar)object).getTimeInMillis());
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        long l2 = 0L;
        if (object instanceof BigDecimal) {
            l2 = TypeUtils.longValue((BigDecimal)object);
        } else if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            if (string.endsWith(".000000000")) {
                string = string.substring(0, string.length() - 10);
            } else if (string.endsWith(".000000")) {
                string = string.substring(0, string.length() - 7);
            }
            if (string.length() == 29 && string.charAt(4) == '-' && string.charAt(7) == '-' && string.charAt(10) == ' ' && string.charAt(13) == ':' && string.charAt(16) == ':' && string.charAt(19) == '.') {
                int n2 = TypeUtils.num(string.charAt(0), string.charAt(1), string.charAt(2), string.charAt(3));
                int n3 = TypeUtils.num(string.charAt(5), string.charAt(6));
                int n4 = TypeUtils.num(string.charAt(8), string.charAt(9));
                int n5 = TypeUtils.num(string.charAt(11), string.charAt(12));
                int n6 = TypeUtils.num(string.charAt(14), string.charAt(15));
                int n7 = TypeUtils.num(string.charAt(17), string.charAt(18));
                int n8 = TypeUtils.num(string.charAt(20), string.charAt(21), string.charAt(22), string.charAt(23), string.charAt(24), string.charAt(25), string.charAt(26), string.charAt(27), string.charAt(28));
                return new Timestamp(n2 - 1900, n3 - 1, n4, n5, n6, n7, n8);
            }
            if (TypeUtils.isNumber(string)) {
                l2 = Long.parseLong(string);
            } else {
                JSONScanner jSONScanner = new JSONScanner(string);
                if (jSONScanner.scanISO8601DateIfMatch(false)) {
                    l2 = jSONScanner.getCalendar().getTime().getTime();
                } else {
                    throw new JSONException("can not cast to Timestamp, value : " + string);
                }
            }
        }
        if (l2 < 0L) {
            throw new JSONException("can not cast to Timestamp, value : " + object);
        }
        return new Timestamp(l2);
    }

    static int num(char c2, char c3) {
        if (c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9') {
            return (c2 - 48) * 10 + (c3 - 48);
        }
        return -1;
    }

    static int num(char c2, char c3, char c4, char c5) {
        if (c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c4 >= '0' && c4 <= '9' && c5 >= '0' && c5 <= '9') {
            return (c2 - 48) * 1000 + (c3 - 48) * 100 + (c4 - 48) * 10 + (c5 - 48);
        }
        return -1;
    }

    static int num(char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9, char c10) {
        if (c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c4 >= '0' && c4 <= '9' && c5 >= '0' && c5 <= '9' && c6 >= '0' && c6 <= '9' && c7 >= '0' && c7 <= '9' && c8 >= '0' && c8 <= '9' && c9 >= '0' && c9 <= '9' && c10 >= '0' && c10 <= '9') {
            return (c2 - 48) * 100000000 + (c3 - 48) * 10000000 + (c4 - 48) * 1000000 + (c5 - 48) * 100000 + (c6 - 48) * 10000 + (c7 - 48) * 1000 + (c8 - 48) * 100 + (c9 - 48) * 10 + (c10 - 48);
        }
        return -1;
    }

    public static boolean isNumber(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!(c2 == '+' || c2 == '-' ? i2 != 0 : c2 < '0' || c2 > '9')) continue;
            return false;
        }
        return true;
    }

    public static Long castToLong(Object object) {
        Object object2;
        Object object3;
        Object object4;
        block10: {
            if (object == null) {
                return null;
            }
            if (object instanceof BigDecimal) {
                return TypeUtils.longValue((BigDecimal)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            if (object instanceof String) {
                object4 = (String)object;
                if (((String)object4).length() == 0 || "null".equals(object4) || "NULL".equals(object4)) {
                    return null;
                }
                if (((String)object4).indexOf(44) != -1) {
                    object4 = ((String)object4).replaceAll(",", "");
                }
                try {
                    return Long.parseLong((String)object4);
                }
                catch (NumberFormatException numberFormatException) {
                    object3 = new JSONScanner((String)object4);
                    object2 = null;
                    if (((JSONScanner)object3).scanISO8601DateIfMatch(false)) {
                        object2 = ((JSONLexerBase)object3).getCalendar();
                    }
                    ((JSONLexerBase)object3).close();
                    if (object2 == null) break block10;
                    return ((Calendar)object2).getTimeInMillis();
                }
            }
        }
        if (object instanceof Map && (object4 = (Map)object).size() == 2 && object4.containsKey("andIncrement") && object4.containsKey("andDecrement")) {
            object3 = object4.values().iterator();
            object3.next();
            object2 = object3.next();
            return TypeUtils.castToLong(object2);
        }
        throw new JSONException("can not cast to long, value : " + object);
    }

    public static byte byteValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n2 = bigDecimal.scale();
        if (n2 >= -100 && n2 <= 100) {
            return bigDecimal.byteValue();
        }
        return bigDecimal.byteValueExact();
    }

    public static short shortValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n2 = bigDecimal.scale();
        if (n2 >= -100 && n2 <= 100) {
            return bigDecimal.shortValue();
        }
        return bigDecimal.shortValueExact();
    }

    public static int intValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n2 = bigDecimal.scale();
        if (n2 >= -100 && n2 <= 100) {
            return bigDecimal.intValue();
        }
        return bigDecimal.intValueExact();
    }

    public static long longValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0L;
        }
        int n2 = bigDecimal.scale();
        if (n2 >= -100 && n2 <= 100) {
            return bigDecimal.longValue();
        }
        return bigDecimal.longValueExact();
    }

    public static Integer castToInt(Object object) {
        Map map;
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.intValue((BigDecimal)object);
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            Matcher matcher;
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            if (string.indexOf(44) != -1) {
                string = string.replaceAll(",", "");
            }
            if ((matcher = NUMBER_WITH_TRAILING_ZEROS_PATTERN.matcher(string)).find()) {
                string = matcher.replaceAll("");
            }
            return Integer.parseInt(string);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Map && (map = (Map)object).size() == 2 && map.containsKey("andIncrement") && map.containsKey("andDecrement")) {
            Iterator iterator = map.values().iterator();
            iterator.next();
            Object v2 = iterator.next();
            return TypeUtils.castToInt(v2);
        }
        throw new JSONException("can not cast to int, value : " + object);
    }

    public static byte[] castToBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return IOUtils.decodeBase64((String)object);
        }
        throw new JSONException("can not cast to byte[], value : " + object);
    }

    public static Boolean castToBoolean(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.intValue((BigDecimal)object) == 1;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() == 1;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            if ("true".equalsIgnoreCase(string) || "1".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string) || "0".equals(string)) {
                return Boolean.FALSE;
            }
            if ("Y".equalsIgnoreCase(string) || "T".equals(string)) {
                return Boolean.TRUE;
            }
            if ("F".equalsIgnoreCase(string) || "N".equals(string)) {
                return Boolean.FALSE;
            }
        }
        throw new JSONException("can not cast to boolean, value : " + object);
    }

    public static <T> T castToJavaBean(Object object, Class<T> clazz) {
        return TypeUtils.cast(object, clazz, ParserConfig.getGlobalInstance());
    }

    public static <T> T cast(Object object, Class<T> clazz, ParserConfig parserConfig) {
        Object object2;
        if (object == null) {
            if (clazz == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (clazz == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (clazz == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (clazz == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (clazz == Float.TYPE) {
                return (T)Float.valueOf(0.0f);
            }
            if (clazz == Double.TYPE) {
                return (T)Double.valueOf(0.0);
            }
            if (clazz == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (clazz == object.getClass()) {
            return (T)object;
        }
        if (object instanceof Map) {
            if (clazz == Map.class) {
                return (T)object;
            }
            Map map = (Map)object;
            if (clazz == Object.class && !map.containsKey(JSON.DEFAULT_TYPE_KEY)) {
                return (T)object;
            }
            return TypeUtils.castToJavaBean((Map)object, clazz, parserConfig);
        }
        if (clazz.isArray()) {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int n2 = 0;
                Object object3 = Array.newInstance(clazz.getComponentType(), collection.size());
                for (Object e2 : collection) {
                    Object obj = TypeUtils.cast(e2, clazz.getComponentType(), parserConfig);
                    Array.set(object3, n2, obj);
                    ++n2;
                }
                return (T)object3;
            }
            if (clazz == byte[].class) {
                return (T)TypeUtils.castToBytes(object);
            }
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtils.castToBoolean(object);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte(object);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return (T)TypeUtils.castToChar(object);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort(object);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtils.castToInt(object);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtils.castToLong(object);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat(object);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble(object);
        }
        if (clazz == String.class) {
            return (T)TypeUtils.castToString(object);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(object);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(object);
        }
        if (clazz == Date.class) {
            return (T)TypeUtils.castToDate(object);
        }
        if (clazz == java.sql.Date.class) {
            return (T)TypeUtils.castToSqlDate(object);
        }
        if (clazz == Time.class) {
            return (T)TypeUtils.castToSqlTime(object);
        }
        if (clazz == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp(object);
        }
        if (clazz.isEnum()) {
            return TypeUtils.castToEnum(object, clazz, parserConfig);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            Calendar calendar;
            Date date = TypeUtils.castToDate(object);
            if (clazz == Calendar.class) {
                calendar = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            } else {
                try {
                    calendar = (Calendar)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new JSONException("can not cast to : " + clazz.getName(), exception);
                }
            }
            calendar.setTime(date);
            return (T)calendar;
        }
        String string = clazz.getName();
        if (string.equals("javax.xml.datatype.XMLGregorianCalendar")) {
            Date date = TypeUtils.castToDate(object);
            Calendar calendar = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            calendar.setTime(date);
            return (T)CalendarCodec.instance.createXMLGregorianCalendar(calendar);
        }
        if (object instanceof String) {
            object2 = (String)object;
            if (((String)object2).length() == 0 || "null".equals(object2) || "NULL".equals(object2)) {
                return null;
            }
            if (clazz == Currency.class) {
                return (T)Currency.getInstance((String)object2);
            }
            if (clazz == Locale.class) {
                return (T)TypeUtils.toLocale((String)object2);
            }
            if (string.startsWith("java.time.")) {
                String string2 = JSON.toJSONString(object2);
                return JSON.parseObject(string2, clazz);
            }
        }
        if ((object2 = parserConfig.get(clazz)) != null) {
            String string3 = JSON.toJSONString(object);
            return JSON.parseObject(string3, clazz);
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static Locale toLocale(String string) {
        String[] stringArray = string.split("_");
        if (stringArray.length == 1) {
            return new Locale(stringArray[0]);
        }
        if (stringArray.length == 2) {
            return new Locale(stringArray[0], stringArray[1]);
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }

    public static <T> T castToEnum(Object object, Class<T> clazz, ParserConfig parserConfig) {
        try {
            T[] TArray;
            int n2;
            if (object instanceof String) {
                ObjectDeserializer objectDeserializer;
                String string = (String)object;
                if (string.length() == 0) {
                    return null;
                }
                if (parserConfig == null) {
                    parserConfig = ParserConfig.getGlobalInstance();
                }
                if ((objectDeserializer = parserConfig.getDeserializer(clazz)) instanceof EnumDeserializer) {
                    EnumDeserializer enumDeserializer = (EnumDeserializer)objectDeserializer;
                    return (T)enumDeserializer.getEnumByHashCode(TypeUtils.fnv1a_64(string));
                }
                return Enum.valueOf(clazz, string);
            }
            if (object instanceof BigDecimal && (n2 = TypeUtils.intValue((BigDecimal)object)) < (TArray = clazz.getEnumConstants()).length) {
                return TArray[n2];
            }
            if (object instanceof Number && (n2 = ((Number)object).intValue()) < (TArray = clazz.getEnumConstants()).length) {
                return TArray[n2];
            }
        }
        catch (Exception exception) {
            throw new JSONException("can not cast to : " + clazz.getName(), exception);
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static <T> T cast(Object object, Type type, ParserConfig parserConfig) {
        String string;
        if (object == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(object, (Class)type, parserConfig);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(object, (ParameterizedType)type, parserConfig);
        }
        if (object instanceof String && ((string = (String)object).length() == 0 || "null".equals(string) || "NULL".equals(string))) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)object;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static <T> T cast(Object object, ParameterizedType parameterizedType, ParserConfig parserConfig) {
        Map.Entry entry;
        Type[] typeArray;
        Type type = parameterizedType.getRawType();
        if (type == List.class || type == ArrayList.class) {
            typeArray = parameterizedType.getActualTypeArguments()[0];
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<T> arrayList = new ArrayList<T>(list.size());
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Object e2 = list.get(i2);
                    T t2 = typeArray instanceof Class ? (e2 != null && e2.getClass() == JSONObject.class ? ((JSONObject)e2).toJavaObject((Class)typeArray, parserConfig, 0) : TypeUtils.cast(e2, (Class)typeArray, parserConfig)) : TypeUtils.cast(e2, (Type)typeArray, parserConfig);
                    arrayList.add(t2);
                }
                return (T)arrayList;
            }
        }
        if (type == Set.class || type == HashSet.class || type == TreeSet.class || type == Collection.class || type == List.class || type == ArrayList.class) {
            typeArray = parameterizedType.getActualTypeArguments()[0];
            if (object instanceof Iterable) {
                AbstractCollection abstractCollection = type == Set.class || type == HashSet.class ? new HashSet() : (type == TreeSet.class ? new TreeSet() : new ArrayList());
                for (Object t3 : (Iterable)object) {
                    T t4 = typeArray instanceof Class ? (t3 != null && t3.getClass() == JSONObject.class ? ((JSONObject)t3).toJavaObject((Class)typeArray, parserConfig, 0) : TypeUtils.cast(t3, (Class)typeArray, parserConfig)) : TypeUtils.cast(t3, (Type)typeArray, parserConfig);
                    abstractCollection.add(t4);
                }
                return (T)abstractCollection;
            }
        }
        if (type == Map.class || type == HashMap.class) {
            typeArray = parameterizedType.getActualTypeArguments()[0];
            entry = parameterizedType.getActualTypeArguments()[1];
            if (object instanceof Map) {
                HashMap<T, T> hashMap = new HashMap<T, T>();
                for (Map.Entry entry2 : ((Map)object).entrySet()) {
                    T t5 = TypeUtils.cast(entry2.getKey(), (Type)typeArray, parserConfig);
                    T t6 = TypeUtils.cast(entry2.getValue(), entry, parserConfig);
                    hashMap.put(t5, t6);
                }
                return (T)hashMap;
            }
        }
        if (object instanceof String && (typeArray = (String)object).length() == 0) {
            return null;
        }
        typeArray = parameterizedType.getActualTypeArguments();
        if (typeArray.length == 1 && (entry = parameterizedType.getActualTypeArguments()[0]) instanceof WildcardType) {
            return TypeUtils.cast(object, type, parserConfig);
        }
        if (type == Map.Entry.class && object instanceof Map && ((Map)object).size() == 1) {
            entry = ((Map)object).entrySet().iterator().next();
            Object v2 = entry.getValue();
            if (typeArray.length == 2 && v2 instanceof Map) {
                Type type2 = typeArray[1];
                entry.setValue(TypeUtils.cast(v2, type2, parserConfig));
            }
            return (T)entry;
        }
        if (type instanceof Class) {
            if (parserConfig == null) {
                parserConfig = ParserConfig.global;
            }
            if ((entry = parserConfig.getDeserializer(type)) != null) {
                String string = JSON.toJSONString(object);
                DefaultJSONParser defaultJSONParser = new DefaultJSONParser(string, parserConfig);
                return entry.deserialze(defaultJSONParser, parameterizedType, null);
            }
        }
        throw new JSONException("can not cast to : " + parameterizedType);
    }

    public static <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig parserConfig) {
        try {
            LinkedHashMap linkedHashMap;
            Object object;
            if (clazz == StackTraceElement.class) {
                String string = (String)map.get("className");
                String string2 = (String)map.get("methodName");
                String string3 = (String)map.get("fileName");
                Number number = (Number)map.get("lineNumber");
                int n2 = number == null ? 0 : (number instanceof BigDecimal ? ((BigDecimal)number).intValueExact() : number.intValue());
                return (T)new StackTraceElement(string, string2, string3, n2);
            }
            Object object2 = map.get(JSON.DEFAULT_TYPE_KEY);
            if (object2 instanceof String) {
                object = (String)object2;
                if (parserConfig == null) {
                    parserConfig = ParserConfig.global;
                }
                if ((linkedHashMap = parserConfig.checkAutoType((String)object, null)) == null) {
                    throw new ClassNotFoundException((String)object + " not found");
                }
                if (!((Object)linkedHashMap).equals(clazz)) {
                    return (T)TypeUtils.castToJavaBean(map, linkedHashMap, parserConfig);
                }
            }
            if (clazz.isInterface()) {
                object2 = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
                if (parserConfig == null) {
                    parserConfig = ParserConfig.getGlobalInstance();
                }
                if ((object = parserConfig.get(clazz)) != null) {
                    linkedHashMap = JSON.toJSONString(object2);
                    return JSON.parseObject((String)((Object)linkedHashMap), clazz);
                }
                return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)object2);
            }
            if (clazz == Locale.class) {
                object2 = map.get("language");
                object = map.get("country");
                if (object2 instanceof String) {
                    linkedHashMap = (String)object2;
                    if (object instanceof String) {
                        String string = (String)object;
                        return (T)new Locale((String)((Object)linkedHashMap), string);
                    }
                    if (object == null) {
                        return (T)new Locale((String)((Object)linkedHashMap));
                    }
                }
            }
            if (clazz == String.class && map instanceof JSONObject) {
                return (T)map.toString();
            }
            if (clazz == JSON.class && map instanceof JSONObject) {
                return (T)map;
            }
            if (clazz == LinkedHashMap.class && map instanceof JSONObject) {
                object2 = (JSONObject)map;
                object = ((JSONObject)object2).getInnerMap();
                if (object instanceof LinkedHashMap) {
                    return (T)object;
                }
                linkedHashMap = new LinkedHashMap();
                linkedHashMap.putAll(object);
            }
            if (clazz.isInstance(map)) {
                return (T)map;
            }
            if (clazz == JSONObject.class) {
                return (T)new JSONObject(map);
            }
            if (parserConfig == null) {
                parserConfig = ParserConfig.getGlobalInstance();
            }
            object2 = null;
            object = parserConfig.getDeserializer(clazz);
            if (object instanceof JavaBeanDeserializer) {
                object2 = (JavaBeanDeserializer)object;
            }
            if (object2 == null) {
                throw new JSONException("can not get javaBeanDeserializer. " + clazz.getName());
            }
            return (T)((JavaBeanDeserializer)object2).createInstance(map, parserConfig);
        }
        catch (Exception exception) {
            throw new JSONException(exception.getMessage(), exception);
        }
    }

    private static void addBaseClassMappings() {
        Class[] classArray;
        mappings.put("byte", Byte.TYPE);
        mappings.put("short", Short.TYPE);
        mappings.put("int", Integer.TYPE);
        mappings.put("long", Long.TYPE);
        mappings.put("float", Float.TYPE);
        mappings.put("double", Double.TYPE);
        mappings.put("boolean", Boolean.TYPE);
        mappings.put("char", Character.TYPE);
        mappings.put("[byte", byte[].class);
        mappings.put("[short", short[].class);
        mappings.put("[int", int[].class);
        mappings.put("[long", long[].class);
        mappings.put("[float", float[].class);
        mappings.put("[double", double[].class);
        mappings.put("[boolean", boolean[].class);
        mappings.put("[char", char[].class);
        mappings.put("[B", byte[].class);
        mappings.put("[S", short[].class);
        mappings.put("[I", int[].class);
        mappings.put("[J", long[].class);
        mappings.put("[F", float[].class);
        mappings.put("[D", double[].class);
        mappings.put("[C", char[].class);
        mappings.put("[Z", boolean[].class);
        for (Class clazz : classArray = new Class[]{Object.class, Cloneable.class, TypeUtils.loadClass("java.lang.AutoCloseable"), Exception.class, RuntimeException.class, IllegalAccessError.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationError.class, InstantiationException.class, InternalError.class, InterruptedException.class, LinkageError.class, NegativeArraySizeException.class, NoClassDefFoundError.class, NoSuchFieldError.class, NoSuchFieldException.class, NoSuchMethodError.class, NoSuchMethodException.class, NullPointerException.class, NumberFormatException.class, OutOfMemoryError.class, SecurityException.class, StackOverflowError.class, StringIndexOutOfBoundsException.class, TypeNotPresentException.class, VerifyError.class, StackTraceElement.class, HashMap.class, Hashtable.class, TreeMap.class, IdentityHashMap.class, WeakHashMap.class, LinkedHashMap.class, HashSet.class, LinkedHashSet.class, TreeSet.class, ArrayList.class, TimeUnit.class, ConcurrentHashMap.class, AtomicInteger.class, AtomicLong.class, Collections.EMPTY_MAP.getClass(), Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Number.class, String.class, BigDecimal.class, BigInteger.class, BitSet.class, Calendar.class, Date.class, Locale.class, UUID.class, Time.class, java.sql.Date.class, Timestamp.class, SimpleDateFormat.class, JSONObject.class, JSONPObject.class, JSONArray.class}) {
            if (clazz == null) continue;
            mappings.put(clazz.getName(), clazz);
        }
    }

    public static void clearClassMapping() {
        mappings.clear();
        TypeUtils.addBaseClassMappings();
    }

    public static void addMapping(String string, Class<?> clazz) {
        mappings.put(string, clazz);
    }

    public static Class<?> loadClass(String string) {
        return TypeUtils.loadClass(string, null);
    }

    public static boolean isPath(Class<?> clazz) {
        if (pathClass == null && !pathClass_error) {
            try {
                pathClass = Class.forName("java.nio.file.Path");
            }
            catch (Throwable throwable) {
                pathClass_error = true;
            }
        }
        if (pathClass != null) {
            return pathClass.isAssignableFrom(clazz);
        }
        return false;
    }

    public static Class<?> getClassFromMapping(String string) {
        return (Class)mappings.get(string);
    }

    public static Class<?> loadClass(String string, ClassLoader classLoader) {
        return TypeUtils.loadClass(string, classLoader, false);
    }

    public static Class<?> loadClass(String string, ClassLoader classLoader, boolean bl) {
        if (string == null || string.length() == 0 || string.length() > 128) {
            return null;
        }
        Class<?> clazz = (Class<?>)mappings.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (string.charAt(0) == '[') {
            Class<?> clazz2 = TypeUtils.loadClass(string.substring(1), classLoader);
            return Array.newInstance(clazz2, 0).getClass();
        }
        if (string.startsWith("L") && string.endsWith(";")) {
            String string2 = string.substring(1, string.length() - 1);
            return TypeUtils.loadClass(string2, classLoader);
        }
        try {
            if (classLoader != null) {
                clazz = classLoader.loadClass(string);
                if (bl) {
                    mappings.put(string, clazz);
                }
                return clazz;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 != null && classLoader2 != classLoader) {
                clazz = classLoader2.loadClass(string);
                if (bl) {
                    mappings.put(string, clazz);
                }
                return clazz;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            clazz = Class.forName(string);
            if (bl) {
                mappings.put(string, clazz);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            return clazz;
        }
    }

    public static SerializeBeanInfo buildBeanInfo(Class<?> clazz, Map<String, String> map, PropertyNamingStrategy propertyNamingStrategy) {
        return TypeUtils.buildBeanInfo(clazz, map, propertyNamingStrategy, false);
    }

    public static SerializeBeanInfo buildBeanInfo(Class<?> clazz, Map<String, String> map, PropertyNamingStrategy object, boolean bl) {
        Object object2;
        Object object3;
        int n2;
        Object object4;
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        String[] stringArray = null;
        String string = null;
        String string2 = null;
        if (jSONType != null) {
            JSONType jSONType2;
            JSONType jSONType3;
            stringArray = jSONType.orders();
            string = jSONType.typeName();
            if (string.length() == 0) {
                string = null;
            }
            if ((object4 = jSONType.naming()) != PropertyNamingStrategy.CamelCase) {
                object = object4;
            }
            n2 = SerializerFeature.of(jSONType.serialzeFeatures());
            for (object3 = clazz.getSuperclass(); object3 != null && object3 != Object.class && (jSONType3 = TypeUtils.getAnnotation(object3, JSONType.class)) != null && (string2 = jSONType3.typeKey()).length() == 0; object3 = object3.getSuperclass()) {
            }
            object3 = clazz.getInterfaces();
            int n3 = ((Class<?>[])object3).length;
            for (int i2 = 0; i2 < n3 && ((jSONType2 = TypeUtils.getAnnotation(object2 = object3[i2], JSONType.class)) == null || (string2 = jSONType2.typeKey()).length() == 0); ++i2) {
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
        } else {
            n2 = 0;
        }
        object4 = new HashMap<String, Field>();
        ParserConfig.parserAllFieldToCache(clazz, object4);
        object3 = bl ? TypeUtils.computeGettersWithFieldBase(clazz, map, false, object) : TypeUtils.computeGetters(clazz, jSONType, map, object4, false, object);
        Object[] objectArray = new FieldInfo[object3.size()];
        object3.toArray(objectArray);
        if (stringArray != null && stringArray.length != 0) {
            object2 = bl ? TypeUtils.computeGettersWithFieldBase(clazz, map, true, object) : TypeUtils.computeGetters(clazz, jSONType, map, object4, true, object);
        } else {
            object2 = new ArrayList(object3);
            Collections.sort(object2);
        }
        Object[] objectArray2 = new FieldInfo[object2.size()];
        object2.toArray(objectArray2);
        if (Arrays.equals(objectArray2, objectArray)) {
            objectArray2 = objectArray;
        }
        return new SerializeBeanInfo(clazz, jSONType, string, string2, n2, (FieldInfo[])objectArray, (FieldInfo[])objectArray2);
    }

    public static List<FieldInfo> computeGettersWithFieldBase(Class<?> clazz, Map<String, String> map, boolean bl, PropertyNamingStrategy propertyNamingStrategy) {
        LinkedHashMap<String, FieldInfo> linkedHashMap = new LinkedHashMap<String, FieldInfo>();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Field[] fieldArray = clazz2.getDeclaredFields();
            TypeUtils.computeFields(clazz2, map, propertyNamingStrategy, linkedHashMap, fieldArray);
        }
        return TypeUtils.getFieldInfos(clazz, bl, linkedHashMap);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> map) {
        return TypeUtils.computeGetters(clazz, map, true);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> map, boolean bl) {
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        ParserConfig.parserAllFieldToCache(clazz, hashMap);
        return TypeUtils.computeGetters(clazz, jSONType, map, hashMap, bl, PropertyNamingStrategy.CamelCase);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, JSONType jSONType, Map<String, String> map, Map<String, Field> map2, boolean bl, PropertyNamingStrategy propertyNamingStrategy) {
        LinkedHashMap<String, FieldInfo> linkedHashMap = new LinkedHashMap<String, FieldInfo>();
        boolean bl2 = TypeUtils.isKotlin(clazz);
        Constructor[] constructorArray = null;
        Annotation[][] annotationArray = null;
        Object[] objectArray = null;
        short[] sArray = null;
        Method[] methodArray = clazz.getMethods();
        for (Method method : methodArray) {
            Object object;
            Object object2;
            Object object3;
            String string = method.getName();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string2 = null;
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0 || method.getReturnType() == ClassLoader.class || string.equals("getMetaClass") && method.getReturnType().getName().equals("groovy.lang.MetaClass") || string.equals("getSuppressed") && method.getDeclaringClass() == Throwable.class || bl2 && TypeUtils.isKotlinIgnore(clazz, string)) continue;
            Boolean bl3 = false;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField == null) {
                jSONField = TypeUtils.getSuperMethodAnnotation(clazz, method);
            }
            if (jSONField == null && bl2) {
                int n5;
                if (constructorArray == null && (object3 = TypeUtils.getKotlinConstructor(constructorArray = clazz.getDeclaredConstructors())) != null) {
                    annotationArray = TypeUtils.getParameterAnnotations((Constructor)object3);
                    objectArray = TypeUtils.getKoltinConstructorParameters(clazz);
                    if (objectArray != null) {
                        object2 = new String[objectArray.length];
                        System.arraycopy(objectArray, 0, object2, 0, objectArray.length);
                        Arrays.sort((Object[])object2);
                        sArray = new short[objectArray.length];
                        for (n5 = 0; n5 < objectArray.length; n5 = (int)((short)(n5 + 1))) {
                            int n6 = Arrays.binarySearch((Object[])object2, objectArray[n5]);
                            sArray[n6] = n5;
                        }
                        objectArray = object2;
                    }
                }
                if (objectArray != null && sArray != null && string.startsWith("get")) {
                    object3 = TypeUtils.decapitalize(string.substring(3));
                    int n7 = Arrays.binarySearch(objectArray, object3);
                    if (n7 < 0) {
                        for (n5 = 0; n5 < objectArray.length; ++n5) {
                            if (!((String)object3).equalsIgnoreCase((String)objectArray[n5])) continue;
                            n7 = n5;
                            break;
                        }
                    }
                    if (n7 >= 0) {
                        n5 = sArray[n7];
                        Annotation[] annotationArray2 = annotationArray[n5];
                        if (annotationArray2 != null) {
                            object = annotationArray2;
                            int n8 = ((Annotation[])object).length;
                            for (int i2 = 0; i2 < n8; ++i2) {
                                Annotation annotation = object[i2];
                                if (!(annotation instanceof JSONField)) continue;
                                jSONField = (JSONField)annotation;
                                break;
                            }
                        }
                        if (jSONField == null && (object = ParserConfig.getFieldFromCache((String)object3, map2)) != null) {
                            jSONField = TypeUtils.getAnnotation((Field)object, JSONField.class);
                        }
                    }
                }
            }
            if (jSONField != null) {
                if (!jSONField.serialize()) continue;
                n2 = jSONField.ordinal();
                n3 = SerializerFeature.of(jSONField.serialzeFeatures());
                n4 = Feature.of(jSONField.parseFeatures());
                if (jSONField.name().length() != 0) {
                    object3 = jSONField.name();
                    if (map != null && (object3 = map.get(object3)) == null) continue;
                    object2 = new FieldInfo((String)object3, method, null, clazz, null, n2, n3, n4, jSONField, null, string2);
                    linkedHashMap.put((String)object3, (FieldInfo)object2);
                    continue;
                }
                if (jSONField.label().length() != 0) {
                    string2 = jSONField.label();
                }
            }
            if (string.startsWith("get")) {
                char c2;
                if (string.length() < 4 || string.equals("getClass") || string.equals("getDeclaringClass") && clazz.isEnum()) continue;
                char c3 = string.charAt(3);
                Field field = null;
                if (Character.isUpperCase(c3) || c3 > '\u0200') {
                    object2 = compatibleWithJavaBean ? TypeUtils.decapitalize(string.substring(3)) : Character.toLowerCase(string.charAt(3)) + string.substring(4);
                    object2 = TypeUtils.getPropertyNameByCompatibleFieldName(map2, string, (String)object2, 3);
                } else if (c3 == '_') {
                    object2 = string.substring(4);
                    field = map2.get(object2);
                    if (field == null) {
                        Object object4 = object2;
                        object2 = string.substring(3);
                        field = ParserConfig.getFieldFromCache((String)object2, map2);
                        if (field == null) {
                            object2 = object4;
                        }
                    }
                } else if (c3 == 'f') {
                    object2 = string.substring(3);
                } else if (string.length() >= 5 && Character.isUpperCase(string.charAt(4))) {
                    object2 = TypeUtils.decapitalize(string.substring(3));
                } else {
                    object2 = string.substring(3);
                    field = ParserConfig.getFieldFromCache((String)object2, map2);
                    if (field == null) continue;
                }
                boolean bl4 = TypeUtils.isJSONTypeIgnore(clazz, (String)object2);
                if (bl4) continue;
                if (field == null) {
                    field = ParserConfig.getFieldFromCache((String)object2, map2);
                }
                if (field == null && ((String)object2).length() > 1 && (c2 = ((String)object2).charAt(1)) >= 'A' && c2 <= 'Z') {
                    String string3 = TypeUtils.decapitalize(string.substring(3));
                    field = ParserConfig.getFieldFromCache(string3, map2);
                }
                object = null;
                if (field != null && (object = TypeUtils.getAnnotation(field, JSONField.class)) != null) {
                    if (!object.serialize()) continue;
                    n2 = object.ordinal();
                    n3 = SerializerFeature.of(object.serialzeFeatures());
                    n4 = Feature.of(object.parseFeatures());
                    if (object.name().length() != 0) {
                        bl3 = true;
                        object2 = object.name();
                        if (map != null && (object2 = map.get(object2)) == null) continue;
                    }
                    if (object.label().length() != 0) {
                        string2 = object.label();
                    }
                }
                if (map != null && (object2 = map.get(object2)) == null) continue;
                if (propertyNamingStrategy != null && !bl3.booleanValue()) {
                    object2 = propertyNamingStrategy.translate((String)object2);
                }
                FieldInfo fieldInfo = new FieldInfo((String)object2, method, field, clazz, null, n2, n3, n4, jSONField, (JSONField)object, string2);
                linkedHashMap.put((String)object2, fieldInfo);
            }
            if (!string.startsWith("is") || string.length() < 3 || method.getReturnType() != Boolean.TYPE && method.getReturnType() != Boolean.class) continue;
            char c4 = string.charAt(2);
            Field field = null;
            if (Character.isUpperCase(c4)) {
                object2 = compatibleWithJavaBean ? TypeUtils.decapitalize(string.substring(2)) : Character.toLowerCase(string.charAt(2)) + string.substring(3);
                object2 = TypeUtils.getPropertyNameByCompatibleFieldName(map2, string, (String)object2, 2);
            } else if (c4 == '_') {
                object2 = string.substring(3);
                field = map2.get(object2);
                if (field == null) {
                    Object object5 = object2;
                    object2 = string.substring(2);
                    field = ParserConfig.getFieldFromCache((String)object2, map2);
                    if (field == null) {
                        object2 = object5;
                    }
                }
            } else if (c4 == 'f') {
                object2 = string.substring(2);
            } else {
                object2 = string.substring(2);
                field = ParserConfig.getFieldFromCache((String)object2, map2);
                if (field == null) continue;
            }
            boolean bl5 = TypeUtils.isJSONTypeIgnore(clazz, (String)object2);
            if (bl5) continue;
            if (field == null) {
                field = ParserConfig.getFieldFromCache((String)object2, map2);
            }
            if (field == null) {
                field = ParserConfig.getFieldFromCache(string, map2);
            }
            object = null;
            if (field != null && (object = TypeUtils.getAnnotation(field, JSONField.class)) != null) {
                if (!object.serialize()) continue;
                n2 = object.ordinal();
                n3 = SerializerFeature.of(object.serialzeFeatures());
                n4 = Feature.of(object.parseFeatures());
                if (object.name().length() != 0) {
                    object2 = object.name();
                    if (map != null && (object2 = map.get(object2)) == null) continue;
                }
                if (object.label().length() != 0) {
                    string2 = object.label();
                }
            }
            if (map != null && (object2 = map.get(object2)) == null) continue;
            if (propertyNamingStrategy != null) {
                object2 = propertyNamingStrategy.translate((String)object2);
            }
            if (linkedHashMap.containsKey(object2)) continue;
            FieldInfo fieldInfo = new FieldInfo((String)object2, method, field, clazz, null, n2, n3, n4, jSONField, (JSONField)object, string2);
            linkedHashMap.put((String)object2, fieldInfo);
        }
        AccessibleObject[] accessibleObjectArray = clazz.getFields();
        TypeUtils.computeFields(clazz, map, propertyNamingStrategy, linkedHashMap, (Field[])accessibleObjectArray);
        return TypeUtils.getFieldInfos(clazz, bl, linkedHashMap);
    }

    private static List<FieldInfo> getFieldInfos(Class<?> clazz, boolean bl, Map<String, FieldInfo> map) {
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>();
        String[] stringArray = null;
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        if (jSONType != null) {
            stringArray = jSONType.orders();
        }
        if (stringArray != null && stringArray.length > 0) {
            LinkedHashMap<String, FieldInfo> linkedHashMap = new LinkedHashMap<String, FieldInfo>(arrayList.size());
            for (FieldInfo object : map.values()) {
                linkedHashMap.put(object.name, object);
            }
            boolean bl2 = false;
            for (String string : stringArray) {
                FieldInfo fieldInfo = (FieldInfo)linkedHashMap.get(string);
                if (fieldInfo == null) continue;
                arrayList.add(fieldInfo);
                linkedHashMap.remove(string);
            }
            for (FieldInfo fieldInfo : linkedHashMap.values()) {
                arrayList.add(fieldInfo);
            }
        } else {
            for (FieldInfo fieldInfo : map.values()) {
                arrayList.add(fieldInfo);
            }
            if (bl) {
                Collections.sort(arrayList);
            }
        }
        return arrayList;
    }

    private static void computeFields(Class<?> clazz, Map<String, String> map, PropertyNamingStrategy propertyNamingStrategy, Map<String, FieldInfo> map2, Field[] fieldArray) {
        for (Field field : fieldArray) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            JSONField jSONField = TypeUtils.getAnnotation(field, JSONField.class);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string = field.getName();
            String string2 = null;
            if (jSONField != null) {
                if (!jSONField.serialize()) continue;
                n2 = jSONField.ordinal();
                n3 = SerializerFeature.of(jSONField.serialzeFeatures());
                n4 = Feature.of(jSONField.parseFeatures());
                if (jSONField.name().length() != 0) {
                    string = jSONField.name();
                }
                if (jSONField.label().length() != 0) {
                    string2 = jSONField.label();
                }
            }
            if (map != null && (string = map.get(string)) == null) continue;
            if (propertyNamingStrategy != null) {
                string = propertyNamingStrategy.translate(string);
            }
            if (map2.containsKey(string)) continue;
            FieldInfo fieldInfo = new FieldInfo(string, null, field, clazz, null, n2, n3, n4, null, jSONField, string2);
            map2.put(string, fieldInfo);
        }
    }

    private static String getPropertyNameByCompatibleFieldName(Map<String, Field> map, String string, String string2, int n2) {
        if (compatibleWithFieldName && !map.containsKey(string2)) {
            String string3 = string.substring(n2);
            return map.containsKey(string3) ? string3 : string2;
        }
        return string2;
    }

    public static JSONField getSuperMethodAnnotation(Class<?> clazz, Method method) {
        Object object;
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray.length > 0) {
            object = method.getParameterTypes();
            for (Class<?> clazz2 : classArray) {
                for (Method method2 : clazz2.getMethods()) {
                    JSONField jSONField;
                    Class<?>[] classArray2 = method2.getParameterTypes();
                    if (classArray2.length != ((Object)object).length || !method2.getName().equals(method.getName())) continue;
                    boolean bl = true;
                    for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                        if (classArray2[i2].equals(object[i2])) continue;
                        bl = false;
                        break;
                    }
                    if (!bl || (jSONField = TypeUtils.getAnnotation(method2, JSONField.class)) == null) continue;
                    return jSONField;
                }
            }
        }
        if ((object = clazz.getSuperclass()) == null) {
            return null;
        }
        if (Modifier.isAbstract(((Class)object).getModifiers())) {
            Class<?>[] classArray3 = method.getParameterTypes();
            for (Method method3 : ((Class)object).getMethods()) {
                JSONField jSONField;
                Class<?>[] classArray4 = method3.getParameterTypes();
                if (classArray4.length != classArray3.length || !method3.getName().equals(method.getName())) continue;
                int n2 = 1;
                for (int i3 = 0; i3 < classArray3.length; ++i3) {
                    if (classArray4[i3].equals(classArray3[i3])) continue;
                    n2 = 0;
                    break;
                }
                if (n2 == 0 || (jSONField = TypeUtils.getAnnotation(method3, JSONField.class)) == null) continue;
                return jSONField;
            }
        }
        return null;
    }

    private static boolean isJSONTypeIgnore(Class<?> clazz, String string) {
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        if (jSONType != null) {
            String[] stringArray = jSONType.includes();
            if (stringArray.length > 0) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!string.equals(stringArray[i2])) continue;
                    return false;
                }
                return true;
            }
            stringArray = jSONType.ignores();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!string.equals(stringArray[i3])) continue;
                return true;
            }
        }
        if (clazz.getSuperclass() != Object.class && clazz.getSuperclass() != null) {
            return TypeUtils.isJSONTypeIgnore(clazz.getSuperclass(), string);
        }
        return false;
    }

    public static boolean isGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof Class) {
            Type type2 = ((Class)type).getGenericSuperclass();
            return type2 != Object.class && TypeUtils.isGenericParamType(type2);
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return type;
        }
        if (type instanceof Class) {
            return TypeUtils.getGenericParamType(((Class)type).getGenericSuperclass());
        }
        return type;
    }

    public static Type unwrapOptional(Type type) {
        ParameterizedType parameterizedType;
        if (!optionalClassInited) {
            try {
                optionalClass = Class.forName("java.util.Optional");
            }
            catch (Exception exception) {
            }
            finally {
                optionalClassInited = true;
            }
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == optionalClass) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    public static Class<?> getClass(Type type) {
        Type[] typeArray;
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type type2 = ((TypeVariable)type).getBounds()[0];
            if (type2 instanceof Class) {
                return (Class)type2;
            }
            return TypeUtils.getClass(type2);
        }
        if (type instanceof WildcardType && (typeArray = ((WildcardType)type).getUpperBounds()).length == 1) {
            return TypeUtils.getClass(typeArray[0]);
        }
        return Object.class;
    }

    public static Field getField(Class<?> clazz, String string, Field[] fieldArray) {
        for (Field field : fieldArray) {
            char c2;
            char c3;
            String string2 = field.getName();
            if (string.equals(string2)) {
                return field;
            }
            if (string.length() <= 2 || (c3 = string.charAt(0)) < 'a' || c3 > 'z' || (c2 = string.charAt(1)) < 'A' || c2 > 'Z' || !string.equalsIgnoreCase(string2)) continue;
            return field;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && clazz2 != Object.class) {
            return TypeUtils.getField(clazz2, string, clazz2.getDeclaredFields());
        }
        return null;
    }

    public static int getSerializeFeatures(Class<?> clazz) {
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        if (jSONType == null) {
            return 0;
        }
        return SerializerFeature.of(jSONType.serialzeFeatures());
    }

    public static int getParserFeatures(Class<?> clazz) {
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        if (jSONType == null) {
            return 0;
        }
        return Feature.of(jSONType.parseFeatures());
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (!setAccessibleEnable) {
            return;
        }
        if (accessibleObject.isAccessible()) {
            return;
        }
        try {
            accessibleObject.setAccessible(true);
        }
        catch (AccessControlException accessControlException) {
            setAccessibleEnable = false;
        }
    }

    public static Type getCollectionItemType(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeUtils.getCollectionItemType((ParameterizedType)type);
        }
        if (type instanceof Class) {
            return TypeUtils.getCollectionItemType((Class)type);
        }
        return Object.class;
    }

    private static Type getCollectionItemType(Class<?> clazz) {
        return clazz.getName().startsWith("java.") ? Object.class : TypeUtils.getCollectionItemType(TypeUtils.getCollectionSuperType(clazz));
    }

    private static Type getCollectionItemType(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getRawType();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (type == Collection.class) {
            return TypeUtils.getWildcardTypeUpperBounds(typeArray[0]);
        }
        Class clazz = (Class)type;
        Map<TypeVariable, Type> map = TypeUtils.createActualTypeMap(clazz.getTypeParameters(), typeArray);
        Type type2 = TypeUtils.getCollectionSuperType(clazz);
        if (type2 instanceof ParameterizedType) {
            Class<?> clazz2 = TypeUtils.getRawClass(type2);
            Type[] typeArray2 = ((ParameterizedType)type2).getActualTypeArguments();
            return typeArray2.length > 0 ? TypeUtils.getCollectionItemType(TypeUtils.makeParameterizedType(clazz2, typeArray2, map)) : TypeUtils.getCollectionItemType(clazz2);
        }
        return TypeUtils.getCollectionItemType((Class)type2);
    }

    private static Type getCollectionSuperType(Class<?> clazz) {
        Type type = null;
        for (Type type2 : clazz.getGenericInterfaces()) {
            Class<?> clazz2 = TypeUtils.getRawClass(type2);
            if (clazz2 == Collection.class) {
                return type2;
            }
            if (!Collection.class.isAssignableFrom(clazz2)) continue;
            type = type2;
        }
        return type == null ? clazz.getGenericSuperclass() : type;
    }

    private static Map<TypeVariable, Type> createActualTypeMap(TypeVariable[] typeVariableArray, Type[] typeArray) {
        int n2 = typeVariableArray.length;
        HashMap<TypeVariable, Type> hashMap = new HashMap<TypeVariable, Type>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            hashMap.put(typeVariableArray[i2], typeArray[i2]);
        }
        return hashMap;
    }

    private static ParameterizedType makeParameterizedType(Class<?> clazz, Type[] typeArray, Map<TypeVariable, Type> map) {
        int n2 = typeArray.length;
        Type[] typeArray2 = new Type[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            typeArray2[i2] = TypeUtils.getActualType(typeArray[i2], map);
        }
        return new ParameterizedTypeImpl(typeArray2, null, clazz);
    }

    private static Type getActualType(Type type, Map<TypeVariable, Type> map) {
        if (type instanceof TypeVariable) {
            return map.get(type);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.makeParameterizedType(TypeUtils.getRawClass(type), ((ParameterizedType)type).getActualTypeArguments(), map);
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(TypeUtils.getActualType(((GenericArrayType)type).getGenericComponentType(), map));
        }
        return type;
    }

    private static Type getWildcardTypeUpperBounds(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getUpperBounds();
            return typeArray.length > 0 ? typeArray[0] : Object.class;
        }
        return type;
    }

    public static Class<?> getCollectionItemClass(Type type) {
        if (type instanceof ParameterizedType) {
            Class clazz;
            WildcardType wildcardType;
            Type[] typeArray;
            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (type2 instanceof WildcardType && (typeArray = (wildcardType = (WildcardType)type2).getUpperBounds()).length == 1) {
                type2 = typeArray[0];
            }
            if (type2 instanceof Class) {
                clazz = (Class)type2;
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    throw new JSONException("can not create ASMParser");
                }
            } else {
                throw new JSONException("can not create ASMParser");
            }
            return clazz;
        }
        return Object.class;
    }

    public static Type checkPrimitiveArray(GenericArrayType genericArrayType) {
        Class clazz;
        Type type = genericArrayType;
        Type type2 = genericArrayType.getGenericComponentType();
        String string = "[";
        while (type2 instanceof GenericArrayType) {
            type2 = ((GenericArrayType)type2).getGenericComponentType();
            string = string + string;
        }
        if (type2 instanceof Class && (clazz = (Class)type2).isPrimitive()) {
            try {
                if (clazz == Boolean.TYPE) {
                    type = Class.forName(string + "Z");
                } else if (clazz == Character.TYPE) {
                    type = Class.forName(string + "C");
                } else if (clazz == Byte.TYPE) {
                    type = Class.forName(string + "B");
                } else if (clazz == Short.TYPE) {
                    type = Class.forName(string + "S");
                } else if (clazz == Integer.TYPE) {
                    type = Class.forName(string + "I");
                } else if (clazz == Long.TYPE) {
                    type = Class.forName(string + "J");
                } else if (clazz == Float.TYPE) {
                    type = Class.forName(string + "F");
                } else if (clazz == Double.TYPE) {
                    type = Class.forName(string + "D");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return type;
    }

    public static Collection createCollection(Type type) {
        Collection<Object> collection;
        Class clazz = TypeUtils.getRawClass(type);
        if (clazz == AbstractCollection.class || clazz == Collection.class) {
            collection = new ArrayList();
        } else if (clazz.isAssignableFrom(HashSet.class)) {
            collection = new HashSet();
        } else if (clazz.isAssignableFrom(LinkedHashSet.class)) {
            collection = new LinkedHashSet();
        } else if (clazz.isAssignableFrom(TreeSet.class)) {
            collection = new TreeSet();
        } else if (clazz.isAssignableFrom(ArrayList.class)) {
            collection = new ArrayList();
        } else if (clazz.isAssignableFrom(EnumSet.class)) {
            Object object = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
            collection = EnumSet.noneOf(object);
        } else if (clazz.isAssignableFrom(Queue.class) || clazz.isAssignableFrom(Deque.class)) {
            collection = new LinkedList();
        } else {
            try {
                collection = (Collection)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JSONException("create instance error, class " + clazz.getName());
            }
        }
        return collection;
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getUpperBounds();
            if (typeArray.length == 1) {
                return TypeUtils.getRawClass(typeArray[0]);
            }
            throw new JSONException("TODO");
        }
        throw new JSONException("TODO");
    }

    public static boolean isProxy(Class<?> clazz) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            String string = clazz2.getName();
            if (string.equals("net.sf.cglib.proxy.Factory") || string.equals("org.springframework.cglib.proxy.Factory")) {
                return true;
            }
            if (string.equals("javassist.util.proxy.ProxyObject") || string.equals("org.apache.ibatis.javassist.util.proxy.ProxyObject")) {
                return true;
            }
            if (!string.equals("org.hibernate.proxy.HibernateProxy")) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransient(Method method) {
        if (method == null) {
            return false;
        }
        if (!transientClassInited) {
            try {
                transientClass = Class.forName("java.beans.Transient");
            }
            catch (Exception exception) {
            }
            finally {
                transientClassInited = true;
            }
        }
        if (transientClass != null) {
            Annotation annotation = TypeUtils.getAnnotation(method, transientClass);
            return annotation != null;
        }
        return false;
    }

    public static boolean isAnnotationPresentOneToMany(Method method) {
        if (method == null) {
            return false;
        }
        if (class_OneToMany == null && !class_OneToMany_error) {
            try {
                class_OneToMany = Class.forName("javax.persistence.OneToMany");
            }
            catch (Throwable throwable) {
                class_OneToMany_error = true;
            }
        }
        return class_OneToMany != null && method.isAnnotationPresent(class_OneToMany);
    }

    public static boolean isAnnotationPresentManyToMany(Method method) {
        if (method == null) {
            return false;
        }
        if (class_ManyToMany == null && !class_ManyToMany_error) {
            try {
                class_ManyToMany = Class.forName("javax.persistence.ManyToMany");
            }
            catch (Throwable throwable) {
                class_ManyToMany_error = true;
            }
        }
        return class_ManyToMany != null && (method.isAnnotationPresent(class_OneToMany) || method.isAnnotationPresent(class_ManyToMany));
    }

    public static boolean isHibernateInitialized(Object object) {
        Constable constable;
        if (object == null) {
            return false;
        }
        if (method_HibernateIsInitialized == null && !method_HibernateIsInitialized_error) {
            try {
                constable = Class.forName("org.hibernate.Hibernate");
                method_HibernateIsInitialized = ((Class)constable).getMethod("isInitialized", Object.class);
            }
            catch (Throwable throwable) {
                method_HibernateIsInitialized_error = true;
            }
        }
        if (method_HibernateIsInitialized != null) {
            try {
                constable = (Boolean)method_HibernateIsInitialized.invoke(null, object);
                return (Boolean)constable;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public static double parseDouble(String string) {
        int n2 = string.length();
        if (n2 > 10) {
            return Double.parseDouble(string);
        }
        boolean bl = false;
        long l2 = 0L;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '-' && i2 == 0) {
                bl = true;
                continue;
            }
            if (c2 == '.') {
                if (n3 != 0) {
                    return Double.parseDouble(string);
                }
                n3 = n2 - i2 - 1;
                continue;
            }
            if (c2 >= '0' && c2 <= '9') {
                int n4 = c2 - 48;
                l2 = l2 * 10L + (long)n4;
                continue;
            }
            return Double.parseDouble(string);
        }
        if (bl) {
            l2 = -l2;
        }
        switch (n3) {
            case 0: {
                return l2;
            }
            case 1: {
                return (double)l2 / 10.0;
            }
            case 2: {
                return (double)l2 / 100.0;
            }
            case 3: {
                return (double)l2 / 1000.0;
            }
            case 4: {
                return (double)l2 / 10000.0;
            }
            case 5: {
                return (double)l2 / 100000.0;
            }
            case 6: {
                return (double)l2 / 1000000.0;
            }
            case 7: {
                return (double)l2 / 1.0E7;
            }
            case 8: {
                return (double)l2 / 1.0E8;
            }
            case 9: {
                return (double)l2 / 1.0E9;
            }
        }
        return Double.parseDouble(string);
    }

    public static float parseFloat(String string) {
        int n2 = string.length();
        if (n2 >= 10) {
            return Float.parseFloat(string);
        }
        boolean bl = false;
        long l2 = 0L;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '-' && i2 == 0) {
                bl = true;
                continue;
            }
            if (c2 == '.') {
                if (n3 != 0) {
                    return Float.parseFloat(string);
                }
                n3 = n2 - i2 - 1;
                continue;
            }
            if (c2 >= '0' && c2 <= '9') {
                int n4 = c2 - 48;
                l2 = l2 * 10L + (long)n4;
                continue;
            }
            return Float.parseFloat(string);
        }
        if (bl) {
            l2 = -l2;
        }
        switch (n3) {
            case 0: {
                return l2;
            }
            case 1: {
                return (float)l2 / 10.0f;
            }
            case 2: {
                return (float)l2 / 100.0f;
            }
            case 3: {
                return (float)l2 / 1000.0f;
            }
            case 4: {
                return (float)l2 / 10000.0f;
            }
            case 5: {
                return (float)l2 / 100000.0f;
            }
            case 6: {
                return (float)l2 / 1000000.0f;
            }
            case 7: {
                return (float)l2 / 1.0E7f;
            }
            case 8: {
                return (float)l2 / 1.0E8f;
            }
            case 9: {
                return (float)l2 / 1.0E9f;
            }
        }
        return Float.parseFloat(string);
    }

    public static long fnv1a_64_lower(String string) {
        long l2 = -3750763034362895579L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '_' || c2 == '-') continue;
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            l2 ^= (long)c2;
            l2 *= 1099511628211L;
        }
        return l2;
    }

    public static long fnv1a_64(String string) {
        long l2 = -3750763034362895579L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            l2 ^= (long)c2;
            l2 *= 1099511628211L;
        }
        return l2;
    }

    public static boolean isKotlin(Class clazz) {
        if (kotlin_metadata == null && !kotlin_metadata_error) {
            try {
                kotlin_metadata = Class.forName("kotlin.Metadata");
            }
            catch (Throwable throwable) {
                kotlin_metadata_error = true;
            }
        }
        return kotlin_metadata != null && clazz.isAnnotationPresent(kotlin_metadata);
    }

    public static Constructor getKotlinConstructor(Constructor[] constructorArray) {
        return TypeUtils.getKotlinConstructor(constructorArray, null);
    }

    public static Constructor getKotlinConstructor(Constructor[] constructorArray, String[] stringArray) {
        Constructor constructor = null;
        for (Constructor constructor2 : constructorArray) {
            Class<?>[] classArray = constructor2.getParameterTypes();
            if (stringArray != null && classArray.length != stringArray.length || classArray.length > 0 && classArray[classArray.length - 1].getName().equals("kotlin.jvm.internal.DefaultConstructorMarker") || constructor != null && constructor.getParameterTypes().length >= classArray.length) continue;
            constructor = constructor2;
        }
        return constructor;
    }

    public static String[] getKoltinConstructorParameters(Class clazz) {
        Class<Object> clazz2;
        if (kotlin_kclass_constructor == null && !kotlin_class_klass_error) {
            try {
                clazz2 = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
                kotlin_kclass_constructor = clazz2.getConstructor(Class.class);
            }
            catch (Throwable throwable) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kclass_constructor == null) {
            return null;
        }
        if (kotlin_kclass_getConstructors == null && !kotlin_class_klass_error) {
            try {
                clazz2 = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
                kotlin_kclass_getConstructors = clazz2.getMethod("getConstructors", new Class[0]);
            }
            catch (Throwable throwable) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kfunction_getParameters == null && !kotlin_class_klass_error) {
            try {
                clazz2 = Class.forName("kotlin.reflect.KFunction");
                kotlin_kfunction_getParameters = clazz2.getMethod("getParameters", new Class[0]);
            }
            catch (Throwable throwable) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kparameter_getName == null && !kotlin_class_klass_error) {
            try {
                clazz2 = Class.forName("kotlin.reflect.KParameter");
                kotlin_kparameter_getName = clazz2.getMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_error) {
            return null;
        }
        try {
            Object object;
            clazz2 = null;
            Object t2 = kotlin_kclass_constructor.newInstance(clazz);
            Iterable iterable = (Iterable)kotlin_kclass_getConstructors.invoke(t2, new Object[0]);
            Object object2 = iterable.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                List list = (List)kotlin_kfunction_getParameters.invoke(object, new Object[0]);
                if (clazz2 == null || list.size() != 0) {
                    clazz2 = object;
                }
                object2.hasNext();
            }
            if (clazz2 == null) {
                return null;
            }
            object2 = (List)kotlin_kfunction_getParameters.invoke(clazz2, new Object[0]);
            object = new String[object2.size()];
            for (int i2 = 0; i2 < object2.size(); ++i2) {
                Object e2 = object2.get(i2);
                object[i2] = (String)kotlin_kparameter_getName.invoke(e2, new Object[0]);
            }
            return object;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            kotlin_error = true;
            return null;
        }
    }

    private static boolean isKotlinIgnore(Class clazz, String string) {
        Object[] objectArray;
        if (kotlinIgnores == null && !kotlinIgnores_error) {
            try {
                objectArray = new HashMap();
                Class<?> clazz2 = Class.forName("kotlin.ranges.CharRange");
                objectArray.put(clazz2, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> clazz3 = Class.forName("kotlin.ranges.IntRange");
                objectArray.put(clazz3, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> clazz4 = Class.forName("kotlin.ranges.LongRange");
                objectArray.put(clazz4, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> clazz5 = Class.forName("kotlin.ranges.ClosedFloatRange");
                objectArray.put(clazz5, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> clazz6 = Class.forName("kotlin.ranges.ClosedDoubleRange");
                objectArray.put(clazz6, new String[]{"getEndInclusive", "isEmpty"});
                kotlinIgnores = objectArray;
            }
            catch (Throwable throwable) {
                kotlinIgnores_error = true;
            }
        }
        if (kotlinIgnores == null) {
            return false;
        }
        objectArray = kotlinIgnores.get(clazz);
        return objectArray != null && Arrays.binarySearch(objectArray, string) >= 0;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> clazz2) {
        int n2;
        Object object;
        A a2 = clazz.getAnnotation(clazz2);
        Class clazz3 = null;
        Type type = JSON.getMixInAnnotations(clazz);
        if (type instanceof Class) {
            clazz3 = (Class)type;
        }
        if (clazz3 != null) {
            object = clazz3.getAnnotation(clazz2);
            if (object == null && clazz3.getAnnotations().length > 0) {
                Annotation annotation;
                Annotation[] annotationArray = clazz3.getAnnotations();
                n2 = annotationArray.length;
                for (int i2 = 0; i2 < n2 && (object = (annotation = annotationArray[i2]).annotationType().getAnnotation(clazz2)) == null; ++i2) {
                }
            }
            if (object != null) {
                return object;
            }
        }
        if (a2 == null && clazz.getAnnotations().length > 0) {
            A a3;
            object = clazz.getAnnotations();
            int n3 = ((A)object).length;
            for (n2 = 0; n2 < n3 && (a2 = (a3 = object[n2]).annotationType().getAnnotation(clazz2)) == null; ++n2) {
            }
        }
        return a2;
    }

    public static <A extends Annotation> A getAnnotation(Field field, Class<A> clazz) {
        A a2 = field.getAnnotation(clazz);
        Class<?> clazz2 = field.getDeclaringClass();
        Class clazz3 = null;
        Type type = JSON.getMixInAnnotations(clazz2);
        if (type instanceof Class) {
            clazz3 = (Class)type;
        }
        if (clazz3 != null) {
            Field field2 = null;
            String string = field.getName();
            for (Class clazz4 = clazz3; clazz4 != null && clazz4 != Object.class; clazz4 = clazz4.getSuperclass()) {
                try {
                    field2 = clazz4.getDeclaredField(string);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            if (field2 == null) {
                return a2;
            }
            A a3 = field2.getAnnotation(clazz);
            if (a3 != null) {
                return a3;
            }
        }
        return a2;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> clazz) {
        A a2 = method.getAnnotation(clazz);
        Class<?> clazz2 = method.getDeclaringClass();
        Class clazz3 = null;
        Type type = JSON.getMixInAnnotations(clazz2);
        if (type instanceof Class) {
            clazz3 = (Class)type;
        }
        if (clazz3 != null) {
            Method method2 = null;
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            for (Class clazz4 = clazz3; clazz4 != null && clazz4 != Object.class; clazz4 = clazz4.getSuperclass()) {
                try {
                    method2 = clazz4.getDeclaredMethod(string, classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (method2 == null) {
                return a2;
            }
            A a3 = method2.getAnnotation(clazz);
            if (a3 != null) {
                return a3;
            }
        }
        return a2;
    }

    public static Annotation[][] getParameterAnnotations(Method method) {
        Annotation[][] annotationArray = method.getParameterAnnotations();
        Class<?> clazz = method.getDeclaringClass();
        Class clazz2 = null;
        Type type = JSON.getMixInAnnotations(clazz);
        if (type instanceof Class) {
            clazz2 = (Class)type;
        }
        if (clazz2 != null) {
            Method method2 = null;
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            for (Class clazz3 = clazz2; clazz3 != null && clazz3 != Object.class; clazz3 = clazz3.getSuperclass()) {
                try {
                    method2 = clazz3.getDeclaredMethod(string, classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (method2 == null) {
                return annotationArray;
            }
            Annotation[][] annotationArray2 = method2.getParameterAnnotations();
            if (annotationArray2 != null) {
                return annotationArray2;
            }
        }
        return annotationArray;
    }

    public static Annotation[][] getParameterAnnotations(Constructor constructor) {
        Annotation[][] annotationArray = constructor.getParameterAnnotations();
        Class clazz = constructor.getDeclaringClass();
        Class clazz2 = null;
        Type type = JSON.getMixInAnnotations(clazz);
        if (type instanceof Class) {
            clazz2 = (Class)type;
        }
        if (clazz2 != null) {
            Constructor constructor2 = null;
            Class<?>[] classArray = constructor.getParameterTypes();
            ArrayList arrayList = new ArrayList(2);
            for (Class<?> clazz3 = clazz2.getEnclosingClass(); clazz3 != null; clazz3 = clazz3.getEnclosingClass()) {
                arrayList.add(clazz3);
            }
            int n2 = arrayList.size();
            for (Class clazz4 = clazz2; clazz4 != null && clazz4 != Object.class; clazz4 = clazz4.getSuperclass()) {
                try {
                    if (n2 != 0) {
                        Class[] classArray2 = new Class[n2 + classArray.length];
                        System.arraycopy(classArray, 0, classArray2, n2, classArray.length);
                        for (int i2 = n2; i2 > 0; --i2) {
                            classArray2[i2 - 1] = (Class)arrayList.get(i2 - 1);
                        }
                        constructor2 = clazz2.getDeclaredConstructor(classArray2);
                        break;
                    }
                    constructor2 = clazz2.getDeclaredConstructor(classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    --n2;
                    continue;
                }
            }
            if (constructor2 == null) {
                return annotationArray;
            }
            Annotation[][] annotationArray2 = constructor2.getParameterAnnotations();
            if (annotationArray2 != null) {
                return annotationArray2;
            }
        }
        return annotationArray;
    }

    public static boolean isJacksonCreator(Method method) {
        if (method == null) {
            return false;
        }
        if (class_JacksonCreator == null && !class_JacksonCreator_error) {
            try {
                class_JacksonCreator = Class.forName("com.fasterxml.jackson.annotation.JsonCreator");
            }
            catch (Throwable throwable) {
                class_JacksonCreator_error = true;
            }
        }
        return class_JacksonCreator != null && method.isAnnotationPresent(class_JacksonCreator);
    }

    public static LocalDateTime castToLocalDateTime(Object object, String string) {
        if (object == null) {
            return null;
        }
        if (string == null) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(string);
        return LocalDateTime.parse(object.toString(), dateTimeFormatter);
    }

    static {
        oracleDateMethodInited = false;
        optionalClassInited = false;
        transientClassInited = false;
        class_OneToMany = null;
        class_OneToMany_error = false;
        class_ManyToMany = null;
        class_ManyToMany_error = false;
        method_HibernateIsInitialized = null;
        method_HibernateIsInitialized_error = false;
        mappings = new ConcurrentHashMap(256, 0.75f, 1);
        pathClass_error = false;
        class_JacksonCreator = null;
        class_JacksonCreator_error = false;
        class_Clob = null;
        class_Clob_error = false;
        class_XmlAccessType = null;
        class_XmlAccessorType = null;
        classXmlAccessorType_error = false;
        method_XmlAccessorType_value = null;
        field_XmlAccessType_FIELD = null;
        field_XmlAccessType_FIELD_VALUE = null;
        try {
            compatibleWithJavaBean = "true".equals(IOUtils.getStringProperty("fastjson.compatibleWithJavaBean"));
            compatibleWithFieldName = "true".equals(IOUtils.getStringProperty("fastjson.compatibleWithFieldName"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TypeUtils.addBaseClassMappings();
    }
}

