/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsigninterface;

import cn.com.infosec.jce.oscca.OSCCAMessageDigest;
import cn.com.infosec.jce.oscca.SM2;
import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.der.util.DERSegment;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class SignatureUtil {
    public static byte[] sign(byte[] plainText, PrivateKey prik, String digestAlg, byte[] id, X509Certificate signCert) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        if (prik instanceof RSAPrivateKey) {
            Signature sig = Signature.getInstance(String.valueOf(digestAlg) + "withRSA", "INFOSEC");
            sig.initSign(prik);
            sig.update(plainText);
            return sig.sign();
        }
        if (prik instanceof JCESM2PrivateKey) {
            JCESM2PublicKey pubk = (JCESM2PublicKey)signCert.getPublicKey();
            byte[] digest = null;
            digest = digestAlg.toUpperCase().equals("SM3") ? OSCCAMessageDigest.SM3Digest((byte[])id, (byte[])pubk.getX(), (byte[])pubk.getY(), (byte[])plainText) : OSCCAMessageDigest.SHADigest((String)digestAlg, (byte[])id, (byte[])pubk.getX(), (byte[])pubk.getY(), (byte[])plainText);
            return SM2.signHash((byte[])digest, (byte[])((JCESM2PrivateKey)prik).getD());
        }
        throw new InvalidKeyException("Unsupport private key type: " + prik.getClass());
    }

    public static boolean verify(byte[] plainText, byte[] signedText, PublicKey pubk, String digestAlg, byte[] id) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        if (pubk instanceof RSAPublicKey) {
            Signature sig = Signature.getInstance(String.valueOf(digestAlg) + "withRSA", "INFOSEC");
            sig.initVerify(pubk);
            sig.update(plainText);
            return sig.verify(signedText);
        }
        if (pubk instanceof JCESM2PublicKey) {
            JCESM2PublicKey sm2Pubk = (JCESM2PublicKey)pubk;
            byte[] digest = null;
            digest = digestAlg.toUpperCase().equals("SM3") ? OSCCAMessageDigest.SM3Digest((byte[])id, (byte[])sm2Pubk.getX(), (byte[])sm2Pubk.getY(), (byte[])plainText) : OSCCAMessageDigest.SHADigest((String)digestAlg, (byte[])id, (byte[])sm2Pubk.getX(), (byte[])sm2Pubk.getY(), (byte[])plainText);
            signedText = SignatureUtil.formatSignedMsg(signedText);
            byte[] kbs = new byte[64];
            System.arraycopy(sm2Pubk.getX(), 0, kbs, 0, 32);
            System.arraycopy(sm2Pubk.getY(), 0, kbs, 32, 32);
            return SM2.verifyHash((byte[])digest, (byte[])signedText, (byte[])kbs);
        }
        throw new InvalidKeyException("Unsupport public key type: " + pubk.getClass());
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] formatSignedMsg(byte[] signed) throws SignatureException {
        if (signed.length != 64) ** GOTO lbl6
        return signed;
lbl-1000:
        // 1 sources

        {
            tmp = new byte[signed.length - 1];
            System.arraycopy(signed, 1, tmp, 0, tmp.length);
            signed = tmp;
lbl6:
            // 2 sources

            ** while (signed[0] == 0)
        }
lbl7:
        // 1 sources

        if (signed[0] != 48) {
            throw new SignatureException("Bad signature structon");
        }
        signedf = new byte[64];
        try {
            ds = new DERSegment(signed);
            ds = ds.getInnerDERSegment();
            tmp = ds.nextDERSegment().getInnerData();
            System.arraycopy(tmp, tmp.length - 32, signedf, 0, 32);
            tmp = ds.nextDERSegment().getInnerData();
            System.arraycopy(tmp, tmp.length - 32, signedf, 32, 32);
            return signedf;
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }
}

