/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsigninterface.util;

import java.io.FileOutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Debugger {
    private static int debug = 10;
    private static SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");

    public static void debug(byte[] bs, int level) {
        if (level >= debug || bs != null) {
            int i = 0;
            int length = bs.length;
            while (i < length) {
                int x = bs[i] & 0xFF;
                System.out.print(String.valueOf(Integer.toString(x, 16)) + " ");
                if ((i + 1) % 32 == 0) {
                    System.out.print("\n");
                }
                ++i;
            }
            System.out.print("\n");
        }
    }

    public static void debug(String title, byte[] bs, int level) {
        Debugger.debug(String.valueOf(title) + ":", level);
        Debugger.debug(bs, level);
    }

    public static void debug(String title, byte[] bs) {
        Debugger.debug(String.valueOf(title) + ":", 11);
        Debugger.debug(bs, 11);
    }

    public static void debug(byte[] bs, String file, int level) {
        if (level >= debug && bs != null) {
            try {
                FileOutputStream out = new FileOutputStream(file);
                out.write(bs);
                out.flush();
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void debug(String msg, int level) {
        if (level >= debug) {
            System.out.println(msg);
        }
    }

    public static void error(String msg, byte[] info, Exception e, int level) {
        StringBuffer buf = new StringBuffer();
        buf.append("============Error log of NetSign============\n");
        buf.append("Time:" + format.format(new Date()) + "\n");
        if (msg != null) {
            buf.append(String.valueOf(msg) + "\n");
        }
        if (info != null) {
            BigInteger bi = new BigInteger(info);
            String hex = bi.toString(16);
            hex = hex.length() % 2 == 0 ? hex : "0" + hex;
            char[] chars = hex.toCharArray();
            int line = 48;
            int i = 0;
            int length = chars.length;
            while (i < length) {
                buf.append(chars[i]);
                buf.append(chars[i + 1]);
                buf.append(" ");
                if ((++i + 1) % line == 0) {
                    buf.append("\n");
                }
                ++i;
            }
            buf.append("\n");
        }
        if (e != null) {
            buf.append(String.valueOf(e.toString()) + "\n");
            StackTraceElement[] elements = e.getStackTrace();
            int i = 0;
            int length = elements.length;
            while (i < length) {
                buf.append(String.valueOf(elements[i].toString()) + "\n");
                ++i;
            }
        }
        buf.append("============================================\n");
        Debugger.debug(buf.toString(), level);
    }
}

