/*
 * Decompiled with CFR 0.152.
 */
package com.infosec.test;

import cn.com.infosec.jce.PKCS7SignedData;
import cn.com.infosec.netsigninterface.util.ConsoleLogger;
import cn.com.infosec.util.Base64;
import com.infosec.NetSignServer;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.PropertyResourceBundle;
import javax.crypto.Cipher;

public class Test {
    static NetSignServer nss = null;

    public static void main(String[] args) throws Exception {
        Test.testInit();
        Test.testCase();
    }

    public static void getMethodList() throws Exception {
        Class<?> c = Class.forName("com.infosec.NetSignServer");
        Method[] ms = c.getMethods();
        int i = 0;
        int length = ms.length;
        while (i < length) {
            System.out.println(ms[i].toString());
            ++i;
        }
    }

    public static void testSignAndVerify() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        nss.NSSetDateFormat(df);
        nss.NSSetPlainText("11111111".getBytes());
        byte[] result = nss.NSDetachedSign("CN=5year,O=syn080924,C=cn");
        nss.NSDetachedVerify(result, "11111111".getBytes());
        System.out.println(nss.getLastErrnum());
        int i = 1;
        while (i < 6) {
            System.out.println(nss.NSGetSignerCertInfo(i));
            ++i;
        }
        nss.NSSetPlainText("11111111".getBytes());
        result = nss.NSSignedAndEncryptedEnvelop("CN=5year,O=syn080924,C=cn", "CN=5year,O=syn080924,C=cn");
        nss.NSDecryptedAndVerifiedEnvelop(result, "CN=5year,O=syn080924,C=cn");
        i = 1;
        while (i < 6) {
            System.out.println(nss.NSGetSignerCertInfo(i));
            ++i;
        }
        i = 1;
        while (i < 6) {
            System.out.println(nss.NSGetReciptCertInfo(i));
            ++i;
        }
    }

    public static void testParseCert() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new FileInputStream("D:/TEMP/temCert2.cer"));
        System.out.println(cert.getSubjectDN().getName());
        System.out.println(cert.getSubjectX500Principal().getName());
        cf = CertificateFactory.getInstance("X.509");
        cert = (X509Certificate)cf.generateCertificate(new FileInputStream("D:/TEMP/temCert.cer"));
        System.out.println(cert.getSubjectDN().getName());
        System.out.println(cert.getSubjectX500Principal().getName());
    }

    public static void getFormFiles(byte[] plainContent) throws Exception {
        ConsoleLogger.logString("length of content:" + plainContent.length);
        int pos = Integer.parseInt(new String(plainContent, 0, 8), 10) + 16;
        ConsoleLogger.logString("pos:" + pos);
        int fLen = 0;
        int fNameLen = 0;
        byte[] fContent = null;
        while (pos < plainContent.length) {
            fLen = Integer.parseInt(new String(plainContent, pos, 8), 10);
            ConsoleLogger.logString("length of fLen:" + fLen);
            ConsoleLogger.logString("pos:" + (pos += 8));
            fNameLen = Integer.parseInt(new String(plainContent, pos, 8), 10);
            ConsoleLogger.logString("length of fname:" + fNameLen);
            byte[] fName = new byte[fNameLen];
            System.arraycopy(plainContent, pos += 8, fName, 0, fNameLen);
            ConsoleLogger.logString("pos:" + (pos += fNameLen));
            fContent = new byte[300911];
            ConsoleLogger.logString("length of content:" + (fLen - fNameLen - 8));
            System.arraycopy(plainContent, pos, fContent, 0, fContent.length);
            pos += fLen - fNameLen - 8;
            ConsoleLogger.logBinary(new String(fName), fContent);
        }
    }

    private static void testUnpackage() throws Exception {
        FileInputStream in = new FileInputStream("d:/TEMP/jtyh/xml.p7b");
        byte[] bs = new byte[in.available()];
        in.read(bs);
        bs = Base64.decode((byte[])bs);
        bs = Base64.decode((byte[])bs);
        ConsoleLogger.isSave = true;
        ConsoleLogger.saveBinary("d:/TEMP/jtyh/xmlb.p7b", bs);
        PKCS7SignedData p7 = new PKCS7SignedData(bs);
        byte[] content = p7.getContentData();
        ConsoleLogger.saveBinaryasHEX("d:/TEMP/jtyh/xmlcontenthex.txt", content);
        Test.getFormFiles(content);
        in = new FileInputStream("d:/TEMP/jtyh/web.xml");
        bs = new byte[in.available()];
        in.read(bs);
        ConsoleLogger.logString("length of web.xml:" + bs.length);
        ConsoleLogger.saveBinaryasHEX("d:/TEMP/jtyh/webhex.txt", bs);
    }

    private static void testDetachedVerify() throws Exception {
        PropertyResourceBundle res = new PropertyResourceBundle(new FileInputStream("D:/WORK/myjava/infosec/netsign/ICBC_NetSign18/netsign.properties"));
        nss = new NetSignServer(res);
        String plainText = "ff";
        nss.NSSetPlainText("ff".getBytes());
        byte[] bs = nss.NSDetachedSign("C=CN,O=\u7f8e\u7684\u96c6\u56e2,OU=netcertadmin,CN=firstpa");
        nss.NSDetachedVerify(bs, plainText.getBytes());
        System.out.println(nss.getLastErrnum());
    }

    private static void testAttachedVerify() throws Exception {
        FileInputStream in = new FileInputStream("d:/TEMP/meidi/1.p7b");
        byte[] bs = new byte[in.available()];
        in.read(bs);
        in.close();
        PropertyResourceBundle res = new PropertyResourceBundle(new FileInputStream("D:/WORK/myjava/infosec/netsign/ICBC_NetSign18/netsign.properties"));
        nss = new NetSignServer(res);
        nss.NSAttachedVerify(bs);
        System.out.println("verify result:" + nss.getLastErrnum());
        byte[] plain = nss.GetCommonPlainText();
        ConsoleLogger.logString(new String(plain));
        ConsoleLogger.logBinary("plain", plain);
    }

    private static void testRAWVerify3() throws Exception {
        String signedStr = "TUN3Q0ZDb2dVbVpYVy9JUi92RUpRQUdWanJVdkJEaHZBaFJkNUEzNktrN2Uvc2FzN05FRVR4NjJaK0hZUEE9PQ==";
        byte[] signed = Base64.decode((String)signedStr);
        ConsoleLogger.logString(new String(signed));
        ConsoleLogger.logBinary("signed", signed);
        String plainText = "MTA4NEExMTAwMDAwMDAwMEY0RkMxMDg0QTExMDAwMDAwMDAwRlVJQm51bGwtbnVsbG51bGw4NTk1MC4wMDAwMDAwMDg1OTUwLjAwMDAwMDAw";
        byte[] plain = Base64.decode((byte[])plainText.getBytes("GBK"));
        ConsoleLogger.logBinary("plaintext", plain);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        FileInputStream in = new FileInputStream("D:\\TEMP\\nc\\xxx.cer");
        byte[] bs = new byte[in.available()];
        in.read(bs);
        bs = Base64.decode((byte[])bs);
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bs));
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", "INFOSEC");
        c.init(2, cert.getPublicKey());
        byte[] de = c.doFinal(signed);
        ConsoleLogger.logBinary("decrypted", de);
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] digest = md.digest(plain);
        ConsoleLogger.logBinary("digest", digest);
    }

    private static byte[] upsetdown(byte[] signed) {
        byte[] usd = new byte[signed.length];
        int i = 0;
        int length = signed.length;
        while (i < length) {
            usd[i] = signed[length - i - 1];
            ++i;
        }
        return usd;
    }

    private static void testRAWVerify2() throws Exception {
        String signedStr = "OdoQpdJTpAC5aggvOUN0hamULPO2kNKE9c0gybvXfK/Q5B0bshlrx2EwA68Cluc9Zedv/lDFY9SfRASiS5KjE5ODaxA9DvT0aZFckK7jJjhpBfXj9EqOr1uyQdKN9C1qxUKDFmwjR0KXXHDMq9ogTd57XJQhMBJPgyuilJYwt1E=";
        byte[] signed = Base64.decode((String)signedStr);
        ConsoleLogger.logBinary("signed", signed);
        String plainText = "bnVsbG51bGwwMDAxMDAwMDAwMDAwMDAwMDAwMW51bGwyLjMyMDAwMDAw";
        byte[] plain = Base64.decode((String)plainText);
        ConsoleLogger.logBinary("plaintext", plain);
        String modules = "a1599d6b1a5ac5bd152df774804d4404aae4890b5e7b823814ff8351253b49a633456e277dad4a019db08db08a9ac7c052c47781f8e51592b3f5768a44b2d7cf7fda0485019eadc339921a6531fd5e8ccc9616caa4f4b72d9352a8adfa955c8c8aae019c9139b9b87d6ddaf6bccd03211bdb10b9f8273a8d6910c86c5c1ebfe7";
        BigInteger n = new BigInteger(modules, 16);
        String exponet = "10001";
        BigInteger e = new BigInteger(exponet, 16);
        BigInteger c = new BigInteger(signed);
        BigInteger dc = c.modPow(e, n);
        byte[] de = dc.toByteArray();
        ConsoleLogger.logBinary("decrypted", de);
    }

    private static void testRAWVerify() throws Exception {
        String signedStr = "NPFXhqPeENZpSDzdcPhDdv4CwUHlFoKH9Ofyqhv4BdBz97C3SBH/oz1TgTx0UBuGT6ByZTEy/s8IG1kspGKPodYfK4sgAJ9yIZ1UYELuUjqmolaLoiUXmYjyqTV4Q6+bF6Jf2dsdAoD9KjVjpHd9RYz1iW3ld2Q9OK117mmaKiw=";
        String plainText = "Q1BHaWJ0dnVxaGJHeGlrWA==";
        FileInputStream in = new FileInputStream("D:\\TEMP\\nc\\user.cer");
        byte[] bs = new byte[in.available()];
        in.read(bs);
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INOFSEC");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bs));
        nss.NSVerifyPlainSignedMsg(Base64.decode((String)plainText), signedStr, cert);
        System.out.println("verify result:" + nss.getLastErrnum());
    }

    private static void testInit() {
        try {
            PropertyResourceBundle res = new PropertyResourceBundle(new FileInputStream("D:/WORK/myjava/infosec/netsign/SM2_NetSign1.8/netsign.properties"));
            nss = new NetSignServer(res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testRAWSign() {
        try {
            byte[] plain = "3031000000062013031800075363|2013-03-18T09:59:53|1|1.00|35001303188200000772|3031000000062013031800075363|C200|CNY1.00|2013-03-18T09:59:53|X|35000051000001072|\u4e2d\u56fd\u5149\u5927\u94f6\u884c|AT01|303100000006|303100000006|304100040000|304100040000|\u534e\u590f\u5317\u4eac\u6d4b\u8bd51|6226330170300012|02001|".getBytes("utf-8");
            byte[] bs = nss.NSRAWSign(plain, "C=CN,O=CFCA TEST CA,OU=CNAPS,OU=Enterprises,CN=041@Z303100000006@CEB@00000001");
            System.out.println(new String(bs));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testAttachedAfterwardsVerify() {
        FileInputStream in = null;
        try {
            in = new FileInputStream("d:/temp/dyl/signed.p7b");
            byte[] bs = new byte[in.available()];
            in.read(bs);
            String signedMsg = new String(bs);
            PropertyResourceBundle res = new PropertyResourceBundle(new FileInputStream("D:/WORK/myjava/infosec/netsign/ICBC_NetSign18/netsign.properties"));
            NetSignServer nss = new NetSignServer(res);
            nss.NSAttachedAfterwardVerify(signedMsg);
            int errorNum = nss.getLastErrnum();
            if (errorNum > -1) {
                String plainText = new String(nss.GetCommonPlainText());
                System.out.println("\u539f\u6587:" + plainText);
                nss.getTotle();
                byte[] formItem = null;
                while ((formItem = nss.GetFormItem()).length > 0) {
                    System.out.println("\u8868\u5355:" + new String(formItem));
                }
                byte[][] fileItem = null;
                while ((fileItem = nss.GetFileInfo()).length > 0) {
                    System.out.println("\u6587\u4ef6\u540d:" + new String(fileItem[0]));
                    ConsoleLogger.logBinary("\u6587\u4ef6\u5185\u5bb9", fileItem[1]);
                }
            } else {
                System.out.println("\u9519\u8bef\u4ee3\u7801:" + errorNum);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testCase() throws Exception {
        String encryptSubject;
        nss.NSSetPlainText("1111111".getBytes());
        System.out.println("test functions");
        String signSubject = "CN=testsm2_1,O=infosec";
        signSubject = encryptSubject = "CN=5year,O=syn080924,C=cn";
        X509Certificate signCert = null;
        System.out.println("Attached Sign and Verify");
        byte[] result = nss.NSAttachedSign(signSubject);
        System.out.println(nss.getLastErrnum());
        System.out.println(new String(result));
        nss.NSAttachedVerify(result);
        System.out.println("result:" + nss.getLastErrnum());
        signCert = nss.NSGetSignCert();
        System.out.println("Detached Sign and Verify");
        result = nss.NSDetachedSign(signSubject);
        System.out.println(new String(result));
        nss.NSDetachedVerify(result, "111111".getBytes());
        System.out.println("result:" + nss.getLastErrnum());
        System.out.println("RAW Sign and Verify");
        result = nss.NSRAWSign("11111111".getBytes(), signSubject);
        System.out.println(new String(result));
        nss.NSVerifyPlainSignedMsg("11111111".getBytes(), new String(result), signCert);
        System.out.println("result:" + nss.getLastErrnum());
        System.out.println("Envelop encrypt and decrypt");
        result = nss.NSEncryptedEnvelop(encryptSubject);
        System.out.println("result:" + nss.getLastErrnum());
        System.out.println(new String(result));
        nss.NSDecryptedEnvelop(result, encryptSubject);
        System.out.println("result:" + nss.getLastErrnum());
        System.out.println("Sign and Envelop encrypt and decrypt");
        result = nss.NSSignedAndEncryptedEnvelop(signSubject, encryptSubject);
        System.out.println(new String(result));
        nss.NSDecryptedAndVerifiedEnvelop(result, encryptSubject);
        System.out.println("result:" + nss.getLastErrnum());
    }
}

