/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DERBitString;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.x509.GeneralNames;

public class IssuerSerial
implements DEREncodable {
    GeneralNames issuer;
    DERInteger serial;
    DERBitString issuerUID;

    public IssuerSerial(ASN1Sequence seq) {
        this.issuer = GeneralNames.getInstance(seq.getObjectAt(0));
        this.serial = (DERInteger)seq.getObjectAt(1);
        if (seq.size() == 3) {
            this.issuerUID = (DERBitString)seq.getObjectAt(2);
        }
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public DERInteger getSerial() {
        return this.serial;
    }

    public DERBitString getIssuerUID() {
        return this.issuerUID;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.issuer);
        v.add(this.serial);
        if (this.issuerUID != null) {
            v.add(this.issuerUID);
        }
        return new DERSequence(v);
    }
}

