/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.DERBitString;

public class KeyUsage
extends DERBitString {
    public static final int digitalSignature = 128;
    public static final int nonRepudiation = 64;
    public static final int keyEncipherment = 32;
    public static final int dataEncipherment = 16;
    public static final int keyAgreement = 8;
    public static final int keyCertSign = 4;
    public static final int cRLSign = 2;
    public static final int encipherOnly = 1;
    public static final int decipherOnly = 32768;

    public KeyUsage(int usage) {
        super(KeyUsage.getBytes(usage), KeyUsage.getPadBits(usage));
    }

    public KeyUsage(DERBitString usage) {
        super(usage.getBytes(), usage.getPadBits());
    }

    public String toString() {
        if (this.data.length == 1) {
            return "KeyUsage: 0x" + Integer.toHexString(this.data[0] & 0xFF);
        }
        return "KeyUsage: 0x" + Integer.toHexString((this.data[1] & 0xFF) << 8 | this.data[0] & 0xFF);
    }

    public boolean[] getKeyUsage() {
        byte[] bKeyUsage = this.getBytes();
        int length = bKeyUsage.length * 8 - this.getPadBits();
        boolean[] keyUsage = new boolean[length < 9 ? 9 : length];
        int i = 0;
        while (i != length) {
            keyUsage[i] = (bKeyUsage[i / 8] & 128 >>> i % 8) != 0;
            ++i;
        }
        return keyUsage;
    }
}

