/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.x509.CRLReason;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.AbstractStandardExtension;

public class ReasonCodeExt
extends AbstractStandardExtension {
    public static final int UNSPECIFIED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int REMOVE_FROM_CRL = 8;
    public static final int PRIVILEGE_WITHDRAWN = 9;
    public static final int AA_COMPROMISE = 10;
    private int reasonCode = 0;

    public ReasonCodeExt() {
        this.critical = false;
        this.OID = X509Extensions.ReasonCode.getId();
        this.reasonCode = 0;
    }

    public void setReasonCode(int value) {
        this.reasonCode = value;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public byte[] encode() {
        return new DEROctetString(new CRLReason(this.reasonCode).getDERObject()).getOctets();
    }
}

