/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.DERBitString;
import com.cfca.util.pki.asn1.DERGeneralizedTime;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.ocsp.BasicOCSPResponse;
import com.cfca.util.pki.asn1.ocsp.CertStatus;
import com.cfca.util.pki.asn1.ocsp.ResponseData;
import com.cfca.util.pki.asn1.ocsp.RevokedInfo;
import com.cfca.util.pki.asn1.ocsp.SingleResponse;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.CRLReason;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.ocsp.BasicOCSPResp;
import com.cfca.util.pki.ocsp.CertificateID;
import com.cfca.util.pki.ocsp.CertificateStatus;
import com.cfca.util.pki.ocsp.RespID;
import com.cfca.util.pki.ocsp.RevokedStatus;
import com.cfca.util.pki.ocsp.UnknownStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class BasicOCSPRespGenerator {
    private List list = new ArrayList();
    private X509Extensions responseExtensions = null;
    private RespID responderID;
    private static Hashtable algorithms = new Hashtable();

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD2WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD5WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("SHA1WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("RIPEMD160WITHRSA", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("SHA1WITHDSA", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("DSAWITHSHA1", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("SHA1WITHECDSA", new DERObjectIdentifier("1.2.840.10045.4.1"));
        algorithms.put("ECDSAWITHSHA1", new DERObjectIdentifier("1.2.840.10045.4.1"));
    }

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return aIn.readObject();
    }

    public BasicOCSPRespGenerator(RespID responderID) {
        this.responderID = responderID;
    }

    public BasicOCSPRespGenerator(JKey pubKey) throws PKIException {
        this.responderID = new RespID(pubKey);
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus) throws PKIException {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), null, null));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, X509Extensions singleExtensions) throws PKIException {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), null, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date nextUpdate, X509Extensions singleExtensions) throws PKIException {
        this.list.add(new ResponseObject(certID, certStatus, new Date(), nextUpdate, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions singleExtensions) throws PKIException {
        this.list.add(new ResponseObject(certID, certStatus, thisUpdate, nextUpdate, singleExtensions));
    }

    public void setResponseExtensions(X509Extensions responseExtensions) {
        this.responseExtensions = responseExtensions;
    }

    private BasicOCSPResp generateResponse(DERObjectIdentifier signingAlgorithm, JKey priKey, X509Cert[] chain, Date producedAt, Session session) throws PKIException {
        Iterator it = this.list.iterator();
        ASN1EncodableVector responses = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                responses.add(((ResponseObject)it.next()).toResponse());
            }
            catch (Exception e) {
                throw new PKIException("850809", "\u6784\u9020\u54cd\u5e94\u5217\u8868\u5931\u8d25", e);
            }
        }
        ResponseData tbsResp = new ResponseData(new DERInteger(0), this.responderID.toASN1Object(), new DERGeneralizedTime(producedAt), new DERSequence(responses), this.responseExtensions);
        byte[] signature = null;
        try {
            signature = session.sign(new Mechanism("SHA1withRSAEncryption"), priKey, tbsResp.getEncoded());
        }
        catch (Exception ex) {
            throw new PKIException("850808", "\u5bf9\u54cd\u5e94\u6570\u636e\u7b7e\u540d\u5931\u8d25", ex);
        }
        DERBitString bitSig = new DERBitString(signature);
        AlgorithmIdentifier sigAlgId = new AlgorithmIdentifier(signingAlgorithm, new DERNull());
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            int i = 0;
            while (i != chain.length) {
                v.add(chain[i].getCertStructure());
                ++i;
            }
            return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, new DERSequence(v)));
        }
        return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, null));
    }

    public BasicOCSPResp generate(String signingAlgorithm, JKey priKey, X509Cert[] certChain, Date producedAt, Session session) throws PKIException {
        DERObjectIdentifier oid = new DERObjectIdentifier(signingAlgorithm);
        return this.generateResponse(oid, priKey, certChain, producedAt, session);
    }

    private class ResponseObject {
        CertificateID certId;
        CertStatus certStatus;
        DERGeneralizedTime thisUpdate;
        DERGeneralizedTime nextUpdate;
        X509Extensions extensions;

        public ResponseObject(CertificateID certId, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, X509Extensions extensions) throws PKIException {
            RevokedStatus rs;
            this.certId = certId;
            this.certStatus = certStatus == null ? new CertStatus() : (certStatus instanceof UnknownStatus ? new CertStatus(2, new DERNull()) : ((rs = (RevokedStatus)certStatus).hasRevocationReason() ? new CertStatus(new RevokedInfo(new DERGeneralizedTime(rs.getRevocationTime()), new CRLReason(rs.getRevocationReason()))) : new CertStatus(new RevokedInfo(new DERGeneralizedTime(rs.getRevocationTime()), null))));
            this.thisUpdate = new DERGeneralizedTime(thisUpdate);
            this.nextUpdate = nextUpdate != null ? new DERGeneralizedTime(nextUpdate) : null;
            this.extensions = extensions;
        }

        public SingleResponse toResponse() throws Exception {
            return new SingleResponse(this.certId.toASN1Object(), this.certStatus, this.thisUpdate, this.nextUpdate, this.extensions);
        }
    }
}

