/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1OutputStream;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.ocsp.ResponderID;
import com.cfca.util.pki.asn1.x509.SubjectPublicKeyInfo;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cipher.JKey;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;

public class RespID {
    ResponderID id;

    public RespID(ResponderID id) {
        this.id = id;
    }

    public RespID(String respName) {
        this.id = new ResponderID(new X509Name(respName));
    }

    public RespID(JKey pubKey) throws PKIException {
        try {
            SubjectPublicKeyInfo info = Parser.key2SPKI(pubKey);
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(info.getPublicKey());
            digest.update(bOut.toByteArray());
            DEROctetString keyHash = new DEROctetString(digest.digest());
            this.id = new ResponderID(keyHash);
        }
        catch (Exception e) {
            throw new PKIException("850811", "\u6784\u9020\u72b6\u6001\u67e5\u8be2\u54cd\u5e94\u4e2d\u7684\u54cd\u5e94\u8005ID\u5931\u8d25", e);
        }
    }

    public String getIDByName() {
        Object idByName = this.id.getID();
        if (idByName instanceof String) {
            return (String)idByName;
        }
        return null;
    }

    public byte[] getIDByKey() {
        Object idByKey = this.id.getID();
        if (idByKey instanceof byte[]) {
            return (byte[])idByKey;
        }
        return null;
    }

    public ResponderID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RespID)) {
            return false;
        }
        RespID obj = (RespID)o;
        return this.id.equals(obj.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

