/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;

public final class BCSNIHostName
extends BCSNIServerName {
    private final String hostName;

    public static BCSNIMatcher createSNIMatcher(String regex) {
        if (regex == null) {
            throw new NullPointerException("'regex' cannot be null");
        }
        return new BCSNIHostNameMatcher(regex);
    }

    private static String fromAscii(byte[] bs) {
        try {
            return new String(bs, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toAscii(String s) {
        try {
            return s.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public BCSNIHostName(String hostName) {
        super(0, BCSNIHostName.toAscii(hostName));
        this.hostName = hostName;
    }

    public BCSNIHostName(byte[] asciiEncoding) {
        super(0, asciiEncoding);
        this.hostName = BCSNIHostName.fromAscii(asciiEncoding);
    }

    public String getAsciiName() {
        return this.hostName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BCSNIHostName)) {
            return false;
        }
        BCSNIHostName other = (BCSNIHostName)obj;
        return this.hostName.equalsIgnoreCase(other.hostName);
    }

    @Override
    public int hashCode() {
        return this.hostName.toUpperCase(Locale.ENGLISH).hashCode();
    }

    private static final class BCSNIHostNameMatcher
    extends BCSNIMatcher {
        private final Pattern pattern;

        BCSNIHostNameMatcher(String regex) {
            super(0);
            this.pattern = Pattern.compile(regex, 2);
        }

        @Override
        public boolean matches(BCSNIServerName serverName) {
            if (serverName == null || serverName.getType() != 0) {
                return false;
            }
            String hostName = BCSNIHostName.fromAscii(serverName.getEncoded());
            return this.pattern.matcher(hostName).matches();
        }
    }
}

