/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.jsse.provider.test.SSLUtils;
import org.bouncycastle.jsse.provider.test.TestProtocolUtil;
import org.bouncycastle.jsse.provider.test.TestUtils;

public class BasicClientAuthTlsTest
extends TestCase {
    private static final String HOST = "localhost";
    private static final int PORT_NO = 9020;

    protected void setUp() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProvider("BCJSSE") == null) {
            Security.addProvider(new BouncyCastleJsseProvider());
        }
    }

    public void testClientAuthTlsConnection() throws Exception {
        char[] keyPass = "keyPassword".toCharArray();
        KeyPair caKeyPair = TestUtils.generateECKeyPair();
        X509Certificate caCert = TestUtils.generateRootCert(caKeyPair);
        KeyStore serverKs = KeyStore.getInstance("JKS");
        serverKs.load(null, null);
        serverKs.setKeyEntry("server", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        KeyStore clientKs = KeyStore.getInstance("JKS");
        clientKs.load(null, null);
        clientKs.setKeyEntry("client", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        TestProtocolUtil.runClientAndServer(new ClientAuthServer(serverKs, keyPass, caCert), new ClientAuthClient(serverKs, keyPass, caCert));
    }

    public static class ClientAuthServer
    implements TestProtocolUtil.BlockingCallable {
        private final KeyStore serverStore;
        private final char[] keyPass;
        private final KeyStore trustStore;
        private final CountDownLatch latch;

        ClientAuthServer(KeyStore serverStore, char[] keyPass, X509Certificate trustAnchor) throws GeneralSecurityException, IOException {
            this.serverStore = serverStore;
            this.keyPass = keyPass;
            this.trustStore = KeyStore.getInstance("JKS");
            this.trustStore.load(null, null);
            this.trustStore.setCertificateEntry("client", trustAnchor);
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception call() throws Exception {
            try {
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(this.serverStore, this.keyPass);
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.trustStore);
                SSLContext serverContext = SSLContext.getInstance("TLS", "BCJSSE");
                serverContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLServerSocketFactory fact = serverContext.getServerSocketFactory();
                SSLServerSocket sSock = (SSLServerSocket)fact.createServerSocket(9020);
                SSLUtils.enableAll(sSock);
                sSock.setNeedClientAuth(true);
                this.latch.countDown();
                SSLSocket sslSock = (SSLSocket)sSock.accept();
                SSLSession session = sslSock.getSession();
                Assert.assertNotNull((Object)session.getCipherSuite());
                Assert.assertEquals((String)"CN=Test CA Certificate", (String)session.getLocalPrincipal().getName());
                Assert.assertEquals((String)"CN=Test CA Certificate", (String)session.getPeerPrincipal().getName());
                TestProtocolUtil.doServerProtocol(sslSock, "World");
                sslSock.close();
                sSock.close();
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }
    }

    public static class ClientAuthClient
    implements TestProtocolUtil.BlockingCallable {
        private final KeyStore trustStore = KeyStore.getInstance("JKS");
        private final KeyStore clientStore;
        private final char[] clientKeyPass;
        private final CountDownLatch latch;

        public ClientAuthClient(KeyStore clientStore, char[] clientKeyPass, X509Certificate trustAnchor) throws GeneralSecurityException, IOException {
            this.trustStore.load(null, null);
            this.trustStore.setCertificateEntry("server", trustAnchor);
            this.clientStore = clientStore;
            this.clientKeyPass = clientKeyPass;
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception call() throws Exception {
            try {
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.trustStore);
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(this.clientStore, this.clientKeyPass);
                SSLContext clientContext = SSLContext.getInstance("TLS", "BCJSSE");
                clientContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLSocketFactory fact = clientContext.getSocketFactory();
                SSLSocket cSock = (SSLSocket)fact.createSocket(BasicClientAuthTlsTest.HOST, 9020);
                SSLSession session = cSock.getSession();
                Assert.assertNotNull((Object)session.getCipherSuite());
                Assert.assertEquals((String)"CN=Test CA Certificate", (String)session.getLocalPrincipal().getName());
                Assert.assertEquals((String)"CN=Test CA Certificate", (String)session.getPeerPrincipal().getName());
                TestProtocolUtil.doClientProtocol(cSock, "Hello");
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }
    }
}

