/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.cmp.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.FileHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.PackHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.ParserHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.payment.salary.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return this.packRequest(bankPayRequest);
    }

    private String packRequest(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String fileName = FileHelper.sendFileToProxy(paymentInfos);
        Element body = JDomUtils.createRoot((String)"body");
        JDomUtils.addChild((Element)body, (String)"visible", (String)"1");
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"tfrType", (String)"1");
        JDomUtils.addChild((Element)body, (String)"currency", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"acctName", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)body, (String)"totalCount", (String)("" + paymentInfos.length));
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (PaymentInfo paymentInfo : paymentInfos) {
            totalAmount = totalAmount.add(paymentInfo.getAmount());
        }
        JDomUtils.addChild((Element)body, (String)"totalAmt", (String)totalAmount.toString());
        JDomUtils.addChild((Element)body, (String)"summary", (String)paymentInfos[0].getExplanation());
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        return PackHelper.getPackMessage("01603020104B0214", paymentInfos[0].getBankBatchSeqId(), body);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse result = ParserHelper.buildHeadMessage(rspStr);
        if (!"0_0000".equals(result.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u5f02\u5e38", (String)"ParserHelper_2", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)result.getResponseCode(), (String)result.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"ParserHelper_3", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)"P", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"ParserHelper_3", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "01603020104B0214";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u4ee3\u53d1", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

