/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dlb.dc.service.payment.salary;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dlb.dc.service.proxy.ProxyQryResultDownload;
import kd.ebg.aqap.banks.dlb.dc.utils.DLBUtils;
import kd.ebg.aqap.banks.dlb.dc.utils.DLB_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);

    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element ap = DLB_DC_Packer.builedHead("416B200201", Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        String serial_no = PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)paymentInfos.get(0)), (String)"serial_no");
        LocalDateTime submitSuccessTime = ((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime();
        if (StringUtils.isEmpty((String)serial_no)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u6279\u91cf\u6d41\u6c34\u53f7serial_no\u4e3a\u7a7a\u3002", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]));
        }
        if (submitSuccessTime == null) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4tr_acdt\u4e3a\u7a7a\u3002", (String)"SalaryQueryPayImpl_4", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"cmsCorpNo"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)submitSuccessTime.format(DateTimeFormatter.BASIC_ISO_DATE));
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return DLBUtils.forStringLengthByte(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        String data;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s.substring(12), (String)encoding);
        Element head = root.getChild("head");
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String mergeCode = succ_flag + "_" + ret_code;
        if (!"0_0000".equalsIgnoreCase(mergeCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)mergeCode, (String)ret_info);
            return new EBBankPayResponse(paymentInfos);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        logger.info("\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equals(record_num)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5,\u94f6\u884c\u8fd4\u56de\u7684\u8bb0\u5f55\u6570\u4e3a0\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001", (String)"SalaryQueryPayImpl_1", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        if ("1".equalsIgnoreCase(file_flag)) {
            ProxyQryResultDownload proxyDownload = new ProxyQryResultDownload();
            String file_name = body.getChildTextTrim("file_name");
            data = proxyDownload.doBiz(file_name);
        } else {
            data = body.getChildTextTrim("serial_record");
        }
        String[] content = StringUtils.split((String)data, (String)"|");
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        for (int i = 1; i <= recordNum; ++i) {
            String STAT = content[fieldNum * i + 9];
            String BATCH_NO = content[fieldNum * i + 11];
            String CARD_NO = content[fieldNum * i + 1];
            String ACNAME = content[fieldNum * i + 3];
            String AMT = content[fieldNum * i + 5];
            String ERR_MSG = content[fieldNum * i + 10];
            logger.info("STAT:" + STAT + ",BATCH_NO:" + BATCH_NO + ",CARD_NO:" + CARD_NO + ",ACNAME:" + ACNAME + ",AMT:" + AMT + ",ERR_MSG:" + ERR_MSG);
            PaymentInfo payInfo = DLBUtils.findPaymentInfo(paymentInfos, BATCH_NO, CARD_NO, ACNAME, AMT);
            if (payInfo == null) {
                logger.info("\u672a\u5339\u914d\u5230\u4ed8\u6b3e\u4fe1\u606f\uff01");
                continue;
            }
            if ("6".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)STAT, (String)ERR_MSG);
                continue;
            }
            if ("9".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("3".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)STAT, (String)ERR_MSG);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)STAT, (String)ERR_MSG);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "416B200201";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5de5\u8d44\u4ee3\u53d1\u67e5\u8be2", (String)"SalaryQueryPayImpl_0", (String)"ebg-aqap-banks-dlb-dc", (Object[])new Object[0]);
    }
}

