/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.hk.service.payment.fps;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.hk.service.Packer;
import kd.ebg.aqap.banks.gdb.hk.service.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryFPSImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "2065", Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"STARTRANSDATE", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"ENDTRANSDATE", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"ORIGENTSEQNO", (String)paymentInfo.getBankDetailSeqId());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bn = Parser.parserHeadXml(root);
        if (!"000".equals(bn.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bn.getResponseCode(), (String)bn.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element message = JDomUtils.getChildElement((Element)root, (String)"MESSAGE");
        Element body = JDomUtils.getChildElement((Element)message, (String)"BODY");
        String TRANSTATUS = JDomUtils.getChildText((Element)body, (String)"TRANSTATUS");
        String SHOWERRORMSG = JDomUtils.getChildText((Element)body, (String)"SHOWERRORMSG");
        if ("1".equals(TRANSTATUS)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)TRANSTATUS, (String)"");
        } else if ("2".equals(TRANSTATUS)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)TRANSTATUS, (String)SHOWERRORMSG);
        } else if ("0".equals(TRANSTATUS)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)TRANSTATUS, (String)SHOWERRORMSG);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)TRANSTATUS, (String)SHOWERRORMSG);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "2065";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"FPS\u4ea4\u6613\u72b6\u6001\u67e5\u8be2", (String)"QueryFPSImpl_0", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/CGBClient_mo/BankAction");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

