/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uob.dc.services.payment;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.uob.dc.services.Api;
import kd.ebg.aqap.banks.uob.dc.services.payment.QueryPayImpl;
import kd.ebg.aqap.banks.uob.dc.utils.UOBUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public EBBankPayResponse doBiz(BankPayRequest request) {
        try {
            EBContext.getContext().setProcessFlag(PROCESS_PACK);
            String requestStr = this.pack(request);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
            try {
                String response = UOBUtil.request((HttpRequestBase)new HttpPost(UOBUtil.url(Api.PAYMENT.getName())), UOBUtil.generateJWT(requestStr));
                EBContext.getContext().setProcessFlag(PROCESS_PARSE);
                return this.parse(request, response);
            }
            catch (Throwable t) {
                EBContext.getContext().setThrowableAfterSend(t);
                return null;
            }
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            String errorMsg = "";
            if (PROCESS_PACK == EBContext.getContext().getProcessFlag()) {
                errorMsg = ResManager.loadKDString((String)"\u6253\u5305\u94f6\u884c\u4ed8\u6b3e\u8bf7\u6c42\u62a5\u6587\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]);
            }
            throw EBExceiptionUtil.payFailException((String)errorMsg, (Throwable)e);
        }
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JSONObject root = new JSONObject();
        root.put("transactionReference", (Object)paymentInfo.getBankDetailSeqID());
        root.put("endToEndId", (Object)paymentInfo.getBankDetailSeqID());
        root.put("paymentType", (Object)"Y");
        root.put("remittanceInfo", (Object)paymentInfo.getExplanation());
        JSONObject originatorDetails = new JSONObject();
        JSONObject receiverDetails = new JSONObject();
        JSONObject paymentAmount = new JSONObject();
        JSONObject payer = new JSONObject();
        payer.put("accountNumber", (Object)paymentInfo.getAccNo());
        payer.put("accountCurrency", (Object)paymentInfo.getCurrency());
        payer.put("accountType", (Object)BankAcntPropertyConfig.getAccType((String)paymentInfo.getAccNo()));
        originatorDetails.put("account", (Object)payer);
        JSONObject payee = new JSONObject();
        payee.put("accountNumber", (Object)paymentInfo.getIncomeAccNo());
        payee.put("accountCurrency", (Object)paymentInfo.getCurrency());
        payee.put("accountType", (Object)"D");
        receiverDetails.put("account", (Object)payee);
        receiverDetails.put("accountName", (Object)paymentInfo.getIncomeAccName());
        receiverDetails.put("bankCode", (Object)paymentInfo.getIncomeCnaps());
        paymentAmount.put("currency", (Object)paymentInfo.getCurrency());
        paymentAmount.put("amount", (Object)paymentInfo.getAmount());
        root.put("originatorDetails", (Object)originatorDetails);
        root.put("receiverDetails", (Object)receiverDetails);
        root.put("paymentAmount", (Object)paymentAmount);
        String r = root.toJSONString();
        logger.info("Payload\u4e3a{}", (Object)r);
        return r;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JSONObject root = JSONObject.parseObject((String)s);
        JSONObject transactionStatus = root.getJSONObject("transactionStatus");
        if (transactionStatus == null) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u4ea4\u6613\u7ed3\u679c\u4fe1\u606f\u3002", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]));
        } else {
            String code = transactionStatus.getString("code");
            String description = transactionStatus.getString("description");
            if ("000000".equalsIgnoreCase(code)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)code, (String)description);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)description);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }
}

