/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.itbjfcl.dc.services.detail;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.itbjfcl.dc.services.util.Helper;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/FrontEnd/FrontEndServlet");
    }

    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = JDomUtils.createRoot((String)"Iss_Itreasury");
        Element queryReq = JDomUtils.addChild((Element)root, (String)"QueryReq");
        boolean innerAcnt = Helper.isInnerAcnt(bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)queryReq, (String)"OperationType", (String)(innerAcnt ? "3" : "8"));
        JDomUtils.addChild((Element)queryReq, (String)"SystemID", (String)"ERP");
        JDomUtils.addChild((Element)queryReq, (String)"SendTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS")));
        Element queryContent = JDomUtils.addChild((Element)queryReq, (String)"QueryContent");
        JDomUtils.addChild((Element)queryContent, (String)"AccountNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)queryContent, (String)"TransactionTypeCode", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"ExcuteDateStart", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)queryContent, (String)"ExcuteDateEnd", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        String currentPage = this.getCurrentPage();
        JDomUtils.addChild((Element)queryContent, (String)"QueryPageNumber", (String)(currentPage.equals("0") ? "1" : currentPage));
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE1", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE2", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE3", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE4", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE5", (String)"");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element queryRen = JDomUtils.getChildElement((Element)root, (String)"QueryRen");
        String processCode = JDomUtils.getChildText((Element)queryRen, (String)"ProcessCode");
        String processDesc = JDomUtils.getChildText((Element)queryRen, (String)"ProcessDesc");
        if (!"0000".equalsIgnoreCase(processCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s\u9519\u8bef\u4fe1\u606f:%1$s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]), processCode, processDesc));
        }
        String totalCount = JDomUtils.getChildText((Element)queryRen, (String)"TotalCount");
        String curCount = JDomUtils.getChildText((Element)queryRen, (String)"CurCount");
        String queryNextPage = JDomUtils.getChildText((Element)queryRen, (String)"QueryNextPage");
        if (StringUtils.isEmpty((String)queryNextPage) || "0".equalsIgnoreCase(queryNextPage)) {
            this.setLastPage(true);
        }
        if ("0".equalsIgnoreCase(totalCount) || "0".equalsIgnoreCase(curCount)) {
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        this.setCurrentPage(queryNextPage);
        List elements = queryRen.getChildren("RenContent");
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (Element renContent : elements) {
            String transNo = JDomUtils.getChildText((Element)renContent, (String)"TransNo");
            String transactionTypeCode = JDomUtils.getChildText((Element)renContent, (String)"TransactionTypeCode");
            String applyCode = JDomUtils.getChildText((Element)renContent, (String)"ApplyCode");
            String banktransNo = JDomUtils.getChildText((Element)renContent, (String)"BanktransNo");
            String accountNo = JDomUtils.getChildText((Element)renContent, (String)"AccountNo");
            String oppAccountNo = JDomUtils.getChildText((Element)renContent, (String)"OppAccountNo");
            String oppAccountName = JDomUtils.getChildText((Element)renContent, (String)"OppAccountName");
            String oppOpenBankName = JDomUtils.getChildText((Element)renContent, (String)"OppOpenBankName");
            String abstractContent = JDomUtils.getChildText((Element)renContent, (String)"AbstractContent");
            String interestStart = JDomUtils.getChildText((Element)renContent, (String)"InterestStart");
            String excutDate = JDomUtils.getChildText((Element)renContent, (String)"ExcutDate");
            if (excutDate.length() == 10) {
                excutDate = excutDate + " 00:00:00";
            }
            LocalDateTime transTime = LocalDateTime.parse(excutDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            String transDirection = JDomUtils.getChildText((Element)renContent, (String)"TransDirection");
            String amount = JDomUtils.getChildText((Element)renContent, (String)"Amount").replaceAll(",", "");
            String currencyCode = JDomUtils.getChildText((Element)renContent, (String)"CurrencyCode");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(accountNo);
            detailInfo.setOppAccNo(oppAccountNo);
            detailInfo.setOppAccName(oppAccountName);
            detailInfo.setOppBankName(oppOpenBankName);
            detailInfo.setTransTime(transTime);
            detailInfo.setTransDate(transTime.toLocalDate());
            detailInfo.setExplanation(abstractContent);
            detailInfo.setCurrency(currencyCode);
            detailInfo.setBankDetailNo(banktransNo);
            if ("1".equalsIgnoreCase(transDirection)) {
                detailInfo.setDebitAmount(new BigDecimal(amount));
                detailInfo.setCreditAmount(new BigDecimal("0"));
            } else if ("2".equalsIgnoreCase(transDirection)) {
                detailInfo.setDebitAmount(new BigDecimal("0"));
                detailInfo.setCreditAmount(new BigDecimal(amount));
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u501f\u8d37\u65b9\u5411\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-itbjfcl-dc", (Object[])new Object[0]));
            }
            if ("1".equalsIgnoreCase(transDirection) && !StringUtils.isEmpty((String)applyCode)) {
                detailInfo.setPayBankDetailSeqID(applyCode);
            }
            String jsonMap = MatchRule.getInstance().getDetailJsonWithStructuredData(renContent);
            detailInfo.setJsonMap(jsonMap);
            String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate()), jsonMap);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            details.add(detailInfo);
        }
        return new EBBankDetailResponse(details);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "Detail";
    }

    public String getBizDesc() {
        return null;
    }
}

